/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#include "csr_synergy.h"

#include "csr_pmem.h"
#include "csr_wifi_router_ctrl_prim.h"
#include "csr_wifi_router_ctrl_lib.h"

static void CsrWifiRouterCtrlHipReqFreeContents(CsrWifiRouterCtrlHipReq *message)
{
    CsrPmemFree(message->mlmeCommand);
    message->mlmeCommand = NULL;
    CsrPmemFree(message->dataRef1);
    message->dataRef1 = NULL;
    CsrPmemFree(message->dataRef2);
    message->dataRef2 = NULL;
}

static void CsrWifiRouterCtrlMulticastAddressResFreeContents(CsrWifiRouterCtrlMulticastAddressRes *message)
{
    CsrPmemFree(message->getAddresses);
    message->getAddresses = NULL;
}

static void CsrWifiRouterCtrlTclasAddReqFreeContents(CsrWifiRouterCtrlTclasAddReq *message)
{
    CsrPmemFree(message->tclas);
    message->tclas = NULL;
}

static void CsrWifiRouterCtrlTclasDelReqFreeContents(CsrWifiRouterCtrlTclasDelReq *message)
{
    CsrPmemFree(message->tclas);
    message->tclas = NULL;
}

static void CsrWifiRouterCtrlWifiOnReqFreeContents(CsrWifiRouterCtrlWifiOnReq *message)
{
    CsrPmemFree(message->values);
    message->values = NULL;
}

static void CsrWifiRouterCtrlWifiOnResFreeContents(CsrWifiRouterCtrlWifiOnRes *message)
{
    CsrPmemFree(message->smeVersions.smeBuild);
    message->smeVersions.smeBuild = NULL;
}

static void CsrWifiRouterCtrlWapiRxPktReqFreeContents(CsrWifiRouterCtrlWapiRxPktReq *message)
{
    CsrPmemFree(message->signal);
    message->signal = NULL;
    CsrPmemFree(message->data);
    message->data = NULL;
}

/*----------------------------------------------------------------------------*
 *  NAME
 *      CsrWifiRouterCtrlFreeDownstreamMessageContents
 *
 *  DESCRIPTION
 *
 *
 *  PARAMETERS
 *      eventClass: only the value CSR_WIFI_ROUTER_CTRL_PRIM will be handled
 *      message:    the message to free
 *----------------------------------------------------------------------------*/
void CsrWifiRouterCtrlFreeDownstreamMessageContents(CsrUint16 eventClass, void *message)
{
    CsrWifiFsmEvent *evt = (CsrWifiFsmEvent *) message;
    if (evt && (eventClass == CSR_WIFI_ROUTER_CTRL_PRIM))
    {
        switch (evt->type)
        {
            case CSR_WIFI_ROUTER_CTRL_HIP_REQ:
                CsrWifiRouterCtrlHipReqFreeContents((CsrWifiRouterCtrlHipReq *) message);
                break;
            case CSR_WIFI_ROUTER_CTRL_MULTICAST_ADDRESS_RES:
                CsrWifiRouterCtrlMulticastAddressResFreeContents((CsrWifiRouterCtrlMulticastAddressRes *) message);
                break;
            case CSR_WIFI_ROUTER_CTRL_TCLAS_ADD_REQ:
                CsrWifiRouterCtrlTclasAddReqFreeContents((CsrWifiRouterCtrlTclasAddReq *) message);
                break;
            case CSR_WIFI_ROUTER_CTRL_TCLAS_DEL_REQ:
                CsrWifiRouterCtrlTclasDelReqFreeContents((CsrWifiRouterCtrlTclasDelReq *) message);
                break;
            case CSR_WIFI_ROUTER_CTRL_WIFI_ON_REQ:
                CsrWifiRouterCtrlWifiOnReqFreeContents((CsrWifiRouterCtrlWifiOnReq *) message);
                break;
            case CSR_WIFI_ROUTER_CTRL_WIFI_ON_RES:
                CsrWifiRouterCtrlWifiOnResFreeContents((CsrWifiRouterCtrlWifiOnRes *) message);
                break;
            case CSR_WIFI_ROUTER_CTRL_WAPI_RX_PKT_REQ:
                CsrWifiRouterCtrlWapiRxPktReqFreeContents((CsrWifiRouterCtrlWapiRxPktReq *) message);
                break;
            default:
                break;
        }
    }
}
