/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#include "csr_synergy.h"

#include "csr_pmem.h"
#include "csr_msgconv.h"
#include "csr_unicode.h"

#ifdef CSR_WIFI_NME_ENABLE
#ifdef CSR_WIFI_AP_ENABLE

#include "csr_wifi_nme_ap_prim.h"
#include "csr_wifi_nme_ap_serialize.h"

void CsrWifiNmeApPfree(void *ptr)
{
    CsrPmemFree(ptr);
}

CsrSize CsrWifiNmeApWpsRegisterReqSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 17) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrWifiSmeWpsDpid primitive->selectedDevicePasswordId */
    bufferSize += 2; /* CsrWifiSmeWpsConfigType primitive->selectedConfigMethod */
    bufferSize += 8; /* CsrUint8 primitive->pin[8] */
    return bufferSize;
}

CsrUint8 *CsrWifiNmeApWpsRegisterReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiNmeApWpsRegisterReq *primitive = (CsrWifiNmeApWpsRegisterReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->selectedDevicePasswordId);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->selectedConfigMethod);
    CsrMemCpySer(ptr, len, (const void *) primitive->pin, ((CsrUint16) (8)));
    return ptr;
}

void *CsrWifiNmeApWpsRegisterReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiNmeApWpsRegisterReq *primitive = (CsrWifiNmeApWpsRegisterReq *) CsrPmemAlloc(sizeof(CsrWifiNmeApWpsRegisterReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->selectedDevicePasswordId, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->selectedConfigMethod, buffer, &offset);
    CsrMemCpyDes(primitive->pin, buffer, &offset, ((CsrUint16) (8)));

    return primitive;
}

CsrSize CsrWifiNmeApStartReqSizeof(void *msg)
{
    CsrWifiNmeApStartReq *primitive = (CsrWifiNmeApStartReq *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 109) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrWifiSmeApType primitive->apType */
    bufferSize += 1; /* CsrBool primitive->cloakSsid */
    bufferSize += 32; /* CsrUint8 primitive->ssid.ssid[32] */
    bufferSize += 1; /* CsrUint8 primitive->ssid.length */
    bufferSize += 1; /* CsrWifiSmeApAuthType primitive->apCredentials.authType */
    switch (primitive->apCredentials.authType)
    {
        case CSR_WIFI_SME_AP_AUTH_TYPE_OPEN_SYSTEM:
            bufferSize += 1; /* CsrUint8 primitive->apCredentials.nmeAuthType.openSystemEmpty.empty */
            break;
        case CSR_WIFI_SME_AP_AUTH_TYPE_WEP:
            bufferSize += 1; /* CsrWifiSmeWepCredentialType primitive->apCredentials.nmeAuthType.authwep.wepKeyType */
            switch (primitive->apCredentials.nmeAuthType.authwep.wepKeyType)
            {
                case CSR_WIFI_SME_CREDENTIAL_TYPE_WEP128:
                    bufferSize += 1; /* CsrWifiSmeWepAuthMode primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.wepAuthType */
                    bufferSize += 1; /* CsrUint8 primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.selectedWepKey */
                    bufferSize += 13; /* CsrUint8 primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.key1[13] */
                    bufferSize += 13; /* CsrUint8 primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.key2[13] */
                    bufferSize += 13; /* CsrUint8 primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.key3[13] */
                    bufferSize += 13; /* CsrUint8 primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.key4[13] */
                    break;
                case CSR_WIFI_SME_CREDENTIAL_TYPE_WEP64:
                    bufferSize += 1; /* CsrWifiSmeWepAuthMode primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.wepAuthType */
                    bufferSize += 1; /* CsrUint8 primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.selectedWepKey */
                    bufferSize += 5; /* CsrUint8 primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.key1[5] */
                    bufferSize += 5; /* CsrUint8 primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.key2[5] */
                    bufferSize += 5; /* CsrUint8 primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.key3[5] */
                    bufferSize += 5; /* CsrUint8 primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.key4[5] */
                    break;
                default:
                    break;
            }
            break;
        case CSR_WIFI_SME_AP_AUTH_TYPE_PERSONAL:
            bufferSize += 1; /* CsrWifiSmeApAuthSupportMask primitive->apCredentials.nmeAuthType.authTypePersonal.authSupport */
            bufferSize += 1; /* CsrWifiNmeApPersCredentialType primitive->apCredentials.nmeAuthType.authTypePersonal.pskOrPassphrase */
            switch (primitive->apCredentials.nmeAuthType.authTypePersonal.pskOrPassphrase)
            {
                case CSR_WIFI_NME_AP_CREDENTIAL_TYPE_PSK:
                    bufferSize += 2; /* CsrUint16 primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.psk.encryptionMode */
                    bufferSize += 32; /* CsrUint8 primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.psk.psk[32] */
                    break;
                case CSR_WIFI_NME_AP_CREDENTIAL_TYPE_PASSPHRASE:
                    bufferSize += 2; /* CsrUint16 primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.passphrase.encryptionMode */
                    bufferSize += CsrCharStringSerLen(primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.passphrase.passphrase); /* CsrCharString* primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.passphrase.passphrase */
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }
    bufferSize += 1; /* CsrWifiSmeApAccessType primitive->accessType */
    bufferSize += 1; /* CsrUint8 primitive->macAddressListCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->macAddressListCount; i1++)
        {
            bufferSize += 6; /* CsrUint8 primitive->macAddressList[i1].a[6] */
        }
    }
    bufferSize += 4; /* CsrUint32 primitive->valuesLength */
    bufferSize += primitive->valuesLength; /* CsrUint8 primitive->values */
    return bufferSize;
}

CsrUint8 *CsrWifiNmeApStartReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiNmeApStartReq *primitive = (CsrWifiNmeApStartReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->apType);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->cloakSsid);
    CsrMemCpySer(ptr, len, (const void *) primitive->ssid.ssid, ((CsrUint16) (32)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->ssid.length);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->apCredentials.authType);
    switch (primitive->apCredentials.authType)
    {
        case CSR_WIFI_SME_AP_AUTH_TYPE_OPEN_SYSTEM:
            CsrUint8Ser(ptr, len, (CsrUint8) primitive->apCredentials.nmeAuthType.openSystemEmpty.empty);
            break;
        case CSR_WIFI_SME_AP_AUTH_TYPE_WEP:
            CsrUint8Ser(ptr, len, (CsrUint8) primitive->apCredentials.nmeAuthType.authwep.wepKeyType);
            switch (primitive->apCredentials.nmeAuthType.authwep.wepKeyType)
            {
                case CSR_WIFI_SME_CREDENTIAL_TYPE_WEP128:
                    CsrUint8Ser(ptr, len, (CsrUint8) primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.wepAuthType);
                    CsrUint8Ser(ptr, len, (CsrUint8) primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.selectedWepKey);
                    CsrMemCpySer(ptr, len, (const void *) primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.key1, ((CsrUint16) (13)));
                    CsrMemCpySer(ptr, len, (const void *) primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.key2, ((CsrUint16) (13)));
                    CsrMemCpySer(ptr, len, (const void *) primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.key3, ((CsrUint16) (13)));
                    CsrMemCpySer(ptr, len, (const void *) primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.key4, ((CsrUint16) (13)));
                    break;
                case CSR_WIFI_SME_CREDENTIAL_TYPE_WEP64:
                    CsrUint8Ser(ptr, len, (CsrUint8) primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.wepAuthType);
                    CsrUint8Ser(ptr, len, (CsrUint8) primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.selectedWepKey);
                    CsrMemCpySer(ptr, len, (const void *) primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.key1, ((CsrUint16) (5)));
                    CsrMemCpySer(ptr, len, (const void *) primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.key2, ((CsrUint16) (5)));
                    CsrMemCpySer(ptr, len, (const void *) primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.key3, ((CsrUint16) (5)));
                    CsrMemCpySer(ptr, len, (const void *) primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.key4, ((CsrUint16) (5)));
                    break;
                default:
                    break;
            }
            break;
        case CSR_WIFI_SME_AP_AUTH_TYPE_PERSONAL:
            CsrUint8Ser(ptr, len, (CsrUint8) primitive->apCredentials.nmeAuthType.authTypePersonal.authSupport);
            CsrUint8Ser(ptr, len, (CsrUint8) primitive->apCredentials.nmeAuthType.authTypePersonal.pskOrPassphrase);
            switch (primitive->apCredentials.nmeAuthType.authTypePersonal.pskOrPassphrase)
            {
                case CSR_WIFI_NME_AP_CREDENTIAL_TYPE_PSK:
                    CsrUint16Ser(ptr, len, (CsrUint16) primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.psk.encryptionMode);
                    CsrMemCpySer(ptr, len, (const void *) primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.psk.psk, ((CsrUint16) (32)));
                    break;
                case CSR_WIFI_NME_AP_CREDENTIAL_TYPE_PASSPHRASE:
                    CsrUint16Ser(ptr, len, (CsrUint16) primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.passphrase.encryptionMode);
                    CsrCharStringSer(ptr, len, primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.passphrase.passphrase);
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->accessType);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->macAddressListCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->macAddressListCount; i1++)
        {
            CsrMemCpySer(ptr, len, (const void *) primitive->macAddressList[i1].a, ((CsrUint16) (6)));
        }
    }
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->valuesLength);
    if (primitive->valuesLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->values, ((CsrUint16) (primitive->valuesLength)));
    }
    return ptr;
}

void *CsrWifiNmeApStartReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiNmeApStartReq *primitive = (CsrWifiNmeApStartReq *) CsrPmemAlloc(sizeof(CsrWifiNmeApStartReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->apType, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->cloakSsid, buffer, &offset);
    CsrMemCpyDes(primitive->ssid.ssid, buffer, &offset, ((CsrUint16) (32)));
    CsrUint8Des((CsrUint8 *) &primitive->ssid.length, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->apCredentials.authType, buffer, &offset);
    switch (primitive->apCredentials.authType)
    {
        case CSR_WIFI_SME_AP_AUTH_TYPE_OPEN_SYSTEM:
            CsrUint8Des((CsrUint8 *) &primitive->apCredentials.nmeAuthType.openSystemEmpty.empty, buffer, &offset);
            break;
        case CSR_WIFI_SME_AP_AUTH_TYPE_WEP:
            CsrUint8Des((CsrUint8 *) &primitive->apCredentials.nmeAuthType.authwep.wepKeyType, buffer, &offset);
            switch (primitive->apCredentials.nmeAuthType.authwep.wepKeyType)
            {
                case CSR_WIFI_SME_CREDENTIAL_TYPE_WEP128:
                    CsrUint8Des((CsrUint8 *) &primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.wepAuthType, buffer, &offset);
                    CsrUint8Des((CsrUint8 *) &primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.selectedWepKey, buffer, &offset);
                    CsrMemCpyDes(primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.key1, buffer, &offset, ((CsrUint16) (13)));
                    CsrMemCpyDes(primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.key2, buffer, &offset, ((CsrUint16) (13)));
                    CsrMemCpyDes(primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.key3, buffer, &offset, ((CsrUint16) (13)));
                    CsrMemCpyDes(primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep128Key.key4, buffer, &offset, ((CsrUint16) (13)));
                    break;
                case CSR_WIFI_SME_CREDENTIAL_TYPE_WEP64:
                    CsrUint8Des((CsrUint8 *) &primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.wepAuthType, buffer, &offset);
                    CsrUint8Des((CsrUint8 *) &primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.selectedWepKey, buffer, &offset);
                    CsrMemCpyDes(primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.key1, buffer, &offset, ((CsrUint16) (5)));
                    CsrMemCpyDes(primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.key2, buffer, &offset, ((CsrUint16) (5)));
                    CsrMemCpyDes(primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.key3, buffer, &offset, ((CsrUint16) (5)));
                    CsrMemCpyDes(primitive->apCredentials.nmeAuthType.authwep.wepCredentials.wep64Key.key4, buffer, &offset, ((CsrUint16) (5)));
                    break;
                default:
                    break;
            }
            break;
        case CSR_WIFI_SME_AP_AUTH_TYPE_PERSONAL:
            CsrUint8Des((CsrUint8 *) &primitive->apCredentials.nmeAuthType.authTypePersonal.authSupport, buffer, &offset);
            CsrUint8Des((CsrUint8 *) &primitive->apCredentials.nmeAuthType.authTypePersonal.pskOrPassphrase, buffer, &offset);
            switch (primitive->apCredentials.nmeAuthType.authTypePersonal.pskOrPassphrase)
            {
                case CSR_WIFI_NME_AP_CREDENTIAL_TYPE_PSK:
                    CsrUint16Des((CsrUint16 *) &primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.psk.encryptionMode, buffer, &offset);
                    CsrMemCpyDes(primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.psk.psk, buffer, &offset, ((CsrUint16) (32)));
                    break;
                case CSR_WIFI_NME_AP_CREDENTIAL_TYPE_PASSPHRASE:
                    CsrUint16Des((CsrUint16 *) &primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.passphrase.encryptionMode, buffer, &offset);
                    CsrCharStringDes(&primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.passphrase.passphrase, buffer, &offset);
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }
    CsrUint8Des((CsrUint8 *) &primitive->accessType, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->macAddressListCount, buffer, &offset);
    primitive->macAddressList = NULL;
    if (primitive->macAddressListCount)
    {
        primitive->macAddressList = (CsrWifiMacAddress *) CsrPmemAlloc(sizeof(CsrWifiMacAddress) * primitive->macAddressListCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->macAddressListCount; i1++)
        {
            CsrMemCpyDes(primitive->macAddressList[i1].a, buffer, &offset, ((CsrUint16) (6)));
        }
    }
    CsrUint32Des((CsrUint32 *) &primitive->valuesLength, buffer, &offset);
    if (primitive->valuesLength)
    {
        primitive->values = (CsrUint8 *) CsrPmemAlloc(primitive->valuesLength);
        CsrMemCpyDes(primitive->values, buffer, &offset, ((CsrUint16) (primitive->valuesLength)));
    }
    else
    {
        primitive->values = NULL;
    }

    return primitive;
}

void CsrWifiNmeApStartReqSerFree(void *voidPrimitivePointer)
{
    CsrWifiNmeApStartReq *primitive = (CsrWifiNmeApStartReq *) voidPrimitivePointer;
    switch (primitive->apCredentials.authType)
    {
        case CSR_WIFI_SME_AP_AUTH_TYPE_PERSONAL:
            switch (primitive->apCredentials.nmeAuthType.authTypePersonal.pskOrPassphrase)
            {
                case CSR_WIFI_NME_AP_CREDENTIAL_TYPE_PASSPHRASE:
                    CsrPmemFree(primitive->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.passphrase.passphrase);
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }
    CsrPmemFree(primitive->macAddressList);
    CsrPmemFree(primitive->values);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiNmeApStaRemoveReqSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 12) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 6; /* CsrUint8 primitive->staMacAddress.a[6] */
    bufferSize += 1; /* CsrBool primitive->keepBlocking */
    return bufferSize;
}

CsrUint8 *CsrWifiNmeApStaRemoveReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiNmeApStaRemoveReq *primitive = (CsrWifiNmeApStaRemoveReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrMemCpySer(ptr, len, (const void *) primitive->staMacAddress.a, ((CsrUint16) (6)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->keepBlocking);
    return ptr;
}

void *CsrWifiNmeApStaRemoveReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiNmeApStaRemoveReq *primitive = (CsrWifiNmeApStaRemoveReq *) CsrPmemAlloc(sizeof(CsrWifiNmeApStaRemoveReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrMemCpyDes(primitive->staMacAddress.a, buffer, &offset, ((CsrUint16) (6)));
    CsrUint8Des((CsrUint8 *) &primitive->keepBlocking, buffer, &offset);

    return primitive;
}

CsrSize CsrWifiNmeApWpsRegisterCfmSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 7) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    return bufferSize;
}

CsrUint8 *CsrWifiNmeApWpsRegisterCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiNmeApWpsRegisterCfm *primitive = (CsrWifiNmeApWpsRegisterCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    return ptr;
}

void *CsrWifiNmeApWpsRegisterCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiNmeApWpsRegisterCfm *primitive = (CsrWifiNmeApWpsRegisterCfm *) CsrPmemAlloc(sizeof(CsrWifiNmeApWpsRegisterCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);

    return primitive;
}

CsrSize CsrWifiNmeApStartCfmSizeof(void *msg)
{
    CsrWifiNmeApStartCfm *primitive = (CsrWifiNmeApStartCfm *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 45) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 32; /* CsrUint8 primitive->ssid.ssid[32] */
    bufferSize += 1; /* CsrUint8 primitive->ssid.length */
    bufferSize += 4; /* CsrUint32 primitive->errorValuesLength */
    bufferSize += primitive->errorValuesLength; /* CsrUint8 primitive->errorValues */
    return bufferSize;
}

CsrUint8 *CsrWifiNmeApStartCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiNmeApStartCfm *primitive = (CsrWifiNmeApStartCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrMemCpySer(ptr, len, (const void *) primitive->ssid.ssid, ((CsrUint16) (32)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->ssid.length);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->errorValuesLength);
    if (primitive->errorValuesLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->errorValues, ((CsrUint16) (primitive->errorValuesLength)));
    }
    return ptr;
}

void *CsrWifiNmeApStartCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiNmeApStartCfm *primitive = (CsrWifiNmeApStartCfm *) CsrPmemAlloc(sizeof(CsrWifiNmeApStartCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrMemCpyDes(primitive->ssid.ssid, buffer, &offset, ((CsrUint16) (32)));
    CsrUint8Des((CsrUint8 *) &primitive->ssid.length, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->errorValuesLength, buffer, &offset);
    if (primitive->errorValuesLength)
    {
        primitive->errorValues = (CsrUint8 *) CsrPmemAlloc(primitive->errorValuesLength);
        CsrMemCpyDes(primitive->errorValues, buffer, &offset, ((CsrUint16) (primitive->errorValuesLength)));
    }
    else
    {
        primitive->errorValues = NULL;
    }

    return primitive;
}

void CsrWifiNmeApStartCfmSerFree(void *voidPrimitivePointer)
{
    CsrWifiNmeApStartCfm *primitive = (CsrWifiNmeApStartCfm *) voidPrimitivePointer;
    CsrPmemFree(primitive->errorValues);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiNmeApStopCfmSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 7) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    return bufferSize;
}

CsrUint8 *CsrWifiNmeApStopCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiNmeApStopCfm *primitive = (CsrWifiNmeApStopCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    return ptr;
}

void *CsrWifiNmeApStopCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiNmeApStopCfm *primitive = (CsrWifiNmeApStopCfm *) CsrPmemAlloc(sizeof(CsrWifiNmeApStopCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);

    return primitive;
}

CsrSize CsrWifiNmeApStopIndSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 8) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrWifiSmeApType primitive->apType */
    bufferSize += 2; /* CsrResult primitive->status */
    return bufferSize;
}

CsrUint8 *CsrWifiNmeApStopIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiNmeApStopInd *primitive = (CsrWifiNmeApStopInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->apType);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    return ptr;
}

void *CsrWifiNmeApStopIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiNmeApStopInd *primitive = (CsrWifiNmeApStopInd *) CsrPmemAlloc(sizeof(CsrWifiNmeApStopInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->apType, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);

    return primitive;
}

CsrSize CsrWifiNmeApStationIndSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 18) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrWifiSmeMediaStatus primitive->mediaStatus */
    bufferSize += 6; /* CsrUint8 primitive->peerMacAddress.a[6] */
    bufferSize += 6; /* CsrUint8 primitive->peerDeviceAddress.a[6] */
    return bufferSize;
}

CsrUint8 *CsrWifiNmeApStationIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiNmeApStationInd *primitive = (CsrWifiNmeApStationInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->mediaStatus);
    CsrMemCpySer(ptr, len, (const void *) primitive->peerMacAddress.a, ((CsrUint16) (6)));
    CsrMemCpySer(ptr, len, (const void *) primitive->peerDeviceAddress.a, ((CsrUint16) (6)));
    return ptr;
}

void *CsrWifiNmeApStationIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiNmeApStationInd *primitive = (CsrWifiNmeApStationInd *) CsrPmemAlloc(sizeof(CsrWifiNmeApStationInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->mediaStatus, buffer, &offset);
    CsrMemCpyDes(primitive->peerMacAddress.a, buffer, &offset, ((CsrUint16) (6)));
    CsrMemCpyDes(primitive->peerDeviceAddress.a, buffer, &offset, ((CsrUint16) (6)));

    return primitive;
}

CsrSize CsrWifiNmeApStartIndSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 39) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrWifiSmeApType primitive->apType */
    bufferSize += 32; /* CsrUint8 primitive->ssid.ssid[32] */
    bufferSize += 1; /* CsrUint8 primitive->ssid.length */
    return bufferSize;
}

CsrUint8 *CsrWifiNmeApStartIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiNmeApStartInd *primitive = (CsrWifiNmeApStartInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->apType);
    CsrMemCpySer(ptr, len, (const void *) primitive->ssid.ssid, ((CsrUint16) (32)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->ssid.length);
    return ptr;
}

void *CsrWifiNmeApStartIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiNmeApStartInd *primitive = (CsrWifiNmeApStartInd *) CsrPmemAlloc(sizeof(CsrWifiNmeApStartInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->apType, buffer, &offset);
    CsrMemCpyDes(primitive->ssid.ssid, buffer, &offset, ((CsrUint16) (32)));
    CsrUint8Des((CsrUint8 *) &primitive->ssid.length, buffer, &offset);

    return primitive;
}

#endif /* CSR_WIFI_NME_ENABLE */
#endif /* CSR_WIFI_AP_ENABLE */
