/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#include "csr_synergy.h"

#include "csr_pmem.h"
#include "csr_wifi_nme_prim.h"
#include "csr_wifi_nme_lib.h"

static void CsrWifiNmeProfileConnectCfmFreeContents(CsrWifiNmeProfileConnectCfm *message)
{
    CsrPmemFree(message->connectAttempts);
    message->connectAttempts = NULL;
}

static void CsrWifiNmeWpsCfmFreeContents(CsrWifiNmeWpsCfm *message)
{
    switch (message->profile.credentials.credentialType)
    {
        case CSR_WIFI_NME_CREDENTIAL_TYPE_8021X:
            CsrPmemFree(message->profile.credentials.credential.eap.userName);
            message->profile.credentials.credential.eap.userName = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.userPassword);
            message->profile.credentials.credential.eap.userPassword = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.authServerUserIdentity);
            message->profile.credentials.credential.eap.authServerUserIdentity = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.clientCertificate);
            message->profile.credentials.credential.eap.clientCertificate = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.certificateAuthorityCertificate);
            message->profile.credentials.credential.eap.certificateAuthorityCertificate = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.privateKey);
            message->profile.credentials.credential.eap.privateKey = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.privateKeyPassword);
            message->profile.credentials.credential.eap.privateKeyPassword = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.session);
            message->profile.credentials.credential.eap.session = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.pac);
            message->profile.credentials.credential.eap.pac = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.pacPassword);
            message->profile.credentials.credential.eap.pacPassword = NULL;
            break;
        case CSR_WIFI_NME_CREDENTIAL_TYPE_WAPI_PASSPHRASE:
            CsrPmemFree(message->profile.credentials.credential.wapiPassphrase.passphrase);
            message->profile.credentials.credential.wapiPassphrase.passphrase = NULL;
            break;
        case CSR_WIFI_NME_CREDENTIAL_TYPE_WPA2_PASSPHRASE:
            CsrPmemFree(message->profile.credentials.credential.wpa2Passphrase.passphrase);
            message->profile.credentials.credential.wpa2Passphrase.passphrase = NULL;
            break;
        case CSR_WIFI_NME_CREDENTIAL_TYPE_WPA_PASSPHRASE:
            CsrPmemFree(message->profile.credentials.credential.wpaPassphrase.passphrase);
            message->profile.credentials.credential.wpaPassphrase.passphrase = NULL;
            break;
        case CSR_WIFI_NME_CREDENTIAL_TYPE_WAPI:
            CsrPmemFree(message->profile.credentials.credential.wapi.certificate);
            message->profile.credentials.credential.wapi.certificate = NULL;
            CsrPmemFree(message->profile.credentials.credential.wapi.privateKey);
            message->profile.credentials.credential.wapi.privateKey = NULL;
            CsrPmemFree(message->profile.credentials.credential.wapi.caCertificate);
            message->profile.credentials.credential.wapi.caCertificate = NULL;
            break;
        default:
            break;
    }
    CsrPmemFree(message->profile.mibValues);
    message->profile.mibValues = NULL;
}

static void CsrWifiNmeProfileUpdateIndFreeContents(CsrWifiNmeProfileUpdateInd *message)
{
    switch (message->profile.credentials.credentialType)
    {
        case CSR_WIFI_NME_CREDENTIAL_TYPE_8021X:
            CsrPmemFree(message->profile.credentials.credential.eap.userName);
            message->profile.credentials.credential.eap.userName = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.userPassword);
            message->profile.credentials.credential.eap.userPassword = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.authServerUserIdentity);
            message->profile.credentials.credential.eap.authServerUserIdentity = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.clientCertificate);
            message->profile.credentials.credential.eap.clientCertificate = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.certificateAuthorityCertificate);
            message->profile.credentials.credential.eap.certificateAuthorityCertificate = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.privateKey);
            message->profile.credentials.credential.eap.privateKey = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.privateKeyPassword);
            message->profile.credentials.credential.eap.privateKeyPassword = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.session);
            message->profile.credentials.credential.eap.session = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.pac);
            message->profile.credentials.credential.eap.pac = NULL;
            CsrPmemFree(message->profile.credentials.credential.eap.pacPassword);
            message->profile.credentials.credential.eap.pacPassword = NULL;
            break;
        case CSR_WIFI_NME_CREDENTIAL_TYPE_WAPI_PASSPHRASE:
            CsrPmemFree(message->profile.credentials.credential.wapiPassphrase.passphrase);
            message->profile.credentials.credential.wapiPassphrase.passphrase = NULL;
            break;
        case CSR_WIFI_NME_CREDENTIAL_TYPE_WPA2_PASSPHRASE:
            CsrPmemFree(message->profile.credentials.credential.wpa2Passphrase.passphrase);
            message->profile.credentials.credential.wpa2Passphrase.passphrase = NULL;
            break;
        case CSR_WIFI_NME_CREDENTIAL_TYPE_WPA_PASSPHRASE:
            CsrPmemFree(message->profile.credentials.credential.wpaPassphrase.passphrase);
            message->profile.credentials.credential.wpaPassphrase.passphrase = NULL;
            break;
        case CSR_WIFI_NME_CREDENTIAL_TYPE_WAPI:
            CsrPmemFree(message->profile.credentials.credential.wapi.certificate);
            message->profile.credentials.credential.wapi.certificate = NULL;
            CsrPmemFree(message->profile.credentials.credential.wapi.privateKey);
            message->profile.credentials.credential.wapi.privateKey = NULL;
            CsrPmemFree(message->profile.credentials.credential.wapi.caCertificate);
            message->profile.credentials.credential.wapi.caCertificate = NULL;
            break;
        default:
            break;
    }
    CsrPmemFree(message->profile.mibValues);
    message->profile.mibValues = NULL;
}

static void CsrWifiNmeProfileDisconnectIndFreeContents(CsrWifiNmeProfileDisconnectInd *message)
{
    CsrPmemFree(message->connectAttempts);
    message->connectAttempts = NULL;
}

static void CsrWifiNmeSimGsmAuthIndFreeContents(CsrWifiNmeSimGsmAuthInd *message)
{
    CsrPmemFree(message->rands);
    message->rands = NULL;
}

/*----------------------------------------------------------------------------*
 *  NAME
 *      CsrWifiNmeFreeUpstreamMessageContents
 *
 *  DESCRIPTION
 *
 *
 *  PARAMETERS
 *      eventClass: only the value CSR_WIFI_NME_PRIM will be handled
 *      message:    the message to free
 *----------------------------------------------------------------------------*/
void CsrWifiNmeFreeUpstreamMessageContents(CsrUint16 eventClass, void *message)
{
    CsrWifiFsmEvent *evt = (CsrWifiFsmEvent *) message;
    if (evt && (eventClass == CSR_WIFI_NME_PRIM))
    {
        switch (evt->type)
        {
            case CSR_WIFI_NME_PROFILE_CONNECT_CFM:
                CsrWifiNmeProfileConnectCfmFreeContents((CsrWifiNmeProfileConnectCfm *) message);
                break;
            case CSR_WIFI_NME_WPS_CFM:
                CsrWifiNmeWpsCfmFreeContents((CsrWifiNmeWpsCfm *) message);
                break;
            case CSR_WIFI_NME_PROFILE_UPDATE_IND:
                CsrWifiNmeProfileUpdateIndFreeContents((CsrWifiNmeProfileUpdateInd *) message);
                break;
            case CSR_WIFI_NME_PROFILE_DISCONNECT_IND:
                CsrWifiNmeProfileDisconnectIndFreeContents((CsrWifiNmeProfileDisconnectInd *) message);
                break;
            case CSR_WIFI_NME_SIM_GSM_AUTH_IND:
                CsrWifiNmeSimGsmAuthIndFreeContents((CsrWifiNmeSimGsmAuthInd *) message);
                break;
            default:
                break;
        }
    }
}
