/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef CSR_WIFI_VIF_UTILS_H__
#define CSR_WIFI_VIF_UTILS_H__

#include "csr_synergy.h"

#ifdef __cplusplus
extern "C" {
#endif

/* including this file for CsrWifiInterfaceMode*/
#include "csr_wifi_private_common.h"

/* MACROS *******************************************************************/

/* Common macros for NME and SME to be used temporarily until SoftMAC changes are made */
#define CSR_WIFI_INTERFACE_IN_USE      (CsrUint16) 0x0

/* This is used at places where interface Id isn't available*/
#define CSR_WIFI_INTERFACE_ZERO        0

#define CSR_WIFI_VIF_UTILS_UNDEFINED_TAG 0xFFFF

#define CSR_WIFI_DEFAULT_INTERFACE 0x0000

/* Extract the Interface Id from the event */
#define CsrWifiVifUtilsGetHostInterfaceTagFromEvent(msg) \
    ((CsrUint16) * ((CsrUint16 *) ((CsrUint8 *) (msg) + sizeof(CsrWifiFsmEvent))))

/* TYPES DEFINITIONS ********************************************************/

/* GLOBAL VARIABLE DECLARATIONS *********************************************/

/* PUBLIC FUNCTION PROTOTYPES ***********************************************/

#ifdef __cplusplus
}
#endif

#endif /* CSR_WIFI_VIF_UTILS_H */
