/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/*
 ******************************************************************************
 * FILE : csr_wifi_hip_card.h
 *
 * PURPOSE : Defines abstract interface for hardware specific functions.
 *           Note, this is a different file from one of the same name in the
 *           Windows driver.
 *
 *****************************************************************************
 */
#ifndef CSR_WIFI_HIP_CARD_H__
#define CSR_WIFI_HIP_CARD_H__

#include "csr_synergy.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "csr_wifi_hip_card_sdio.h"
#include "csr_wifi_hip_signals.h"
#include "csr_wifi_hip_unifi_udi.h"

#define INCLUDE_SLOT_LIST 1

/*****************************************************************************
 * CardEnableInt -
 */
CsrResult CardEnableInt(card_t *card);

/*****************************************************************************
 * CardGenInt -
 */
CsrResult CardGenInt(card_t *card);

/*****************************************************************************
 * CardPendingInt -
 */
CsrResult CardPendingInt(card_t *card, CsrBool *pintr);

/*****************************************************************************
 * CardDisableInt -
 */
CsrResult CardDisableInt(card_t *card);

/*****************************************************************************
 * CardClearInt -
 */
CsrResult CardClearInt(card_t *card);

/*****************************************************************************
 * CardDisable -
 */
void CardDisable(card_t *card);

/*****************************************************************************
 * CardIntEnabled -
 */
CsrResult CardIntEnabled(card_t *card, CsrBool *enabled);

/*****************************************************************************
 * CardGetDataSlotSize
 */
CsrUint32 CardGetDataSlotSize(card_t *card);

/*****************************************************************************
 * CardWriteBulkData -
 */
CsrResult CardWriteBulkData(card_t *card, struct csrWifiHipPacketSchedulerQsig *qsig, CsrUint16 slot_list[], CsrUint16 *slot_count);

/*****************************************************************************
 * CardClearFromHostDataSlot -
 */
void CardClearFromHostDataSlot(card_t *card, const CsrUint16 aSlotNum, CsrBool free_net_buf);

/*****************************************************************************
 * CardGetFreeFromHostDataSlots -
 */
CsrUint16 CardGetFreeFromHostDataSlots(card_t *card);

CsrUint16 CardAreAllFromHostDataSlotsEmpty(card_t *card);

CsrResult CardClearSlotQsigPtr(card_t *card, CsrUint16 slot, struct csrWifiHipPacketSchedulerQsig *qsig);

CsrResult card_wait_for_firmware_to_start(card_t *card, CsrUint32 *paddr);

CsrResult card_start_processor(card_t *card, enum unifi_dbg_processors_select which);
#ifndef CSR_WIFI_DRIVER_HYDRA
CsrResult unifi_dl_firmware(card_t *card, void *arg);
CsrResult unifi_dl_patch(card_t *card, void *arg, CsrUint32 boot_ctrl);
CsrResult unifi_do_loader_op(card_t *card, CsrUint32 op_addr, CsrUint8 opcode);
void *unifi_dl_fw_read_start(card_t *card, CsrInt8 is_fw);
#endif
CsrResult ConvertCsrSdioToCsrHipResult(card_t *card, CsrResult csrResult);
#ifdef CSR_WIFI_HIP_DEBUG_OFFLINE_ENABLE
void unifi_debug_request_mark(CsrUint8 id);
void unifi_debug_log_to_buf(CsrInt16 append_flag, const CsrCharString *fmt, ...);
void unifi_debug_string_to_buf(CsrInt16 append_flag, const CsrCharString *str);
void unifi_debug_hex_to_buf(const CsrUint8 *buff, CsrUint16 length);
#endif


#ifdef __cplusplus
}
#endif

#endif /* __CARD_H__ */
