/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef CSR_WIFI_HIP_SPINLOCK_H__
#define CSR_WIFI_HIP_SPINLOCK_H__

#include "csr_synergy.h"
#include "csr_result.h"
#include "csr_framework_ext.h"

#ifdef __cplusplus
extern "C" {
#endif

/* The CSR_HAVE_SPINLOCK flag is set in the framework BSP for the platform
 * and indicates if spinlock has been implemented/ported for the platform.
 * Default to mutexes, if spinlocks have not been implemented.
 */
#if defined CSR_WIFI_SPINLOCK_SUPPORT && defined CSR_HAVE_SPINLOCK

typedef CsrSpinlock CsrWifiHipSpinlock;
/* Spinlock create can't fail, so return success regardless. */
#define CSR_WIFI_HIP_SPINLOCK_CREATE(lock) ({CsrSpinlockCreate(lock); \
                                             CSR_RESULT_SUCCESS;})
#define CSR_WIFI_HIP_SPINLOCK_DESTROY(lock) CsrSpinlockDestroy(lock)
#define CSR_WIFI_HIP_SPINLOCK_LOCK(lock)    CsrSpinlockLock(lock)
#define CSR_WIFI_HIP_SPINLOCK_UNLOCK(lock)  CsrSpinlockUnlock(lock)

#else

typedef CsrMutexHandle CsrWifiHipSpinlock;
#define CSR_WIFI_HIP_SPINLOCK_CREATE(lock)         CsrMutexCreate(lock)
#define CSR_WIFI_HIP_SPINLOCK_DESTROY(lock) (void) CsrMutexDestroy(lock)
#define CSR_WIFI_HIP_SPINLOCK_LOCK(lock)    (void) CsrMutexLock(lock)
#define CSR_WIFI_HIP_SPINLOCK_UNLOCK(lock)  (void) CsrMutexUnlock(lock)

#endif


#ifdef __cplusplus
}
#endif

#endif /* CSR_WIFI_HIP_SPINLOCK_H__ */
