/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#include "csr_synergy.h"

#include "csr_wifi_hip_log_text.h"
#include "csr_wifi_hip_hal_priv.h"
#include "csr_wifi_common.h"
#include "csr_wifi_hip.h"


CsrResult CsrWifiHipTaClassificationReq(void *hipHandle, CsrWifiRouterCtrlTrafficType trafficType, CsrUint16 period)
{
    CsrWifiHipHalPriv *priv = (CsrWifiHipHalPriv *) hipHandle;

    if (hipHandle == NULL)
    {
        CSR_LOG_TEXT_CRITICAL((CSR_WIFI_HIP_LOG_ID, CSR_WIFI_HIP_LOG_DEF, "unifi%d: CsrWifiHipTaClassificationReq: Invalid hipHandle \n", priv ? priv->instance : 0));
        return CSR_RESULT_FAILURE;
    }

    unifi_ta_classification(priv->card, trafficType, period);

    return CSR_RESULT_SUCCESS;
}

CsrResult CsrWifiHipTaConfigureReq(void *hipHandle, CsrWifiRouterCtrlTrafficConfigType trafficConfigType,
                                   CsrWifiRouterCtrlTrafficConfig config)
{
    CsrResult r;
    CsrWifiHipHalPriv *priv = (CsrWifiHipHalPriv *) hipHandle;

    if (hipHandle == NULL)
    {
        CSR_LOG_TEXT_CRITICAL((CSR_WIFI_HIP_LOG_ID, CSR_WIFI_HIP_LOG_DEF, "unifi%d: CsrWifiHipTaConfigureReq: Invalid hipHandle \n", priv ? priv->instance : 0));
        return CSR_RESULT_FAILURE;
    }

    r = unifi_ta_configure(priv->card, trafficConfigType, &config);
    if (r != CSR_RESULT_SUCCESS)
    {
        CSR_LOG_TEXT_CRITICAL((CSR_WIFI_HIP_LOG_ID, CSR_WIFI_HIP_LOG_DEF, "unifi%d: CsrWifiHipTaConfigureReq: Error during configuring the traffic analysis\n", priv ? priv->instance : 0));
        return CSR_RESULT_FAILURE;
    }

    return CSR_RESULT_SUCCESS;
}

/*
 * ---------------------------------------------------------------------------
 *  unifi_ta_indicate_protocol
 *
 *      Report that a packet of a particular type has been seen
 *
 *  Arguments:
 *      ospriv          The device context pointer passed to ta_init.
 *      protocol        The protocol type enum value.
 *      direction       Whether the packet was a tx or rx.
 *      src_addr        The source MAC address from the data packet.
 *
 *  Returns:
 *      None.
 * ---------------------------------------------------------------------------
 */
void unifi_ta_indicate_protocol(void                              *ospriv,
                                CsrUint16                          interfaceTag,
                                CsrWifiRouterCtrlTrafficPacketType packet_type,
                                CsrWifiRouterCtrlProtocolDirection taDirection,
                                const CsrWifiMacAddress           *src_addr)
{
    CsrWifiHipHalPriv *priv = (CsrWifiHipHalPriv *) ospriv;
    CsrWifiMacAddress macSrcAddr;

    CsrMemCpy(&macSrcAddr, src_addr, sizeof(CsrWifiMacAddress));

    CsrWifiHipTaIndicateProtocolInd(priv->osLayerContext,
                                    interfaceTag,
                                    packet_type,
                                    taDirection,
                                    macSrcAddr);
} /* unifi_ta_indicate_protocol() */

/*
 * ---------------------------------------------------------------------------
 * unifi_ta_indicate_sampling
 *
 *      Send the TA sampling information to the SME.
 *
 *  Arguments:
 *      ospriv  The device context pointer.
 *      stats   The TA sampling data to send.
 *      interfaceTag
 *
 *  Returns:
 *      None.
 * ---------------------------------------------------------------------------
 */
void unifi_ta_indicate_sampling(void *ospriv, CsrWifiRouterCtrlTrafficStats *stats, CsrUint16 interfaceTag)
{
    CsrWifiHipHalPriv *priv = (CsrWifiHipHalPriv *) ospriv;

    if (!priv)
    {
        return;
    }

    CsrWifiHipTaIndicateSamplingInd(priv->osLayerContext,
                                    interfaceTag,
                                    stats);
} /* unifi_ta_indicate_sampling() */
