/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#include "csr_synergy.h"

#include "csr_types.h"
#include "csr_wifi_hip_hal_priv.h"
#include "csr_framework_ext.h"

#include "csr_util.h"
#include "csr_pmem.h"

void unifi_net_data_free(void *priv, CsrWifiHipBulkDataDesc *bulk_data_slot)
{
    CsrWifiHipHalPriv *halPriv = priv;

    halPriv->freeFrame(halPriv->osLayerContext, bulk_data_slot);
}

CsrResult unifi_net_data_malloc(void *priv, CsrWifiHipBulkDataDesc *bulk_data_slot, CsrUint32 size)
{
    CsrWifiHipHalPriv *halPriv = priv;

    return halPriv->allocFrame(halPriv->osLayerContext, bulk_data_slot, size);
}
