/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#ifndef CSR_WIFI_SME_PRIM_H__
#define CSR_WIFI_SME_PRIM_H__

#include "csr_synergy.h"

#include "csr_types.h"
#include "csr_prim_defs.h"
#include "csr_sched.h"
#include "csr_wifi_common.h"
#include "csr_result.h"
#include "csr_wifi_fsm_event.h"

#ifdef __cplusplus
extern "C" {
#endif

#define CSR_WIFI_SME_PRIM                                               (0x0404)

typedef CsrPrim CsrWifiSmePrim;


/*******************************************************************************

  NAME
    CsrWifiSme80211PrivacyMode

  DESCRIPTION
    Bits to enable or disable the privacy mode

 VALUES
    CSR_WIFI_SME_80211_PRIVACY_MODE_DISABLED
                   - Privacy mode is enabled: use of WEP for confidentiality is
                     required.
    CSR_WIFI_SME_80211_PRIVACY_MODE_ENABLED
                   - Privacy mode is disabled

*******************************************************************************/
typedef CsrUint8 CsrWifiSme80211PrivacyMode;
#define CSR_WIFI_SME_80211_PRIVACY_MODE_DISABLED   ((CsrWifiSme80211PrivacyMode) 0x00)
#define CSR_WIFI_SME_80211_PRIVACY_MODE_ENABLED    ((CsrWifiSme80211PrivacyMode) 0x01)

/*******************************************************************************

  NAME
    CsrWifiSmeAmpStatus

  DESCRIPTION
    AMP Current Status

 VALUES
    CSR_WIFI_SME_AMP_ACTIVE   - AMP ACTIVE.
    CSR_WIFI_SME_AMP_INACTIVE - AMP INACTIVE

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeAmpStatus;
#define CSR_WIFI_SME_AMP_ACTIVE     ((CsrWifiSmeAmpStatus) 0x00)
#define CSR_WIFI_SME_AMP_INACTIVE   ((CsrWifiSmeAmpStatus) 0x01)

/*******************************************************************************

  NAME
    CsrWifiSmeAuthMode

  DESCRIPTION
    Define bits for CsrWifiSmeAuthMode

 VALUES
    CSR_WIFI_SME_AUTH_MODE_80211_OPEN
                   - Connects to an open system network (i.e. no authentication,
                     no encryption) or to a WEP enabled network.
    CSR_WIFI_SME_AUTH_MODE_80211_SHARED
                   - Connect to a WEP enabled network.
    CSR_WIFI_SME_AUTH_MODE_8021X_WPA
                   - Connects to a WPA Enterprise enabled network.
    CSR_WIFI_SME_AUTH_MODE_8021X_WPAPSK
                   - Connects to a WPA with Pre-Shared Key enabled network.
    CSR_WIFI_SME_AUTH_MODE_8021X_WPA2
                   - Connects to a WPA2 Enterprise enabled network.
    CSR_WIFI_SME_AUTH_MODE_8021X_WPA2PSK
                   - Connects to a WPA2 with Pre-Shared Key enabled network.
    CSR_WIFI_SME_AUTH_MODE_8021X_CCKM
                   - Connects to a CCKM enabled network.
    CSR_WIFI_SME_AUTH_MODE_WAPI_WAI
                   - Connects to a WAPI Enterprise enabled network.
    CSR_WIFI_SME_AUTH_MODE_WAPI_WAIPSK
                   - Connects to a WAPI with Pre-Shared Key enabled network.
    CSR_WIFI_SME_AUTH_MODE_8021X_OTHER1X
                   - For future use.

*******************************************************************************/
typedef CsrUint16 CsrWifiSmeAuthMode;
#define CSR_WIFI_SME_AUTH_MODE_80211_OPEN      ((CsrWifiSmeAuthMode) 0x0001)
#define CSR_WIFI_SME_AUTH_MODE_80211_SHARED    ((CsrWifiSmeAuthMode) 0x0002)
#define CSR_WIFI_SME_AUTH_MODE_8021X_WPA       ((CsrWifiSmeAuthMode) 0x0004)
#define CSR_WIFI_SME_AUTH_MODE_8021X_WPAPSK    ((CsrWifiSmeAuthMode) 0x0008)
#define CSR_WIFI_SME_AUTH_MODE_8021X_WPA2      ((CsrWifiSmeAuthMode) 0x0010)
#define CSR_WIFI_SME_AUTH_MODE_8021X_WPA2PSK   ((CsrWifiSmeAuthMode) 0x0020)
#define CSR_WIFI_SME_AUTH_MODE_8021X_CCKM      ((CsrWifiSmeAuthMode) 0x0040)
#define CSR_WIFI_SME_AUTH_MODE_WAPI_WAI        ((CsrWifiSmeAuthMode) 0x0080)
#define CSR_WIFI_SME_AUTH_MODE_WAPI_WAIPSK     ((CsrWifiSmeAuthMode) 0x0100)
#define CSR_WIFI_SME_AUTH_MODE_8021X_OTHER1X   ((CsrWifiSmeAuthMode) 0x0200)

/*******************************************************************************

  NAME
    CsrWifiSmeBasicUsability

  DESCRIPTION
    Indicates the usability level of a channel

 VALUES
    CSR_WIFI_SME_BASIC_USABILITY_UNUSABLE
                   - Not usable; connection not recommended
    CSR_WIFI_SME_BASIC_USABILITY_POOR
                   - Poor quality; connect only if nothing better is available
    CSR_WIFI_SME_BASIC_USABILITY_SATISFACTORY
                   - Quality is satisfactory
    CSR_WIFI_SME_BASIC_USABILITY_NOT_CONNECTED
                   - Not connected

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeBasicUsability;
#define CSR_WIFI_SME_BASIC_USABILITY_UNUSABLE        ((CsrWifiSmeBasicUsability) 0x00)
#define CSR_WIFI_SME_BASIC_USABILITY_POOR            ((CsrWifiSmeBasicUsability) 0x01)
#define CSR_WIFI_SME_BASIC_USABILITY_SATISFACTORY    ((CsrWifiSmeBasicUsability) 0x02)
#define CSR_WIFI_SME_BASIC_USABILITY_NOT_CONNECTED   ((CsrWifiSmeBasicUsability) 0x03)

/*******************************************************************************

  NAME
    CsrWifiSmeBssType

  DESCRIPTION
    Indicates the BSS type

 VALUES
    CSR_WIFI_SME_BSS_TYPE_INFRASTRUCTURE
                   - Infrastructure BSS.
    CSR_WIFI_SME_BSS_TYPE_ADHOC
                   - Ad hoc or Independent BSS.
    CSR_WIFI_SME_BSS_TYPE_ANY_BSS
                   - Specifies any type of BSS
    CSR_WIFI_SME_BSS_TYPE_P2P
                   - Specifies P2P

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeBssType;
#define CSR_WIFI_SME_BSS_TYPE_INFRASTRUCTURE   ((CsrWifiSmeBssType) 0x00)
#define CSR_WIFI_SME_BSS_TYPE_ADHOC            ((CsrWifiSmeBssType) 0x01)
#define CSR_WIFI_SME_BSS_TYPE_ANY_BSS          ((CsrWifiSmeBssType) 0x02)
#define CSR_WIFI_SME_BSS_TYPE_P2P              ((CsrWifiSmeBssType) 0x03)

/*******************************************************************************

  NAME
    CsrWifiSmeControlIndication

  DESCRIPTION
    Indicates the reason why the Wi-Fi has been switched off.
    The values of this type are used across the NME/SME/Router API's and they
    must be kept consistent with the corresponding types in the .xml of the
    ottherinterfaces

 VALUES
    CSR_WIFI_SME_CONTROL_INDICATION_ERROR
                   - An unrecoverable error (for example, an unrecoverable SDIO
                     error) has occurred.
                     The wireless manager application should reinitialise the
                     chip by calling CSR_WIFI_SME_WIFI_ON_REQ.
    CSR_WIFI_SME_CONTROL_INDICATION_EXIT
                   - The chip became unavailable due to an external action, for
                     example, when a plug-in card is ejected or the driver is
                     unloaded.
    CSR_WIFI_SME_CONTROL_INDICATION_USER_REQUESTED
                   - The Wi-Fi has been switched off as the wireless manager
                     application has sent CSR_WIFI_SME_WIFI_OFF_REQ

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeControlIndication;
#define CSR_WIFI_SME_CONTROL_INDICATION_ERROR            ((CsrWifiSmeControlIndication) 0x01)
#define CSR_WIFI_SME_CONTROL_INDICATION_EXIT             ((CsrWifiSmeControlIndication) 0x02)
#define CSR_WIFI_SME_CONTROL_INDICATION_USER_REQUESTED   ((CsrWifiSmeControlIndication) 0x03)

/*******************************************************************************

  NAME
    CsrWifiSmeCtsProtectionType

  DESCRIPTION
    SME CTS Protection Types

 VALUES
    CSR_WIFI_SME_CTS_PROTECTION_AUTOMATIC
                   - AP CTS Protection automatic based on non-ERP station in own
                     BSS or neighbouring BSS on the same channel based on OLBC.
                     This requires monitoring of beacons from other APs.
    CSR_WIFI_SME_CTS_PROTECTION_FORCE_ENABLED
                   - AP CTS Protection Force enabled
    CSR_WIFI_SME_CTS_PROTECTION_FORCE_DISABLED
                   - AP CTS Protection Force disabled.
    CSR_WIFI_SME_CTS_PROTECTION_AUTOMATIC_NO_OLBC
                   - AP CTS Protection automatic without considering OLBC but
                     considering non-ERP station in the own BSS Valid only if AP
                     is configured to work in 802.11bg or 802.11g mode otherwise
                     this option specifies the same behaviour as AUTOMATIC

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeCtsProtectionType;
#define CSR_WIFI_SME_CTS_PROTECTION_AUTOMATIC           ((CsrWifiSmeCtsProtectionType) 0x00)
#define CSR_WIFI_SME_CTS_PROTECTION_FORCE_ENABLED       ((CsrWifiSmeCtsProtectionType) 0x01)
#define CSR_WIFI_SME_CTS_PROTECTION_FORCE_DISABLED      ((CsrWifiSmeCtsProtectionType) 0x02)
#define CSR_WIFI_SME_CTS_PROTECTION_AUTOMATIC_NO_OLBC   ((CsrWifiSmeCtsProtectionType) 0x03)

/*******************************************************************************

  NAME
    CsrWifiSmeEncryption

  DESCRIPTION
    Defines bits for CsrWifiSmeEncryption
    For a WEP enabled network, the caller must specify the correct
    combination of flags in the encryptionModeMask.

 VALUES
    CSR_WIFI_SME_ENCRYPTION_CIPHER_NONE
                   - No encryption set
    CSR_WIFI_SME_ENCRYPTION_CIPHER_PAIRWISE_WEP40
                   - Selects 40 byte key WEP for unicast communication
    CSR_WIFI_SME_ENCRYPTION_CIPHER_PAIRWISE_WEP104
                   - Selects 104 byte key WEP for unicast communication
    CSR_WIFI_SME_ENCRYPTION_CIPHER_PAIRWISE_TKIP
                   - Selects TKIP for unicast communication
    CSR_WIFI_SME_ENCRYPTION_CIPHER_PAIRWISE_CCMP
                   - Selects CCMP for unicast communication
    CSR_WIFI_SME_ENCRYPTION_CIPHER_PAIRWISE_SMS4
                   - Selects SMS4 for unicast communication
    CSR_WIFI_SME_ENCRYPTION_CIPHER_GROUP_WEP40
                   - Selects 40 byte key WEP for broadcast messages
    CSR_WIFI_SME_ENCRYPTION_CIPHER_GROUP_WEP104
                   - Selects 104 byte key WEP for broadcast messages
    CSR_WIFI_SME_ENCRYPTION_CIPHER_GROUP_TKIP
                   - Selects a TKIP for broadcast messages
    CSR_WIFI_SME_ENCRYPTION_CIPHER_GROUP_CCMP
                   - Selects CCMP for broadcast messages
    CSR_WIFI_SME_ENCRYPTION_CIPHER_GROUP_SMS4
                   - Selects SMS4 for broadcast messages
    CSR_WIFI_SME_ENCRYPTION_CIPHER_GROUP_MGT_BIP
                   - Selects AES-128-CMAC for broadcast management messages

*******************************************************************************/
typedef CsrUint16 CsrWifiSmeEncryption;
#define CSR_WIFI_SME_ENCRYPTION_CIPHER_NONE              ((CsrWifiSmeEncryption) 0x0000)
#define CSR_WIFI_SME_ENCRYPTION_CIPHER_PAIRWISE_WEP40    ((CsrWifiSmeEncryption) 0x0001)
#define CSR_WIFI_SME_ENCRYPTION_CIPHER_PAIRWISE_WEP104   ((CsrWifiSmeEncryption) 0x0002)
#define CSR_WIFI_SME_ENCRYPTION_CIPHER_PAIRWISE_TKIP     ((CsrWifiSmeEncryption) 0x0004)
#define CSR_WIFI_SME_ENCRYPTION_CIPHER_PAIRWISE_CCMP     ((CsrWifiSmeEncryption) 0x0008)
#define CSR_WIFI_SME_ENCRYPTION_CIPHER_PAIRWISE_SMS4     ((CsrWifiSmeEncryption) 0x0010)
#define CSR_WIFI_SME_ENCRYPTION_CIPHER_GROUP_WEP40       ((CsrWifiSmeEncryption) 0x0020)
#define CSR_WIFI_SME_ENCRYPTION_CIPHER_GROUP_WEP104      ((CsrWifiSmeEncryption) 0x0040)
#define CSR_WIFI_SME_ENCRYPTION_CIPHER_GROUP_TKIP        ((CsrWifiSmeEncryption) 0x0080)
#define CSR_WIFI_SME_ENCRYPTION_CIPHER_GROUP_CCMP        ((CsrWifiSmeEncryption) 0x0100)
#define CSR_WIFI_SME_ENCRYPTION_CIPHER_GROUP_SMS4        ((CsrWifiSmeEncryption) 0x0200)
#define CSR_WIFI_SME_ENCRYPTION_CIPHER_GROUP_MGT_BIP     ((CsrWifiSmeEncryption) 0x0400)

/*******************************************************************************

  NAME
    CsrWifiSmeIEEE80211Reason

  DESCRIPTION
    As definined in the IEEE 802.11 standards

 VALUES
    CSR_WIFI_SME_IEEE80211_REASON_SUCCESS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_UNSPECIFIED_REASON
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_AUTHENTICATION_NOT_VALID
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_DEAUTHENTICATED_LEAVE_BSS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_DISASSOCIATED_INACTIVITY
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_AP_OVERLOAD
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_CLASS_2FRAME_ERROR
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_CLASS_3FRAME_ERROR
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_DISASSOCIATED_LEAVE_BSS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_ASSOCIATION_NOT_AUTHENTICATED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_DISASSOCIATED_POWER_CAPABILITY
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_DISASSOCIATED_SUPPORTED_CHANNELS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_INVALID_INFORMATION_ELEMENT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_MICHAEL_MIC_FAILURE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_FOURWAY_HANDSHAKE_TIMEOUT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_GROUP_KEY_UPDATE_TIMEOUT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_HANDSHAKE_ELEMENT_DIFFERENT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_INVALID_GROUP_CIPHER
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_INVALID_PAIRWISE_CIPHER
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_INVALID_AKMP
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_UNSUPPORTED_RSN_IEVERSION
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_INVALID_RSN_IECAPABILITIES
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_DOT1X_AUTH_FAILED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_CIPHER_REJECTED_BY_POLICY
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_SERVICE_CHANGE_PRECLUDES_TS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_QOS_UNSPECIFIED_REASON
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_QOS_INSUFFICIENT_BANDWIDTH
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_QOS_EXCESSIVE_NOT_ACK
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_QOS_TXOPLIMIT_EXCEEDED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_QSTA_LEAVING
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_END_TS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_END_DLS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_END_BA
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_UNKNOWN_TS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_UNKNOWN_BA
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_UNKNOWN_DLS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_TIMEOUT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_STAKEY_MISMATCH
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_UNICAST_KEY_NEGOTIATION_TIMEOUT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_MULTICAST_KEY_ANNOUNCEMENT_TIMEOUT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_INCOMPATIBLE_UNICAST_KEY_NEGOTIATION_IE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_INVALID_MULTICAST_CIPHER
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_INVALID_UNICAST_CIPHER
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_UNSUPPORTED_WAPI_IE_VERSION
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_INVALID_WAPI_CAPABILITY_IE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_REASON_WAI_CERTIFICATE_AUTHENTICATION_FAILED
                   - See IEEE 802.11 Standard

*******************************************************************************/
typedef CsrUint16 CsrWifiSmeIEEE80211Reason;
#define CSR_WIFI_SME_IEEE80211_REASON_SUCCESS                                   ((CsrWifiSmeIEEE80211Reason) 0x0000)
#define CSR_WIFI_SME_IEEE80211_REASON_UNSPECIFIED_REASON                        ((CsrWifiSmeIEEE80211Reason) 0x0001)
#define CSR_WIFI_SME_IEEE80211_REASON_AUTHENTICATION_NOT_VALID                  ((CsrWifiSmeIEEE80211Reason) 0x0002)
#define CSR_WIFI_SME_IEEE80211_REASON_DEAUTHENTICATED_LEAVE_BSS                 ((CsrWifiSmeIEEE80211Reason) 0x0003)
#define CSR_WIFI_SME_IEEE80211_REASON_DISASSOCIATED_INACTIVITY                  ((CsrWifiSmeIEEE80211Reason) 0x0004)
#define CSR_WIFI_SME_IEEE80211_REASON_AP_OVERLOAD                               ((CsrWifiSmeIEEE80211Reason) 0x0005)
#define CSR_WIFI_SME_IEEE80211_REASON_CLASS_2FRAME_ERROR                        ((CsrWifiSmeIEEE80211Reason) 0x0006)
#define CSR_WIFI_SME_IEEE80211_REASON_CLASS_3FRAME_ERROR                        ((CsrWifiSmeIEEE80211Reason) 0x0007)
#define CSR_WIFI_SME_IEEE80211_REASON_DISASSOCIATED_LEAVE_BSS                   ((CsrWifiSmeIEEE80211Reason) 0x0008)
#define CSR_WIFI_SME_IEEE80211_REASON_ASSOCIATION_NOT_AUTHENTICATED             ((CsrWifiSmeIEEE80211Reason) 0x0009)
#define CSR_WIFI_SME_IEEE80211_REASON_DISASSOCIATED_POWER_CAPABILITY            ((CsrWifiSmeIEEE80211Reason) 0x000a)
#define CSR_WIFI_SME_IEEE80211_REASON_DISASSOCIATED_SUPPORTED_CHANNELS          ((CsrWifiSmeIEEE80211Reason) 0x000b)
#define CSR_WIFI_SME_IEEE80211_REASON_INVALID_INFORMATION_ELEMENT               ((CsrWifiSmeIEEE80211Reason) 0x000d)
#define CSR_WIFI_SME_IEEE80211_REASON_MICHAEL_MIC_FAILURE                       ((CsrWifiSmeIEEE80211Reason) 0x000e)
#define CSR_WIFI_SME_IEEE80211_REASON_FOURWAY_HANDSHAKE_TIMEOUT                 ((CsrWifiSmeIEEE80211Reason) 0x000f)
#define CSR_WIFI_SME_IEEE80211_REASON_GROUP_KEY_UPDATE_TIMEOUT                  ((CsrWifiSmeIEEE80211Reason) 0x0010)
#define CSR_WIFI_SME_IEEE80211_REASON_HANDSHAKE_ELEMENT_DIFFERENT               ((CsrWifiSmeIEEE80211Reason) 0x0011)
#define CSR_WIFI_SME_IEEE80211_REASON_INVALID_GROUP_CIPHER                      ((CsrWifiSmeIEEE80211Reason) 0x0012)
#define CSR_WIFI_SME_IEEE80211_REASON_INVALID_PAIRWISE_CIPHER                   ((CsrWifiSmeIEEE80211Reason) 0x0013)
#define CSR_WIFI_SME_IEEE80211_REASON_INVALID_AKMP                              ((CsrWifiSmeIEEE80211Reason) 0x0014)
#define CSR_WIFI_SME_IEEE80211_REASON_UNSUPPORTED_RSN_IEVERSION                 ((CsrWifiSmeIEEE80211Reason) 0x0015)
#define CSR_WIFI_SME_IEEE80211_REASON_INVALID_RSN_IECAPABILITIES                ((CsrWifiSmeIEEE80211Reason) 0x0016)
#define CSR_WIFI_SME_IEEE80211_REASON_DOT1X_AUTH_FAILED                         ((CsrWifiSmeIEEE80211Reason) 0x0017)
#define CSR_WIFI_SME_IEEE80211_REASON_CIPHER_REJECTED_BY_POLICY                 ((CsrWifiSmeIEEE80211Reason) 0x0018)
#define CSR_WIFI_SME_IEEE80211_REASON_SERVICE_CHANGE_PRECLUDES_TS               ((CsrWifiSmeIEEE80211Reason) 0x001F)
#define CSR_WIFI_SME_IEEE80211_REASON_QOS_UNSPECIFIED_REASON                    ((CsrWifiSmeIEEE80211Reason) 0x0020)
#define CSR_WIFI_SME_IEEE80211_REASON_QOS_INSUFFICIENT_BANDWIDTH                ((CsrWifiSmeIEEE80211Reason) 0x0021)
#define CSR_WIFI_SME_IEEE80211_REASON_QOS_EXCESSIVE_NOT_ACK                     ((CsrWifiSmeIEEE80211Reason) 0x0022)
#define CSR_WIFI_SME_IEEE80211_REASON_QOS_TXOPLIMIT_EXCEEDED                    ((CsrWifiSmeIEEE80211Reason) 0x0023)
#define CSR_WIFI_SME_IEEE80211_REASON_QSTA_LEAVING                              ((CsrWifiSmeIEEE80211Reason) 0x0024)
#define CSR_WIFI_SME_IEEE80211_REASON_END_TS                                    ((CsrWifiSmeIEEE80211Reason) 0x0025)
#define CSR_WIFI_SME_IEEE80211_REASON_END_DLS                                   ((CsrWifiSmeIEEE80211Reason) 0x0025)
#define CSR_WIFI_SME_IEEE80211_REASON_END_BA                                    ((CsrWifiSmeIEEE80211Reason) 0x0025)
#define CSR_WIFI_SME_IEEE80211_REASON_UNKNOWN_TS                                ((CsrWifiSmeIEEE80211Reason) 0x0026)
#define CSR_WIFI_SME_IEEE80211_REASON_UNKNOWN_BA                                ((CsrWifiSmeIEEE80211Reason) 0x0026)
#define CSR_WIFI_SME_IEEE80211_REASON_UNKNOWN_DLS                               ((CsrWifiSmeIEEE80211Reason) 0x0026)
#define CSR_WIFI_SME_IEEE80211_REASON_TIMEOUT                                   ((CsrWifiSmeIEEE80211Reason) 0x0027)
#define CSR_WIFI_SME_IEEE80211_REASON_STAKEY_MISMATCH                           ((CsrWifiSmeIEEE80211Reason) 0x002d)
#define CSR_WIFI_SME_IEEE80211_REASON_UNICAST_KEY_NEGOTIATION_TIMEOUT           ((CsrWifiSmeIEEE80211Reason) 0xf019)
#define CSR_WIFI_SME_IEEE80211_REASON_MULTICAST_KEY_ANNOUNCEMENT_TIMEOUT        ((CsrWifiSmeIEEE80211Reason) 0xf01a)
#define CSR_WIFI_SME_IEEE80211_REASON_INCOMPATIBLE_UNICAST_KEY_NEGOTIATION_IE   ((CsrWifiSmeIEEE80211Reason) 0xf01b)
#define CSR_WIFI_SME_IEEE80211_REASON_INVALID_MULTICAST_CIPHER                  ((CsrWifiSmeIEEE80211Reason) 0xf01c)
#define CSR_WIFI_SME_IEEE80211_REASON_INVALID_UNICAST_CIPHER                    ((CsrWifiSmeIEEE80211Reason) 0xf01d)
#define CSR_WIFI_SME_IEEE80211_REASON_UNSUPPORTED_WAPI_IE_VERSION               ((CsrWifiSmeIEEE80211Reason) 0xf01e)
#define CSR_WIFI_SME_IEEE80211_REASON_INVALID_WAPI_CAPABILITY_IE                ((CsrWifiSmeIEEE80211Reason) 0xf01f)
#define CSR_WIFI_SME_IEEE80211_REASON_WAI_CERTIFICATE_AUTHENTICATION_FAILED     ((CsrWifiSmeIEEE80211Reason) 0xf020)

/*******************************************************************************

  NAME
    CsrWifiSmeIEEE80211Result

  DESCRIPTION
    As definined in the IEEE 802.11 standards

 VALUES
    CSR_WIFI_SME_IEEE80211_RESULT_SUCCESS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_UNSPECIFIED_FAILURE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_CAPABILITIES_MISMATCH
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REASSOCIATION_DENIED_NO_ASSOCIATION
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_EXTERNAL_REASON
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_AUTHENTICATION_MISMATCH
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_INVALID_AUTHENTICATION_SEQUENCE_NUMBER
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_CHALLENGE_FAILURE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_AUTHENTICATION_TIMEOUT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_AP_OUT_OF_MEMORY
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_BASIC_RATES_MISMATCH
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_SHORT_PREAMBLE_REQUIRED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_PBCC_MODULATION_REQUIRED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_CHANNEL_AGILITY_REQUIRED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_SPECTRUM_MANAGEMENT_REQUIRED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_POWER_CAPABILITY_UNACCEPTABLE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_SUPPORTED_CHANNELS_UNACCEPTABLE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_SHORT_SLOT_REQUIRED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_DSSS_OFDMREQUIRED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_NO_HT_SUPPORT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_R0KH_UNREACHABLE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_PCO_TRANSITION_SUPPORT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_ASSOCIATION_REQUEST_REJECTED_TEMPORARILY
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_ROBUST_MANAGEMENT_FRAME_POLICY_VIOLATION
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_FAILURE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_AP_BANDWIDTH_INSUFFICIENT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_POOR_OPERATING_CHANNEL
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_QOS_REQUIRED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_REASON_UNSPECIFIED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_INVALID_PARAMETERS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_WITH_SUGGESTED_TSPEC_CHANGES
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_INVALID_IE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_INVALID_GROUP_CIPHER
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_INVALID_PAIRWISE_CIPHER
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_INVALID_AKMP
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_UNSUPPORTED_RSN_VERSION
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_INVALID_RSN_CAPABILITY
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_SECURITY_POLICY
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_FOR_DELAY_PERIOD
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_NOT_ALLOWED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_NOT_PRESENT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_NOT_QSTA
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_LISTEN_INTERVAL_TOO_LARGE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_INVALID_FT_ACTION_FRAME_COUNT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_INVALID_PMKID
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_INVALID_MDIE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_INVALID_FTIE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_UNSPECIFIED_QOS_FAILURE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_WRONG_POLICY
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_INSUFFICIENT_BANDWIDTH
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_INVALID_TSPEC_PARAMETERS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_TIMEOUT
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_TOO_MANY_SIMULTANEOUS_REQUESTS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_BSS_ALREADY_STARTED_OR_JOINED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_NOT_SUPPORTED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_TRANSMISSION_FAILURE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_NOT_AUTHENTICATED
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_RESET_REQUIRED_BEFORE_START
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_LM_INFO_UNAVAILABLE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_INVALID_UNICAST_CIPHER
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_INVALID_MULTICAST_CIPHER
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_UNSUPPORTED_WAPI_IE_VERSION
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_IEEE80211_RESULT_INVALID_WAPI_CAPABILITY_IE
                   - See IEEE 802.11 Standard

*******************************************************************************/
typedef CsrUint16 CsrWifiSmeIEEE80211Result;
#define CSR_WIFI_SME_IEEE80211_RESULT_SUCCESS                                          ((CsrWifiSmeIEEE80211Result) 0x0000)
#define CSR_WIFI_SME_IEEE80211_RESULT_UNSPECIFIED_FAILURE                              ((CsrWifiSmeIEEE80211Result) 0x0001)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_CAPABILITIES_MISMATCH                    ((CsrWifiSmeIEEE80211Result) 0x000a)
#define CSR_WIFI_SME_IEEE80211_RESULT_REASSOCIATION_DENIED_NO_ASSOCIATION              ((CsrWifiSmeIEEE80211Result) 0x000b)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_EXTERNAL_REASON                          ((CsrWifiSmeIEEE80211Result) 0x000c)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_AUTHENTICATION_MISMATCH                  ((CsrWifiSmeIEEE80211Result) 0x000d)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_INVALID_AUTHENTICATION_SEQUENCE_NUMBER   ((CsrWifiSmeIEEE80211Result) 0x000e)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_CHALLENGE_FAILURE                        ((CsrWifiSmeIEEE80211Result) 0x000f)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_AUTHENTICATION_TIMEOUT                   ((CsrWifiSmeIEEE80211Result) 0x0010)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_AP_OUT_OF_MEMORY                         ((CsrWifiSmeIEEE80211Result) 0x0011)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_BASIC_RATES_MISMATCH                     ((CsrWifiSmeIEEE80211Result) 0x0012)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_SHORT_PREAMBLE_REQUIRED                  ((CsrWifiSmeIEEE80211Result) 0x0013)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_PBCC_MODULATION_REQUIRED                 ((CsrWifiSmeIEEE80211Result) 0x0014)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_CHANNEL_AGILITY_REQUIRED                 ((CsrWifiSmeIEEE80211Result) 0x0015)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_SPECTRUM_MANAGEMENT_REQUIRED             ((CsrWifiSmeIEEE80211Result) 0x0016)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_POWER_CAPABILITY_UNACCEPTABLE            ((CsrWifiSmeIEEE80211Result) 0x0017)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_SUPPORTED_CHANNELS_UNACCEPTABLE          ((CsrWifiSmeIEEE80211Result) 0x0018)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_SHORT_SLOT_REQUIRED                      ((CsrWifiSmeIEEE80211Result) 0x0019)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_DSSS_OFDMREQUIRED                        ((CsrWifiSmeIEEE80211Result) 0x001a)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_NO_HT_SUPPORT                            ((CsrWifiSmeIEEE80211Result) 0x001b)
#define CSR_WIFI_SME_IEEE80211_RESULT_R0KH_UNREACHABLE                                 ((CsrWifiSmeIEEE80211Result) 0x001c)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_PCO_TRANSITION_SUPPORT                   ((CsrWifiSmeIEEE80211Result) 0x001d)
#define CSR_WIFI_SME_IEEE80211_RESULT_ASSOCIATION_REQUEST_REJECTED_TEMPORARILY         ((CsrWifiSmeIEEE80211Result) 0x001e)
#define CSR_WIFI_SME_IEEE80211_RESULT_ROBUST_MANAGEMENT_FRAME_POLICY_VIOLATION         ((CsrWifiSmeIEEE80211Result) 0x001f)
#define CSR_WIFI_SME_IEEE80211_RESULT_FAILURE                                          ((CsrWifiSmeIEEE80211Result) 0x0020)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_AP_BANDWIDTH_INSUFFICIENT                ((CsrWifiSmeIEEE80211Result) 0x0021)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_POOR_OPERATING_CHANNEL                   ((CsrWifiSmeIEEE80211Result) 0x0022)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_QOS_REQUIRED                             ((CsrWifiSmeIEEE80211Result) 0x0023)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_REASON_UNSPECIFIED                       ((CsrWifiSmeIEEE80211Result) 0x0025)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED                                          ((CsrWifiSmeIEEE80211Result) 0x0025)
#define CSR_WIFI_SME_IEEE80211_RESULT_INVALID_PARAMETERS                               ((CsrWifiSmeIEEE80211Result) 0x0026)
#define CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_WITH_SUGGESTED_TSPEC_CHANGES            ((CsrWifiSmeIEEE80211Result) 0x0027)
#define CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_INVALID_IE                              ((CsrWifiSmeIEEE80211Result) 0x0028)
#define CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_INVALID_GROUP_CIPHER                    ((CsrWifiSmeIEEE80211Result) 0x0029)
#define CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_INVALID_PAIRWISE_CIPHER                 ((CsrWifiSmeIEEE80211Result) 0x002a)
#define CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_INVALID_AKMP                            ((CsrWifiSmeIEEE80211Result) 0x002b)
#define CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_UNSUPPORTED_RSN_VERSION                 ((CsrWifiSmeIEEE80211Result) 0x002c)
#define CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_INVALID_RSN_CAPABILITY                  ((CsrWifiSmeIEEE80211Result) 0x002d)
#define CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_SECURITY_POLICY                         ((CsrWifiSmeIEEE80211Result) 0x002e)
#define CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_FOR_DELAY_PERIOD                        ((CsrWifiSmeIEEE80211Result) 0x002f)
#define CSR_WIFI_SME_IEEE80211_RESULT_NOT_ALLOWED                                      ((CsrWifiSmeIEEE80211Result) 0x0030)
#define CSR_WIFI_SME_IEEE80211_RESULT_NOT_PRESENT                                      ((CsrWifiSmeIEEE80211Result) 0x0031)
#define CSR_WIFI_SME_IEEE80211_RESULT_NOT_QSTA                                         ((CsrWifiSmeIEEE80211Result) 0x0032)
#define CSR_WIFI_SME_IEEE80211_RESULT_REJECTED_LISTEN_INTERVAL_TOO_LARGE               ((CsrWifiSmeIEEE80211Result) 0x0033)
#define CSR_WIFI_SME_IEEE80211_RESULT_INVALID_FT_ACTION_FRAME_COUNT                    ((CsrWifiSmeIEEE80211Result) 0x0034)
#define CSR_WIFI_SME_IEEE80211_RESULT_INVALID_PMKID                                    ((CsrWifiSmeIEEE80211Result) 0x0035)
#define CSR_WIFI_SME_IEEE80211_RESULT_INVALID_MDIE                                     ((CsrWifiSmeIEEE80211Result) 0x0036)
#define CSR_WIFI_SME_IEEE80211_RESULT_INVALID_FTIE                                     ((CsrWifiSmeIEEE80211Result) 0x0037)
#define CSR_WIFI_SME_IEEE80211_RESULT_UNSPECIFIED_QOS_FAILURE                          ((CsrWifiSmeIEEE80211Result) 0x00c8)
#define CSR_WIFI_SME_IEEE80211_RESULT_WRONG_POLICY                                     ((CsrWifiSmeIEEE80211Result) 0x00c9)
#define CSR_WIFI_SME_IEEE80211_RESULT_INSUFFICIENT_BANDWIDTH                           ((CsrWifiSmeIEEE80211Result) 0x00ca)
#define CSR_WIFI_SME_IEEE80211_RESULT_INVALID_TSPEC_PARAMETERS                         ((CsrWifiSmeIEEE80211Result) 0x00cb)
#define CSR_WIFI_SME_IEEE80211_RESULT_TIMEOUT                                          ((CsrWifiSmeIEEE80211Result) 0x8000)
#define CSR_WIFI_SME_IEEE80211_RESULT_TOO_MANY_SIMULTANEOUS_REQUESTS                   ((CsrWifiSmeIEEE80211Result) 0x8001)
#define CSR_WIFI_SME_IEEE80211_RESULT_BSS_ALREADY_STARTED_OR_JOINED                    ((CsrWifiSmeIEEE80211Result) 0x8002)
#define CSR_WIFI_SME_IEEE80211_RESULT_NOT_SUPPORTED                                    ((CsrWifiSmeIEEE80211Result) 0x8003)
#define CSR_WIFI_SME_IEEE80211_RESULT_TRANSMISSION_FAILURE                             ((CsrWifiSmeIEEE80211Result) 0x8004)
#define CSR_WIFI_SME_IEEE80211_RESULT_REFUSED_NOT_AUTHENTICATED                        ((CsrWifiSmeIEEE80211Result) 0x8005)
#define CSR_WIFI_SME_IEEE80211_RESULT_RESET_REQUIRED_BEFORE_START                      ((CsrWifiSmeIEEE80211Result) 0x8006)
#define CSR_WIFI_SME_IEEE80211_RESULT_LM_INFO_UNAVAILABLE                              ((CsrWifiSmeIEEE80211Result) 0x8007)
#define CSR_WIFI_SME_IEEE80211_RESULT_INVALID_UNICAST_CIPHER                           ((CsrWifiSmeIEEE80211Result) 0xf02f)
#define CSR_WIFI_SME_IEEE80211_RESULT_INVALID_MULTICAST_CIPHER                         ((CsrWifiSmeIEEE80211Result) 0xf030)
#define CSR_WIFI_SME_IEEE80211_RESULT_UNSUPPORTED_WAPI_IE_VERSION                      ((CsrWifiSmeIEEE80211Result) 0xf031)
#define CSR_WIFI_SME_IEEE80211_RESULT_INVALID_WAPI_CAPABILITY_IE                       ((CsrWifiSmeIEEE80211Result) 0xf032)

/*******************************************************************************

  NAME
    CsrWifiSmeIndications

  DESCRIPTION
    Defines bits for CsrWifiSmeIndicationsMask

 VALUES
    CSR_WIFI_SME_INDICATIONS_NONE
                   - Used to cancel the registrations for receiving indications
    CSR_WIFI_SME_INDICATIONS_WIFIOFF
                   - Used to register for CSR_WIFI_SME_WIFI_OFF_IND events
    CSR_WIFI_SME_INDICATIONS_SCANRESULT
                   - Used to register for CSR_WIFI_SME_SCAN_RESULT_IND events
    CSR_WIFI_SME_INDICATIONS_CONNECTIONQUALITY
                   - Used to register for CSR_WIFI_SME_CONNECTION_QUALITY_IND
                     events
    CSR_WIFI_SME_INDICATIONS_MEDIASTATUS
                   - Used to register for CSR_WIFI_SME_MEDIA_STATUS_IND events
    CSR_WIFI_SME_INDICATIONS_MICFAILURE
                   - Used to register for CSR_WIFI_SME_MICFAILURE_IND events
    CSR_WIFI_SME_INDICATIONS_PMKIDCANDIDATELIST
                   - Used to register for CSR_WIFI_SME_PMKIDCANDIDATE_LIST_IND
                     events
    CSR_WIFI_SME_INDICATIONS_TSPEC
                   - Used to register for CSR_WIFI_SME_TSPEC_IND events
    CSR_WIFI_SME_INDICATIONS_ROAMSTART
                   - Used to register for CSR_WIFI_SME_ROAM_START_IND events
    CSR_WIFI_SME_INDICATIONS_ROAMCOMPLETE
                   - Used to register for CSR_WIFI_SME_ROAM_COMPLETE_IND events
    CSR_WIFI_SME_INDICATIONS_ASSOCIATIONSTART
                   - Used to register for CSR_WIFI_SME_ASSOCIATION_START_IND
                     events
    CSR_WIFI_SME_INDICATIONS_ASSOCIATIONCOMPLETE
                   - Used to register for CSR_WIFI_SME_ASSOCIATION_COMPLETE_IND
                     events
    CSR_WIFI_SME_INDICATIONS_IBSSSTATION
                   - Used to register for CSR_WIFI_SME_IBSS_STATION_IND events
    CSR_WIFI_SME_INDICATIONS_WIFION
                   - Used to register for CSR_WIFI_SME_WIFI_ON_IND events
    CSR_WIFI_SME_INDICATIONS_COREDUMP
                   - Used to register for CSR_WIFI_SME_CORE_DUMP_IND events
    CSR_WIFI_SME_INDICATIONS_ADD_INTERFACE
                   - Used to register for CSR_WIFI_SME_ADD_INTERFACE_IND events
    CSR_WIFI_SME_INDICATIONS_DEL_INTERFACE
                   - Used to register for CSR_WIFI_SME_DEL_INTERFACE_IND events
    CSR_WIFI_SME_INDICATIONS_AMP_STATUS
                   - Used to register for CSR_WIFI_SME_AMP_STATUS_CHANGE_IND
                     events
    CSR_WIFI_SME_INDICATIONS_P2P_FIND
                   - Used to register for CSR_WIFI_SME_P2P_FIND_IND events
    CSR_WIFI_SME_INDICATIONS_P2P_PROVISION_DISCOVERY
                   - Used to register for
                     CSR_WIFI_SME_P2P_PROVISION_DISCOVERY_IND events
    CSR_WIFI_SME_INDICATIONS_P2P_LISTEN_STOP
                   - Used to register for CSR_WIFI_SME_P2P_LISTEN_STOP_IND
                     events
    CSR_WIFI_SME_INDICATIONS_SUSPEND
                   - Used to register for CSR_WIFI_SME_SUSPEND_IND events
    CSR_WIFI_SME_INDICATIONS_RESUME
                   - Used to register for CSR_WIFI_SME_RESUME_IND events
    CSR_WIFI_SME_INDICATIONS_SERVICE
                   - Used to register for CSR_WIFI_SME_SERVICE_ROLE_IND events
    CSR_WIFI_SME_INDICATIONS_ALL
                   - Used to register for all available indications

*******************************************************************************/
typedef CsrUint32 CsrWifiSmeIndications;
#define CSR_WIFI_SME_INDICATIONS_NONE                      ((CsrWifiSmeIndications) 0x00000000)
#define CSR_WIFI_SME_INDICATIONS_WIFIOFF                   ((CsrWifiSmeIndications) 0x00000001)
#define CSR_WIFI_SME_INDICATIONS_SCANRESULT                ((CsrWifiSmeIndications) 0x00000002)
#define CSR_WIFI_SME_INDICATIONS_CONNECTIONQUALITY         ((CsrWifiSmeIndications) 0x00000004)
#define CSR_WIFI_SME_INDICATIONS_MEDIASTATUS               ((CsrWifiSmeIndications) 0x00000008)
#define CSR_WIFI_SME_INDICATIONS_MICFAILURE                ((CsrWifiSmeIndications) 0x00000010)
#define CSR_WIFI_SME_INDICATIONS_PMKIDCANDIDATELIST        ((CsrWifiSmeIndications) 0x00000020)
#define CSR_WIFI_SME_INDICATIONS_TSPEC                     ((CsrWifiSmeIndications) 0x00000040)
#define CSR_WIFI_SME_INDICATIONS_ROAMSTART                 ((CsrWifiSmeIndications) 0x00000080)
#define CSR_WIFI_SME_INDICATIONS_ROAMCOMPLETE              ((CsrWifiSmeIndications) 0x00000100)
#define CSR_WIFI_SME_INDICATIONS_ASSOCIATIONSTART          ((CsrWifiSmeIndications) 0x00000200)
#define CSR_WIFI_SME_INDICATIONS_ASSOCIATIONCOMPLETE       ((CsrWifiSmeIndications) 0x00000400)
#define CSR_WIFI_SME_INDICATIONS_IBSSSTATION               ((CsrWifiSmeIndications) 0x00000800)
#define CSR_WIFI_SME_INDICATIONS_WIFION                    ((CsrWifiSmeIndications) 0x00001000)
#define CSR_WIFI_SME_INDICATIONS_COREDUMP                  ((CsrWifiSmeIndications) 0x00002000)
#define CSR_WIFI_SME_INDICATIONS_ADD_INTERFACE             ((CsrWifiSmeIndications) 0x00004000)
#define CSR_WIFI_SME_INDICATIONS_DEL_INTERFACE             ((CsrWifiSmeIndications) 0x00008000)
#define CSR_WIFI_SME_INDICATIONS_AMP_STATUS                ((CsrWifiSmeIndications) 0x00010000)
#define CSR_WIFI_SME_INDICATIONS_P2P_FIND                  ((CsrWifiSmeIndications) 0x00020000)
#define CSR_WIFI_SME_INDICATIONS_P2P_PROVISION_DISCOVERY   ((CsrWifiSmeIndications) 0x00040000)
#define CSR_WIFI_SME_INDICATIONS_P2P_LISTEN_STOP           ((CsrWifiSmeIndications) 0x00080000)
#define CSR_WIFI_SME_INDICATIONS_SUSPEND                   ((CsrWifiSmeIndications) 0x00100000)
#define CSR_WIFI_SME_INDICATIONS_RESUME                    ((CsrWifiSmeIndications) 0x00200000)
#define CSR_WIFI_SME_INDICATIONS_SERVICE                   ((CsrWifiSmeIndications) 0x00400000)
#define CSR_WIFI_SME_INDICATIONS_ALL                       ((CsrWifiSmeIndications) 0xFFFFFFFF)

/*******************************************************************************

  NAME
    CsrWifiSmeKeyType

  DESCRIPTION
    Indicates the type of the key

 VALUES
    CSR_WIFI_SME_KEY_TYPE_GROUP    - Key for broadcast communication
    CSR_WIFI_SME_KEY_TYPE_PAIRWISE - Key for unicast communication
    CSR_WIFI_SME_KEY_TYPE_STAKEY   - Key for direct link communication to
                                     another station in infrastructure networks
    CSR_WIFI_SME_KEY_TYPE_IGTK     - Integrity Group Temporal Key
    CSR_WIFI_SME_KEY_TYPE_CCKM     - Key for Cisco Centralized Key Management

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeKeyType;
#define CSR_WIFI_SME_KEY_TYPE_GROUP      ((CsrWifiSmeKeyType) 0x00)
#define CSR_WIFI_SME_KEY_TYPE_PAIRWISE   ((CsrWifiSmeKeyType) 0x01)
#define CSR_WIFI_SME_KEY_TYPE_STAKEY     ((CsrWifiSmeKeyType) 0x02)
#define CSR_WIFI_SME_KEY_TYPE_IGTK       ((CsrWifiSmeKeyType) 0x03)
#define CSR_WIFI_SME_KEY_TYPE_CCKM       ((CsrWifiSmeKeyType) 0x04)

/*******************************************************************************

  NAME
    CsrWifiSmeListAction

  DESCRIPTION
    Identifies the type of action to be performed on a list of items
    The values of this type are used across the NME/SME/Router API's and they
    must be kept consistent with the corresponding types in the .xml of the
    ottherinterfaces

 VALUES
    CSR_WIFI_SME_LIST_ACTION_GET    - Retrieve the current list of items
    CSR_WIFI_SME_LIST_ACTION_ADD    - Add one or more items
    CSR_WIFI_SME_LIST_ACTION_REMOVE - Remove one or more items
    CSR_WIFI_SME_LIST_ACTION_FLUSH  - Remove all items

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeListAction;
#define CSR_WIFI_SME_LIST_ACTION_GET      ((CsrWifiSmeListAction) 0x00)
#define CSR_WIFI_SME_LIST_ACTION_ADD      ((CsrWifiSmeListAction) 0x01)
#define CSR_WIFI_SME_LIST_ACTION_REMOVE   ((CsrWifiSmeListAction) 0x02)
#define CSR_WIFI_SME_LIST_ACTION_FLUSH    ((CsrWifiSmeListAction) 0x03)

/*******************************************************************************

  NAME
    CsrWifiSmeMediaStatus

  DESCRIPTION
    Indicates the connection status
    The values of this type are used across the NME/SME/Router API's and they
    must be kept consistent with the corresponding types in the .xml of the
    ottherinterfaces

 VALUES
    CSR_WIFI_SME_MEDIA_STATUS_CONNECTED
                   - Value CSR_WIFI_SME_MEDIA_STATUS_CONNECTED can happen in two
                     situations:
                       * A network connection is established. Specifically, this is
                         when the MLME_ASSOCIATION completes or the first peer
                         relationship is established in an IBSS. In a WPA/WPA2
                         network, this indicates that the stack is ready to perform
                         the 4-way handshake or 802.1x authentication if CSR NME
                         security library is not used. If CSR NME security library
                         is used this indicates, completion of 4way handshake or
                         802.1x authentication
                       * The SME roams to another AP on the same ESS
                     During the AP operation, it indicates that the peer station
                     is connected to the AP and is ready for data transfer.
    CSR_WIFI_SME_MEDIA_STATUS_DISCONNECTED
                   - Value CSR_WIFI_SME_MEDIA_STATUS_DISCONNECTED can happen in
                     two situations:
                       * when the connection to a network is lost and there is no
                         alternative on the same ESS to roam to
                       * when a CSR_WIFI_SME_DISCONNECT_REQ request is issued
                     During AP or P2PGO operation, it indicates that the peer
                     station has disconnected from the AP

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeMediaStatus;
#define CSR_WIFI_SME_MEDIA_STATUS_CONNECTED      ((CsrWifiSmeMediaStatus) 0x00)
#define CSR_WIFI_SME_MEDIA_STATUS_DISCONNECTED   ((CsrWifiSmeMediaStatus) 0x01)

/*******************************************************************************

  NAME
    CsrWifiSmeP2pCapability

  DESCRIPTION
    Defines P2P Device Capabilities

 VALUES
    CSR_WIFI_SME_P2P_SERVICE_DISCOVERY_CAPABILITY
                   - This field is set to 1 if the P2P Device supports Service
                     Discovery, and to 0 otherwise
    CSR_WIFI_SME_P2P_CLIENT_DISCOVERABILITY_CAPABILITY
                   - This field is set to 1 when the P2P Device supports P2P
                     Client Discoverability, and to 0 otherwise.
    CSR_WIFI_SME_P2P_CONCURRENT_OPERATION_CAPABILITY
                   - This field is set to 1 when the P2P Device supports
                     Concurrent Operation with WLAN, and to 0 otherwise.
    CSR_WIFI_SME_P2P_MANAGED_DEVICE_CAPABILITY
                   - This field is set to 1 when the P2P interface of the P2P
                     Device is capable of being managed by the WLAN
                     (infrastructure network) based on P2P coexistence
                     parameters, and to 0 otherwise
    CSR_WIFI_SME_P2P_INVITAION_CAPABILITY
                   - This field is set to 1 if the P2P Device is capable of
                     processing P2P Invitation Procedure signaling, and to 0
                     otherwise.

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeP2pCapability;
#define CSR_WIFI_SME_P2P_SERVICE_DISCOVERY_CAPABILITY        ((CsrWifiSmeP2pCapability) 0x01)
#define CSR_WIFI_SME_P2P_CLIENT_DISCOVERABILITY_CAPABILITY   ((CsrWifiSmeP2pCapability) 0x02)
#define CSR_WIFI_SME_P2P_CONCURRENT_OPERATION_CAPABILITY     ((CsrWifiSmeP2pCapability) 0x04)
#define CSR_WIFI_SME_P2P_MANAGED_DEVICE_CAPABILITY           ((CsrWifiSmeP2pCapability) 0x08)
#define CSR_WIFI_SME_P2P_INVITAION_CAPABILITY                ((CsrWifiSmeP2pCapability) 0x20)

/*******************************************************************************

  NAME
    CsrWifiSmeP2pGroupCapability

  DESCRIPTION
    Define bits for P2P Group Capability

 VALUES
    CSR_WIFI_P2P_GRP_CAP_GO
                   - Indicates if the local device has become a GO after GO
                     negotiation
    CSR_WIFI_P2P_GRP_CAP_PERSISTENT
                   - Persistent group
    CSR_WIFI_P2P_GRP_CAP_INTRABSS_DIST
                   - Intra-BSS data distribution support
    CSR_WIFI_P2P_GRP_CAP_CROSS_CONN
                   - Support of cross connection
    CSR_WIFI_P2P_GRP_CAP_PERSISTENT_RECONNECT
                   - Support of persistent reconnect

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeP2pGroupCapability;
#define CSR_WIFI_P2P_GRP_CAP_GO                     ((CsrWifiSmeP2pGroupCapability) 0x01)
#define CSR_WIFI_P2P_GRP_CAP_PERSISTENT             ((CsrWifiSmeP2pGroupCapability) 0x02)
#define CSR_WIFI_P2P_GRP_CAP_INTRABSS_DIST          ((CsrWifiSmeP2pGroupCapability) 0x08)
#define CSR_WIFI_P2P_GRP_CAP_CROSS_CONN             ((CsrWifiSmeP2pGroupCapability) 0x10)
#define CSR_WIFI_P2P_GRP_CAP_PERSISTENT_RECONNECT   ((CsrWifiSmeP2pGroupCapability) 0x20)

/*******************************************************************************

  NAME
    CsrWifiSmeP2pNoaConfigMethod

  DESCRIPTION
    Notice of Absece Configuration

 VALUES
    CSR_WIFI_P2P_NOA_NONE         - Do not use NOA
    CSR_WIFI_P2P_NOA_AUTONOMOUS   - NOA based on the traffic analysis
    CSR_WIFI_P2P_NOA_USER_DEFINED - NOA as specified by the user

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeP2pNoaConfigMethod;
#define CSR_WIFI_P2P_NOA_NONE           ((CsrWifiSmeP2pNoaConfigMethod) 0x00)
#define CSR_WIFI_P2P_NOA_AUTONOMOUS     ((CsrWifiSmeP2pNoaConfigMethod) 0x01)
#define CSR_WIFI_P2P_NOA_USER_DEFINED   ((CsrWifiSmeP2pNoaConfigMethod) 0x02)

/*******************************************************************************

  NAME
    CsrWifiSmeP2pRole

  DESCRIPTION
    Definition of roles for a P2P Device

 VALUES
    CSR_WIFI_SME_P2P_ROLE_NONE       - A non-P2PDevice device
    CSR_WIFI_SME_P2P_ROLE_STANDALONE - A Standalone P2P device
    CSR_WIFI_SME_P2P_ROLE_GO         - Role Assumed is that of a Group Owner
                                       within a P2P Group
    CSR_WIFI_SME_P2P_ROLE_CLI        - Role Assumed is that of a P2P Client
                                       within a P2P Group

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeP2pRole;
#define CSR_WIFI_SME_P2P_ROLE_NONE         ((CsrWifiSmeP2pRole) 0x00)
#define CSR_WIFI_SME_P2P_ROLE_STANDALONE   ((CsrWifiSmeP2pRole) 0x01)
#define CSR_WIFI_SME_P2P_ROLE_GO           ((CsrWifiSmeP2pRole) 0x02)
#define CSR_WIFI_SME_P2P_ROLE_CLI          ((CsrWifiSmeP2pRole) 0x03)

/*******************************************************************************

  NAME
    CsrWifiSmeP2pStatus

  DESCRIPTION
    This data type enumerates the outcome of P2P procedure

 VALUES
    CSR_WIFI_SME_P2P_STATUS_SUCCESS
                   - Success
    CSR_WIFI_SME_P2P_STATUS_FAIL_INFO_UNAVAILABLE
                   - Fail; information is currently unavailable
    CSR_WIFI_SME_P2P_STATUS_FAIL_INCOMPATIBLE_PARAM
                   - Fail; incompatible parameters
    CSR_WIFI_SME_P2P_STATUS_FAIL_LIMIT_REACHED
                   - Fail; limit reached
    CSR_WIFI_SME_P2P_STATUS_FAIL_INVALID_PARAM
                   - Fail; invalid parameters
    CSR_WIFI_SME_P2P_STATUS_FAIL_ACCOMODATE
                   - Fail; unable to accommodate request
    CSR_WIFI_SME_P2P_STATUS_FAIL_PREV_ERROR
                   - Fail; previous protocol error, or disruptive behavior
    CSR_WIFI_SME_P2P_STATUS_FAIL_COMMON_CHANNELS
                   - Fail; no common channels
    CSR_WIFI_SME_P2P_STATUS_FAIL_UNKNOWN_GROUP
                   - Fail; unknown P2P Group
    CSR_WIFI_SME_P2P_STATUS_FAIL_GO_INTENT
                   - Fail: both P2P Devices indicated an Intent of 15 in Group
                     Owner Negotiation
    CSR_WIFI_SME_P2P_STATUS_FAIL_PROVISION_METHOD_INCOMPATIBLE
                   - Fail; incompatible provisioning method
    CSR_WIFI_SME_P2P_STATUS_FAIL_REJECT
                   - Fail: rejected by user
    CSR_WIFI_SME_P2P_STATUS_FAIL_RESERVED
                   - Fail; Status Reserved

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeP2pStatus;
#define CSR_WIFI_SME_P2P_STATUS_SUCCESS                              ((CsrWifiSmeP2pStatus) 0x00)
#define CSR_WIFI_SME_P2P_STATUS_FAIL_INFO_UNAVAILABLE                ((CsrWifiSmeP2pStatus) 0x01)
#define CSR_WIFI_SME_P2P_STATUS_FAIL_INCOMPATIBLE_PARAM              ((CsrWifiSmeP2pStatus) 0x02)
#define CSR_WIFI_SME_P2P_STATUS_FAIL_LIMIT_REACHED                   ((CsrWifiSmeP2pStatus) 0x03)
#define CSR_WIFI_SME_P2P_STATUS_FAIL_INVALID_PARAM                   ((CsrWifiSmeP2pStatus) 0x04)
#define CSR_WIFI_SME_P2P_STATUS_FAIL_ACCOMODATE                      ((CsrWifiSmeP2pStatus) 0x05)
#define CSR_WIFI_SME_P2P_STATUS_FAIL_PREV_ERROR                      ((CsrWifiSmeP2pStatus) 0x06)
#define CSR_WIFI_SME_P2P_STATUS_FAIL_COMMON_CHANNELS                 ((CsrWifiSmeP2pStatus) 0x07)
#define CSR_WIFI_SME_P2P_STATUS_FAIL_UNKNOWN_GROUP                   ((CsrWifiSmeP2pStatus) 0x08)
#define CSR_WIFI_SME_P2P_STATUS_FAIL_GO_INTENT                       ((CsrWifiSmeP2pStatus) 0x09)
#define CSR_WIFI_SME_P2P_STATUS_FAIL_PROVISION_METHOD_INCOMPATIBLE   ((CsrWifiSmeP2pStatus) 0x0A)
#define CSR_WIFI_SME_P2P_STATUS_FAIL_REJECT                          ((CsrWifiSmeP2pStatus) 0x0B)
#define CSR_WIFI_SME_P2P_STATUS_FAIL_RESERVED                        ((CsrWifiSmeP2pStatus) 0xFF)

/*******************************************************************************

  NAME
    CsrWifiSmePacketFilterMode

  DESCRIPTION
    Options for the filter mode parameter.
    The Values here match the HIP interface

 VALUES
    CSR_WIFI_SME_PACKET_FILTER_MODE_OPT_OUT
                   - Broadcast packets are always reported to the host unless
                     they match at least one of the specified TCLAS IEs.
    CSR_WIFI_SME_PACKET_FILTER_MODE_OPT_IN
                   - Broadcast packets are reported to the host only if they
                     match at least one of the specified TCLAS IEs.

*******************************************************************************/
typedef CsrUint8 CsrWifiSmePacketFilterMode;
#define CSR_WIFI_SME_PACKET_FILTER_MODE_OPT_OUT   ((CsrWifiSmePacketFilterMode) 0x00)
#define CSR_WIFI_SME_PACKET_FILTER_MODE_OPT_IN    ((CsrWifiSmePacketFilterMode) 0x03)

/*******************************************************************************

  NAME
    CsrWifiSmePreambleType

  DESCRIPTION
    SME Preamble Types

 VALUES
    CSR_WIFI_SME_USE_LONG_PREAMBLE  - Use legacy (long) preamble
    CSR_WIFI_SME_USE_SHORT_PREAMBLE - Use short PPDU format

*******************************************************************************/
typedef CsrUint8 CsrWifiSmePreambleType;
#define CSR_WIFI_SME_USE_LONG_PREAMBLE    ((CsrWifiSmePreambleType) 0x00)
#define CSR_WIFI_SME_USE_SHORT_PREAMBLE   ((CsrWifiSmePreambleType) 0x01)

/*******************************************************************************

  NAME
    CsrWifiSmeRoamReason

  DESCRIPTION
    Indicates the reason for roaming

 VALUES
    CSR_WIFI_SME_ROAM_REASON_BEACONLOST
                   - The station cannot receive the beacon signal any more
    CSR_WIFI_SME_ROAM_REASON_DISASSOCIATED
                   - The station has been disassociated
    CSR_WIFI_SME_ROAM_REASON_DEAUTHENTICATED
                   - The station has been deauthenticated
    CSR_WIFI_SME_ROAM_REASON_BETTERAPFOUND
                   - A better AP has been found

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeRoamReason;
#define CSR_WIFI_SME_ROAM_REASON_BEACONLOST        ((CsrWifiSmeRoamReason) 0x00)
#define CSR_WIFI_SME_ROAM_REASON_DISASSOCIATED     ((CsrWifiSmeRoamReason) 0x01)
#define CSR_WIFI_SME_ROAM_REASON_DEAUTHENTICATED   ((CsrWifiSmeRoamReason) 0x02)
#define CSR_WIFI_SME_ROAM_REASON_BETTERAPFOUND     ((CsrWifiSmeRoamReason) 0x03)

/*******************************************************************************

  NAME
    CsrWifiSmeTspecCtrl

  DESCRIPTION
    Defines bits for CsrWifiSmeTspecCtrlMask.

 VALUES
    CSR_WIFI_SME_TSPEC_CTRL_STRICT - No automatic negotiation

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeTspecCtrl;
#define CSR_WIFI_SME_TSPEC_CTRL_STRICT   ((CsrWifiSmeTspecCtrl) 0x01)

/*******************************************************************************

  NAME
    CsrWifiSmeTspecResultCode

  DESCRIPTION
    Defines the result of the TSPEC exchanges with the AP

 VALUES
    CSR_WIFI_SME_TSPEC_RESULT_SUCCESS
                   - TSPEC command has been processed correctly
    CSR_WIFI_SME_TSPEC_RESULT_UNSPECIFIED_QOS_FAILURE
                   - The Access Point reported a failure
    CSR_WIFI_SME_TSPEC_RESULT_FAILURE
                   - Internal failure in the SME
    CSR_WIFI_SME_TSPEC_RESULT_INVALID_TSPEC_PARAMETERS
                   - The TSPEC parameters are invalid
    CSR_WIFI_SME_TSPEC_RESULT_INVALID_TCLAS_PARAMETERS
                   - The TCLASS parameters are invalid
    CSR_WIFI_SME_TSPEC_RESULT_INSUFFICIENT_BANDWIDTH
                   - As specified by the WMM Spec
    CSR_WIFI_SME_TSPEC_RESULT_WRONG_POLICY
                   - As specified by the WMM Spec
    CSR_WIFI_SME_TSPEC_RESULT_REJECTED_WITH_SUGGESTED_CHANGES
                   - As specified by the WMM Spec
    CSR_WIFI_SME_TSPEC_RESULT_TIMEOUT
                   - The TSPEC negotiation timed out
    CSR_WIFI_SME_TSPEC_RESULT_NOT_SUPPORTED
                   - The Access Point does not support the TSPEC
    CSR_WIFI_SME_TSPEC_RESULT_IE_LENGTH_INCORRECT
                   - The length of the TSPEC is not correct
    CSR_WIFI_SME_TSPEC_RESULT_INVALID_TRANSACTION_ID
                   - The TSPEC transaction id is not in the list
    CSR_WIFI_SME_TSPEC_RESULT_INSTALLED
                   - The TSPEC has been installed and it is now active.
    CSR_WIFI_SME_TSPEC_RESULT_TID_ALREADY_INSTALLED
                   - The Traffic ID has already been installed
    CSR_WIFI_SME_TSPEC_RESULT_TSPEC_REMOTELY_DELETED
                   - The AP has deleted the TSPEC

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeTspecResultCode;
#define CSR_WIFI_SME_TSPEC_RESULT_SUCCESS                           ((CsrWifiSmeTspecResultCode) 0x00)
#define CSR_WIFI_SME_TSPEC_RESULT_UNSPECIFIED_QOS_FAILURE           ((CsrWifiSmeTspecResultCode) 0x01)
#define CSR_WIFI_SME_TSPEC_RESULT_FAILURE                           ((CsrWifiSmeTspecResultCode) 0x02)
#define CSR_WIFI_SME_TSPEC_RESULT_INVALID_TSPEC_PARAMETERS          ((CsrWifiSmeTspecResultCode) 0x05)
#define CSR_WIFI_SME_TSPEC_RESULT_INVALID_TCLAS_PARAMETERS          ((CsrWifiSmeTspecResultCode) 0x06)
#define CSR_WIFI_SME_TSPEC_RESULT_INSUFFICIENT_BANDWIDTH            ((CsrWifiSmeTspecResultCode) 0x07)
#define CSR_WIFI_SME_TSPEC_RESULT_WRONG_POLICY                      ((CsrWifiSmeTspecResultCode) 0x08)
#define CSR_WIFI_SME_TSPEC_RESULT_REJECTED_WITH_SUGGESTED_CHANGES   ((CsrWifiSmeTspecResultCode) 0x09)
#define CSR_WIFI_SME_TSPEC_RESULT_TIMEOUT                           ((CsrWifiSmeTspecResultCode) 0x0D)
#define CSR_WIFI_SME_TSPEC_RESULT_NOT_SUPPORTED                     ((CsrWifiSmeTspecResultCode) 0x0E)
#define CSR_WIFI_SME_TSPEC_RESULT_IE_LENGTH_INCORRECT               ((CsrWifiSmeTspecResultCode) 0x10)
#define CSR_WIFI_SME_TSPEC_RESULT_INVALID_TRANSACTION_ID            ((CsrWifiSmeTspecResultCode) 0x11)
#define CSR_WIFI_SME_TSPEC_RESULT_INSTALLED                         ((CsrWifiSmeTspecResultCode) 0x12)
#define CSR_WIFI_SME_TSPEC_RESULT_TID_ALREADY_INSTALLED             ((CsrWifiSmeTspecResultCode) 0x13)
#define CSR_WIFI_SME_TSPEC_RESULT_TSPEC_REMOTELY_DELETED            ((CsrWifiSmeTspecResultCode) 0x14)

/*******************************************************************************

  NAME
    CsrWifiSmeWepAuthMode

  DESCRIPTION
    Define bits for CsrWifiSmeWepAuthMode

 VALUES
    CSR_WIFI_SME_WEP_AUTH_MODE_OPEN   - Open-WEP enabled network
    CSR_WIFI_SME_WEP_AUTH_MODE_SHARED - Shared-key WEP enabled network.

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeWepAuthMode;
#define CSR_WIFI_SME_WEP_AUTH_MODE_OPEN     ((CsrWifiSmeWepAuthMode) 0x00)
#define CSR_WIFI_SME_WEP_AUTH_MODE_SHARED   ((CsrWifiSmeWepAuthMode) 0x01)

/*******************************************************************************

  NAME
    CsrWifiSmeWepCredentialType

  DESCRIPTION
    Definition of types of WEP Credentials

 VALUES
    CSR_WIFI_SME_CREDENTIAL_TYPE_WEP64
                   - WEP 64 credential
    CSR_WIFI_SME_CREDENTIAL_TYPE_WEP128
                   - WEP 128 credential

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeWepCredentialType;
#define CSR_WIFI_SME_CREDENTIAL_TYPE_WEP64    ((CsrWifiSmeWepCredentialType) 0x00)
#define CSR_WIFI_SME_CREDENTIAL_TYPE_WEP128   ((CsrWifiSmeWepCredentialType) 0x01)

/*******************************************************************************

  NAME
    CsrWifiSmeWmmMode

  DESCRIPTION
    Defines bits for wmmModeMask: enable/disable WMM features.

 VALUES
    CSR_WIFI_SME_WMM_MODE_DISABLED   - Disables the WMM features.
    CSR_WIFI_SME_WMM_MODE_AC_ENABLED - Enables support for WMM-AC.
    CSR_WIFI_SME_WMM_MODE_PS_ENABLED - Enables support for WMM Power Save.
    CSR_WIFI_SME_WMM_MODE_SA_ENABLED - Currently not supported
    CSR_WIFI_SME_WMM_MODE_ENABLED    - Enables support for all currently
                                       available WMM features.

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeWmmMode;
#define CSR_WIFI_SME_WMM_MODE_DISABLED     ((CsrWifiSmeWmmMode) 0x00)
#define CSR_WIFI_SME_WMM_MODE_AC_ENABLED   ((CsrWifiSmeWmmMode) 0x01)
#define CSR_WIFI_SME_WMM_MODE_PS_ENABLED   ((CsrWifiSmeWmmMode) 0x02)
#define CSR_WIFI_SME_WMM_MODE_SA_ENABLED   ((CsrWifiSmeWmmMode) 0x04)
#define CSR_WIFI_SME_WMM_MODE_ENABLED      ((CsrWifiSmeWmmMode) 0xFF)

/*******************************************************************************

  NAME
    CsrWifiSmeWmmQosInfo

  DESCRIPTION
    Defines bits for the QoS Info Octect as defined in the WMM specification.
    The first four values define one bit each that can be set or cleared.
    Each of the last four values define all the remaining 4 bits and only one
    of them at the time shall be used.
    For more information, see 'WMM (including WMM Power Save) Specification -
    Version 1.1' and 'UniFi Configuring WMM and WMM-PS, Application Note'.

 VALUES
    CSR_WIFI_SME_WMM_QOS_INFO_AC_MAX_SP_ALL
                   - WMM AP may deliver all buffered frames
    CSR_WIFI_SME_WMM_QOS_INFO_AC_VO
                   - Enable UAPSD(both trigger and delivery) for Voice Access
                     Category
    CSR_WIFI_SME_WMM_QOS_INFO_AC_VI
                   - Enable UAPSD(both trigger and delivery) for  Video Access
                     Category
    CSR_WIFI_SME_WMM_QOS_INFO_AC_BK
                   - Enable UAPSD(both trigger and delivery) for  Background
                     Access Category
    CSR_WIFI_SME_WMM_QOS_INFO_AC_BE
                   - Enable UAPSD(both trigger and delivery) for  Best Effort
                     Access Category
    CSR_WIFI_SME_WMM_QOS_INFO_AC_MAX_SP_TWO
                   - WMM AP may deliver a maximum of 2 buffered frames (MSDUs
                     and MMPDUs) per USP
    CSR_WIFI_SME_WMM_QOS_INFO_AC_MAX_SP_FOUR
                   - WMM AP may deliver a maximum of 4 buffered frames (MSDUs
                     and MMPDUs) per USP
    CSR_WIFI_SME_WMM_QOS_INFO_AC_MAX_SP_SIX
                   - WMM AP may deliver a maximum of 6 buffered frames (MSDUs
                     and MMPDUs) per USP

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeWmmQosInfo;
#define CSR_WIFI_SME_WMM_QOS_INFO_AC_MAX_SP_ALL    ((CsrWifiSmeWmmQosInfo) 0x00)
#define CSR_WIFI_SME_WMM_QOS_INFO_AC_VO            ((CsrWifiSmeWmmQosInfo) 0x01)
#define CSR_WIFI_SME_WMM_QOS_INFO_AC_VI            ((CsrWifiSmeWmmQosInfo) 0x02)
#define CSR_WIFI_SME_WMM_QOS_INFO_AC_BK            ((CsrWifiSmeWmmQosInfo) 0x04)
#define CSR_WIFI_SME_WMM_QOS_INFO_AC_BE            ((CsrWifiSmeWmmQosInfo) 0x08)
#define CSR_WIFI_SME_WMM_QOS_INFO_AC_MAX_SP_TWO    ((CsrWifiSmeWmmQosInfo) 0x20)
#define CSR_WIFI_SME_WMM_QOS_INFO_AC_MAX_SP_FOUR   ((CsrWifiSmeWmmQosInfo) 0x40)
#define CSR_WIFI_SME_WMM_QOS_INFO_AC_MAX_SP_SIX    ((CsrWifiSmeWmmQosInfo) 0x60)

/*******************************************************************************

  NAME
    CsrWifiSmeWpsConfigType

  DESCRIPTION
    WPS config methods supported/used by a device

 VALUES
    CSR_WIFI_WPS_CONFIG_LABEL
                   - Label
    CSR_WIFI_WPS_CONFIG_DISPLAY
                   - Display
    CSR_WIFI_WPS_CONFIG_EXT_NFC
                   - External NFC : Not supported in this release
    CSR_WIFI_WPS_CONFIG_INT_NFC
                   - Internal NFC : Not supported in this release
    CSR_WIFI_WPS_CONFIG_NFC_IFACE
                   - NFC interface : Not supported in this release
    CSR_WIFI_WPS_CONFIG_PBC
                   - PBC
    CSR_WIFI_WPS_CONFIG_KEYPAD
                   - KeyPad
    CSR_WIFI_WPS_CONFIG_VIRTUAL_PBC
                   - PBC through software user interface
    CSR_WIFI_WPS_CONFIG_PHYSICAL_PBC
                   - Physical PBC
    CSR_WIFI_WPS_CONFIG_VIRTUAL_DISPLAY
                   - Virtual Display : via html config page etc
    CSR_WIFI_WPS_CONFIG_PHYSICAL_DISPLAY
                   - Physical Display : Attached to the device

*******************************************************************************/
typedef CsrUint16 CsrWifiSmeWpsConfigType;
#define CSR_WIFI_WPS_CONFIG_LABEL              ((CsrWifiSmeWpsConfigType) 0x0004)
#define CSR_WIFI_WPS_CONFIG_DISPLAY            ((CsrWifiSmeWpsConfigType) 0x0008)
#define CSR_WIFI_WPS_CONFIG_EXT_NFC            ((CsrWifiSmeWpsConfigType) 0x0010)
#define CSR_WIFI_WPS_CONFIG_INT_NFC            ((CsrWifiSmeWpsConfigType) 0x0020)
#define CSR_WIFI_WPS_CONFIG_NFC_IFACE          ((CsrWifiSmeWpsConfigType) 0x0040)
#define CSR_WIFI_WPS_CONFIG_PBC                ((CsrWifiSmeWpsConfigType) 0x0080)
#define CSR_WIFI_WPS_CONFIG_KEYPAD             ((CsrWifiSmeWpsConfigType) 0x0100)
#define CSR_WIFI_WPS_CONFIG_VIRTUAL_PBC        ((CsrWifiSmeWpsConfigType) 0x0280)
#define CSR_WIFI_WPS_CONFIG_PHYSICAL_PBC       ((CsrWifiSmeWpsConfigType) 0x0480)
#define CSR_WIFI_WPS_CONFIG_VIRTUAL_DISPLAY    ((CsrWifiSmeWpsConfigType) 0x2008)
#define CSR_WIFI_WPS_CONFIG_PHYSICAL_DISPLAY   ((CsrWifiSmeWpsConfigType) 0x4008)

/*******************************************************************************

  NAME
    CsrWifiSmeWpsDeviceCategory

  DESCRIPTION
    Wps Primary Device Types

 VALUES
    CSR_WIFI_SME_WPS_CATEGORY_UNSPECIFIED
                   - Unspecified.
    CSR_WIFI_SME_WPS_CATEGORY_COMPUTER
                   - Computer.
    CSR_WIFI_SME_WPS_CATEGORY_INPUT_DEV
                   - Input device
    CSR_WIFI_SME_WPS_CATEGORY_PRT_SCAN_FX_CP
                   - Printer Scanner Fax Copier etc
    CSR_WIFI_SME_WPS_CATEGORY_CAMERA
                   - Camera
    CSR_WIFI_SME_WPS_CATEGORY_STORAGE
                   - Storage
    CSR_WIFI_SME_WPS_CATEGORY_NET_INFRA
                   - Net Infra
    CSR_WIFI_SME_WPS_CATEGORY_DISPLAY
                   - Display
    CSR_WIFI_SME_WPS_CATEGORY_MULTIMEDIA
                   - Multimedia
    CSR_WIFI_SME_WPS_CATEGORY_GAMING
                   - Gaming.
    CSR_WIFI_SME_WPS_CATEGORY_TELEPHONE
                   - Telephone.
    CSR_WIFI_SME_WPS_CATEGORY_AUDIO
                   - Audio
    CSR_WIFI_SME_WPS_CATEOARY_OTHERS
                   - Others.

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeWpsDeviceCategory;
#define CSR_WIFI_SME_WPS_CATEGORY_UNSPECIFIED      ((CsrWifiSmeWpsDeviceCategory) 0x00)
#define CSR_WIFI_SME_WPS_CATEGORY_COMPUTER         ((CsrWifiSmeWpsDeviceCategory) 0x01)
#define CSR_WIFI_SME_WPS_CATEGORY_INPUT_DEV        ((CsrWifiSmeWpsDeviceCategory) 0x02)
#define CSR_WIFI_SME_WPS_CATEGORY_PRT_SCAN_FX_CP   ((CsrWifiSmeWpsDeviceCategory) 0x03)
#define CSR_WIFI_SME_WPS_CATEGORY_CAMERA           ((CsrWifiSmeWpsDeviceCategory) 0x04)
#define CSR_WIFI_SME_WPS_CATEGORY_STORAGE          ((CsrWifiSmeWpsDeviceCategory) 0x05)
#define CSR_WIFI_SME_WPS_CATEGORY_NET_INFRA        ((CsrWifiSmeWpsDeviceCategory) 0x06)
#define CSR_WIFI_SME_WPS_CATEGORY_DISPLAY          ((CsrWifiSmeWpsDeviceCategory) 0x07)
#define CSR_WIFI_SME_WPS_CATEGORY_MULTIMEDIA       ((CsrWifiSmeWpsDeviceCategory) 0x08)
#define CSR_WIFI_SME_WPS_CATEGORY_GAMING           ((CsrWifiSmeWpsDeviceCategory) 0x09)
#define CSR_WIFI_SME_WPS_CATEGORY_TELEPHONE        ((CsrWifiSmeWpsDeviceCategory) 0x0A)
#define CSR_WIFI_SME_WPS_CATEGORY_AUDIO            ((CsrWifiSmeWpsDeviceCategory) 0x0B)
#define CSR_WIFI_SME_WPS_CATEOARY_OTHERS           ((CsrWifiSmeWpsDeviceCategory) 0xFF)

/*******************************************************************************

  NAME
    CsrWifiSmeWpsDeviceSubCategory

  DESCRIPTION
    Wps Secondary Device Types

 VALUES
    CSR_WIFI_SME_WPS_SUB_CATEGORY_UNSPECIFIED
                   - Unspecied
    CSR_WIFI_SME_WPS_STORAGE_SUB_CATEGORY_NAS
                   - Network Associated Storage
    CSR_WIFI_SME_WPS_PSFC_SUB_CATEGORY_PRNTR
                   - Printer or print server
    CSR_WIFI_SME_WPS_TELEPHONE_SUB_CATEGORY_WM
                   - Windows mobile
    CSR_WIFI_SME_WPS_AUDIO_SUB_CATEGORY_TUNER
                   - Audio tuner/receiver
    CSR_WIFI_SME_WPS_CAMERA_SUB_CATEGORY_DIG_STL
                   - Digital still camera
    CSR_WIFI_SME_WPS_NET_INFRA_SUB_CATEGORY_AP
                   - Access Point
    CSR_WIFI_SME_WPS_DISPLAY_SUB_CATEGORY_TV
                   - TV.
    CSR_WIFI_SME_WPS_MM_SUB_CATEGORY_DAR
                   - DAR.
    CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_KEYBD
                   - Keyboard.
    CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_PC
                   - PC.
    CSR_WIFI_SME_WPS_GAMING_SUB_CATEGORY_XBOX
                   - Xbox.
    CSR_WIFI_SME_WPS_PSFC_SUB_CATEGORY_SCNR
                   - Scanner
    CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_SERVER
                   - Server
    CSR_WIFI_SME_WPS_NET_INFRA_SUB_CATEGORY_ROUTER
                   - Router
    CSR_WIFI_SME_WPS_MM_SUB_CATEGORY_PVR
                   - PVR
    CSR_WIFI_SME_WPS_AUDIO_SUB_CATEGORY_SPEAKER
                   - Speaker
    CSR_WIFI_SME_WPS_TELEPHONE_SUB_CATEGORY_FP_SM
                   - Feature phone - Single mode
    CSR_WIFI_SME_WPS_CAMERA_SUB_CATEGORY_VIDEO
                   - Video camera
    CSR_WIFI_SME_WPS_DISPLAY_SUB_CATEGORY_PIC_FRM
                   - Picture frame
    CSR_WIFI_SME_WPS_GAMING_SUB_CATEGORY_XBOX_360
                   - Xbox360
    CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_MOUSE
                   - Mouse
    CSR_WIFI_SME_WPS_NET_INFRA_SUB_CATEGORY_SWITCH
                   - Switch
    CSR_WIFI_SME_WPS_AUDIO_SUB_CATEGORY_PMP
                   - Portable music player
    CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_JOYSTK
                   - Joy stick
    CSR_WIFI_SME_WPS_GAMING_SUB_CATEGORY_PLAY_STN
                   - Play-station
    CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_MED_CENT
                   - Media Center
    CSR_WIFI_SME_WPS_MM_SUB_CATEGORY_MCX
                   - MCX
    CSR_WIFI_SME_WPS_TELEPHONE_SUB_CATEGORY_FP_DM
                   - Feature phone - Dual mode
    CSR_WIFI_SME_WPS_CAMERA_SUB_CATEGORY_WEB
                   - Web camera
    CSR_WIFI_SME_WPS_PSFC_SUB_CATEGORY_FAX
                   - Fax
    CSR_WIFI_SME_WPS_DISPLAY_SUB_CATEGORY_PROJECTOR
                   - Projector
    CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_TRKBL
                   - Track Ball
    CSR_WIFI_SME_WPS_MM_SUB_CATEGORY_ST_BOX
                   - Set-Top-Box
    CSR_WIFI_SME_WPS_NET_INFRA_SUB_CATEGORY_GATEWAY
                   - GateWay.
    CSR_WIFI_SME_WPS_CAMERA_SUB_CATEGORY_SECURITY
                   - Security camera
    CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_ULTRA_MOB_PC
                   - Ultra mobile PC.
    CSR_WIFI_SME_WPS_GAMING_SUB_CATEGORY_CONSOLE
                   - Game console/Game console adapter
    CSR_WIFI_SME_WPS_PSFC_SUB_CATEGORY_CPR
                   - Copier
    CSR_WIFI_SME_WPS_AUDIO_SUB_CATEGORY_HEADSET
                   - Headset(headphones + microphone)
    CSR_WIFI_SME_WPS_TELEPHONE_SUB_CATEGORY_SP_SM
                   - Smart phone - Single mode
    CSR_WIFI_SME_WPS_DISPLAY_SUB_CATEGORY_MONITOR
                   - Monitor.
    CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_GAME_CTRL
                   - Game control.
    CSR_WIFI_SME_WPS_PSFC_SUB_CATEGORY_ALL
                   - All-in-One
    CSR_WIFI_SME_WPS_MM_SUB_CATEGORY_MEDIA
                   - Media Server/Media Adapter/Media Extender
    CSR_WIFI_SME_WPS_TELEPHONE_SUB_CATEGORY_SP_DM
                   - Smart phone - Dual mode
    CSR_WIFI_SME_WPS_GAMING_SUB_CATEGORY_PORT_DEV
                   - Portable gaming device
    CSR_WIFI_SME_WPS_AUDIO_SUB_CATEGORY_HEADPHONE
                   - Headphone.
    CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_NOTEBOOK
                   - Notebook.
    CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_REMOTE
                   - Remote control
    CSR_WIFI_SME_WPS_AUDIO_SUB_CATEGORY_MIC
                   - Microphone
    CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_DESKTOP
                   - Desktop.
    CSR_WIFI_SME_WPS_MM_SUB_CATEGORY_VP
                   - Portable video player
    CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_MID
                   - Mobile internet device
    CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_TOUCH_SCRN
                   - Touch screen
    CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_BIOMET_RDR
                   - Biometric reader
    CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_NETBOOK
                   - Netbook
    CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_BRCD_RDR
                   - Bar code reader.

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeWpsDeviceSubCategory;
#define CSR_WIFI_SME_WPS_SUB_CATEGORY_UNSPECIFIED             ((CsrWifiSmeWpsDeviceSubCategory) 0x00)
#define CSR_WIFI_SME_WPS_STORAGE_SUB_CATEGORY_NAS             ((CsrWifiSmeWpsDeviceSubCategory) 0x01)
#define CSR_WIFI_SME_WPS_PSFC_SUB_CATEGORY_PRNTR              ((CsrWifiSmeWpsDeviceSubCategory) 0x01)
#define CSR_WIFI_SME_WPS_TELEPHONE_SUB_CATEGORY_WM            ((CsrWifiSmeWpsDeviceSubCategory) 0x01)
#define CSR_WIFI_SME_WPS_AUDIO_SUB_CATEGORY_TUNER             ((CsrWifiSmeWpsDeviceSubCategory) 0x01)
#define CSR_WIFI_SME_WPS_CAMERA_SUB_CATEGORY_DIG_STL          ((CsrWifiSmeWpsDeviceSubCategory) 0x01)
#define CSR_WIFI_SME_WPS_NET_INFRA_SUB_CATEGORY_AP            ((CsrWifiSmeWpsDeviceSubCategory) 0x01)
#define CSR_WIFI_SME_WPS_DISPLAY_SUB_CATEGORY_TV              ((CsrWifiSmeWpsDeviceSubCategory) 0x01)
#define CSR_WIFI_SME_WPS_MM_SUB_CATEGORY_DAR                  ((CsrWifiSmeWpsDeviceSubCategory) 0x01)
#define CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_KEYBD         ((CsrWifiSmeWpsDeviceSubCategory) 0x01)
#define CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_PC             ((CsrWifiSmeWpsDeviceSubCategory) 0x01)
#define CSR_WIFI_SME_WPS_GAMING_SUB_CATEGORY_XBOX             ((CsrWifiSmeWpsDeviceSubCategory) 0x01)
#define CSR_WIFI_SME_WPS_PSFC_SUB_CATEGORY_SCNR               ((CsrWifiSmeWpsDeviceSubCategory) 0x02)
#define CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_SERVER         ((CsrWifiSmeWpsDeviceSubCategory) 0x02)
#define CSR_WIFI_SME_WPS_NET_INFRA_SUB_CATEGORY_ROUTER        ((CsrWifiSmeWpsDeviceSubCategory) 0x02)
#define CSR_WIFI_SME_WPS_MM_SUB_CATEGORY_PVR                  ((CsrWifiSmeWpsDeviceSubCategory) 0x02)
#define CSR_WIFI_SME_WPS_AUDIO_SUB_CATEGORY_SPEAKER           ((CsrWifiSmeWpsDeviceSubCategory) 0x02)
#define CSR_WIFI_SME_WPS_TELEPHONE_SUB_CATEGORY_FP_SM         ((CsrWifiSmeWpsDeviceSubCategory) 0x02)
#define CSR_WIFI_SME_WPS_CAMERA_SUB_CATEGORY_VIDEO            ((CsrWifiSmeWpsDeviceSubCategory) 0x02)
#define CSR_WIFI_SME_WPS_DISPLAY_SUB_CATEGORY_PIC_FRM         ((CsrWifiSmeWpsDeviceSubCategory) 0x02)
#define CSR_WIFI_SME_WPS_GAMING_SUB_CATEGORY_XBOX_360         ((CsrWifiSmeWpsDeviceSubCategory) 0x02)
#define CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_MOUSE         ((CsrWifiSmeWpsDeviceSubCategory) 0x02)
#define CSR_WIFI_SME_WPS_NET_INFRA_SUB_CATEGORY_SWITCH        ((CsrWifiSmeWpsDeviceSubCategory) 0x03)
#define CSR_WIFI_SME_WPS_AUDIO_SUB_CATEGORY_PMP               ((CsrWifiSmeWpsDeviceSubCategory) 0x03)
#define CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_JOYSTK        ((CsrWifiSmeWpsDeviceSubCategory) 0x03)
#define CSR_WIFI_SME_WPS_GAMING_SUB_CATEGORY_PLAY_STN         ((CsrWifiSmeWpsDeviceSubCategory) 0x03)
#define CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_MED_CENT       ((CsrWifiSmeWpsDeviceSubCategory) 0x03)
#define CSR_WIFI_SME_WPS_MM_SUB_CATEGORY_MCX                  ((CsrWifiSmeWpsDeviceSubCategory) 0x03)
#define CSR_WIFI_SME_WPS_TELEPHONE_SUB_CATEGORY_FP_DM         ((CsrWifiSmeWpsDeviceSubCategory) 0x03)
#define CSR_WIFI_SME_WPS_CAMERA_SUB_CATEGORY_WEB              ((CsrWifiSmeWpsDeviceSubCategory) 0x03)
#define CSR_WIFI_SME_WPS_PSFC_SUB_CATEGORY_FAX                ((CsrWifiSmeWpsDeviceSubCategory) 0x03)
#define CSR_WIFI_SME_WPS_DISPLAY_SUB_CATEGORY_PROJECTOR       ((CsrWifiSmeWpsDeviceSubCategory) 0x03)
#define CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_TRKBL         ((CsrWifiSmeWpsDeviceSubCategory) 0x04)
#define CSR_WIFI_SME_WPS_MM_SUB_CATEGORY_ST_BOX               ((CsrWifiSmeWpsDeviceSubCategory) 0x04)
#define CSR_WIFI_SME_WPS_NET_INFRA_SUB_CATEGORY_GATEWAY       ((CsrWifiSmeWpsDeviceSubCategory) 0x04)
#define CSR_WIFI_SME_WPS_CAMERA_SUB_CATEGORY_SECURITY         ((CsrWifiSmeWpsDeviceSubCategory) 0x04)
#define CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_ULTRA_MOB_PC   ((CsrWifiSmeWpsDeviceSubCategory) 0x04)
#define CSR_WIFI_SME_WPS_GAMING_SUB_CATEGORY_CONSOLE          ((CsrWifiSmeWpsDeviceSubCategory) 0x04)
#define CSR_WIFI_SME_WPS_PSFC_SUB_CATEGORY_CPR                ((CsrWifiSmeWpsDeviceSubCategory) 0x04)
#define CSR_WIFI_SME_WPS_AUDIO_SUB_CATEGORY_HEADSET           ((CsrWifiSmeWpsDeviceSubCategory) 0x04)
#define CSR_WIFI_SME_WPS_TELEPHONE_SUB_CATEGORY_SP_SM         ((CsrWifiSmeWpsDeviceSubCategory) 0x04)
#define CSR_WIFI_SME_WPS_DISPLAY_SUB_CATEGORY_MONITOR         ((CsrWifiSmeWpsDeviceSubCategory) 0x04)
#define CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_GAME_CTRL     ((CsrWifiSmeWpsDeviceSubCategory) 0x05)
#define CSR_WIFI_SME_WPS_PSFC_SUB_CATEGORY_ALL                ((CsrWifiSmeWpsDeviceSubCategory) 0x05)
#define CSR_WIFI_SME_WPS_MM_SUB_CATEGORY_MEDIA                ((CsrWifiSmeWpsDeviceSubCategory) 0x05)
#define CSR_WIFI_SME_WPS_TELEPHONE_SUB_CATEGORY_SP_DM         ((CsrWifiSmeWpsDeviceSubCategory) 0x05)
#define CSR_WIFI_SME_WPS_GAMING_SUB_CATEGORY_PORT_DEV         ((CsrWifiSmeWpsDeviceSubCategory) 0x05)
#define CSR_WIFI_SME_WPS_AUDIO_SUB_CATEGORY_HEADPHONE         ((CsrWifiSmeWpsDeviceSubCategory) 0x05)
#define CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_NOTEBOOK       ((CsrWifiSmeWpsDeviceSubCategory) 0x05)
#define CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_REMOTE        ((CsrWifiSmeWpsDeviceSubCategory) 0x06)
#define CSR_WIFI_SME_WPS_AUDIO_SUB_CATEGORY_MIC               ((CsrWifiSmeWpsDeviceSubCategory) 0x06)
#define CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_DESKTOP        ((CsrWifiSmeWpsDeviceSubCategory) 0x06)
#define CSR_WIFI_SME_WPS_MM_SUB_CATEGORY_VP                   ((CsrWifiSmeWpsDeviceSubCategory) 0x06)
#define CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_MID            ((CsrWifiSmeWpsDeviceSubCategory) 0x07)
#define CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_TOUCH_SCRN    ((CsrWifiSmeWpsDeviceSubCategory) 0x07)
#define CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_BIOMET_RDR    ((CsrWifiSmeWpsDeviceSubCategory) 0x08)
#define CSR_WIFI_SME_WPS_COMPUTER_SUB_CATEGORY_NETBOOK        ((CsrWifiSmeWpsDeviceSubCategory) 0x08)
#define CSR_WIFI_SME_WPS_INPUT_DEV_SUB_CATEGORY_BRCD_RDR      ((CsrWifiSmeWpsDeviceSubCategory) 0x09)

/*******************************************************************************

  NAME
    CsrWifiSmeWpsDpid

  DESCRIPTION
    Device Password ID for the chosen config method

 VALUES
    CSR_WIFI_SME_WPS_DPID_PIN       - PIN
    CSR_WIFI_SME_WPS_DPID_USER      - User specified : Used only during P2P GO
                                      negotiation procedure
    CSR_WIFI_SME_WPS_DPID_MACHINE   - Machine specified i: Not used in this
                                      release
    CSR_WIFI_SME_WPS_DPID_REKEY     - Rekey : Not used in this release
    CSR_WIFI_SME_WPS_DPID_PBC       - PBC
    CSR_WIFI_SME_WPS_DPID_REGISTRAR - Registrar specified : Used only in P2P Go
                                      negotiation procedure

*******************************************************************************/
typedef CsrUint16 CsrWifiSmeWpsDpid;
#define CSR_WIFI_SME_WPS_DPID_PIN         ((CsrWifiSmeWpsDpid) 0x0000)
#define CSR_WIFI_SME_WPS_DPID_USER        ((CsrWifiSmeWpsDpid) 0x0001)
#define CSR_WIFI_SME_WPS_DPID_MACHINE     ((CsrWifiSmeWpsDpid) 0x0002)
#define CSR_WIFI_SME_WPS_DPID_REKEY       ((CsrWifiSmeWpsDpid) 0x0003)
#define CSR_WIFI_SME_WPS_DPID_PBC         ((CsrWifiSmeWpsDpid) 0x0004)
#define CSR_WIFI_SME_WPS_DPID_REGISTRAR   ((CsrWifiSmeWpsDpid) 0x0005)

/*******************************************************************************

  NAME
    CsrWifiSmeWpsRegistration

  DESCRIPTION

 VALUES
    CSR_WIFI_SME_WPS_REG_NOT_REQUIRED - No encryption set
    CSR_WIFI_SME_WPS_REG_REQUIRED     - No encryption set
    CSR_WIFI_SME_WPS_REG_UNKNOWN      - No encryption set

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeWpsRegistration;
#define CSR_WIFI_SME_WPS_REG_NOT_REQUIRED   ((CsrWifiSmeWpsRegistration) 0x00)
#define CSR_WIFI_SME_WPS_REG_REQUIRED       ((CsrWifiSmeWpsRegistration) 0x01)
#define CSR_WIFI_SME_WPS_REG_UNKNOWN        ((CsrWifiSmeWpsRegistration) 0x02)


/*******************************************************************************

  NAME
    CsrWifiSmeAuthModeMask

  DESCRIPTION
    Mask type for use with the values defined by CsrWifiSmeAuthMode

*******************************************************************************/
typedef CsrUint16 CsrWifiSmeAuthModeMask;
/*******************************************************************************

  NAME
    CsrWifiSmeEncryptionMask

  DESCRIPTION
    Mask type for use with the values defined by CsrWifiSmeEncryption

*******************************************************************************/
typedef CsrUint16 CsrWifiSmeEncryptionMask;
/*******************************************************************************

  NAME
    CsrWifiSmeIndicationsMask

  DESCRIPTION
    Mask type for use with the values defined by CsrWifiSmeIndications

*******************************************************************************/
typedef CsrUint32 CsrWifiSmeIndicationsMask;
/*******************************************************************************

  NAME
    CsrWifiSmeP2pCapabilityMask

  DESCRIPTION
    Mask type for use with the values defined by CsrWifiSmeP2pCapability

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeP2pCapabilityMask;
/*******************************************************************************

  NAME
    CsrWifiSmeP2pGroupCapabilityMask

  DESCRIPTION
    Mask type for use with the values defined by CsrWifiSmeP2pGroupCapability

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeP2pGroupCapabilityMask;
/*******************************************************************************

  NAME
    CsrWifiSmeTspecCtrlMask

  DESCRIPTION
    Mask type for use with the values defined by CsrWifiSmeTspecCtrl

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeTspecCtrlMask;
/*******************************************************************************

  NAME
    CsrWifiSmeWmmModeMask

  DESCRIPTION
    Mask type for use with the values defined by CsrWifiSmeWmmMode

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeWmmModeMask;
/*******************************************************************************

  NAME
    CsrWifiSmeWmmQosInfoMask

  DESCRIPTION
    Mask type for use with the values defined by CsrWifiSmeWmmQosInfo

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeWmmQosInfoMask;
/*******************************************************************************

  NAME
    CsrWifiSmeWpsConfigTypeMask

  DESCRIPTION
    Mask type for use with the values defined by CsrWifiSmeWpsConfigType

*******************************************************************************/
typedef CsrUint16 CsrWifiSmeWpsConfigTypeMask;


/*******************************************************************************

  NAME
    CsrWifiSmeEmpty

  DESCRIPTION
    Empty Structure to indicate that no parameters are available.

  MEMBERS
    empty  - Only element of the empty structure (always set to 0).

*******************************************************************************/
typedef struct
{
    CsrUint8 empty;
} CsrWifiSmeEmpty;

/*******************************************************************************

  NAME
    CsrWifiSmeLinkQuality

  DESCRIPTION
    Indicates the quality of the link

  MEMBERS
    unifiRssi - Indicates the received signal strength indication of the link in
                dBm
    unifiSnr  - Indicates the signal to noise ratio of the link in dB

*******************************************************************************/
typedef struct
{
    CsrInt16 unifiRssi;
    CsrInt16 unifiSnr;
} CsrWifiSmeLinkQuality;

/*******************************************************************************

  NAME
    CsrWifiSmeP2pProfileIdentity

  DESCRIPTION
    Details to be filled in

  MEMBERS
    listenChannel        -
    availabilityDuration -
    avalabilityPeriod    -

*******************************************************************************/
typedef struct
{
    CsrUint8  listenChannel;
    CsrUint16 availabilityDuration;
    CsrUint16 avalabilityPeriod;
} CsrWifiSmeP2pProfileIdentity;

/*******************************************************************************

  NAME
    CsrWifiSmePmkid

  DESCRIPTION
    Defines a PMKID association with BSS

  MEMBERS
    bssid  - BSS identifier
    pmkid  - PMKID

*******************************************************************************/
typedef struct
{
    CsrWifiMacAddress bssid;
    CsrUint8          pmkid[16];
} CsrWifiSmePmkid;

/*******************************************************************************

  NAME
    CsrWifiSmePmkidCandidate

  DESCRIPTION
    Information for a PMKID candidate

  MEMBERS
    bssid          - BSS identifier
    preAuthAllowed - Indicates whether preauthentication is allowed

*******************************************************************************/
typedef struct
{
    CsrWifiMacAddress bssid;
    CsrBool           preAuthAllowed;
} CsrWifiSmePmkidCandidate;

/*******************************************************************************

  NAME
    CsrWifiSmePmkidList

  DESCRIPTION
    NOT USED
    Used in the Sync access API

  MEMBERS
    pmkidsCount - Number of PMKIDs in the list
    pmkids      - Points to the first PMKID in the list

*******************************************************************************/
typedef struct
{
    CsrUint8         pmkidsCount;
    CsrWifiSmePmkid *pmkids;
} CsrWifiSmePmkidList;

/*******************************************************************************

  NAME
    CsrWifiSmeTsfTime

  DESCRIPTION
    Time stamp representation

  MEMBERS
    data   - TSF Bytes

*******************************************************************************/
typedef struct
{
    CsrUint8 data[8];
} CsrWifiSmeTsfTime;

/*******************************************************************************

  NAME
    CsrWifiSmeWpsDeviceType

  DESCRIPTION
    Structure holding AP WPS device type data.

  MEMBERS
    deviceDetails - category , sub category etc

*******************************************************************************/
typedef struct
{
    CsrUint8 deviceDetails[8];
} CsrWifiSmeWpsDeviceType;

/*******************************************************************************

  NAME
    CsrWifiSmeWpsInfo

  DESCRIPTION

  MEMBERS
    version         -
    configMethods   -
    devicePassworId -

*******************************************************************************/
typedef struct
{
    CsrUint16 version;
    CsrUint16 configMethods;
    CsrUint16 devicePassworId;
} CsrWifiSmeWpsInfo;

/*******************************************************************************

  NAME
    CsrWifiSmeCloakedSsidConfig

  DESCRIPTION
    List of cloaked SSIDs .

  MEMBERS
    cloakedSsidsCount - Number of cloaked SSID
    cloakedSsids      - Points to the first byte of the first SSID provided

*******************************************************************************/
typedef struct
{
    CsrUint8     cloakedSsidsCount;
    CsrWifiSsid *cloakedSsids;
} CsrWifiSmeCloakedSsidConfig;

/*******************************************************************************

  NAME
    CsrWifiSmeConnectionConfig

  DESCRIPTION
    Specifies the parameters that the SME should use in selecting a network.

  MEMBERS
    ssid
                   - Service Set identifier
    bssid
                   - BSS identifier
    bssType
                   - Indicates the type of BSS
    privacyMode
                   - Specifies whether the privacy mode is enabled or disabled.
    authModeMask
                   - Sets the authentication options that the SME can use while
                     associating to the AP
                     Set mask with values from CsrWifiSmeAuthMode
    encryptionModeMask
                   - Sets the encryption options that the SME can use while
                     associating to the AP
                     Set mask with values from CsrWifiSmeEncryption
    mlmeAssociateReqInformationElementsLength
                   - Length in bytes of information elements to be sent in the
                     Association Request.
    mlmeAssociateReqInformationElements
                   - Points to the first byte of the information elements, if
                     any.
    mibValuesLength
                   - Length in bytes mibValues.
    mibValues
                   - Any Mib values to set before connecting

*******************************************************************************/
typedef struct
{
    CsrWifiSsid                ssid;
    CsrWifiMacAddress          bssid;
    CsrWifiSmeBssType          bssType;
    CsrWifiSme80211PrivacyMode privacyMode;
    CsrWifiSmeAuthModeMask     authModeMask;
    CsrWifiSmeEncryptionMask   encryptionModeMask;
    CsrUint32                  mlmeAssociateReqInformationElementsLength;
    CsrUint8                  *mlmeAssociateReqInformationElements;
    CsrUint32                  mibValuesLength;
    CsrUint8                  *mibValues;
} CsrWifiSmeConnectionConfig;

/*******************************************************************************

  NAME
    CsrWifiSmeConnectionInfo

  DESCRIPTION
    Parameters that the SME should use in selecting a network

  MEMBERS
    ssid                        - Service set identifier
    bssid                       - BSS identifier
    channelInfo                 - Channel Info
    channelFrequency            - Channel frequency
    authMode                    - Authentication mode used for the connection
    pairwiseCipher              - Encryption type for peer to peer communication
    groupCipher                 - Encryption type for broadcast and multicast
                                  communication
    atimWindowTu                - ATIM window specified for IBSS
    beaconPeriodTu              - Interval between beacon packets
    reassociation               - Indicates whether a reassociation occurred
    wmmAssociation              - Indicates if this was a WMM association
    beaconFrameLength           - Indicates the number of bytes of the beacon
                                  frame
    beaconFrame                 - Points at the first byte of the beacon frame
    associationReqFrameLength   - Indicates the number of bytes of the
                                  association request frame
    associationReqFrame         - Points at the first byte of the association
                                  request frame
    associationRspFrameLength   - Indicates the number of bytes of the
                                  association response frame
    associationRspFrame         - Points at the first byte of the association
                                  response frame
    assocScanInfoElementsLength - Indicates the number of bytes in the buffer
                                  pointed by assocScanInfoElements
    assocScanInfoElements       - Pointer to the buffer containing the
                                  information elements of the probe response
                                  received after the probe requests sent before
                                  attempting to authenticate to the network
    assocReqCapabilities        - Reports the content of the Capability
                                  information element as specified in the
                                  association request.
    assocReqListenIntervalTu    - Listen Interval specified in the association
                                  request
    assocReqApAddress           - AP address to which the association requests
                                  has been sent
    assocReqInfoElementsLength  - Indicates the number of bytes of the
                                  association request information elements
    assocReqInfoElements        - Points at the first byte of the association
                                  request information elements
    assocRspResult              - Result reported in the association response
    assocRspCapabilityInfo      - Reports the content of the Capability
                                  information element as received in the
                                  association response.
    assocRspAssociationId       - Reports the association ID received in the
                                  association response.
    assocRspInfoElementsLength  - Indicates the number of bytes of the
                                  association response information elements
    assocRspInfoElements        - Points at the first byte of the association
                                  response information elements

*******************************************************************************/
typedef struct
{
    CsrWifiSsid               ssid;
    CsrWifiMacAddress         bssid;
    CsrUint16                 channelInfo;
    CsrUint16                 channelFrequency;
    CsrWifiSmeAuthMode        authMode;
    CsrWifiSmeEncryption      pairwiseCipher;
    CsrWifiSmeEncryption      groupCipher;
    CsrUint16                 atimWindowTu;
    CsrUint16                 beaconPeriodTu;
    CsrBool                   reassociation;
    CsrBool                   wmmAssociation;
    CsrUint32                 beaconFrameLength;
    CsrUint8                 *beaconFrame;
    CsrUint32                 associationReqFrameLength;
    CsrUint8                 *associationReqFrame;
    CsrUint32                 associationRspFrameLength;
    CsrUint8                 *associationRspFrame;
    CsrUint32                 assocScanInfoElementsLength;
    CsrUint8                 *assocScanInfoElements;
    CsrUint16                 assocReqCapabilities;
    CsrUint16                 assocReqListenIntervalTu;
    CsrWifiMacAddress         assocReqApAddress;
    CsrUint32                 assocReqInfoElementsLength;
    CsrUint8                 *assocReqInfoElements;
    CsrWifiSmeIEEE80211Result assocRspResult;
    CsrUint16                 assocRspCapabilityInfo;
    CsrUint16                 assocRspAssociationId;
    CsrUint32                 assocRspInfoElementsLength;
    CsrUint8                 *assocRspInfoElements;
} CsrWifiSmeConnectionInfo;

/*******************************************************************************

  NAME
    CsrWifiSmeDeviceInfo

  DESCRIPTION
    P2P Information for a P2P Device

  MEMBERS
    deviceAddress            - Device Address of the P2P device
    configMethods            - Supported WPS configuration methods.
    p2PDeviceCap             - P2P device capabilities
    primDeviceType           - Primary WPS device type
    secondaryDeviceTypeCount - Number of secondary device types
    secDeviceType            - list of secondary WPS device types
    deviceName               - Device name without up to 32 characters'\0'.
    deviceNameLength         - Number of characters of the device name

*******************************************************************************/
typedef struct
{
    CsrWifiMacAddress           deviceAddress;
    CsrWifiSmeWpsConfigTypeMask configMethods;
    CsrWifiSmeP2pCapabilityMask p2PDeviceCap;
    CsrWifiSmeWpsDeviceType     primDeviceType;
    CsrUint8                    secondaryDeviceTypeCount;
    CsrWifiSmeWpsDeviceType    *secDeviceType;
    CsrUint8                    deviceName[32];
    CsrUint8                    deviceNameLength;
} CsrWifiSmeDeviceInfo;

/*******************************************************************************

  NAME
    CsrWifiSmeKey

  DESCRIPTION
    Information for a key to be used for encryption

  MEMBERS
    keyType       - Specifies whether the key is a pairwise or group key; it
                    should be set to CSR_WIFI_SME_GROUP_KEY or
                    CSR_WIFI_SME_PAIRWISE_KEY, as required.
    keyIndex      - Specifies which WEP key (0-3) to set; it should be set to 0
                    for a WPA/WPA2 pairwise key and non-zero for a WPA/WPA2
                    group key.
    wepTxKey      - If wepTxKey is TRUE, and the key is a WEP key, the key will
                    be selected for encrypting transmitted packets.
                    To select a previously defined key as the transmit
                    encryption key, set keyIndex to the required key, wepTxKey
                    to TRUE and the keyLength to 0.
    keyRsc        - Key Receive Sequence Counter
    authenticator - If TRUE the WMA will act as authenticator.
                    CURRENTLY NOT SUPPORTED
    address       - BSS identifier of the AP
    keyLength     - Length of the key in bytes
    key           - Points to the first byte of the key

*******************************************************************************/
typedef struct
{
    CsrWifiSmeKeyType keyType;
    CsrUint8          keyIndex;
    CsrBool           wepTxKey;
    CsrUint16         keyRsc[8];
    CsrBool           authenticator;
    CsrWifiMacAddress address;
    CsrUint8          keyLength;
    CsrUint8          key[32];
} CsrWifiSmeKey;

/*******************************************************************************

  NAME
    CsrWifiSmeScanResult

  DESCRIPTION
    This structure defines the scan result for each BSS found

  MEMBERS
    ssid                      - Service set identifier. If the scan result
                                represents a standalone P2P device, it shall be
                                set to the P2P Wildcard SSID.
    bssid                     - BSS identifier. If SSID is set to P2P Wildcard
                                SSID, this field represents the P2P device
                                address of the peer.
    rssi                      - Received signal strength indication in dBm
    snr                       - Signal to noise ratio in dB
    beaconPeriodTu            - Interval between beacon frames
    timeStamp                 - Timestamp in the BSS
    localTime                 - Timestamp in the Access Point
    channelFrequency          - Channel frequency
    capabilityInformation     - Capabilities of the BSS.
    channelInfo               - Channel Info
    usability                 - Indicates the usability level.
    bssType                   - Type of BSS. If scan results represents a P2PGO
                                or a P2P device, it shall be set to
                                CSR_WIFI_SME_BSS_TYPE_P2P.
    informationElementsLength - Number of bytes of the information elements
                                received as part of the beacon or probe
                                response.
    informationElements       - Points to the first byte of the IEs received as
                                part of the beacon or probe response.
                                The format of the IEs is as specified in the
                                IEEE 802.11 specification.

*******************************************************************************/
typedef struct
{
    CsrWifiSsid              ssid;
    CsrWifiMacAddress        bssid;
    CsrInt16                 rssi;
    CsrInt16                 snr;
    CsrUint16                beaconPeriodTu;
    CsrWifiSmeTsfTime        timeStamp;
    CsrWifiSmeTsfTime        localTime;
    CsrUint16                channelFrequency;
    CsrUint16                capabilityInformation;
    CsrUint16                channelInfo;
    CsrWifiSmeBasicUsability usability;
    CsrWifiSmeBssType        bssType;
    CsrUint32                informationElementsLength;
    CsrUint8                *informationElements;
} CsrWifiSmeScanResult;

/*******************************************************************************

  NAME
    CsrWifiSmeWep128Keys

  DESCRIPTION
    Structure holding WEP Authentication Type and WEP keys that can be used
    when using WEP128.

  MEMBERS
    wepAuthType    - Mask to select the WEP authentication type (Open or Shared)
    selectedWepKey - Index to one of the four keys below indicating the
                     currently used WEP key. Mapping From SME/User -> firmware.
                     Key 1 -> Index 0. Key 2 -> Index 1. key 3 -> Index 2. Key
                     4-> Index 3.
    key1           - Value for key number 1.
    key2           - Value for key number 2.
    key3           - Value for key number 3.
    key4           - Value for key number 4.

*******************************************************************************/
typedef struct
{
    CsrWifiSmeWepAuthMode wepAuthType;
    CsrUint8              selectedWepKey;
    CsrUint8              key1[13];
    CsrUint8              key2[13];
    CsrUint8              key3[13];
    CsrUint8              key4[13];
} CsrWifiSmeWep128Keys;

/*******************************************************************************

  NAME
    CsrWifiSmeWep64Keys

  DESCRIPTION
    Structure holding WEP Authentication Type and WEP keys that can be used
    when using WEP64.

  MEMBERS
    wepAuthType    - Mask to select the WEP authentication type (Open or Shared)
    selectedWepKey - Index to one of the four keys below indicating the
                     currently used WEP key. Mapping From SME/User -> firmware.
                     Key 1 -> Index 0. Key 2 -> Index 1. key 3 -> Index 2. Key
                     4-> Index 3.
    key1           - Value for key number 1.
    key2           - Value for key number 2.
    key3           - Value for key number 3.
    key4           - Value for key number 4.

*******************************************************************************/
typedef struct
{
    CsrWifiSmeWepAuthMode wepAuthType;
    CsrUint8              selectedWepKey;
    CsrUint8              key1[5];
    CsrUint8              key2[5];
    CsrUint8              key3[5];
    CsrUint8              key4[5];
} CsrWifiSmeWep64Keys;

/*******************************************************************************

  NAME
    CsrWifiSmeWepAuth

  DESCRIPTION
    WEP authentication parameter structure

  MEMBERS
    wepKeyType               - WEP key try (128 bit or 64 bit)
    wepCredentials           - Union containing credentials which depends on
                               wepKeyType parameter.
    wepCredentialswep128Key  -
    wepCredentialswep64Key   -

*******************************************************************************/
typedef struct
{
    CsrWifiSmeWepCredentialType wepKeyType;
    union
    {
        CsrWifiSmeWep128Keys wep128Key;
        CsrWifiSmeWep64Keys  wep64Key;
    } wepCredentials;
} CsrWifiSmeWepAuth;


/* Downstream */
#define CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST            (0x0000)

#define CSR_WIFI_SME_ACTIVATE_REQ                         ((CsrWifiSmePrim) (0x0000 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_BLACKLIST_REQ                        ((CsrWifiSmePrim) (0x0001 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_CALIBRATION_DATA_GET_REQ             ((CsrWifiSmePrim) (0x0002 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_CONNECT_REQ                          ((CsrWifiSmePrim) (0x0003 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_DEACTIVATE_REQ                       ((CsrWifiSmePrim) (0x0004 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_DISCONNECT_REQ                       ((CsrWifiSmePrim) (0x0005 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_EVENT_MASK_SET_REQ                   ((CsrWifiSmePrim) (0x0006 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_KEY_REQ                              ((CsrWifiSmePrim) (0x0007 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_GET_REQ                              ((CsrWifiSmePrim) (0x0008 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_SET_REQ                              ((CsrWifiSmePrim) (0x0009 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_MULTICAST_ADDRESS_REQ                ((CsrWifiSmePrim) (0x000A + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_PMKID_REQ                            ((CsrWifiSmePrim) (0x000B + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_SCAN_FULL_REQ                        ((CsrWifiSmePrim) (0x000C + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_SCAN_RESULTS_FLUSH_REQ               ((CsrWifiSmePrim) (0x000D + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_SCAN_RESULTS_GET_REQ                 ((CsrWifiSmePrim) (0x000E + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_TSPEC_REQ                            ((CsrWifiSmePrim) (0x000F + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_WIFI_FLIGHTMODE_REQ                  ((CsrWifiSmePrim) (0x0010 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_WIFI_OFF_REQ                         ((CsrWifiSmePrim) (0x0011 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_WIFI_ON_REQ                          ((CsrWifiSmePrim) (0x0012 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_CLOAKED_SSIDS_SET_REQ                ((CsrWifiSmePrim) (0x0013 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_CLOAKED_SSIDS_GET_REQ                ((CsrWifiSmePrim) (0x0014 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_INTERFACE_ADD_REQ                    ((CsrWifiSmePrim) (0x0015 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_INTERFACE_DEL_REQ                    ((CsrWifiSmePrim) (0x0016 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST))


#define CSR_WIFI_SME_PRIM_DOWNSTREAM_HIGHEST           (0x0016 + CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST)

/* Upstream */
#define CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST              (0x0000 + CSR_PRIM_UPSTREAM)

#define CSR_WIFI_SME_ACTIVATE_CFM                         ((CsrWifiSmePrim) (0x0000 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_ASSOCIATION_COMPLETE_IND             ((CsrWifiSmePrim) (0x0001 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_ASSOCIATION_START_IND                ((CsrWifiSmePrim) (0x0002 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_BLACKLIST_CFM                        ((CsrWifiSmePrim) (0x0003 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_CALIBRATION_DATA_GET_CFM             ((CsrWifiSmePrim) (0x0004 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_CONNECT_CFM                          ((CsrWifiSmePrim) (0x0005 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_CONNECTION_QUALITY_IND               ((CsrWifiSmePrim) (0x0006 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_DEACTIVATE_CFM                       ((CsrWifiSmePrim) (0x0007 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_DISCONNECT_CFM                       ((CsrWifiSmePrim) (0x0008 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_EVENT_MASK_SET_CFM                   ((CsrWifiSmePrim) (0x0009 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_IBSS_STATION_IND                     ((CsrWifiSmePrim) (0x000A + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_KEY_CFM                              ((CsrWifiSmePrim) (0x000B + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_MEDIA_STATUS_IND                     ((CsrWifiSmePrim) (0x000C + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_GET_CFM                              ((CsrWifiSmePrim) (0x000D + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_SET_CFM                              ((CsrWifiSmePrim) (0x000E + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_MIC_FAILURE_IND                      ((CsrWifiSmePrim) (0x000F + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_MULTICAST_ADDRESS_CFM                ((CsrWifiSmePrim) (0x0010 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_PMKID_CANDIDATE_LIST_IND             ((CsrWifiSmePrim) (0x0011 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_PMKID_CFM                            ((CsrWifiSmePrim) (0x0012 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_ROAM_COMPLETE_IND                    ((CsrWifiSmePrim) (0x0013 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_ROAM_START_IND                       ((CsrWifiSmePrim) (0x0014 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_SCAN_FULL_CFM                        ((CsrWifiSmePrim) (0x0015 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_SCAN_RESULT_IND                      ((CsrWifiSmePrim) (0x0016 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_SCAN_RESULTS_FLUSH_CFM               ((CsrWifiSmePrim) (0x0017 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_SCAN_RESULTS_GET_CFM                 ((CsrWifiSmePrim) (0x0018 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_TSPEC_IND                            ((CsrWifiSmePrim) (0x0019 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_TSPEC_CFM                            ((CsrWifiSmePrim) (0x001A + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_WIFI_FLIGHTMODE_CFM                  ((CsrWifiSmePrim) (0x001B + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_WIFI_OFF_IND                         ((CsrWifiSmePrim) (0x001C + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_WIFI_OFF_CFM                         ((CsrWifiSmePrim) (0x001D + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_WIFI_ON_CFM                          ((CsrWifiSmePrim) (0x001E + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_CLOAKED_SSIDS_SET_CFM                ((CsrWifiSmePrim) (0x001F + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_CLOAKED_SSIDS_GET_CFM                ((CsrWifiSmePrim) (0x0020 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_WIFI_ON_IND                          ((CsrWifiSmePrim) (0x0021 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_CORE_DUMP_IND                        ((CsrWifiSmePrim) (0x0022 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_AMP_STATUS_CHANGE_IND                ((CsrWifiSmePrim) (0x0023 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_INTERFACE_ADD_IND                    ((CsrWifiSmePrim) (0x0024 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_INTERFACE_ADD_CFM                    ((CsrWifiSmePrim) (0x0025 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_INTERFACE_DEL_IND                    ((CsrWifiSmePrim) (0x0026 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_INTERFACE_DEL_CFM                    ((CsrWifiSmePrim) (0x0027 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_SUSPEND_IND                          ((CsrWifiSmePrim) (0x0028 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_RESUME_IND                           ((CsrWifiSmePrim) (0x0029 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST))

#define CSR_WIFI_SME_PRIM_UPSTREAM_HIGHEST             (0x0029 + CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST)

#define CSR_WIFI_SME_PRIM_DOWNSTREAM_COUNT             (CSR_WIFI_SME_PRIM_DOWNSTREAM_HIGHEST + 1 - CSR_WIFI_SME_PRIM_DOWNSTREAM_LOWEST)
#define CSR_WIFI_SME_PRIM_UPSTREAM_COUNT               (CSR_WIFI_SME_PRIM_UPSTREAM_HIGHEST + 1 - CSR_WIFI_SME_PRIM_UPSTREAM_LOWEST)

/*******************************************************************************

  NAME
    CsrWifiSmeActivateReq

  DESCRIPTION
    The WMA sends this primitive to activate the SME.
    The WMA must activate the SME before it can send any other primitive.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
} CsrWifiSmeActivateReq;

/*******************************************************************************

  NAME
    CsrWifiSmeBlacklistReq

  DESCRIPTION
    The wireless manager application should call this primitive to notify the
    driver of any networks that should not be connected to. The interface
    allows the wireless manager application to query, add, remove, and flush
    the BSSIDs that the driver may not connect or roam to.
    When this primitive adds to the black list the BSSID to which the SME is
    currently connected, the SME will try to roam, if applicable, to another
    BSSID in the same ESS; if the roaming procedure fails, the SME will
    disconnect.

  MEMBERS
    common          - Common header for use with the CsrWifiFsm Module
    interfaceTag    - Interface Identifier; unique identifier of an interface
    action          - The value of the CsrWifiSmeListAction parameter instructs
                      the driver to modify or provide the list of blacklisted
                      networks.
    setAddressCount - Number of BSSIDs sent with this primitive
    setAddresses    - Pointer to the list of BBSIDs sent with the primitive, set
                      to NULL if none is sent.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent      common;
    CsrUint16            interfaceTag;
    CsrWifiSmeListAction action;
    CsrUint8             setAddressCount;
    CsrWifiMacAddress   *setAddresses;
} CsrWifiSmeBlacklistReq;

/*******************************************************************************

  NAME
    CsrWifiSmeCalibrationDataGetReq

  DESCRIPTION
    This primitive retrieves the Wi-Fi radio calibration data.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
} CsrWifiSmeCalibrationDataGetReq;

/*******************************************************************************

  NAME
    CsrWifiSmeConnectReq

  DESCRIPTION
    The wireless manager application calls this primitive to start the
    process of joining an 802.11 wireless network or to start an ad hoc
    network.
    The structure pointed by connectionConfig contains parameters describing
    the network to join or, in case of an ad hoc network, to host or join.
    The SME will select a network, perform the IEEE 802.11 Join, Authenticate
    and Associate exchanges.
    The SME selects the networks from the current scan list that match both
    the SSID and BSSID, however either or both of these may be the wildcard
    value. Using this rule, the following operations are possible:
      * To connect to a network by name, specify the SSID and set the BSSID to
        0xFF 0xFF 0xFF 0xFF 0xFF 0xFF. If there are two or more networks visible,
        the SME will select the one with the strongest signal.
      * To connect to a specific network, specify the BSSID. The SSID is
        optional, but if given it must match the SSID of the network. An empty
        SSID may be specified by setting the SSID length to zero. Please note
        that if the BSSID is specified (i.e. not equal to 0xFF 0xFF 0xFF 0xFF
        0xFF 0xFF), the SME will not attempt to roam if signal conditions become
        poor, even if there is an alternative AP with an SSID that matches the
        current network SSID.
      * To connect to any network matching the other parameters (i.e. security,
        etc), set the SSID length to zero and set the BSSID to 0xFF 0xFF 0xFF
        0xFF 0xFF 0xFF. In this case, the SME will order all available networks
        by their signal strengths and will iterate through this list until it
        successfully connects.
    NOTE: Specifying the BSSID will restrict the selection to one specific
    network. If SSID and BSSID are given, they must both match the network
    for it to be selected. To select a network based on the SSID only, the
    wireless manager application must set the BSSID to 0xFF 0xFF 0xFF 0xFF
    0xFF 0xFF.
    The SME will try to connect to each network that matches the provided
    parameters, one by one, until it succeeds or has tried unsuccessfully
    with all the matching networks.
    If there is no network that matches the parameters and the request allows
    to host an ad hoc network, the SME will advertise a new ad hoc network
    instead.
    If the SME cannot connect, it will notify the failure in the confirm.

  MEMBERS
    common           - Common header for use with the CsrWifiFsm Module
    interfaceTag     - Interface Identifier; unique identifier of an interface
    connectionConfig - Describes the candidate network to join or to host.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent            common;
    CsrUint16                  interfaceTag;
    CsrWifiSmeConnectionConfig connectionConfig;
} CsrWifiSmeConnectReq;

/*******************************************************************************

  NAME
    CsrWifiSmeDeactivateReq

  DESCRIPTION
    The WMA sends this primitive to deactivate the SME.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
} CsrWifiSmeDeactivateReq;

/*******************************************************************************

  NAME
    CsrWifiSmeDisconnectReq

  DESCRIPTION
    The wireless manager application may disconnect from the current network
    by calling this primitive

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
} CsrWifiSmeDisconnectReq;

/*******************************************************************************

  NAME
    CsrWifiSmeEventMaskSetReq

  DESCRIPTION
    The wireless manager application may register with the SME to receive
    notification of interesting events. Indications will be sent only if the
    wireless manager explicitly registers to be notified of that event.
    indMask is a bit mask of values defined in CsrWifiSmeIndicationsMask.

  MEMBERS
    common  - Common header for use with the CsrWifiFsm Module
    indMask - Set mask with values from CsrWifiSmeIndications

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent           common;
    CsrWifiSmeIndicationsMask indMask;
} CsrWifiSmeEventMaskSetReq;

/*******************************************************************************

  NAME
    CsrWifiSmeKeyReq

  DESCRIPTION
    The wireless manager application calls this primitive to add or remove
    keys that the chip should use for encryption of data.
    The interface allows the wireless manager application to add and remove
    keys according to the specified action.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    action       - The value of the CsrWifiSmeListAction parameter instructs the
                   driver to modify or provide the list of keys.
                   CSR_WIFI_SME_LIST_ACTION_GET is not supported here.
    key          - Key to be added or removed

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent      common;
    CsrUint16            interfaceTag;
    CsrWifiSmeListAction action;
    CsrWifiSmeKey        key;
} CsrWifiSmeKeyReq;

/*******************************************************************************

  NAME
    CsrWifiSmeGetReq

  DESCRIPTION
    The wireless manager application calls this primitive to retrieve one or
    more MIB variables.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface Use
                   0xFFFF to read the values from the interface mib defaults
    valuesLength - Length of values
    values       - Encoded Psids and Indexes

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrUint32       valuesLength;
    CsrUint8       *values;
} CsrWifiSmeGetReq;

/*******************************************************************************

  NAME
    CsrWifiSmeSetReq

  DESCRIPTION
    This primitive carries PSIDs to be set within WiFi stack and/or Firmware

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface Use
                   0xFFFF to write the values from the interface mib defaults
    resetMib     - Reset the Mib values. If interfaceTag == 0xFFFF : This value
                   should be set to FALSE. If interfaceTag != 0xFFFF : Reset
                   Interface values to the same as the Interface Defaults. Note:
                   The interface must not be in use otherwise no reset will
                   occur. Note: This only affects Host Mib values. Firmware mib
                   values are not reset Note: If the Reset Fails or is not
                   allowed the requested 'values' will fail to be set and return
                   with a status of 'CSR_WIFI_SME_MIB_STATUS_NOT_TRIED'
    valuesLength - Length of values
    values       - Encoded Psids, Indexes and Data

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrBool         resetMib;
    CsrUint32       valuesLength;
    CsrUint8       *values;
} CsrWifiSmeSetReq;

/*******************************************************************************

  NAME
    CsrWifiSmeMulticastAddressReq

  DESCRIPTION
    The wireless manager application calls this primitive to specify the
    multicast addresses which the chip should recognise. The interface allows
    the wireless manager application to query, add, remove and flush the
    multicast addresses for the network interface according to the specified
    action.

  MEMBERS
    common            - Common header for use with the CsrWifiFsm Module
    interfaceTag      - Interface Identifier; unique identifier of an interface
    action            - The value of the CsrWifiSmeListAction parameter
                        instructs the driver to modify or provide the list of
                        MAC addresses.
    setAddressesCount - Number of MAC addresses sent with the primitive
    setAddresses      - Pointer to the list of MAC Addresses sent with the
                        primitive, set to NULL if none is sent.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent      common;
    CsrUint16            interfaceTag;
    CsrWifiSmeListAction action;
    CsrUint8             setAddressesCount;
    CsrWifiMacAddress   *setAddresses;
} CsrWifiSmeMulticastAddressReq;

/*******************************************************************************

  NAME
    CsrWifiSmePmkidReq

  DESCRIPTION
    The wireless manager application calls this primitive to request an
    operation on the SME PMKID list.
    The action argument specifies the operation to perform.
    When the connection is complete, the wireless manager application may
    then send and receive EAPOL packets to complete WPA or WPA2
    authentication if appropriate.
    The wireless manager application can then pass the resulting encryption
    keys using this primitive.

  MEMBERS
    common         - Common header for use with the CsrWifiFsm Module
    interfaceTag   - Interface Identifier; unique identifier of an interface
    action         - The value of the CsrWifiSmeListAction parameter instructs
                     the driver to modify or provide the list of PMKIDs.
    setPmkidsCount - Number of PMKIDs sent with the primitive
    setPmkids      - Pointer to the list of PMKIDs sent with the primitive, set
                     to NULL if none is sent.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent      common;
    CsrUint16            interfaceTag;
    CsrWifiSmeListAction action;
    CsrUint8             setPmkidsCount;
    CsrWifiSmePmkid     *setPmkids;
} CsrWifiSmePmkidReq;

/*******************************************************************************

  NAME
    CsrWifiSmeScanFullReq

  DESCRIPTION
    The wireless manager application should call this primitive to request a
    full scan.
    Channels are scanned actively or passively according to the requirement
    set by regulatory domain.
    If the SME receives this primitive while a full scan is going on, the new
    request is buffered and it will be served after the current full scan is
    completed.

  MEMBERS
    common               - Common header for use with the CsrWifiFsm Module
    ssidCount            - Number of SSIDs provided.
                           If it is 0, the SME will attempt to detect any
                           network
    ssid                 - Points to the first SSID provided, if any.
    bssid                - BSS identifier.
                           If it is equal to FF-FF-FF-FF-FF, the SME will listen
                           for messages from any BSS.
                           If it is different from FF-FF-FF-FF-FF and any SSID
                           is provided, one SSID must match the network of the
                           BSS.
    forceScan            - Forces the scan even if the SME is in a state which
                           would normally prevent it
    bssType              - Type of BSS to scan for
    channelInfoListCount - Number of channels provided.
                           If it is 0, the SME will initiate a scan of all the
                           supported channels that are permitted by the current
                           regulatory domain.
    channelInfoList      - List of ChannelInfo to scan or NULL if
                           channelListCount is zero.
    probeIeLength        - Length of the information element in bytes to be sent
                           with the probe message.
    probeIe              - Points to the first byte of the information element
                           to be sent with the probe message.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrUint8          ssidCount;
    CsrWifiSsid      *ssid;
    CsrWifiMacAddress bssid;
    CsrBool           forceScan;
    CsrWifiSmeBssType bssType;
    CsrUint16         channelInfoListCount;
    CsrUint16        *channelInfoList;
    CsrUint32         probeIeLength;
    CsrUint8         *probeIe;
} CsrWifiSmeScanFullReq;

/*******************************************************************************

  NAME
    CsrWifiSmeScanResultsFlushReq

  DESCRIPTION
    The Wireless Manager calls this primitive to ask the SME to delete all
    scan results from its cache, except for the scan result of any currently
    connected network.
    As scan results are received by the SME from the firmware, they are
    cached in the SME memory.
    Any time the Wireless Manager requests scan results, they are returned
    from the SME internal cache.
    For some applications it may be desirable to clear this cache prior to
    requesting that a scan be performed; this will ensure that the cache then
    only contains the networks detected in the most recent scan.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
} CsrWifiSmeScanResultsFlushReq;

/*******************************************************************************

  NAME
    CsrWifiSmeScanResultsGetReq

  DESCRIPTION
    The wireless manager application calls this primitive to retrieve the
    current set of scan results, either after receiving a successful
    CSR_WIFI_SME_SCAN_FULL_CFM, or to get autonomous scan results.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
} CsrWifiSmeScanResultsGetReq;

/*******************************************************************************

  NAME
    CsrWifiSmeTspecReq

  DESCRIPTION
    The wireless manager application should call this primitive to use the
    TSPEC feature.
    The chip supports the use of TSPECs and TCLAS for the use of IEEE
    802.11/WMM Quality of Service features.
    The API allows the wireless manager application to supply a correctly
    formatted TSPEC and TCLAS pair to the driver.
    After performing basic validation, the driver negotiates the installation
    of the TSPEC with the AP as defined by the 802.11 specification.
    The driver retains all TSPEC and TCLAS pairs until they are specifically
    removed.
    It is not compulsory for a TSPEC to have a TCLAS (NULL is used to
    indicate that no TCLAS is supplied), while a TCLASS always require a
    TSPEC.
    The format of the TSPEC element is specified in 'WMM (including WMM Power
    Save) Specification - Version 1.1' and 'ANSI/IEEE Std 802.11-REVmb/D3.0'.
    For more information, see 'UniFi Configuring WMM and WMM-PS'.

  MEMBERS
    common        - Common header for use with the CsrWifiFsm Module
    interfaceTag  - Interface Identifier; unique identifier of an interface
    action        - Specifies the action to be carried out on the list of TSPECs.
                    CSR_WIFI_SME_LIST_ACTION_FLUSH is not applicable here.
    transactionId - Unique Transaction ID for the TSPEC, as assigned by the
                    driver
    strict        - If it set to false, allows the SME to perform automatic
                    TSPEC negotiation
    ctrlMask      - Additional TSPEC configuration
                    Set mask with values from CsrWifiSmeTspecCtrl.
    tspecLength   - Length of the TSPEC.
    tspec         - Points to the first byte of the TSPEC
    tclasLength   - Length of the TCLAS.
                    If it is equal to 0, no TCLASS is provided for the TSPEC
    tclas         - Points to the first byte of the TCLAS, if any.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent         common;
    CsrUint16               interfaceTag;
    CsrWifiSmeListAction    action;
    CsrUint32               transactionId;
    CsrBool                 strict;
    CsrWifiSmeTspecCtrlMask ctrlMask;
    CsrUint32               tspecLength;
    CsrUint8               *tspec;
    CsrUint32               tclasLength;
    CsrUint8               *tclas;
} CsrWifiSmeTspecReq;

/*******************************************************************************

  NAME
    CsrWifiSmeWifiFlightmodeReq

  DESCRIPTION
    The wireless manager application may call this primitive on boot-up of
    the platform to ensure that the chip is placed in a mode that prevents
    any emission of RF energy.
    This primitive is an alternative to CSR_WIFI_SME_WIFI_ON_REQ.
    As in CSR_WIFI_SME_WIFI_ON_REQ, it causes the download of the patch file
    (if any) and the programming of the initial MIB settings (if supplied by
    the WMA), but it also ensures that the chip is left in its lowest
    possible power-mode with the radio subsystems disabled.
    This feature is useful on platforms where power cannot be removed from
    the chip (leaving the chip not initialised will cause it to consume more
    power so calling this function ensures that the chip is initialised into
    a low power mode but without entering a state where it could emit any RF
    energy).
    NOTE: this primitive does not cause the Wi-Fi to change state: Wi-Fi
    stays conceptually off. Configuration primitives can be sent after
    CSR_WIFI_SME_WIFI_FLIGHTMODE_REQ and the configuration will be maintained.
    Requests that require the state of the Wi-Fi to be ON will return
    CSR_RESULT_WIFI_OFF in their confirms.

  MEMBERS
    common        - Common header for use with the CsrWifiFsm Module
    mibFilesCount - Number of provided data blocks with initial MIB values
    mibFiles      - Points to the first data block with initial MIB values.
                    These data blocks are typically the contents of the provided
                    files ufmib.dat and localmib.dat, available from the host
                    file system, if they exist.
                    These files typically contain radio tuning and calibration
                    values.
                    More values can be created using the Host Tools.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrUint16         mibFilesCount;
    CsrWifiDataBlock *mibFiles;
} CsrWifiSmeWifiFlightmodeReq;

/*******************************************************************************

  NAME
    CsrWifiSmeWifiOffReq

  DESCRIPTION
    The wireless manager application calls this primitive to turn off the
    chip, thus saving power when Wi-Fi is not in use.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
} CsrWifiSmeWifiOffReq;

/*******************************************************************************

  NAME
    CsrWifiSmeWifiOnReq

  DESCRIPTION
    The wireless manager application calls this primitive to turn on the
    Wi-Fi chip.
    If the Wi-Fi chip is currently off, the SME turns the Wi-Fi chip on,
    downloads the patch file (if any), and programs the initial MIB settings
    (if supplied by the WMA).
    The patch file is not provided with the SME API; its downloading is
    automatic and handled internally by the system.
    The MIB settings, when provided, override the default values that the
    firmware loads from EEPROM.
    If the Wi-Fi chip is already on, the SME takes no action and returns a
    successful status in the confirm.

  MEMBERS
    common        - Common header for use with the CsrWifiFsm Module
    address       - Optionally specifies a station MAC address.
                    In normal use, the manager should set the address to 0xFF
                    0xFF 0xFF 0xFF 0xFF 0xFF, which will cause the chip to use
                    the MAC address in the MIB
    mibFilesCount - Number of provided data blocks with initial MIB values
    mibFiles      - Points to the first data block with initial MIB values.
                    These data blocks are typically the contents of the provided
                    files ufmib.dat and localmib.dat, available from the host
                    file system, if they exist.
                    These files typically contain radio tuning and calibration
                    values.
                    More values can be created using the Host Tools.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrWifiMacAddress address;
    CsrUint16         mibFilesCount;
    CsrWifiDataBlock *mibFiles;
} CsrWifiSmeWifiOnReq;

/*******************************************************************************

  NAME
    CsrWifiSmeCloakedSsidsSetReq

  DESCRIPTION
    This primitive sets the list of cloaked SSIDs for which the WMA possesses
    profiles.
    When the driver detects a cloaked AP, the SME will explicitly scan for it
    using the list of cloaked SSIDs provided it, and, if the scan succeeds,
    it will report the AP to the WMA either via CSR_WIFI_SME_SCAN_RESULT_IND
    (if registered) or via CSR_WIFI_SCAN_RESULT_GET_CFM.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    cloakedSsids - Sets the list of cloaked SSIDs

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent             common;
    CsrWifiSmeCloakedSsidConfig cloakedSsids;
} CsrWifiSmeCloakedSsidsSetReq;

/*******************************************************************************

  NAME
    CsrWifiSmeCloakedSsidsGetReq

  DESCRIPTION
    This primitive gets the value of the CloakedSsids parameter.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
} CsrWifiSmeCloakedSsidsGetReq;

/*******************************************************************************

  NAME
    CsrWifiSmeInterfaceAddReq

  DESCRIPTION
    This primitive is used to create a non-default virtual interface in the
    Wi-Fi stack.

  MEMBERS
    common  - Common header for use with the CsrWifiFsm Module
    address - Must be a Global address or FF:FF:FF:FF:FF:FF for the Sme to
              allocate a local address.
              Note: For the current release it must be FF:FF:FF:FF:FF:FF

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrWifiMacAddress address;
} CsrWifiSmeInterfaceAddReq;

/*******************************************************************************

  NAME
    CsrWifiSmeInterfaceDelReq

  DESCRIPTION
    Note Cannot del the default interface ONLY a interface created by
    CsrWifiSmeInterfaceAddReq can use CsrWifiSmeInterfaceDelReq if no
    activity is going on that interface.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
} CsrWifiSmeInterfaceDelReq;

/*******************************************************************************

  NAME
    CsrWifiSmeActivateCfm

  DESCRIPTION
    The SME sends this primitive when the activation is complete.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module
    status - Reports the result of the request

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrResult       status;
} CsrWifiSmeActivateCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeAssociationCompleteInd

  DESCRIPTION
    The SME will send this primitive to all the tasks that have registered to
    receive it whenever it completes an attempt to associate with an AP. If
    the association was successful, status will be set to CSR_RESULT_SUCCESS,
    otherwise status and deauthReason shall be set to appropriate error
    codes.

  MEMBERS
    common         - Common header for use with the CsrWifiFsm Module
    interfaceTag   - Interface Identifier; unique identifier of an interface
    status         - Reports the result of the association procedure
    connectionInfo - This parameter is relevant only if result is
                     CSR_RESULT_SUCCESS:
                     it points to the connection information for the new network
    deauthReason   - This parameter is relevant only if result is not
                     CSR_RESULT_SUCCESS:
                     if the AP deauthorised the station, it gives the reason of
                     the deauthorization

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent           common;
    CsrUint16                 interfaceTag;
    CsrResult                 status;
    CsrWifiSmeConnectionInfo  connectionInfo;
    CsrWifiSmeIEEE80211Reason deauthReason;
} CsrWifiSmeAssociationCompleteInd;

/*******************************************************************************

  NAME
    CsrWifiSmeAssociationStartInd

  DESCRIPTION
    The SME will send this primitive to all the tasks that have registered to
    receive it whenever it begins an attempt to associate with an AP.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    address      - BSSID of the associating network
    ssid         - Service Set identifier of the associating network

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrUint16         interfaceTag;
    CsrWifiMacAddress address;
    CsrWifiSsid       ssid;
} CsrWifiSmeAssociationStartInd;

/*******************************************************************************

  NAME
    CsrWifiSmeBlacklistCfm

  DESCRIPTION
    The SME will call this primitive when the action on the blacklist has
    completed. For a GET action, this primitive also reports the list of
    BBSIDs in the blacklist.

  MEMBERS
    common          - Common header for use with the CsrWifiFsm Module
    interfaceTag    - Interface Identifier; unique identifier of an interface
    status          - Reports the result of the request
    action          - Action in the request
    getAddressCount - This parameter is only relevant if action is
                      CSR_WIFI_SME_LIST_ACTION_GET:
                      number of BSSIDs sent with this primitive
    getAddresses    - Pointer to the list of BBSIDs sent with the primitive, set
                      to NULL if none is sent.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent      common;
    CsrUint16            interfaceTag;
    CsrResult            status;
    CsrWifiSmeListAction action;
    CsrUint8             getAddressCount;
    CsrWifiMacAddress   *getAddresses;
} CsrWifiSmeBlacklistCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeCalibrationDataGetCfm

  DESCRIPTION
    This primitive reports the result of the request.

  MEMBERS
    common                - Common header for use with the CsrWifiFsm Module
    status                - Reports the result of the request
    calibrationDataLength - Number of bytes in the buffer pointed by
                            calibrationData
    calibrationData       - Pointer to a buffer of length calibrationDataLength
                            containing the calibration data

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrResult       status;
    CsrUint32       calibrationDataLength;
    CsrUint8       *calibrationData;
} CsrWifiSmeCalibrationDataGetCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeConnectCfm

  DESCRIPTION
    The SME calls this primitive when the connection exchange is complete or
    all connection attempts fail.

  MEMBERS
    common            - Common header for use with the CsrWifiFsm Module
    interfaceTag      - Interface Identifier; unique identifier of an interface
    status            - Reports the result of the request.
                        CSR_RESULT_NOT_FOUND: all attempts by the SME to locate
                        the requested AP failed
    errorValuesLength - Length of errorValues
    errorValues       - Encoded Psids, Indexes and Status Code

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrResult       status;
    CsrUint32       errorValuesLength;
    CsrUint8       *errorValues;
} CsrWifiSmeConnectCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeConnectionQualityInd

  DESCRIPTION
    The SME sends this primitive to all the tasks that have registered to
    receive it whenever the value of the current connection quality
    parameters change by more than a certain configurable amount.
    The wireless manager application may configure the trigger thresholds for
    this indication using the field in smeConfig parameter of
    CSR_WIFI_SME_SME_CONFIG_SET_REQ.
    Connection quality messages can be suppressed by setting both thresholds
    to zero.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    linkQuality  - Indicates the quality of the link

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent       common;
    CsrUint16             interfaceTag;
    CsrWifiSmeLinkQuality linkQuality;
} CsrWifiSmeConnectionQualityInd;

/*******************************************************************************

  NAME
    CsrWifiSmeDeactivateCfm

  DESCRIPTION
    The SME sends this primitive when the deactivation is complete.
    The WMA cannot send any more primitives until it actives the SME again
    sending another CSR_WIFI_SME_ACTIVATE_REQ.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module
    status - Reports the result of the request

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrResult       status;
} CsrWifiSmeDeactivateCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeDisconnectCfm

  DESCRIPTION
    On reception of CSR_WIFI_SME_DISCONNECT_REQ the SME will perform a
    disconnect operation, sending a CsrWifiSmeMediaStatusInd with
    CSR_WIFI_SME_MEDIA_STATUS_DISCONNECTED and then call this primitive when
    disconnection is complete.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    status       - Reports the result of the request

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrResult       status;
} CsrWifiSmeDisconnectCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeEventMaskSetCfm

  DESCRIPTION
    The SME calls the primitive to report the result of the request
    primitive.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module
    status - Reports the result of the request

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrResult       status;
} CsrWifiSmeEventMaskSetCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeIbssStationInd

  DESCRIPTION
    The SME will send this primitive to indicate that a station has joined or
    left the ad-hoc network.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    address      - MAC address of the station that has joined or left
    isconnected  - TRUE if the station joined, FALSE if the station left

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrUint16         interfaceTag;
    CsrWifiMacAddress address;
    CsrBool           isconnected;
} CsrWifiSmeIbssStationInd;

/*******************************************************************************

  NAME
    CsrWifiSmeKeyCfm

  DESCRIPTION
    The SME calls the primitive to report the result of the request
    primitive.

  MEMBERS
    common         - Common header for use with the CsrWifiFsm Module
    interfaceTag   - Interface Identifier; unique identifier of an interface
    status         - Reports the result of the request
    action         - Action in the request
    keyType        - Type of the key added/deleted
    peerMacAddress - Peer MAC Address of the key added/deleted

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent      common;
    CsrUint16            interfaceTag;
    CsrResult            status;
    CsrWifiSmeListAction action;
    CsrWifiSmeKeyType    keyType;
    CsrWifiMacAddress    peerMacAddress;
} CsrWifiSmeKeyCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeMediaStatusInd

  DESCRIPTION
    The SME sends this primitive to all the tasks that have registered to
    receive it when a network connection is established, lost or has moved to
    another AP.

  MEMBERS
    common         - Common header for use with the CsrWifiFsm Module
    interfaceTag   - Interface Identifier; unique identifier of an interface
    mediaStatus    - Indicates the media status
    connectionInfo - This parameter is relevant only if the mediaStatus is
                     CSR_WIFI_SME_MEDIA_STATUS_CONNECTED:
                     it points to the connection information for the new network
    disassocReason - This parameter is relevant only if the mediaStatus is
                     CSR_WIFI_SME_MEDIA_STATUS_DISCONNECTED:
                     if a disassociation has occurred it gives the reason of the
                     disassociation
    deauthReason   - This parameter is relevant only if the mediaStatus is
                     CSR_WIFI_SME_MEDIA_STATUS_DISCONNECTED:
                     if a deauthentication has occurred it gives the reason of
                     the deauthentication

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent           common;
    CsrUint16                 interfaceTag;
    CsrWifiSmeMediaStatus     mediaStatus;
    CsrWifiSmeConnectionInfo  connectionInfo;
    CsrWifiSmeIEEE80211Reason disassocReason;
    CsrWifiSmeIEEE80211Reason deauthReason;
} CsrWifiSmeMediaStatusInd;

/*******************************************************************************

  NAME
    CsrWifiSmeGetCfm

  DESCRIPTION
    The SME calls this primitive to return the requested MIB variable values.

  MEMBERS
    common            - Common header for use with the CsrWifiFsm Module
    interfaceTag      - Interface Identifier; unique identifier of an interface
    valuesLength      - Length of values
    values            - Encoded Psids, Indexes and Data
    errorValuesLength - Length of errorValues
    errorValues       - Encoded Psids, Indexes and Status Code

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrUint32       valuesLength;
    CsrUint8       *values;
    CsrUint32       errorValuesLength;
    CsrUint8       *errorValues;
} CsrWifiSmeGetCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeSetCfm

  DESCRIPTION
    The SME calls the primitive to report the result of the set primitive.

  MEMBERS
    common            - Common header for use with the CsrWifiFsm Module
    interfaceTag      - Interface Identifier; unique identifier of an interface
    mibReset          - True  : if the mib values were reset due to the
                        CsrWifiSmeSetReq.resetMib flag. False : if
                        CsrWifiSmeSetReq.resetMib == False or the interface was
                        in use and the reset was not allowed.
    errorValuesLength - Length of errorValues
    errorValues       - Encoded Psids, Indexes and Status Code

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrBool         mibReset;
    CsrUint32       errorValuesLength;
    CsrUint8       *errorValues;
} CsrWifiSmeSetCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeMicFailureInd

  DESCRIPTION
    The SME sends this primitive to all the tasks that have registered to
    receive it whenever the chip firmware reports a MIC failure. It is the
    responsibility of the wireless manager application generate any
    appropriate Michael MIC Failure Report and if required disconenct from
    teh AP.

  MEMBERS
    common        - Common header for use with the CsrWifiFsm Module
    interfaceTag  - Interface Identifier; unique identifier of an interface
    secondFailure - TRUE if this indication is for a second failure in 60
                    seconds
    count         - The number of MIC failure events since the connection was
                    established
    address       - MAC address of the transmitter that caused the MIC failure
    keyType       - Type of key for which the failure occurred

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrUint16         interfaceTag;
    CsrBool           secondFailure;
    CsrUint16         count;
    CsrWifiMacAddress address;
    CsrWifiSmeKeyType keyType;
} CsrWifiSmeMicFailureInd;

/*******************************************************************************

  NAME
    CsrWifiSmeMulticastAddressCfm

  DESCRIPTION
    The SME will call this primitive when the operation is complete. For a
    GET action, this primitive reports the current list of MAC addresses.

  MEMBERS
    common            - Common header for use with the CsrWifiFsm Module
    interfaceTag      - Interface Identifier; unique identifier of an interface
    status            - Reports the result of the request
    action            - Action in the request
    getAddressesCount - This parameter is only relevant if action is
                        CSR_WIFI_SME_LIST_ACTION_GET:
                        number of MAC addresses sent with the primitive
    getAddresses      - Pointer to the list of MAC Addresses sent with the
                        primitive, set to NULL if none is sent.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent      common;
    CsrUint16            interfaceTag;
    CsrResult            status;
    CsrWifiSmeListAction action;
    CsrUint8             getAddressesCount;
    CsrWifiMacAddress   *getAddresses;
} CsrWifiSmeMulticastAddressCfm;

/*******************************************************************************

  NAME
    CsrWifiSmePmkidCandidateListInd

  DESCRIPTION
    The SME will send this primitive to all the tasks that have registered to
    receive it when a new network supporting preauthentication and/or PMK
    caching is seen.

  MEMBERS
    common               - Common header for use with the CsrWifiFsm Module
    interfaceTag         - Interface Identifier; unique identifier of an
                           interface
    pmkidCandidatesCount - Number of PMKID candidates provided
    pmkidCandidates      - Points to the first PMKID candidate

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent           common;
    CsrUint16                 interfaceTag;
    CsrUint8                  pmkidCandidatesCount;
    CsrWifiSmePmkidCandidate *pmkidCandidates;
} CsrWifiSmePmkidCandidateListInd;

/*******************************************************************************

  NAME
    CsrWifiSmePmkidCfm

  DESCRIPTION
    The SME will call this primitive when the operation is complete. For a
    GET action, this primitive reports the current list of PMKIDs

  MEMBERS
    common         - Common header for use with the CsrWifiFsm Module
    interfaceTag   - Interface Identifier; unique identifier of an interface
    status         - Reports the result of the request
    action         - Action in the request
    getPmkidsCount - This parameter is only relevant if action is
                     CSR_WIFI_SME_LIST_ACTION_GET:
                     number of PMKIDs sent with the primitive
    getPmkids      - Pointer to the list of PMKIDs sent with the primitive, set
                     to NULL if none is sent.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent      common;
    CsrUint16            interfaceTag;
    CsrResult            status;
    CsrWifiSmeListAction action;
    CsrUint8             getPmkidsCount;
    CsrWifiSmePmkid     *getPmkids;
} CsrWifiSmePmkidCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeRoamCompleteInd

  DESCRIPTION
    The SME will send this primitive to all the tasks that have registered to
    receive it whenever it completes an attempt to roam to an AP. If the roam
    attempt was successful, status will be set to CSR_WIFI_SME_SUCCESS,
    otherwise it shall be set to the appropriate error code.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    status       - Reports the result of the roaming procedure

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrResult       status;
} CsrWifiSmeRoamCompleteInd;

/*******************************************************************************

  NAME
    CsrWifiSmeRoamStartInd

  DESCRIPTION
    The SME will send this primitive to all the tasks that have registered to
    receive it whenever it begins an attempt to roam to an AP.
    If the wireless manager application connect request specified the SSID
    and the BSSID was set to the broadcast address (0xFF 0xFF 0xFF 0xFF 0xFF
    0xFF), the SME monitors the signal quality and maintains a list of
    candidates to roam to. When the signal quality of the current connection
    falls below a threshold, and there is a candidate with better quality,
    the SME will attempt to the candidate AP.
    If the roaming procedure succeeds, the SME will also issue a Media
    Connect indication to inform the wireless manager application of the
    change.
    NOTE: to prevent the SME from initiating roaming the WMA must specify the
    BSSID in the connection request; this forces the SME to connect only to
    that AP.
    The wireless manager application can obtain statistics for roaming
    purposes using CSR_WIFI_SME_CONNECTION_QUALITY_IND and
    CSR_WIFI_SME_CONNECTION_STATS_GET_REQ.
    When the wireless manager application wishes to roam to another AP, it
    must issue a connection request specifying the BSSID of the desired AP.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    roamReason   - Indicates the reason for starting the roaming procedure
    reason80211  - Indicates the reason for deauthentication or disassociation

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent           common;
    CsrUint16                 interfaceTag;
    CsrWifiSmeRoamReason      roamReason;
    CsrWifiSmeIEEE80211Reason reason80211;
} CsrWifiSmeRoamStartInd;

/*******************************************************************************

  NAME
    CsrWifiSmeScanFullCfm

  DESCRIPTION
    The SME calls this primitive when the results from the scan are
    available.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module
    status - Reports the result of the request

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrResult       status;
} CsrWifiSmeScanFullCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeScanResultInd

  DESCRIPTION
    The SME sends this primitive to all the tasks that have registered to
    receive it whenever a scan indication is received from the firmware.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module
    result - Points to a buffer containing a scan result.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent      common;
    CsrWifiSmeScanResult result;
} CsrWifiSmeScanResultInd;

/*******************************************************************************

  NAME
    CsrWifiSmeScanResultsFlushCfm

  DESCRIPTION
    The SME will call this primitive when the cache has been cleared.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module
    status - Reports the result of the request

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrResult       status;
} CsrWifiSmeScanResultsFlushCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeScanResultsGetCfm

  DESCRIPTION
    The SME sends this primitive to provide the current set of scan results.

  MEMBERS
    common           - Common header for use with the CsrWifiFsm Module
    status           - Reports the result of the request
    scanResultsCount - Number of scan results
    scanResults      - Points to a buffer containing an array of
                       CsrWifiSmeScanResult structures.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent       common;
    CsrResult             status;
    CsrUint16             scanResultsCount;
    CsrWifiSmeScanResult *scanResults;
} CsrWifiSmeScanResultsGetCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeTspecInd

  DESCRIPTION
    The SME will send this primitive to all the task that have registered to
    receive it when a change in the TSPEC occurs.

  MEMBERS
    common          - Common header for use with the CsrWifiFsm Module
    interfaceTag    - Interface Identifier; unique identifier of an interface
    transactionId   - Unique Transaction ID for the TSPEC, as assigned by the
                      driver
    tspecResultCode - Specifies the TSPEC operation requested by the peer
                      station
    tspecLength     - Length of the TSPEC.
    tspec           - Points to the first byte of the TSPEC

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent           common;
    CsrUint16                 interfaceTag;
    CsrUint32                 transactionId;
    CsrWifiSmeTspecResultCode tspecResultCode;
    CsrUint32                 tspecLength;
    CsrUint8                 *tspec;
} CsrWifiSmeTspecInd;

/*******************************************************************************

  NAME
    CsrWifiSmeTspecCfm

  DESCRIPTION
    The SME calls the primitive to report the result of the TSpec primitive
    request.

  MEMBERS
    common          - Common header for use with the CsrWifiFsm Module
    interfaceTag    - Interface Identifier; unique identifier of an interface
    status          - Reports the result of the request
    transactionId   - Unique Transaction ID for the TSPEC, as assigned by the
                      driver
    tspecResultCode - Specifies the result of the negotiated TSPEC operation
    tspecLength     - Length of the TSPEC.
    tspec           - Points to the first byte of the TSPEC

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent           common;
    CsrUint16                 interfaceTag;
    CsrResult                 status;
    CsrUint32                 transactionId;
    CsrWifiSmeTspecResultCode tspecResultCode;
    CsrUint32                 tspecLength;
    CsrUint8                 *tspec;
} CsrWifiSmeTspecCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeWifiFlightmodeCfm

  DESCRIPTION
    The SME calls this primitive when the chip is initialised for low power
    mode and with the radio subsystem disabled. To leave flight mode, and
    enable Wi-Fi, the wireless manager application should call
    CSR_WIFI_SME_WIFI_ON_REQ.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module
    status - Reports the result of the request

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrResult       status;
} CsrWifiSmeWifiFlightmodeCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeWifiOffInd

  DESCRIPTION
    The SME sends this primitive to all the tasks that have registered to
    receive it to report that the chip has been turned off.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module
    reason - Indicates the reason why the Wi-Fi has been switched off.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent             common;
    CsrWifiSmeControlIndication reason;
} CsrWifiSmeWifiOffInd;

/*******************************************************************************

  NAME
    CsrWifiSmeWifiOffCfm

  DESCRIPTION
    After receiving CSR_WIFI_SME_WIFI_OFF_REQ, if the chip is connected to a
    network, the SME will perform a disconnect operation, will send a
    CSR_WIFI_SME_MEDIA_STATUS_IND with
    CSR_WIFI_SME_MEDIA_STATUS_DISCONNECTED, and then will call
    CSR_WIFI_SME_WIFI_OFF_CFM when the chip is off.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module
    status - Reports the result of the request

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrResult       status;
} CsrWifiSmeWifiOffCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeWifiOnCfm

  DESCRIPTION
    The SME sends this primitive to the task that has sent the request once
    the chip has been initialised and is available for use.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    status       - Reports the result of the request
    address      - Current MAC address

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrUint16         interfaceTag;
    CsrResult         status;
    CsrWifiMacAddress address;
} CsrWifiSmeWifiOnCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeCloakedSsidsSetCfm

  DESCRIPTION
    This primitive reports the result of the request.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module
    status - Reports the result of the request

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrResult       status;
} CsrWifiSmeCloakedSsidsSetCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeCloakedSsidsGetCfm

  DESCRIPTION
    This primitive reports the result of the request.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    status       - Reports the result of the request
    cloakedSsids - Reports list of cloaked SSIDs that are explicitly scanned for
                   by the driver

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent             common;
    CsrResult                   status;
    CsrWifiSmeCloakedSsidConfig cloakedSsids;
} CsrWifiSmeCloakedSsidsGetCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeWifiOnInd

  DESCRIPTION
    The SME sends this primitive to all tasks that have registered to receive
    it once the chip becomes available and ready to use.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    address      - Current MAC address

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrUint16         interfaceTag;
    CsrWifiMacAddress address;
} CsrWifiSmeWifiOnInd;

/*******************************************************************************

  NAME
    CsrWifiSmeCoreDumpInd

  DESCRIPTION
    The SME will send this primitive to all the tasks that have registered to
    receive Wi-Fi Chip core dump data.
    The core dump data may be fragmented and sent using more than one
    indication.
    To indicate that all the data has been sent, the last indication contains
    a 'length' of 0 and 'data' of NULL.

  MEMBERS
    common     - Common header for use with the CsrWifiFsm Module
    dataLength - Number of bytes in the buffer pointed to by 'data'
    data       - Pointer to the buffer containing 'dataLength' bytes of core
                 dump data

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint32       dataLength;
    CsrUint8       *data;
} CsrWifiSmeCoreDumpInd;

/*******************************************************************************

  NAME
    CsrWifiSmeAmpStatusChangeInd

  DESCRIPTION
    Indication of change to AMP activity.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface on which the AMP activity changed.
    ampStatus    - The new status of AMP activity.Range: {AMP_ACTIVE,
                   AMP_INACTIVE}.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent     common;
    CsrUint16           interfaceTag;
    CsrWifiSmeAmpStatus ampStatus;
} CsrWifiSmeAmpStatusChangeInd;

/*******************************************************************************

  NAME
    CsrWifiSmeInterfaceAddInd

  DESCRIPTION
    The SME sends this primitive to all tasks that have registered to receive
    it once the new interface has been created

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    address      - Current MAC address

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrUint16         interfaceTag;
    CsrWifiMacAddress address;
} CsrWifiSmeInterfaceAddInd;

/*******************************************************************************

  NAME
    CsrWifiSmeInterfaceAddCfm

  DESCRIPTION
    The SME sends this primitive to the task that has sent the request once
    the new interface has been created

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    status       - Reports the result of the request
    address      - Current MAC address

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrUint16         interfaceTag;
    CsrResult         status;
    CsrWifiMacAddress address;
} CsrWifiSmeInterfaceAddCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeInterfaceDelInd

  DESCRIPTION
    The SME sends this primitive to all tasks that have registered to receive
    it once the new interface has been removed.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
} CsrWifiSmeInterfaceDelInd;

/*******************************************************************************

  NAME
    CsrWifiSmeInterfaceDelCfm

  DESCRIPTION
    The SME sends this primitive to the task that has sent the request once
    the interface has been removed

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    status       - Reports the result of the request

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrResult       status;
} CsrWifiSmeInterfaceDelCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeSuspendInd

  DESCRIPTION
    The SME sends this primitive to all tasks that have registered to receive
    it before it goes on a Suspend status; entering this status all the
    current connections are lost and the system will stop hosting BSS/ P2P
    Groups.

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
} CsrWifiSmeSuspendInd;

/*******************************************************************************

  NAME
    CsrWifiSmeResumeInd

  DESCRIPTION
    The SME sends this primitive to all tasks that have registered to receive
    it after it goes back on a normal operation status after suspend; at this
    stage the system is ready to receive from the application to start again
    the services it wants (AP, STA connection, etc.).

  MEMBERS
    common - Common header for use with the CsrWifiFsm Module

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
} CsrWifiSmeResumeInd;


#ifdef __cplusplus
}
#endif

#endif /* CSR_WIFI_SME_PRIM_H__ */
