/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#ifndef CSR_WIFI_SME_LIB_H__
#define CSR_WIFI_SME_LIB_H__

#include "csr_synergy.h"

#include "csr_types.h"
#include "csr_pmem.h"
#include "csr_sched.h"
#include "csr_util.h"
#include "csr_msg_transport.h"

#include "csr_wifi_lib.h"

#include "csr_wifi_sme_prim.h"
#include "csr_wifi_sme_task.h"
#ifdef CSR_WIFI_NME_ENABLE
#include "csr_wifi_nme_task.h"
#endif


#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------*
 *  CsrWifiSmeFreeUpstreamMessageContents
 *
 *  DESCRIPTION
 *      Free the allocated memory in a CSR_WIFI_SME upstream message. Does not
 *      free the message itself, and can only be used for upstream messages.
 *
 *  PARAMETERS
 *      Deallocates the resources in a CSR_WIFI_SME upstream message
 *----------------------------------------------------------------------------*/
void CsrWifiSmeFreeUpstreamMessageContents(CsrUint16 eventClass, void *message);

/*----------------------------------------------------------------------------*
 *  CsrWifiSmeFreeDownstreamMessageContents
 *
 *  DESCRIPTION
 *      Free the allocated memory in a CSR_WIFI_SME downstream message. Does not
 *      free the message itself, and can only be used for downstream messages.
 *
 *  PARAMETERS
 *      Deallocates the resources in a CSR_WIFI_SME downstream message
 *----------------------------------------------------------------------------*/
void CsrWifiSmeFreeDownstreamMessageContents(CsrUint16 eventClass, void *message);

/*----------------------------------------------------------------------------*
 * Enum to string functions
 *----------------------------------------------------------------------------*/
const CsrCharString *CsrWifiSme80211PrivacyModeToString(CsrWifiSme80211PrivacyMode value);
const CsrCharString *CsrWifiSmeAmpStatusToString(CsrWifiSmeAmpStatus value);
const CsrCharString *CsrWifiSmeAuthModeToString(CsrWifiSmeAuthMode value);
const CsrCharString *CsrWifiSmeBasicUsabilityToString(CsrWifiSmeBasicUsability value);
const CsrCharString *CsrWifiSmeBssTypeToString(CsrWifiSmeBssType value);
const CsrCharString *CsrWifiSmeControlIndicationToString(CsrWifiSmeControlIndication value);
const CsrCharString *CsrWifiSmeCtsProtectionTypeToString(CsrWifiSmeCtsProtectionType value);
const CsrCharString *CsrWifiSmeEncryptionToString(CsrWifiSmeEncryption value);
const CsrCharString *CsrWifiSmeIEEE80211ReasonToString(CsrWifiSmeIEEE80211Reason value);
const CsrCharString *CsrWifiSmeIEEE80211ResultToString(CsrWifiSmeIEEE80211Result value);
const CsrCharString *CsrWifiSmeIndicationsToString(CsrWifiSmeIndications value);
const CsrCharString *CsrWifiSmeKeyTypeToString(CsrWifiSmeKeyType value);
const CsrCharString *CsrWifiSmeListActionToString(CsrWifiSmeListAction value);
const CsrCharString *CsrWifiSmeMediaStatusToString(CsrWifiSmeMediaStatus value);
const CsrCharString *CsrWifiSmeP2pCapabilityToString(CsrWifiSmeP2pCapability value);
const CsrCharString *CsrWifiSmeP2pGroupCapabilityToString(CsrWifiSmeP2pGroupCapability value);
const CsrCharString *CsrWifiSmeP2pNoaConfigMethodToString(CsrWifiSmeP2pNoaConfigMethod value);
const CsrCharString *CsrWifiSmeP2pRoleToString(CsrWifiSmeP2pRole value);
const CsrCharString *CsrWifiSmeP2pStatusToString(CsrWifiSmeP2pStatus value);
const CsrCharString *CsrWifiSmePacketFilterModeToString(CsrWifiSmePacketFilterMode value);
const CsrCharString *CsrWifiSmePreambleTypeToString(CsrWifiSmePreambleType value);
const CsrCharString *CsrWifiSmeRoamReasonToString(CsrWifiSmeRoamReason value);
const CsrCharString *CsrWifiSmeTspecCtrlToString(CsrWifiSmeTspecCtrl value);
const CsrCharString *CsrWifiSmeTspecResultCodeToString(CsrWifiSmeTspecResultCode value);
const CsrCharString *CsrWifiSmeWepAuthModeToString(CsrWifiSmeWepAuthMode value);
const CsrCharString *CsrWifiSmeWepCredentialTypeToString(CsrWifiSmeWepCredentialType value);
const CsrCharString *CsrWifiSmeWmmModeToString(CsrWifiSmeWmmMode value);
const CsrCharString *CsrWifiSmeWmmQosInfoToString(CsrWifiSmeWmmQosInfo value);
const CsrCharString *CsrWifiSmeWpsConfigTypeToString(CsrWifiSmeWpsConfigType value);
const CsrCharString *CsrWifiSmeWpsDeviceCategoryToString(CsrWifiSmeWpsDeviceCategory value);
const CsrCharString *CsrWifiSmeWpsDeviceSubCategoryToString(CsrWifiSmeWpsDeviceSubCategory value);
const CsrCharString *CsrWifiSmeWpsDpidToString(CsrWifiSmeWpsDpid value);
const CsrCharString *CsrWifiSmeWpsRegistrationToString(CsrWifiSmeWpsRegistration value);


/*----------------------------------------------------------------------------*
 * CsrPrim Type toString function.
 * Converts a message type to the String name of the Message
 *----------------------------------------------------------------------------*/
const CsrCharString *CsrWifiSmePrimTypeToString(CsrPrim msgType);

/*----------------------------------------------------------------------------*
 * Lookup arrays for PrimType name Strings
 *----------------------------------------------------------------------------*/
extern const CsrCharString *const CsrWifiSmeUpstreamPrimNames[CSR_WIFI_SME_PRIM_UPSTREAM_COUNT];
extern const CsrCharString *const CsrWifiSmeDownstreamPrimNames[CSR_WIFI_SME_PRIM_DOWNSTREAM_COUNT];

/*----------------------------------------------------------------------------*
 * Pretty Print a Prim Stucture to a String
 *----------------------------------------------------------------------------*/
CsrSize CsrWifiSmeSnprintf(void *msg, CsrCharString *str, CsrSize strLength);

/*******************************************************************************

  NAME
    CsrWifiSmeActivateReqSend

  DESCRIPTION
    The WMA sends this primitive to activate the SME.
    The WMA must activate the SME before it can send any other primitive.

  PARAMETERS
    queue  - Message Source Task Queue (Cfm's will be sent to this Queue)

*******************************************************************************/
#define CsrWifiSmeActivateReqCreate(msg__, dst__, src__) \
    msg__ = (CsrWifiSmeActivateReq *) CsrPmemAlloc(sizeof(CsrWifiSmeActivateReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_ACTIVATE_REQ, dst__, src__);

#define CsrWifiSmeActivateReqSendTo(dst__, src__) \
    { \
        CsrWifiSmeActivateReq *msg__; \
        CsrWifiSmeActivateReqCreate(msg__, dst__, src__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeActivateReqSend(src__) \
    CsrWifiSmeActivateReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__)
#else
#define CsrWifiSmeActivateReqSend(src__) \
    CsrWifiSmeActivateReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeActivateCfmSend

  DESCRIPTION
    The SME sends this primitive when the activation is complete.

  PARAMETERS
    queue  - Destination Task Queue
    status - Reports the result of the request

*******************************************************************************/
#define CsrWifiSmeActivateCfmCreate(msg__, dst__, src__, status__) \
    msg__ = (CsrWifiSmeActivateCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeActivateCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_ACTIVATE_CFM, dst__, src__); \
    msg__->status = (status__);

#define CsrWifiSmeActivateCfmSendTo(dst__, src__, status__) \
    { \
        CsrWifiSmeActivateCfm *msg__; \
        CsrWifiSmeActivateCfmCreate(msg__, dst__, src__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeActivateCfmSend(dst__, status__) \
    CsrWifiSmeActivateCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeAmpStatusChangeIndSend

  DESCRIPTION
    Indication of change to AMP activity.

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface on which the AMP activity changed.
    ampStatus    - The new status of AMP activity.Range: {AMP_ACTIVE,
                   AMP_INACTIVE}.

*******************************************************************************/
#define CsrWifiSmeAmpStatusChangeIndCreate(msg__, dst__, src__, interfaceTag__, ampStatus__) \
    msg__ = (CsrWifiSmeAmpStatusChangeInd *) CsrPmemAlloc(sizeof(CsrWifiSmeAmpStatusChangeInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_AMP_STATUS_CHANGE_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->ampStatus = (ampStatus__);

#define CsrWifiSmeAmpStatusChangeIndSendTo(dst__, src__, interfaceTag__, ampStatus__) \
    { \
        CsrWifiSmeAmpStatusChangeInd *msg__; \
        CsrWifiSmeAmpStatusChangeIndCreate(msg__, dst__, src__, interfaceTag__, ampStatus__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeAmpStatusChangeIndSend(dst__, interfaceTag__, ampStatus__) \
    CsrWifiSmeAmpStatusChangeIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, ampStatus__)

/*******************************************************************************

  NAME
    CsrWifiSmeAssociationCompleteIndSend

  DESCRIPTION
    The SME will send this primitive to all the tasks that have registered to
    receive it whenever it completes an attempt to associate with an AP. If
    the association was successful, status will be set to CSR_RESULT_SUCCESS,
    otherwise status and deauthReason shall be set to appropriate error
    codes.

  PARAMETERS
    queue          - Destination Task Queue
    interfaceTag   - Interface Identifier; unique identifier of an interface
    status         - Reports the result of the association procedure
    connectionInfo - This parameter is relevant only if result is
                     CSR_RESULT_SUCCESS:
                     it points to the connection information for the new network
    deauthReason   - This parameter is relevant only if result is not
                     CSR_RESULT_SUCCESS:
                     if the AP deauthorised the station, it gives the reason of
                     the deauthorization

*******************************************************************************/
#define CsrWifiSmeAssociationCompleteIndCreate(msg__, dst__, src__, interfaceTag__, status__, connectionInfo__, deauthReason__) \
    msg__ = (CsrWifiSmeAssociationCompleteInd *) CsrPmemAlloc(sizeof(CsrWifiSmeAssociationCompleteInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_ASSOCIATION_COMPLETE_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__); \
    msg__->connectionInfo = (connectionInfo__); \
    msg__->deauthReason = (deauthReason__);

#define CsrWifiSmeAssociationCompleteIndSendTo(dst__, src__, interfaceTag__, status__, connectionInfo__, deauthReason__) \
    { \
        CsrWifiSmeAssociationCompleteInd *msg__; \
        CsrWifiSmeAssociationCompleteIndCreate(msg__, dst__, src__, interfaceTag__, status__, connectionInfo__, deauthReason__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeAssociationCompleteIndSend(dst__, interfaceTag__, status__, connectionInfo__, deauthReason__) \
    CsrWifiSmeAssociationCompleteIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__, connectionInfo__, deauthReason__)

/*******************************************************************************

  NAME
    CsrWifiSmeAssociationStartIndSend

  DESCRIPTION
    The SME will send this primitive to all the tasks that have registered to
    receive it whenever it begins an attempt to associate with an AP.

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface Identifier; unique identifier of an interface
    address      - BSSID of the associating network
    ssid         - Service Set identifier of the associating network

*******************************************************************************/
#define CsrWifiSmeAssociationStartIndCreate(msg__, dst__, src__, interfaceTag__, address__, ssid__) \
    msg__ = (CsrWifiSmeAssociationStartInd *) CsrPmemAlloc(sizeof(CsrWifiSmeAssociationStartInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_ASSOCIATION_START_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->address = (address__); \
    msg__->ssid = (ssid__);

#define CsrWifiSmeAssociationStartIndSendTo(dst__, src__, interfaceTag__, address__, ssid__) \
    { \
        CsrWifiSmeAssociationStartInd *msg__; \
        CsrWifiSmeAssociationStartIndCreate(msg__, dst__, src__, interfaceTag__, address__, ssid__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeAssociationStartIndSend(dst__, interfaceTag__, address__, ssid__) \
    CsrWifiSmeAssociationStartIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, address__, ssid__)

/*******************************************************************************

  NAME
    CsrWifiSmeBlacklistReqSend

  DESCRIPTION
    The wireless manager application should call this primitive to notify the
    driver of any networks that should not be connected to. The interface
    allows the wireless manager application to query, add, remove, and flush
    the BSSIDs that the driver may not connect or roam to.
    When this primitive adds to the black list the BSSID to which the SME is
    currently connected, the SME will try to roam, if applicable, to another
    BSSID in the same ESS; if the roaming procedure fails, the SME will
    disconnect.

  PARAMETERS
    queue           - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag    - Interface Identifier; unique identifier of an interface
    action          - The value of the CsrWifiSmeListAction parameter instructs
                      the driver to modify or provide the list of blacklisted
                      networks.
    setAddressCount - Number of BSSIDs sent with this primitive
    setAddresses    - Pointer to the list of BBSIDs sent with the primitive, set
                      to NULL if none is sent.

*******************************************************************************/
#define CsrWifiSmeBlacklistReqCreate(msg__, dst__, src__, interfaceTag__, action__, setAddressCount__, setAddresses__) \
    msg__ = (CsrWifiSmeBlacklistReq *) CsrPmemAlloc(sizeof(CsrWifiSmeBlacklistReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_BLACKLIST_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->action = (action__); \
    msg__->setAddressCount = (setAddressCount__); \
    msg__->setAddresses = (setAddresses__);

#define CsrWifiSmeBlacklistReqSendTo(dst__, src__, interfaceTag__, action__, setAddressCount__, setAddresses__) \
    { \
        CsrWifiSmeBlacklistReq *msg__; \
        CsrWifiSmeBlacklistReqCreate(msg__, dst__, src__, interfaceTag__, action__, setAddressCount__, setAddresses__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeBlacklistReqSend(src__, interfaceTag__, action__, setAddressCount__, setAddresses__) \
    CsrWifiSmeBlacklistReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__, action__, setAddressCount__, setAddresses__)
#else
#define CsrWifiSmeBlacklistReqSend(src__, interfaceTag__, action__, setAddressCount__, setAddresses__) \
    CsrWifiSmeBlacklistReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__, action__, setAddressCount__, setAddresses__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeBlacklistCfmSend

  DESCRIPTION
    The SME will call this primitive when the action on the blacklist has
    completed. For a GET action, this primitive also reports the list of
    BBSIDs in the blacklist.

  PARAMETERS
    queue           - Destination Task Queue
    interfaceTag    - Interface Identifier; unique identifier of an interface
    status          - Reports the result of the request
    action          - Action in the request
    getAddressCount - This parameter is only relevant if action is
                      CSR_WIFI_SME_LIST_ACTION_GET:
                      number of BSSIDs sent with this primitive
    getAddresses    - Pointer to the list of BBSIDs sent with the primitive, set
                      to NULL if none is sent.

*******************************************************************************/
#define CsrWifiSmeBlacklistCfmCreate(msg__, dst__, src__, interfaceTag__, status__, action__, getAddressCount__, getAddresses__) \
    msg__ = (CsrWifiSmeBlacklistCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeBlacklistCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_BLACKLIST_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__); \
    msg__->action = (action__); \
    msg__->getAddressCount = (getAddressCount__); \
    msg__->getAddresses = (getAddresses__);

#define CsrWifiSmeBlacklistCfmSendTo(dst__, src__, interfaceTag__, status__, action__, getAddressCount__, getAddresses__) \
    { \
        CsrWifiSmeBlacklistCfm *msg__; \
        CsrWifiSmeBlacklistCfmCreate(msg__, dst__, src__, interfaceTag__, status__, action__, getAddressCount__, getAddresses__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeBlacklistCfmSend(dst__, interfaceTag__, status__, action__, getAddressCount__, getAddresses__) \
    CsrWifiSmeBlacklistCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__, action__, getAddressCount__, getAddresses__)

/*******************************************************************************

  NAME
    CsrWifiSmeCalibrationDataGetReqSend

  DESCRIPTION
    This primitive retrieves the Wi-Fi radio calibration data.

  PARAMETERS
    queue  - Message Source Task Queue (Cfm's will be sent to this Queue)

*******************************************************************************/
#define CsrWifiSmeCalibrationDataGetReqCreate(msg__, dst__, src__) \
    msg__ = (CsrWifiSmeCalibrationDataGetReq *) CsrPmemAlloc(sizeof(CsrWifiSmeCalibrationDataGetReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_CALIBRATION_DATA_GET_REQ, dst__, src__);

#define CsrWifiSmeCalibrationDataGetReqSendTo(dst__, src__) \
    { \
        CsrWifiSmeCalibrationDataGetReq *msg__; \
        CsrWifiSmeCalibrationDataGetReqCreate(msg__, dst__, src__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeCalibrationDataGetReqSend(src__) \
    CsrWifiSmeCalibrationDataGetReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__)
#else
#define CsrWifiSmeCalibrationDataGetReqSend(src__) \
    CsrWifiSmeCalibrationDataGetReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeCalibrationDataGetCfmSend

  DESCRIPTION
    This primitive reports the result of the request.

  PARAMETERS
    queue                 - Destination Task Queue
    status                - Reports the result of the request
    calibrationDataLength - Number of bytes in the buffer pointed by
                            calibrationData
    calibrationData       - Pointer to a buffer of length calibrationDataLength
                            containing the calibration data

*******************************************************************************/
#define CsrWifiSmeCalibrationDataGetCfmCreate(msg__, dst__, src__, status__, calibrationDataLength__, calibrationData__) \
    msg__ = (CsrWifiSmeCalibrationDataGetCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeCalibrationDataGetCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_CALIBRATION_DATA_GET_CFM, dst__, src__); \
    msg__->status = (status__); \
    msg__->calibrationDataLength = (calibrationDataLength__); \
    msg__->calibrationData = (calibrationData__);

#define CsrWifiSmeCalibrationDataGetCfmSendTo(dst__, src__, status__, calibrationDataLength__, calibrationData__) \
    { \
        CsrWifiSmeCalibrationDataGetCfm *msg__; \
        CsrWifiSmeCalibrationDataGetCfmCreate(msg__, dst__, src__, status__, calibrationDataLength__, calibrationData__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeCalibrationDataGetCfmSend(dst__, status__, calibrationDataLength__, calibrationData__) \
    CsrWifiSmeCalibrationDataGetCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, status__, calibrationDataLength__, calibrationData__)

/*******************************************************************************

  NAME
    CsrWifiSmeCloakedSsidsGetReqSend

  DESCRIPTION
    This primitive gets the value of the CloakedSsids parameter.

  PARAMETERS
    queue  - Message Source Task Queue (Cfm's will be sent to this Queue)

*******************************************************************************/
#define CsrWifiSmeCloakedSsidsGetReqCreate(msg__, dst__, src__) \
    msg__ = (CsrWifiSmeCloakedSsidsGetReq *) CsrPmemAlloc(sizeof(CsrWifiSmeCloakedSsidsGetReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_CLOAKED_SSIDS_GET_REQ, dst__, src__);

#define CsrWifiSmeCloakedSsidsGetReqSendTo(dst__, src__) \
    { \
        CsrWifiSmeCloakedSsidsGetReq *msg__; \
        CsrWifiSmeCloakedSsidsGetReqCreate(msg__, dst__, src__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeCloakedSsidsGetReqSend(src__) \
    CsrWifiSmeCloakedSsidsGetReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__)
#else
#define CsrWifiSmeCloakedSsidsGetReqSend(src__) \
    CsrWifiSmeCloakedSsidsGetReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeCloakedSsidsGetCfmSend

  DESCRIPTION
    This primitive reports the result of the request.

  PARAMETERS
    queue        - Destination Task Queue
    status       - Reports the result of the request
    cloakedSsids - Reports list of cloaked SSIDs that are explicitly scanned for
                   by the driver

*******************************************************************************/
#define CsrWifiSmeCloakedSsidsGetCfmCreate(msg__, dst__, src__, status__, cloakedSsids__) \
    msg__ = (CsrWifiSmeCloakedSsidsGetCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeCloakedSsidsGetCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_CLOAKED_SSIDS_GET_CFM, dst__, src__); \
    msg__->status = (status__); \
    msg__->cloakedSsids = (cloakedSsids__);

#define CsrWifiSmeCloakedSsidsGetCfmSendTo(dst__, src__, status__, cloakedSsids__) \
    { \
        CsrWifiSmeCloakedSsidsGetCfm *msg__; \
        CsrWifiSmeCloakedSsidsGetCfmCreate(msg__, dst__, src__, status__, cloakedSsids__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeCloakedSsidsGetCfmSend(dst__, status__, cloakedSsids__) \
    CsrWifiSmeCloakedSsidsGetCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, status__, cloakedSsids__)

/*******************************************************************************

  NAME
    CsrWifiSmeCloakedSsidsSetReqSend

  DESCRIPTION
    This primitive sets the list of cloaked SSIDs for which the WMA possesses
    profiles.
    When the driver detects a cloaked AP, the SME will explicitly scan for it
    using the list of cloaked SSIDs provided it, and, if the scan succeeds,
    it will report the AP to the WMA either via CSR_WIFI_SME_SCAN_RESULT_IND
    (if registered) or via CSR_WIFI_SCAN_RESULT_GET_CFM.

  PARAMETERS
    queue        - Message Source Task Queue (Cfm's will be sent to this Queue)
    cloakedSsids - Sets the list of cloaked SSIDs

*******************************************************************************/
#define CsrWifiSmeCloakedSsidsSetReqCreate(msg__, dst__, src__, cloakedSsids__) \
    msg__ = (CsrWifiSmeCloakedSsidsSetReq *) CsrPmemAlloc(sizeof(CsrWifiSmeCloakedSsidsSetReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_CLOAKED_SSIDS_SET_REQ, dst__, src__); \
    msg__->cloakedSsids = (cloakedSsids__);

#define CsrWifiSmeCloakedSsidsSetReqSendTo(dst__, src__, cloakedSsids__) \
    { \
        CsrWifiSmeCloakedSsidsSetReq *msg__; \
        CsrWifiSmeCloakedSsidsSetReqCreate(msg__, dst__, src__, cloakedSsids__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeCloakedSsidsSetReqSend(src__, cloakedSsids__) \
    CsrWifiSmeCloakedSsidsSetReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, cloakedSsids__)
#else
#define CsrWifiSmeCloakedSsidsSetReqSend(src__, cloakedSsids__) \
    CsrWifiSmeCloakedSsidsSetReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, cloakedSsids__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeCloakedSsidsSetCfmSend

  DESCRIPTION
    This primitive reports the result of the request.

  PARAMETERS
    queue  - Destination Task Queue
    status - Reports the result of the request

*******************************************************************************/
#define CsrWifiSmeCloakedSsidsSetCfmCreate(msg__, dst__, src__, status__) \
    msg__ = (CsrWifiSmeCloakedSsidsSetCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeCloakedSsidsSetCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_CLOAKED_SSIDS_SET_CFM, dst__, src__); \
    msg__->status = (status__);

#define CsrWifiSmeCloakedSsidsSetCfmSendTo(dst__, src__, status__) \
    { \
        CsrWifiSmeCloakedSsidsSetCfm *msg__; \
        CsrWifiSmeCloakedSsidsSetCfmCreate(msg__, dst__, src__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeCloakedSsidsSetCfmSend(dst__, status__) \
    CsrWifiSmeCloakedSsidsSetCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeConnectReqSend

  DESCRIPTION
    The wireless manager application calls this primitive to start the
    process of joining an 802.11 wireless network or to start an ad hoc
    network.
    The structure pointed by connectionConfig contains parameters describing
    the network to join or, in case of an ad hoc network, to host or join.
    The SME will select a network, perform the IEEE 802.11 Join, Authenticate
    and Associate exchanges.
    The SME selects the networks from the current scan list that match both
    the SSID and BSSID, however either or both of these may be the wildcard
    value. Using this rule, the following operations are possible:
      * To connect to a network by name, specify the SSID and set the BSSID to
        0xFF 0xFF 0xFF 0xFF 0xFF 0xFF. If there are two or more networks visible,
        the SME will select the one with the strongest signal.
      * To connect to a specific network, specify the BSSID. The SSID is
        optional, but if given it must match the SSID of the network. An empty
        SSID may be specified by setting the SSID length to zero. Please note
        that if the BSSID is specified (i.e. not equal to 0xFF 0xFF 0xFF 0xFF
        0xFF 0xFF), the SME will not attempt to roam if signal conditions become
        poor, even if there is an alternative AP with an SSID that matches the
        current network SSID.
      * To connect to any network matching the other parameters (i.e. security,
        etc), set the SSID length to zero and set the BSSID to 0xFF 0xFF 0xFF
        0xFF 0xFF 0xFF. In this case, the SME will order all available networks
        by their signal strengths and will iterate through this list until it
        successfully connects.
    NOTE: Specifying the BSSID will restrict the selection to one specific
    network. If SSID and BSSID are given, they must both match the network
    for it to be selected. To select a network based on the SSID only, the
    wireless manager application must set the BSSID to 0xFF 0xFF 0xFF 0xFF
    0xFF 0xFF.
    The SME will try to connect to each network that matches the provided
    parameters, one by one, until it succeeds or has tried unsuccessfully
    with all the matching networks.
    If there is no network that matches the parameters and the request allows
    to host an ad hoc network, the SME will advertise a new ad hoc network
    instead.
    If the SME cannot connect, it will notify the failure in the confirm.

  PARAMETERS
    queue            - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag     - Interface Identifier; unique identifier of an interface
    connectionConfig - Describes the candidate network to join or to host.

*******************************************************************************/
#define CsrWifiSmeConnectReqCreate(msg__, dst__, src__, interfaceTag__, connectionConfig__) \
    msg__ = (CsrWifiSmeConnectReq *) CsrPmemAlloc(sizeof(CsrWifiSmeConnectReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_CONNECT_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->connectionConfig = (connectionConfig__);

#define CsrWifiSmeConnectReqSendTo(dst__, src__, interfaceTag__, connectionConfig__) \
    { \
        CsrWifiSmeConnectReq *msg__; \
        CsrWifiSmeConnectReqCreate(msg__, dst__, src__, interfaceTag__, connectionConfig__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeConnectReqSend(src__, interfaceTag__, connectionConfig__) \
    CsrWifiSmeConnectReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__, connectionConfig__)
#else
#define CsrWifiSmeConnectReqSend(src__, interfaceTag__, connectionConfig__) \
    CsrWifiSmeConnectReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__, connectionConfig__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeConnectCfmSend

  DESCRIPTION
    The SME calls this primitive when the connection exchange is complete or
    all connection attempts fail.

  PARAMETERS
    queue             - Destination Task Queue
    interfaceTag      - Interface Identifier; unique identifier of an interface
    status            - Reports the result of the request.
                        CSR_RESULT_NOT_FOUND: all attempts by the SME to locate
                        the requested AP failed
    errorValuesLength - Length of errorValues
    errorValues       - Encoded Psids, Indexes and Status Code

*******************************************************************************/
#define CsrWifiSmeConnectCfmCreate(msg__, dst__, src__, interfaceTag__, status__, errorValuesLength__, errorValues__) \
    msg__ = (CsrWifiSmeConnectCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeConnectCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_CONNECT_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__); \
    msg__->errorValuesLength = (errorValuesLength__); \
    msg__->errorValues = (errorValues__);

#define CsrWifiSmeConnectCfmSendTo(dst__, src__, interfaceTag__, status__, errorValuesLength__, errorValues__) \
    { \
        CsrWifiSmeConnectCfm *msg__; \
        CsrWifiSmeConnectCfmCreate(msg__, dst__, src__, interfaceTag__, status__, errorValuesLength__, errorValues__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeConnectCfmSend(dst__, interfaceTag__, status__, errorValuesLength__, errorValues__) \
    CsrWifiSmeConnectCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__, errorValuesLength__, errorValues__)

/*******************************************************************************

  NAME
    CsrWifiSmeConnectionQualityIndSend

  DESCRIPTION
    The SME sends this primitive to all the tasks that have registered to
    receive it whenever the value of the current connection quality
    parameters change by more than a certain configurable amount.
    The wireless manager application may configure the trigger thresholds for
    this indication using the field in smeConfig parameter of
    CSR_WIFI_SME_SME_CONFIG_SET_REQ.
    Connection quality messages can be suppressed by setting both thresholds
    to zero.

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface Identifier; unique identifier of an interface
    linkQuality  - Indicates the quality of the link

*******************************************************************************/
#define CsrWifiSmeConnectionQualityIndCreate(msg__, dst__, src__, interfaceTag__, linkQuality__) \
    msg__ = (CsrWifiSmeConnectionQualityInd *) CsrPmemAlloc(sizeof(CsrWifiSmeConnectionQualityInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_CONNECTION_QUALITY_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->linkQuality = (linkQuality__);

#define CsrWifiSmeConnectionQualityIndSendTo(dst__, src__, interfaceTag__, linkQuality__) \
    { \
        CsrWifiSmeConnectionQualityInd *msg__; \
        CsrWifiSmeConnectionQualityIndCreate(msg__, dst__, src__, interfaceTag__, linkQuality__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeConnectionQualityIndSend(dst__, interfaceTag__, linkQuality__) \
    CsrWifiSmeConnectionQualityIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, linkQuality__)

/*******************************************************************************

  NAME
    CsrWifiSmeCoreDumpIndSend

  DESCRIPTION
    The SME will send this primitive to all the tasks that have registered to
    receive Wi-Fi Chip core dump data.
    The core dump data may be fragmented and sent using more than one
    indication.
    To indicate that all the data has been sent, the last indication contains
    a 'length' of 0 and 'data' of NULL.

  PARAMETERS
    queue      - Destination Task Queue
    dataLength - Number of bytes in the buffer pointed to by 'data'
    data       - Pointer to the buffer containing 'dataLength' bytes of core
                 dump data

*******************************************************************************/
#define CsrWifiSmeCoreDumpIndCreate(msg__, dst__, src__, dataLength__, data__) \
    msg__ = (CsrWifiSmeCoreDumpInd *) CsrPmemAlloc(sizeof(CsrWifiSmeCoreDumpInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_CORE_DUMP_IND, dst__, src__); \
    msg__->dataLength = (dataLength__); \
    msg__->data = (data__);

#define CsrWifiSmeCoreDumpIndSendTo(dst__, src__, dataLength__, data__) \
    { \
        CsrWifiSmeCoreDumpInd *msg__; \
        CsrWifiSmeCoreDumpIndCreate(msg__, dst__, src__, dataLength__, data__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeCoreDumpIndSend(dst__, dataLength__, data__) \
    CsrWifiSmeCoreDumpIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, dataLength__, data__)

/*******************************************************************************

  NAME
    CsrWifiSmeDeactivateReqSend

  DESCRIPTION
    The WMA sends this primitive to deactivate the SME.

  PARAMETERS
    queue  - Message Source Task Queue (Cfm's will be sent to this Queue)

*******************************************************************************/
#define CsrWifiSmeDeactivateReqCreate(msg__, dst__, src__) \
    msg__ = (CsrWifiSmeDeactivateReq *) CsrPmemAlloc(sizeof(CsrWifiSmeDeactivateReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_DEACTIVATE_REQ, dst__, src__);

#define CsrWifiSmeDeactivateReqSendTo(dst__, src__) \
    { \
        CsrWifiSmeDeactivateReq *msg__; \
        CsrWifiSmeDeactivateReqCreate(msg__, dst__, src__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeDeactivateReqSend(src__) \
    CsrWifiSmeDeactivateReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__)
#else
#define CsrWifiSmeDeactivateReqSend(src__) \
    CsrWifiSmeDeactivateReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeDeactivateCfmSend

  DESCRIPTION
    The SME sends this primitive when the deactivation is complete.
    The WMA cannot send any more primitives until it actives the SME again
    sending another CSR_WIFI_SME_ACTIVATE_REQ.

  PARAMETERS
    queue  - Destination Task Queue
    status - Reports the result of the request

*******************************************************************************/
#define CsrWifiSmeDeactivateCfmCreate(msg__, dst__, src__, status__) \
    msg__ = (CsrWifiSmeDeactivateCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeDeactivateCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_DEACTIVATE_CFM, dst__, src__); \
    msg__->status = (status__);

#define CsrWifiSmeDeactivateCfmSendTo(dst__, src__, status__) \
    { \
        CsrWifiSmeDeactivateCfm *msg__; \
        CsrWifiSmeDeactivateCfmCreate(msg__, dst__, src__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeDeactivateCfmSend(dst__, status__) \
    CsrWifiSmeDeactivateCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeDisconnectReqSend

  DESCRIPTION
    The wireless manager application may disconnect from the current network
    by calling this primitive

  PARAMETERS
    queue        - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag - Interface Identifier; unique identifier of an interface

*******************************************************************************/
#define CsrWifiSmeDisconnectReqCreate(msg__, dst__, src__, interfaceTag__) \
    msg__ = (CsrWifiSmeDisconnectReq *) CsrPmemAlloc(sizeof(CsrWifiSmeDisconnectReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_DISCONNECT_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__);

#define CsrWifiSmeDisconnectReqSendTo(dst__, src__, interfaceTag__) \
    { \
        CsrWifiSmeDisconnectReq *msg__; \
        CsrWifiSmeDisconnectReqCreate(msg__, dst__, src__, interfaceTag__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeDisconnectReqSend(src__, interfaceTag__) \
    CsrWifiSmeDisconnectReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__)
#else
#define CsrWifiSmeDisconnectReqSend(src__, interfaceTag__) \
    CsrWifiSmeDisconnectReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeDisconnectCfmSend

  DESCRIPTION
    On reception of CSR_WIFI_SME_DISCONNECT_REQ the SME will perform a
    disconnect operation, sending a CsrWifiSmeMediaStatusInd with
    CSR_WIFI_SME_MEDIA_STATUS_DISCONNECTED and then call this primitive when
    disconnection is complete.

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface Identifier; unique identifier of an interface
    status       - Reports the result of the request

*******************************************************************************/
#define CsrWifiSmeDisconnectCfmCreate(msg__, dst__, src__, interfaceTag__, status__) \
    msg__ = (CsrWifiSmeDisconnectCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeDisconnectCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_DISCONNECT_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__);

#define CsrWifiSmeDisconnectCfmSendTo(dst__, src__, interfaceTag__, status__) \
    { \
        CsrWifiSmeDisconnectCfm *msg__; \
        CsrWifiSmeDisconnectCfmCreate(msg__, dst__, src__, interfaceTag__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeDisconnectCfmSend(dst__, interfaceTag__, status__) \
    CsrWifiSmeDisconnectCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeEventMaskSetReqSend

  DESCRIPTION
    The wireless manager application may register with the SME to receive
    notification of interesting events. Indications will be sent only if the
    wireless manager explicitly registers to be notified of that event.
    indMask is a bit mask of values defined in CsrWifiSmeIndicationsMask.

  PARAMETERS
    queue   - Message Source Task Queue (Cfm's will be sent to this Queue)
    indMask - Set mask with values from CsrWifiSmeIndications

*******************************************************************************/
#define CsrWifiSmeEventMaskSetReqCreate(msg__, dst__, src__, indMask__) \
    msg__ = (CsrWifiSmeEventMaskSetReq *) CsrPmemAlloc(sizeof(CsrWifiSmeEventMaskSetReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_EVENT_MASK_SET_REQ, dst__, src__); \
    msg__->indMask = (indMask__);

#define CsrWifiSmeEventMaskSetReqSendTo(dst__, src__, indMask__) \
    { \
        CsrWifiSmeEventMaskSetReq *msg__; \
        CsrWifiSmeEventMaskSetReqCreate(msg__, dst__, src__, indMask__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeEventMaskSetReqSend(src__, indMask__) \
    CsrWifiSmeEventMaskSetReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, indMask__)
#else
#define CsrWifiSmeEventMaskSetReqSend(src__, indMask__) \
    CsrWifiSmeEventMaskSetReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, indMask__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeEventMaskSetCfmSend

  DESCRIPTION
    The SME calls the primitive to report the result of the request
    primitive.

  PARAMETERS
    queue  - Destination Task Queue
    status - Reports the result of the request

*******************************************************************************/
#define CsrWifiSmeEventMaskSetCfmCreate(msg__, dst__, src__, status__) \
    msg__ = (CsrWifiSmeEventMaskSetCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeEventMaskSetCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_EVENT_MASK_SET_CFM, dst__, src__); \
    msg__->status = (status__);

#define CsrWifiSmeEventMaskSetCfmSendTo(dst__, src__, status__) \
    { \
        CsrWifiSmeEventMaskSetCfm *msg__; \
        CsrWifiSmeEventMaskSetCfmCreate(msg__, dst__, src__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeEventMaskSetCfmSend(dst__, status__) \
    CsrWifiSmeEventMaskSetCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeGetReqSend

  DESCRIPTION
    The wireless manager application calls this primitive to retrieve one or
    more MIB variables.

  PARAMETERS
    queue        - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag - Interface Identifier; unique identifier of an interface Use
                   0xFFFF to read the values from the interface mib defaults
    valuesLength - Length of values
    values       - Encoded Psids and Indexes

*******************************************************************************/
#define CsrWifiSmeGetReqCreate(msg__, dst__, src__, interfaceTag__, valuesLength__, values__) \
    msg__ = (CsrWifiSmeGetReq *) CsrPmemAlloc(sizeof(CsrWifiSmeGetReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_GET_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->valuesLength = (valuesLength__); \
    msg__->values = (values__);

#define CsrWifiSmeGetReqSendTo(dst__, src__, interfaceTag__, valuesLength__, values__) \
    { \
        CsrWifiSmeGetReq *msg__; \
        CsrWifiSmeGetReqCreate(msg__, dst__, src__, interfaceTag__, valuesLength__, values__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeGetReqSend(src__, interfaceTag__, valuesLength__, values__) \
    CsrWifiSmeGetReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__, valuesLength__, values__)
#else
#define CsrWifiSmeGetReqSend(src__, interfaceTag__, valuesLength__, values__) \
    CsrWifiSmeGetReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__, valuesLength__, values__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeGetCfmSend

  DESCRIPTION
    The SME calls this primitive to return the requested MIB variable values.

  PARAMETERS
    queue             - Destination Task Queue
    interfaceTag      - Interface Identifier; unique identifier of an interface
    valuesLength      - Length of values
    values            - Encoded Psids, Indexes and Data
    errorValuesLength - Length of errorValues
    errorValues       - Encoded Psids, Indexes and Status Code

*******************************************************************************/
#define CsrWifiSmeGetCfmCreate(msg__, dst__, src__, interfaceTag__, valuesLength__, values__, errorValuesLength__, errorValues__) \
    msg__ = (CsrWifiSmeGetCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeGetCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_GET_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->valuesLength = (valuesLength__); \
    msg__->values = (values__); \
    msg__->errorValuesLength = (errorValuesLength__); \
    msg__->errorValues = (errorValues__);

#define CsrWifiSmeGetCfmSendTo(dst__, src__, interfaceTag__, valuesLength__, values__, errorValuesLength__, errorValues__) \
    { \
        CsrWifiSmeGetCfm *msg__; \
        CsrWifiSmeGetCfmCreate(msg__, dst__, src__, interfaceTag__, valuesLength__, values__, errorValuesLength__, errorValues__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeGetCfmSend(dst__, interfaceTag__, valuesLength__, values__, errorValuesLength__, errorValues__) \
    CsrWifiSmeGetCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, valuesLength__, values__, errorValuesLength__, errorValues__)

/*******************************************************************************

  NAME
    CsrWifiSmeIbssStationIndSend

  DESCRIPTION
    The SME will send this primitive to indicate that a station has joined or
    left the ad-hoc network.

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface Identifier; unique identifier of an interface
    address      - MAC address of the station that has joined or left
    isconnected  - TRUE if the station joined, FALSE if the station left

*******************************************************************************/
#define CsrWifiSmeIbssStationIndCreate(msg__, dst__, src__, interfaceTag__, address__, isconnected__) \
    msg__ = (CsrWifiSmeIbssStationInd *) CsrPmemAlloc(sizeof(CsrWifiSmeIbssStationInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_IBSS_STATION_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->address = (address__); \
    msg__->isconnected = (isconnected__);

#define CsrWifiSmeIbssStationIndSendTo(dst__, src__, interfaceTag__, address__, isconnected__) \
    { \
        CsrWifiSmeIbssStationInd *msg__; \
        CsrWifiSmeIbssStationIndCreate(msg__, dst__, src__, interfaceTag__, address__, isconnected__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeIbssStationIndSend(dst__, interfaceTag__, address__, isconnected__) \
    CsrWifiSmeIbssStationIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, address__, isconnected__)

/*******************************************************************************

  NAME
    CsrWifiSmeInterfaceAddReqSend

  DESCRIPTION
    This primitive is used to create a non-default virtual interface in the
    Wi-Fi stack.

  PARAMETERS
    queue   - Message Source Task Queue (Cfm's will be sent to this Queue)
    address - Must be a Global address or FF:FF:FF:FF:FF:FF for the Sme to
              allocate a local address.
              Note: For the current release it must be FF:FF:FF:FF:FF:FF

*******************************************************************************/
#define CsrWifiSmeInterfaceAddReqCreate(msg__, dst__, src__, address__) \
    msg__ = (CsrWifiSmeInterfaceAddReq *) CsrPmemAlloc(sizeof(CsrWifiSmeInterfaceAddReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_INTERFACE_ADD_REQ, dst__, src__); \
    msg__->address = (address__);

#define CsrWifiSmeInterfaceAddReqSendTo(dst__, src__, address__) \
    { \
        CsrWifiSmeInterfaceAddReq *msg__; \
        CsrWifiSmeInterfaceAddReqCreate(msg__, dst__, src__, address__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeInterfaceAddReqSend(src__, address__) \
    CsrWifiSmeInterfaceAddReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, address__)
#else
#define CsrWifiSmeInterfaceAddReqSend(src__, address__) \
    CsrWifiSmeInterfaceAddReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, address__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeInterfaceAddIndSend

  DESCRIPTION
    The SME sends this primitive to all tasks that have registered to receive
    it once the new interface has been created

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface Identifier; unique identifier of an interface
    address      - Current MAC address

*******************************************************************************/
#define CsrWifiSmeInterfaceAddIndCreate(msg__, dst__, src__, interfaceTag__, address__) \
    msg__ = (CsrWifiSmeInterfaceAddInd *) CsrPmemAlloc(sizeof(CsrWifiSmeInterfaceAddInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_INTERFACE_ADD_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->address = (address__);

#define CsrWifiSmeInterfaceAddIndSendTo(dst__, src__, interfaceTag__, address__) \
    { \
        CsrWifiSmeInterfaceAddInd *msg__; \
        CsrWifiSmeInterfaceAddIndCreate(msg__, dst__, src__, interfaceTag__, address__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeInterfaceAddIndSend(dst__, interfaceTag__, address__) \
    CsrWifiSmeInterfaceAddIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, address__)

/*******************************************************************************

  NAME
    CsrWifiSmeInterfaceAddCfmSend

  DESCRIPTION
    The SME sends this primitive to the task that has sent the request once
    the new interface has been created

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface Identifier; unique identifier of an interface
    status       - Reports the result of the request
    address      - Current MAC address

*******************************************************************************/
#define CsrWifiSmeInterfaceAddCfmCreate(msg__, dst__, src__, interfaceTag__, status__, address__) \
    msg__ = (CsrWifiSmeInterfaceAddCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeInterfaceAddCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_INTERFACE_ADD_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__); \
    msg__->address = (address__);

#define CsrWifiSmeInterfaceAddCfmSendTo(dst__, src__, interfaceTag__, status__, address__) \
    { \
        CsrWifiSmeInterfaceAddCfm *msg__; \
        CsrWifiSmeInterfaceAddCfmCreate(msg__, dst__, src__, interfaceTag__, status__, address__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeInterfaceAddCfmSend(dst__, interfaceTag__, status__, address__) \
    CsrWifiSmeInterfaceAddCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__, address__)

/*******************************************************************************

  NAME
    CsrWifiSmeInterfaceDelReqSend

  DESCRIPTION
    Note Cannot del the default interface ONLY a interface created by
    CsrWifiSmeInterfaceAddReq can use CsrWifiSmeInterfaceDelReq if no
    activity is going on that interface.

  PARAMETERS
    queue        - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag - Interface Identifier; unique identifier of an interface

*******************************************************************************/
#define CsrWifiSmeInterfaceDelReqCreate(msg__, dst__, src__, interfaceTag__) \
    msg__ = (CsrWifiSmeInterfaceDelReq *) CsrPmemAlloc(sizeof(CsrWifiSmeInterfaceDelReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_INTERFACE_DEL_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__);

#define CsrWifiSmeInterfaceDelReqSendTo(dst__, src__, interfaceTag__) \
    { \
        CsrWifiSmeInterfaceDelReq *msg__; \
        CsrWifiSmeInterfaceDelReqCreate(msg__, dst__, src__, interfaceTag__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeInterfaceDelReqSend(src__, interfaceTag__) \
    CsrWifiSmeInterfaceDelReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__)
#else
#define CsrWifiSmeInterfaceDelReqSend(src__, interfaceTag__) \
    CsrWifiSmeInterfaceDelReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeInterfaceDelIndSend

  DESCRIPTION
    The SME sends this primitive to all tasks that have registered to receive
    it once the new interface has been removed.

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface Identifier; unique identifier of an interface

*******************************************************************************/
#define CsrWifiSmeInterfaceDelIndCreate(msg__, dst__, src__, interfaceTag__) \
    msg__ = (CsrWifiSmeInterfaceDelInd *) CsrPmemAlloc(sizeof(CsrWifiSmeInterfaceDelInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_INTERFACE_DEL_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__);

#define CsrWifiSmeInterfaceDelIndSendTo(dst__, src__, interfaceTag__) \
    { \
        CsrWifiSmeInterfaceDelInd *msg__; \
        CsrWifiSmeInterfaceDelIndCreate(msg__, dst__, src__, interfaceTag__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeInterfaceDelIndSend(dst__, interfaceTag__) \
    CsrWifiSmeInterfaceDelIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__)

/*******************************************************************************

  NAME
    CsrWifiSmeInterfaceDelCfmSend

  DESCRIPTION
    The SME sends this primitive to the task that has sent the request once
    the interface has been removed

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface Identifier; unique identifier of an interface
    status       - Reports the result of the request

*******************************************************************************/
#define CsrWifiSmeInterfaceDelCfmCreate(msg__, dst__, src__, interfaceTag__, status__) \
    msg__ = (CsrWifiSmeInterfaceDelCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeInterfaceDelCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_INTERFACE_DEL_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__);

#define CsrWifiSmeInterfaceDelCfmSendTo(dst__, src__, interfaceTag__, status__) \
    { \
        CsrWifiSmeInterfaceDelCfm *msg__; \
        CsrWifiSmeInterfaceDelCfmCreate(msg__, dst__, src__, interfaceTag__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeInterfaceDelCfmSend(dst__, interfaceTag__, status__) \
    CsrWifiSmeInterfaceDelCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeKeyReqSend

  DESCRIPTION
    The wireless manager application calls this primitive to add or remove
    keys that the chip should use for encryption of data.
    The interface allows the wireless manager application to add and remove
    keys according to the specified action.

  PARAMETERS
    queue        - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag - Interface Identifier; unique identifier of an interface
    action       - The value of the CsrWifiSmeListAction parameter instructs the
                   driver to modify or provide the list of keys.
                   CSR_WIFI_SME_LIST_ACTION_GET is not supported here.
    key          - Key to be added or removed

*******************************************************************************/
#define CsrWifiSmeKeyReqCreate(msg__, dst__, src__, interfaceTag__, action__, key__) \
    msg__ = (CsrWifiSmeKeyReq *) CsrPmemAlloc(sizeof(CsrWifiSmeKeyReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_KEY_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->action = (action__); \
    msg__->key = (key__);

#define CsrWifiSmeKeyReqSendTo(dst__, src__, interfaceTag__, action__, key__) \
    { \
        CsrWifiSmeKeyReq *msg__; \
        CsrWifiSmeKeyReqCreate(msg__, dst__, src__, interfaceTag__, action__, key__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeKeyReqSend(src__, interfaceTag__, action__, key__) \
    CsrWifiSmeKeyReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__, action__, key__)
#else
#define CsrWifiSmeKeyReqSend(src__, interfaceTag__, action__, key__) \
    CsrWifiSmeKeyReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__, action__, key__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeKeyCfmSend

  DESCRIPTION
    The SME calls the primitive to report the result of the request
    primitive.

  PARAMETERS
    queue          - Destination Task Queue
    interfaceTag   - Interface Identifier; unique identifier of an interface
    status         - Reports the result of the request
    action         - Action in the request
    keyType        - Type of the key added/deleted
    peerMacAddress - Peer MAC Address of the key added/deleted

*******************************************************************************/
#define CsrWifiSmeKeyCfmCreate(msg__, dst__, src__, interfaceTag__, status__, action__, keyType__, peerMacAddress__) \
    msg__ = (CsrWifiSmeKeyCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeKeyCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_KEY_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__); \
    msg__->action = (action__); \
    msg__->keyType = (keyType__); \
    msg__->peerMacAddress = (peerMacAddress__);

#define CsrWifiSmeKeyCfmSendTo(dst__, src__, interfaceTag__, status__, action__, keyType__, peerMacAddress__) \
    { \
        CsrWifiSmeKeyCfm *msg__; \
        CsrWifiSmeKeyCfmCreate(msg__, dst__, src__, interfaceTag__, status__, action__, keyType__, peerMacAddress__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeKeyCfmSend(dst__, interfaceTag__, status__, action__, keyType__, peerMacAddress__) \
    CsrWifiSmeKeyCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__, action__, keyType__, peerMacAddress__)

/*******************************************************************************

  NAME
    CsrWifiSmeMediaStatusIndSend

  DESCRIPTION
    The SME sends this primitive to all the tasks that have registered to
    receive it when a network connection is established, lost or has moved to
    another AP.

  PARAMETERS
    queue          - Destination Task Queue
    interfaceTag   - Interface Identifier; unique identifier of an interface
    mediaStatus    - Indicates the media status
    connectionInfo - This parameter is relevant only if the mediaStatus is
                     CSR_WIFI_SME_MEDIA_STATUS_CONNECTED:
                     it points to the connection information for the new network
    disassocReason - This parameter is relevant only if the mediaStatus is
                     CSR_WIFI_SME_MEDIA_STATUS_DISCONNECTED:
                     if a disassociation has occurred it gives the reason of the
                     disassociation
    deauthReason   - This parameter is relevant only if the mediaStatus is
                     CSR_WIFI_SME_MEDIA_STATUS_DISCONNECTED:
                     if a deauthentication has occurred it gives the reason of
                     the deauthentication

*******************************************************************************/
#define CsrWifiSmeMediaStatusIndCreate(msg__, dst__, src__, interfaceTag__, mediaStatus__, connectionInfo__, disassocReason__, deauthReason__) \
    msg__ = (CsrWifiSmeMediaStatusInd *) CsrPmemAlloc(sizeof(CsrWifiSmeMediaStatusInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_MEDIA_STATUS_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->mediaStatus = (mediaStatus__); \
    msg__->connectionInfo = (connectionInfo__); \
    msg__->disassocReason = (disassocReason__); \
    msg__->deauthReason = (deauthReason__);

#define CsrWifiSmeMediaStatusIndSendTo(dst__, src__, interfaceTag__, mediaStatus__, connectionInfo__, disassocReason__, deauthReason__) \
    { \
        CsrWifiSmeMediaStatusInd *msg__; \
        CsrWifiSmeMediaStatusIndCreate(msg__, dst__, src__, interfaceTag__, mediaStatus__, connectionInfo__, disassocReason__, deauthReason__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeMediaStatusIndSend(dst__, interfaceTag__, mediaStatus__, connectionInfo__, disassocReason__, deauthReason__) \
    CsrWifiSmeMediaStatusIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, mediaStatus__, connectionInfo__, disassocReason__, deauthReason__)

/*******************************************************************************

  NAME
    CsrWifiSmeMicFailureIndSend

  DESCRIPTION
    The SME sends this primitive to all the tasks that have registered to
    receive it whenever the chip firmware reports a MIC failure. It is the
    responsibility of the wireless manager application generate any
    appropriate Michael MIC Failure Report and if required disconenct from
    teh AP.

  PARAMETERS
    queue         - Destination Task Queue
    interfaceTag  - Interface Identifier; unique identifier of an interface
    secondFailure - TRUE if this indication is for a second failure in 60
                    seconds
    count         - The number of MIC failure events since the connection was
                    established
    address       - MAC address of the transmitter that caused the MIC failure
    keyType       - Type of key for which the failure occurred

*******************************************************************************/
#define CsrWifiSmeMicFailureIndCreate(msg__, dst__, src__, interfaceTag__, secondFailure__, count__, address__, keyType__) \
    msg__ = (CsrWifiSmeMicFailureInd *) CsrPmemAlloc(sizeof(CsrWifiSmeMicFailureInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_MIC_FAILURE_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->secondFailure = (secondFailure__); \
    msg__->count = (count__); \
    msg__->address = (address__); \
    msg__->keyType = (keyType__);

#define CsrWifiSmeMicFailureIndSendTo(dst__, src__, interfaceTag__, secondFailure__, count__, address__, keyType__) \
    { \
        CsrWifiSmeMicFailureInd *msg__; \
        CsrWifiSmeMicFailureIndCreate(msg__, dst__, src__, interfaceTag__, secondFailure__, count__, address__, keyType__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeMicFailureIndSend(dst__, interfaceTag__, secondFailure__, count__, address__, keyType__) \
    CsrWifiSmeMicFailureIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, secondFailure__, count__, address__, keyType__)

/*******************************************************************************

  NAME
    CsrWifiSmeMulticastAddressReqSend

  DESCRIPTION
    The wireless manager application calls this primitive to specify the
    multicast addresses which the chip should recognise. The interface allows
    the wireless manager application to query, add, remove and flush the
    multicast addresses for the network interface according to the specified
    action.

  PARAMETERS
    queue             - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag      - Interface Identifier; unique identifier of an interface
    action            - The value of the CsrWifiSmeListAction parameter
                        instructs the driver to modify or provide the list of
                        MAC addresses.
    setAddressesCount - Number of MAC addresses sent with the primitive
    setAddresses      - Pointer to the list of MAC Addresses sent with the
                        primitive, set to NULL if none is sent.

*******************************************************************************/
#define CsrWifiSmeMulticastAddressReqCreate(msg__, dst__, src__, interfaceTag__, action__, setAddressesCount__, setAddresses__) \
    msg__ = (CsrWifiSmeMulticastAddressReq *) CsrPmemAlloc(sizeof(CsrWifiSmeMulticastAddressReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_MULTICAST_ADDRESS_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->action = (action__); \
    msg__->setAddressesCount = (setAddressesCount__); \
    msg__->setAddresses = (setAddresses__);

#define CsrWifiSmeMulticastAddressReqSendTo(dst__, src__, interfaceTag__, action__, setAddressesCount__, setAddresses__) \
    { \
        CsrWifiSmeMulticastAddressReq *msg__; \
        CsrWifiSmeMulticastAddressReqCreate(msg__, dst__, src__, interfaceTag__, action__, setAddressesCount__, setAddresses__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeMulticastAddressReqSend(src__, interfaceTag__, action__, setAddressesCount__, setAddresses__) \
    CsrWifiSmeMulticastAddressReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__, action__, setAddressesCount__, setAddresses__)
#else
#define CsrWifiSmeMulticastAddressReqSend(src__, interfaceTag__, action__, setAddressesCount__, setAddresses__) \
    CsrWifiSmeMulticastAddressReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__, action__, setAddressesCount__, setAddresses__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeMulticastAddressCfmSend

  DESCRIPTION
    The SME will call this primitive when the operation is complete. For a
    GET action, this primitive reports the current list of MAC addresses.

  PARAMETERS
    queue             - Destination Task Queue
    interfaceTag      - Interface Identifier; unique identifier of an interface
    status            - Reports the result of the request
    action            - Action in the request
    getAddressesCount - This parameter is only relevant if action is
                        CSR_WIFI_SME_LIST_ACTION_GET:
                        number of MAC addresses sent with the primitive
    getAddresses      - Pointer to the list of MAC Addresses sent with the
                        primitive, set to NULL if none is sent.

*******************************************************************************/
#define CsrWifiSmeMulticastAddressCfmCreate(msg__, dst__, src__, interfaceTag__, status__, action__, getAddressesCount__, getAddresses__) \
    msg__ = (CsrWifiSmeMulticastAddressCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeMulticastAddressCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_MULTICAST_ADDRESS_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__); \
    msg__->action = (action__); \
    msg__->getAddressesCount = (getAddressesCount__); \
    msg__->getAddresses = (getAddresses__);

#define CsrWifiSmeMulticastAddressCfmSendTo(dst__, src__, interfaceTag__, status__, action__, getAddressesCount__, getAddresses__) \
    { \
        CsrWifiSmeMulticastAddressCfm *msg__; \
        CsrWifiSmeMulticastAddressCfmCreate(msg__, dst__, src__, interfaceTag__, status__, action__, getAddressesCount__, getAddresses__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeMulticastAddressCfmSend(dst__, interfaceTag__, status__, action__, getAddressesCount__, getAddresses__) \
    CsrWifiSmeMulticastAddressCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__, action__, getAddressesCount__, getAddresses__)

/*******************************************************************************

  NAME
    CsrWifiSmePmkidCandidateListIndSend

  DESCRIPTION
    The SME will send this primitive to all the tasks that have registered to
    receive it when a new network supporting preauthentication and/or PMK
    caching is seen.

  PARAMETERS
    queue                - Destination Task Queue
    interfaceTag         - Interface Identifier; unique identifier of an
                           interface
    pmkidCandidatesCount - Number of PMKID candidates provided
    pmkidCandidates      - Points to the first PMKID candidate

*******************************************************************************/
#define CsrWifiSmePmkidCandidateListIndCreate(msg__, dst__, src__, interfaceTag__, pmkidCandidatesCount__, pmkidCandidates__) \
    msg__ = (CsrWifiSmePmkidCandidateListInd *) CsrPmemAlloc(sizeof(CsrWifiSmePmkidCandidateListInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_PMKID_CANDIDATE_LIST_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->pmkidCandidatesCount = (pmkidCandidatesCount__); \
    msg__->pmkidCandidates = (pmkidCandidates__);

#define CsrWifiSmePmkidCandidateListIndSendTo(dst__, src__, interfaceTag__, pmkidCandidatesCount__, pmkidCandidates__) \
    { \
        CsrWifiSmePmkidCandidateListInd *msg__; \
        CsrWifiSmePmkidCandidateListIndCreate(msg__, dst__, src__, interfaceTag__, pmkidCandidatesCount__, pmkidCandidates__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmePmkidCandidateListIndSend(dst__, interfaceTag__, pmkidCandidatesCount__, pmkidCandidates__) \
    CsrWifiSmePmkidCandidateListIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, pmkidCandidatesCount__, pmkidCandidates__)

/*******************************************************************************

  NAME
    CsrWifiSmePmkidReqSend

  DESCRIPTION
    The wireless manager application calls this primitive to request an
    operation on the SME PMKID list.
    The action argument specifies the operation to perform.
    When the connection is complete, the wireless manager application may
    then send and receive EAPOL packets to complete WPA or WPA2
    authentication if appropriate.
    The wireless manager application can then pass the resulting encryption
    keys using this primitive.

  PARAMETERS
    queue          - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag   - Interface Identifier; unique identifier of an interface
    action         - The value of the CsrWifiSmeListAction parameter instructs
                     the driver to modify or provide the list of PMKIDs.
    setPmkidsCount - Number of PMKIDs sent with the primitive
    setPmkids      - Pointer to the list of PMKIDs sent with the primitive, set
                     to NULL if none is sent.

*******************************************************************************/
#define CsrWifiSmePmkidReqCreate(msg__, dst__, src__, interfaceTag__, action__, setPmkidsCount__, setPmkids__) \
    msg__ = (CsrWifiSmePmkidReq *) CsrPmemAlloc(sizeof(CsrWifiSmePmkidReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_PMKID_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->action = (action__); \
    msg__->setPmkidsCount = (setPmkidsCount__); \
    msg__->setPmkids = (setPmkids__);

#define CsrWifiSmePmkidReqSendTo(dst__, src__, interfaceTag__, action__, setPmkidsCount__, setPmkids__) \
    { \
        CsrWifiSmePmkidReq *msg__; \
        CsrWifiSmePmkidReqCreate(msg__, dst__, src__, interfaceTag__, action__, setPmkidsCount__, setPmkids__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmePmkidReqSend(src__, interfaceTag__, action__, setPmkidsCount__, setPmkids__) \
    CsrWifiSmePmkidReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__, action__, setPmkidsCount__, setPmkids__)
#else
#define CsrWifiSmePmkidReqSend(src__, interfaceTag__, action__, setPmkidsCount__, setPmkids__) \
    CsrWifiSmePmkidReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__, action__, setPmkidsCount__, setPmkids__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmePmkidCfmSend

  DESCRIPTION
    The SME will call this primitive when the operation is complete. For a
    GET action, this primitive reports the current list of PMKIDs

  PARAMETERS
    queue          - Destination Task Queue
    interfaceTag   - Interface Identifier; unique identifier of an interface
    status         - Reports the result of the request
    action         - Action in the request
    getPmkidsCount - This parameter is only relevant if action is
                     CSR_WIFI_SME_LIST_ACTION_GET:
                     number of PMKIDs sent with the primitive
    getPmkids      - Pointer to the list of PMKIDs sent with the primitive, set
                     to NULL if none is sent.

*******************************************************************************/
#define CsrWifiSmePmkidCfmCreate(msg__, dst__, src__, interfaceTag__, status__, action__, getPmkidsCount__, getPmkids__) \
    msg__ = (CsrWifiSmePmkidCfm *) CsrPmemAlloc(sizeof(CsrWifiSmePmkidCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_PMKID_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__); \
    msg__->action = (action__); \
    msg__->getPmkidsCount = (getPmkidsCount__); \
    msg__->getPmkids = (getPmkids__);

#define CsrWifiSmePmkidCfmSendTo(dst__, src__, interfaceTag__, status__, action__, getPmkidsCount__, getPmkids__) \
    { \
        CsrWifiSmePmkidCfm *msg__; \
        CsrWifiSmePmkidCfmCreate(msg__, dst__, src__, interfaceTag__, status__, action__, getPmkidsCount__, getPmkids__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmePmkidCfmSend(dst__, interfaceTag__, status__, action__, getPmkidsCount__, getPmkids__) \
    CsrWifiSmePmkidCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__, action__, getPmkidsCount__, getPmkids__)

/*******************************************************************************

  NAME
    CsrWifiSmeResumeIndSend

  DESCRIPTION
    The SME sends this primitive to all tasks that have registered to receive
    it after it goes back on a normal operation status after suspend; at this
    stage the system is ready to receive from the application to start again
    the services it wants (AP, STA connection, etc.).

  PARAMETERS
    queue  - Destination Task Queue

*******************************************************************************/
#define CsrWifiSmeResumeIndCreate(msg__, dst__, src__) \
    msg__ = (CsrWifiSmeResumeInd *) CsrPmemAlloc(sizeof(CsrWifiSmeResumeInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_RESUME_IND, dst__, src__);

#define CsrWifiSmeResumeIndSendTo(dst__, src__) \
    { \
        CsrWifiSmeResumeInd *msg__; \
        CsrWifiSmeResumeIndCreate(msg__, dst__, src__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeResumeIndSend(dst__) \
    CsrWifiSmeResumeIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE)

/*******************************************************************************

  NAME
    CsrWifiSmeRoamCompleteIndSend

  DESCRIPTION
    The SME will send this primitive to all the tasks that have registered to
    receive it whenever it completes an attempt to roam to an AP. If the roam
    attempt was successful, status will be set to CSR_WIFI_SME_SUCCESS,
    otherwise it shall be set to the appropriate error code.

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface Identifier; unique identifier of an interface
    status       - Reports the result of the roaming procedure

*******************************************************************************/
#define CsrWifiSmeRoamCompleteIndCreate(msg__, dst__, src__, interfaceTag__, status__) \
    msg__ = (CsrWifiSmeRoamCompleteInd *) CsrPmemAlloc(sizeof(CsrWifiSmeRoamCompleteInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_ROAM_COMPLETE_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__);

#define CsrWifiSmeRoamCompleteIndSendTo(dst__, src__, interfaceTag__, status__) \
    { \
        CsrWifiSmeRoamCompleteInd *msg__; \
        CsrWifiSmeRoamCompleteIndCreate(msg__, dst__, src__, interfaceTag__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeRoamCompleteIndSend(dst__, interfaceTag__, status__) \
    CsrWifiSmeRoamCompleteIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeRoamStartIndSend

  DESCRIPTION
    The SME will send this primitive to all the tasks that have registered to
    receive it whenever it begins an attempt to roam to an AP.
    If the wireless manager application connect request specified the SSID
    and the BSSID was set to the broadcast address (0xFF 0xFF 0xFF 0xFF 0xFF
    0xFF), the SME monitors the signal quality and maintains a list of
    candidates to roam to. When the signal quality of the current connection
    falls below a threshold, and there is a candidate with better quality,
    the SME will attempt to the candidate AP.
    If the roaming procedure succeeds, the SME will also issue a Media
    Connect indication to inform the wireless manager application of the
    change.
    NOTE: to prevent the SME from initiating roaming the WMA must specify the
    BSSID in the connection request; this forces the SME to connect only to
    that AP.
    The wireless manager application can obtain statistics for roaming
    purposes using CSR_WIFI_SME_CONNECTION_QUALITY_IND and
    CSR_WIFI_SME_CONNECTION_STATS_GET_REQ.
    When the wireless manager application wishes to roam to another AP, it
    must issue a connection request specifying the BSSID of the desired AP.

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface Identifier; unique identifier of an interface
    roamReason   - Indicates the reason for starting the roaming procedure
    reason80211  - Indicates the reason for deauthentication or disassociation

*******************************************************************************/
#define CsrWifiSmeRoamStartIndCreate(msg__, dst__, src__, interfaceTag__, roamReason__, reason80211__) \
    msg__ = (CsrWifiSmeRoamStartInd *) CsrPmemAlloc(sizeof(CsrWifiSmeRoamStartInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_ROAM_START_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->roamReason = (roamReason__); \
    msg__->reason80211 = (reason80211__);

#define CsrWifiSmeRoamStartIndSendTo(dst__, src__, interfaceTag__, roamReason__, reason80211__) \
    { \
        CsrWifiSmeRoamStartInd *msg__; \
        CsrWifiSmeRoamStartIndCreate(msg__, dst__, src__, interfaceTag__, roamReason__, reason80211__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeRoamStartIndSend(dst__, interfaceTag__, roamReason__, reason80211__) \
    CsrWifiSmeRoamStartIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, roamReason__, reason80211__)

/*******************************************************************************

  NAME
    CsrWifiSmeScanFullReqSend

  DESCRIPTION
    The wireless manager application should call this primitive to request a
    full scan.
    Channels are scanned actively or passively according to the requirement
    set by regulatory domain.
    If the SME receives this primitive while a full scan is going on, the new
    request is buffered and it will be served after the current full scan is
    completed.

  PARAMETERS
    queue                - Message Source Task Queue (Cfm's will be sent to this Queue)
    ssidCount            - Number of SSIDs provided.
                           If it is 0, the SME will attempt to detect any
                           network
    ssid                 - Points to the first SSID provided, if any.
    bssid                - BSS identifier.
                           If it is equal to FF-FF-FF-FF-FF, the SME will listen
                           for messages from any BSS.
                           If it is different from FF-FF-FF-FF-FF and any SSID
                           is provided, one SSID must match the network of the
                           BSS.
    forceScan            - Forces the scan even if the SME is in a state which
                           would normally prevent it
    bssType              - Type of BSS to scan for
    channelInfoListCount - Number of channels provided.
                           If it is 0, the SME will initiate a scan of all the
                           supported channels that are permitted by the current
                           regulatory domain.
    channelInfoList      - List of ChannelInfo to scan or NULL if
                           channelListCount is zero.
    probeIeLength        - Length of the information element in bytes to be sent
                           with the probe message.
    probeIe              - Points to the first byte of the information element
                           to be sent with the probe message.

*******************************************************************************/
#define CsrWifiSmeScanFullReqCreate(msg__, dst__, src__, ssidCount__, ssid__, bssid__, forceScan__, bssType__, channelInfoListCount__, channelInfoList__, probeIeLength__, probeIe__) \
    msg__ = (CsrWifiSmeScanFullReq *) CsrPmemAlloc(sizeof(CsrWifiSmeScanFullReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_SCAN_FULL_REQ, dst__, src__); \
    msg__->ssidCount = (ssidCount__); \
    msg__->ssid = (ssid__); \
    msg__->bssid = (bssid__); \
    msg__->forceScan = (forceScan__); \
    msg__->bssType = (bssType__); \
    msg__->channelInfoListCount = (channelInfoListCount__); \
    msg__->channelInfoList = (channelInfoList__); \
    msg__->probeIeLength = (probeIeLength__); \
    msg__->probeIe = (probeIe__);

#define CsrWifiSmeScanFullReqSendTo(dst__, src__, ssidCount__, ssid__, bssid__, forceScan__, bssType__, channelInfoListCount__, channelInfoList__, probeIeLength__, probeIe__) \
    { \
        CsrWifiSmeScanFullReq *msg__; \
        CsrWifiSmeScanFullReqCreate(msg__, dst__, src__, ssidCount__, ssid__, bssid__, forceScan__, bssType__, channelInfoListCount__, channelInfoList__, probeIeLength__, probeIe__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeScanFullReqSend(src__, ssidCount__, ssid__, bssid__, forceScan__, bssType__, channelInfoListCount__, channelInfoList__, probeIeLength__, probeIe__) \
    CsrWifiSmeScanFullReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, ssidCount__, ssid__, bssid__, forceScan__, bssType__, channelInfoListCount__, channelInfoList__, probeIeLength__, probeIe__)
#else
#define CsrWifiSmeScanFullReqSend(src__, ssidCount__, ssid__, bssid__, forceScan__, bssType__, channelInfoListCount__, channelInfoList__, probeIeLength__, probeIe__) \
    CsrWifiSmeScanFullReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, ssidCount__, ssid__, bssid__, forceScan__, bssType__, channelInfoListCount__, channelInfoList__, probeIeLength__, probeIe__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeScanFullCfmSend

  DESCRIPTION
    The SME calls this primitive when the results from the scan are
    available.

  PARAMETERS
    queue  - Destination Task Queue
    status - Reports the result of the request

*******************************************************************************/
#define CsrWifiSmeScanFullCfmCreate(msg__, dst__, src__, status__) \
    msg__ = (CsrWifiSmeScanFullCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeScanFullCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_SCAN_FULL_CFM, dst__, src__); \
    msg__->status = (status__);

#define CsrWifiSmeScanFullCfmSendTo(dst__, src__, status__) \
    { \
        CsrWifiSmeScanFullCfm *msg__; \
        CsrWifiSmeScanFullCfmCreate(msg__, dst__, src__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeScanFullCfmSend(dst__, status__) \
    CsrWifiSmeScanFullCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeScanResultIndSend

  DESCRIPTION
    The SME sends this primitive to all the tasks that have registered to
    receive it whenever a scan indication is received from the firmware.

  PARAMETERS
    queue  - Destination Task Queue
    result - Points to a buffer containing a scan result.

*******************************************************************************/
#define CsrWifiSmeScanResultIndCreate(msg__, dst__, src__, result__) \
    msg__ = (CsrWifiSmeScanResultInd *) CsrPmemAlloc(sizeof(CsrWifiSmeScanResultInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_SCAN_RESULT_IND, dst__, src__); \
    msg__->result = (result__);

#define CsrWifiSmeScanResultIndSendTo(dst__, src__, result__) \
    { \
        CsrWifiSmeScanResultInd *msg__; \
        CsrWifiSmeScanResultIndCreate(msg__, dst__, src__, result__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeScanResultIndSend(dst__, result__) \
    CsrWifiSmeScanResultIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, result__)

/*******************************************************************************

  NAME
    CsrWifiSmeScanResultsFlushReqSend

  DESCRIPTION
    The Wireless Manager calls this primitive to ask the SME to delete all
    scan results from its cache, except for the scan result of any currently
    connected network.
    As scan results are received by the SME from the firmware, they are
    cached in the SME memory.
    Any time the Wireless Manager requests scan results, they are returned
    from the SME internal cache.
    For some applications it may be desirable to clear this cache prior to
    requesting that a scan be performed; this will ensure that the cache then
    only contains the networks detected in the most recent scan.

  PARAMETERS
    queue  - Message Source Task Queue (Cfm's will be sent to this Queue)

*******************************************************************************/
#define CsrWifiSmeScanResultsFlushReqCreate(msg__, dst__, src__) \
    msg__ = (CsrWifiSmeScanResultsFlushReq *) CsrPmemAlloc(sizeof(CsrWifiSmeScanResultsFlushReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_SCAN_RESULTS_FLUSH_REQ, dst__, src__);

#define CsrWifiSmeScanResultsFlushReqSendTo(dst__, src__) \
    { \
        CsrWifiSmeScanResultsFlushReq *msg__; \
        CsrWifiSmeScanResultsFlushReqCreate(msg__, dst__, src__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeScanResultsFlushReqSend(src__) \
    CsrWifiSmeScanResultsFlushReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__)
#else
#define CsrWifiSmeScanResultsFlushReqSend(src__) \
    CsrWifiSmeScanResultsFlushReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeScanResultsFlushCfmSend

  DESCRIPTION
    The SME will call this primitive when the cache has been cleared.

  PARAMETERS
    queue  - Destination Task Queue
    status - Reports the result of the request

*******************************************************************************/
#define CsrWifiSmeScanResultsFlushCfmCreate(msg__, dst__, src__, status__) \
    msg__ = (CsrWifiSmeScanResultsFlushCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeScanResultsFlushCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_SCAN_RESULTS_FLUSH_CFM, dst__, src__); \
    msg__->status = (status__);

#define CsrWifiSmeScanResultsFlushCfmSendTo(dst__, src__, status__) \
    { \
        CsrWifiSmeScanResultsFlushCfm *msg__; \
        CsrWifiSmeScanResultsFlushCfmCreate(msg__, dst__, src__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeScanResultsFlushCfmSend(dst__, status__) \
    CsrWifiSmeScanResultsFlushCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeScanResultsGetReqSend

  DESCRIPTION
    The wireless manager application calls this primitive to retrieve the
    current set of scan results, either after receiving a successful
    CSR_WIFI_SME_SCAN_FULL_CFM, or to get autonomous scan results.

  PARAMETERS
    queue  - Message Source Task Queue (Cfm's will be sent to this Queue)

*******************************************************************************/
#define CsrWifiSmeScanResultsGetReqCreate(msg__, dst__, src__) \
    msg__ = (CsrWifiSmeScanResultsGetReq *) CsrPmemAlloc(sizeof(CsrWifiSmeScanResultsGetReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_SCAN_RESULTS_GET_REQ, dst__, src__);

#define CsrWifiSmeScanResultsGetReqSendTo(dst__, src__) \
    { \
        CsrWifiSmeScanResultsGetReq *msg__; \
        CsrWifiSmeScanResultsGetReqCreate(msg__, dst__, src__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeScanResultsGetReqSend(src__) \
    CsrWifiSmeScanResultsGetReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__)
#else
#define CsrWifiSmeScanResultsGetReqSend(src__) \
    CsrWifiSmeScanResultsGetReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeScanResultsGetCfmSend

  DESCRIPTION
    The SME sends this primitive to provide the current set of scan results.

  PARAMETERS
    queue            - Destination Task Queue
    status           - Reports the result of the request
    scanResultsCount - Number of scan results
    scanResults      - Points to a buffer containing an array of
                       CsrWifiSmeScanResult structures.

*******************************************************************************/
#define CsrWifiSmeScanResultsGetCfmCreate(msg__, dst__, src__, status__, scanResultsCount__, scanResults__) \
    msg__ = (CsrWifiSmeScanResultsGetCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeScanResultsGetCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_SCAN_RESULTS_GET_CFM, dst__, src__); \
    msg__->status = (status__); \
    msg__->scanResultsCount = (scanResultsCount__); \
    msg__->scanResults = (scanResults__);

#define CsrWifiSmeScanResultsGetCfmSendTo(dst__, src__, status__, scanResultsCount__, scanResults__) \
    { \
        CsrWifiSmeScanResultsGetCfm *msg__; \
        CsrWifiSmeScanResultsGetCfmCreate(msg__, dst__, src__, status__, scanResultsCount__, scanResults__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeScanResultsGetCfmSend(dst__, status__, scanResultsCount__, scanResults__) \
    CsrWifiSmeScanResultsGetCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, status__, scanResultsCount__, scanResults__)

/*******************************************************************************

  NAME
    CsrWifiSmeSetReqSend

  DESCRIPTION
    This primitive carries PSIDs to be set within WiFi stack and/or Firmware

  PARAMETERS
    queue        - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag - Interface Identifier; unique identifier of an interface Use
                   0xFFFF to write the values from the interface mib defaults
    resetMib     - Reset the Mib values. If interfaceTag == 0xFFFF : This value
                   should be set to FALSE. If interfaceTag != 0xFFFF : Reset
                   Interface values to the same as the Interface Defaults. Note:
                   The interface must not be in use otherwise no reset will
                   occur. Note: This only affects Host Mib values. Firmware mib
                   values are not reset Note: If the Reset Fails or is not
                   allowed the requested 'values' will fail to be set and return
                   with a status of 'CSR_WIFI_SME_MIB_STATUS_NOT_TRIED'
    valuesLength - Length of values
    values       - Encoded Psids, Indexes and Data

*******************************************************************************/
#define CsrWifiSmeSetReqCreate(msg__, dst__, src__, interfaceTag__, resetMib__, valuesLength__, values__) \
    msg__ = (CsrWifiSmeSetReq *) CsrPmemAlloc(sizeof(CsrWifiSmeSetReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_SET_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->resetMib = (resetMib__); \
    msg__->valuesLength = (valuesLength__); \
    msg__->values = (values__);

#define CsrWifiSmeSetReqSendTo(dst__, src__, interfaceTag__, resetMib__, valuesLength__, values__) \
    { \
        CsrWifiSmeSetReq *msg__; \
        CsrWifiSmeSetReqCreate(msg__, dst__, src__, interfaceTag__, resetMib__, valuesLength__, values__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeSetReqSend(src__, interfaceTag__, resetMib__, valuesLength__, values__) \
    CsrWifiSmeSetReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__, resetMib__, valuesLength__, values__)
#else
#define CsrWifiSmeSetReqSend(src__, interfaceTag__, resetMib__, valuesLength__, values__) \
    CsrWifiSmeSetReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__, resetMib__, valuesLength__, values__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeSetCfmSend

  DESCRIPTION
    The SME calls the primitive to report the result of the set primitive.

  PARAMETERS
    queue             - Destination Task Queue
    interfaceTag      - Interface Identifier; unique identifier of an interface
    mibReset          - True  : if the mib values were reset due to the
                        CsrWifiSmeSetReq.resetMib flag. False : if
                        CsrWifiSmeSetReq.resetMib == False or the interface was
                        in use and the reset was not allowed.
    errorValuesLength - Length of errorValues
    errorValues       - Encoded Psids, Indexes and Status Code

*******************************************************************************/
#define CsrWifiSmeSetCfmCreate(msg__, dst__, src__, interfaceTag__, mibReset__, errorValuesLength__, errorValues__) \
    msg__ = (CsrWifiSmeSetCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeSetCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_SET_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->mibReset = (mibReset__); \
    msg__->errorValuesLength = (errorValuesLength__); \
    msg__->errorValues = (errorValues__);

#define CsrWifiSmeSetCfmSendTo(dst__, src__, interfaceTag__, mibReset__, errorValuesLength__, errorValues__) \
    { \
        CsrWifiSmeSetCfm *msg__; \
        CsrWifiSmeSetCfmCreate(msg__, dst__, src__, interfaceTag__, mibReset__, errorValuesLength__, errorValues__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeSetCfmSend(dst__, interfaceTag__, mibReset__, errorValuesLength__, errorValues__) \
    CsrWifiSmeSetCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, mibReset__, errorValuesLength__, errorValues__)

/*******************************************************************************

  NAME
    CsrWifiSmeSuspendIndSend

  DESCRIPTION
    The SME sends this primitive to all tasks that have registered to receive
    it before it goes on a Suspend status; entering this status all the
    current connections are lost and the system will stop hosting BSS/ P2P
    Groups.

  PARAMETERS
    queue  - Destination Task Queue

*******************************************************************************/
#define CsrWifiSmeSuspendIndCreate(msg__, dst__, src__) \
    msg__ = (CsrWifiSmeSuspendInd *) CsrPmemAlloc(sizeof(CsrWifiSmeSuspendInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_SUSPEND_IND, dst__, src__);

#define CsrWifiSmeSuspendIndSendTo(dst__, src__) \
    { \
        CsrWifiSmeSuspendInd *msg__; \
        CsrWifiSmeSuspendIndCreate(msg__, dst__, src__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeSuspendIndSend(dst__) \
    CsrWifiSmeSuspendIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE)

/*******************************************************************************

  NAME
    CsrWifiSmeTspecReqSend

  DESCRIPTION
    The wireless manager application should call this primitive to use the
    TSPEC feature.
    The chip supports the use of TSPECs and TCLAS for the use of IEEE
    802.11/WMM Quality of Service features.
    The API allows the wireless manager application to supply a correctly
    formatted TSPEC and TCLAS pair to the driver.
    After performing basic validation, the driver negotiates the installation
    of the TSPEC with the AP as defined by the 802.11 specification.
    The driver retains all TSPEC and TCLAS pairs until they are specifically
    removed.
    It is not compulsory for a TSPEC to have a TCLAS (NULL is used to
    indicate that no TCLAS is supplied), while a TCLASS always require a
    TSPEC.
    The format of the TSPEC element is specified in 'WMM (including WMM Power
    Save) Specification - Version 1.1' and 'ANSI/IEEE Std 802.11-REVmb/D3.0'.
    For more information, see 'UniFi Configuring WMM and WMM-PS'.

  PARAMETERS
    queue         - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag  - Interface Identifier; unique identifier of an interface
    action        - Specifies the action to be carried out on the list of TSPECs.
                    CSR_WIFI_SME_LIST_ACTION_FLUSH is not applicable here.
    transactionId - Unique Transaction ID for the TSPEC, as assigned by the
                    driver
    strict        - If it set to false, allows the SME to perform automatic
                    TSPEC negotiation
    ctrlMask      - Additional TSPEC configuration
                    Set mask with values from CsrWifiSmeTspecCtrl.
    tspecLength   - Length of the TSPEC.
    tspec         - Points to the first byte of the TSPEC
    tclasLength   - Length of the TCLAS.
                    If it is equal to 0, no TCLASS is provided for the TSPEC
    tclas         - Points to the first byte of the TCLAS, if any.

*******************************************************************************/
#define CsrWifiSmeTspecReqCreate(msg__, dst__, src__, interfaceTag__, action__, transactionId__, strict__, ctrlMask__, tspecLength__, tspec__, tclasLength__, tclas__) \
    msg__ = (CsrWifiSmeTspecReq *) CsrPmemAlloc(sizeof(CsrWifiSmeTspecReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_TSPEC_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->action = (action__); \
    msg__->transactionId = (transactionId__); \
    msg__->strict = (strict__); \
    msg__->ctrlMask = (ctrlMask__); \
    msg__->tspecLength = (tspecLength__); \
    msg__->tspec = (tspec__); \
    msg__->tclasLength = (tclasLength__); \
    msg__->tclas = (tclas__);

#define CsrWifiSmeTspecReqSendTo(dst__, src__, interfaceTag__, action__, transactionId__, strict__, ctrlMask__, tspecLength__, tspec__, tclasLength__, tclas__) \
    { \
        CsrWifiSmeTspecReq *msg__; \
        CsrWifiSmeTspecReqCreate(msg__, dst__, src__, interfaceTag__, action__, transactionId__, strict__, ctrlMask__, tspecLength__, tspec__, tclasLength__, tclas__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeTspecReqSend(src__, interfaceTag__, action__, transactionId__, strict__, ctrlMask__, tspecLength__, tspec__, tclasLength__, tclas__) \
    CsrWifiSmeTspecReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__, action__, transactionId__, strict__, ctrlMask__, tspecLength__, tspec__, tclasLength__, tclas__)
#else
#define CsrWifiSmeTspecReqSend(src__, interfaceTag__, action__, transactionId__, strict__, ctrlMask__, tspecLength__, tspec__, tclasLength__, tclas__) \
    CsrWifiSmeTspecReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__, action__, transactionId__, strict__, ctrlMask__, tspecLength__, tspec__, tclasLength__, tclas__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeTspecIndSend

  DESCRIPTION
    The SME will send this primitive to all the task that have registered to
    receive it when a change in the TSPEC occurs.

  PARAMETERS
    queue           - Destination Task Queue
    interfaceTag    - Interface Identifier; unique identifier of an interface
    transactionId   - Unique Transaction ID for the TSPEC, as assigned by the
                      driver
    tspecResultCode - Specifies the TSPEC operation requested by the peer
                      station
    tspecLength     - Length of the TSPEC.
    tspec           - Points to the first byte of the TSPEC

*******************************************************************************/
#define CsrWifiSmeTspecIndCreate(msg__, dst__, src__, interfaceTag__, transactionId__, tspecResultCode__, tspecLength__, tspec__) \
    msg__ = (CsrWifiSmeTspecInd *) CsrPmemAlloc(sizeof(CsrWifiSmeTspecInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_TSPEC_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->transactionId = (transactionId__); \
    msg__->tspecResultCode = (tspecResultCode__); \
    msg__->tspecLength = (tspecLength__); \
    msg__->tspec = (tspec__);

#define CsrWifiSmeTspecIndSendTo(dst__, src__, interfaceTag__, transactionId__, tspecResultCode__, tspecLength__, tspec__) \
    { \
        CsrWifiSmeTspecInd *msg__; \
        CsrWifiSmeTspecIndCreate(msg__, dst__, src__, interfaceTag__, transactionId__, tspecResultCode__, tspecLength__, tspec__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeTspecIndSend(dst__, interfaceTag__, transactionId__, tspecResultCode__, tspecLength__, tspec__) \
    CsrWifiSmeTspecIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, transactionId__, tspecResultCode__, tspecLength__, tspec__)

/*******************************************************************************

  NAME
    CsrWifiSmeTspecCfmSend

  DESCRIPTION
    The SME calls the primitive to report the result of the TSpec primitive
    request.

  PARAMETERS
    queue           - Destination Task Queue
    interfaceTag    - Interface Identifier; unique identifier of an interface
    status          - Reports the result of the request
    transactionId   - Unique Transaction ID for the TSPEC, as assigned by the
                      driver
    tspecResultCode - Specifies the result of the negotiated TSPEC operation
    tspecLength     - Length of the TSPEC.
    tspec           - Points to the first byte of the TSPEC

*******************************************************************************/
#define CsrWifiSmeTspecCfmCreate(msg__, dst__, src__, interfaceTag__, status__, transactionId__, tspecResultCode__, tspecLength__, tspec__) \
    msg__ = (CsrWifiSmeTspecCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeTspecCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_TSPEC_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__); \
    msg__->transactionId = (transactionId__); \
    msg__->tspecResultCode = (tspecResultCode__); \
    msg__->tspecLength = (tspecLength__); \
    msg__->tspec = (tspec__);

#define CsrWifiSmeTspecCfmSendTo(dst__, src__, interfaceTag__, status__, transactionId__, tspecResultCode__, tspecLength__, tspec__) \
    { \
        CsrWifiSmeTspecCfm *msg__; \
        CsrWifiSmeTspecCfmCreate(msg__, dst__, src__, interfaceTag__, status__, transactionId__, tspecResultCode__, tspecLength__, tspec__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeTspecCfmSend(dst__, interfaceTag__, status__, transactionId__, tspecResultCode__, tspecLength__, tspec__) \
    CsrWifiSmeTspecCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__, transactionId__, tspecResultCode__, tspecLength__, tspec__)

/*******************************************************************************

  NAME
    CsrWifiSmeWifiFlightmodeReqSend

  DESCRIPTION
    The wireless manager application may call this primitive on boot-up of
    the platform to ensure that the chip is placed in a mode that prevents
    any emission of RF energy.
    This primitive is an alternative to CSR_WIFI_SME_WIFI_ON_REQ.
    As in CSR_WIFI_SME_WIFI_ON_REQ, it causes the download of the patch file
    (if any) and the programming of the initial MIB settings (if supplied by
    the WMA), but it also ensures that the chip is left in its lowest
    possible power-mode with the radio subsystems disabled.
    This feature is useful on platforms where power cannot be removed from
    the chip (leaving the chip not initialised will cause it to consume more
    power so calling this function ensures that the chip is initialised into
    a low power mode but without entering a state where it could emit any RF
    energy).
    NOTE: this primitive does not cause the Wi-Fi to change state: Wi-Fi
    stays conceptually off. Configuration primitives can be sent after
    CSR_WIFI_SME_WIFI_FLIGHTMODE_REQ and the configuration will be maintained.
    Requests that require the state of the Wi-Fi to be ON will return
    CSR_RESULT_WIFI_OFF in their confirms.

  PARAMETERS
    queue         - Message Source Task Queue (Cfm's will be sent to this Queue)
    mibFilesCount - Number of provided data blocks with initial MIB values
    mibFiles      - Points to the first data block with initial MIB values.
                    These data blocks are typically the contents of the provided
                    files ufmib.dat and localmib.dat, available from the host
                    file system, if they exist.
                    These files typically contain radio tuning and calibration
                    values.
                    More values can be created using the Host Tools.

*******************************************************************************/
#define CsrWifiSmeWifiFlightmodeReqCreate(msg__, dst__, src__, mibFilesCount__, mibFiles__) \
    msg__ = (CsrWifiSmeWifiFlightmodeReq *) CsrPmemAlloc(sizeof(CsrWifiSmeWifiFlightmodeReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_WIFI_FLIGHTMODE_REQ, dst__, src__); \
    msg__->mibFilesCount = (mibFilesCount__); \
    msg__->mibFiles = (mibFiles__);

#define CsrWifiSmeWifiFlightmodeReqSendTo(dst__, src__, mibFilesCount__, mibFiles__) \
    { \
        CsrWifiSmeWifiFlightmodeReq *msg__; \
        CsrWifiSmeWifiFlightmodeReqCreate(msg__, dst__, src__, mibFilesCount__, mibFiles__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeWifiFlightmodeReqSend(src__, mibFilesCount__, mibFiles__) \
    CsrWifiSmeWifiFlightmodeReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, mibFilesCount__, mibFiles__)
#else
#define CsrWifiSmeWifiFlightmodeReqSend(src__, mibFilesCount__, mibFiles__) \
    CsrWifiSmeWifiFlightmodeReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, mibFilesCount__, mibFiles__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeWifiFlightmodeCfmSend

  DESCRIPTION
    The SME calls this primitive when the chip is initialised for low power
    mode and with the radio subsystem disabled. To leave flight mode, and
    enable Wi-Fi, the wireless manager application should call
    CSR_WIFI_SME_WIFI_ON_REQ.

  PARAMETERS
    queue  - Destination Task Queue
    status - Reports the result of the request

*******************************************************************************/
#define CsrWifiSmeWifiFlightmodeCfmCreate(msg__, dst__, src__, status__) \
    msg__ = (CsrWifiSmeWifiFlightmodeCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeWifiFlightmodeCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_WIFI_FLIGHTMODE_CFM, dst__, src__); \
    msg__->status = (status__);

#define CsrWifiSmeWifiFlightmodeCfmSendTo(dst__, src__, status__) \
    { \
        CsrWifiSmeWifiFlightmodeCfm *msg__; \
        CsrWifiSmeWifiFlightmodeCfmCreate(msg__, dst__, src__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeWifiFlightmodeCfmSend(dst__, status__) \
    CsrWifiSmeWifiFlightmodeCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeWifiOffReqSend

  DESCRIPTION
    The wireless manager application calls this primitive to turn off the
    chip, thus saving power when Wi-Fi is not in use.

  PARAMETERS
    queue  - Message Source Task Queue (Cfm's will be sent to this Queue)

*******************************************************************************/
#define CsrWifiSmeWifiOffReqCreate(msg__, dst__, src__) \
    msg__ = (CsrWifiSmeWifiOffReq *) CsrPmemAlloc(sizeof(CsrWifiSmeWifiOffReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_WIFI_OFF_REQ, dst__, src__);

#define CsrWifiSmeWifiOffReqSendTo(dst__, src__) \
    { \
        CsrWifiSmeWifiOffReq *msg__; \
        CsrWifiSmeWifiOffReqCreate(msg__, dst__, src__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeWifiOffReqSend(src__) \
    CsrWifiSmeWifiOffReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__)
#else
#define CsrWifiSmeWifiOffReqSend(src__) \
    CsrWifiSmeWifiOffReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeWifiOffIndSend

  DESCRIPTION
    The SME sends this primitive to all the tasks that have registered to
    receive it to report that the chip has been turned off.

  PARAMETERS
    queue  - Destination Task Queue
    reason - Indicates the reason why the Wi-Fi has been switched off.

*******************************************************************************/
#define CsrWifiSmeWifiOffIndCreate(msg__, dst__, src__, reason__) \
    msg__ = (CsrWifiSmeWifiOffInd *) CsrPmemAlloc(sizeof(CsrWifiSmeWifiOffInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_WIFI_OFF_IND, dst__, src__); \
    msg__->reason = (reason__);

#define CsrWifiSmeWifiOffIndSendTo(dst__, src__, reason__) \
    { \
        CsrWifiSmeWifiOffInd *msg__; \
        CsrWifiSmeWifiOffIndCreate(msg__, dst__, src__, reason__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeWifiOffIndSend(dst__, reason__) \
    CsrWifiSmeWifiOffIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, reason__)

/*******************************************************************************

  NAME
    CsrWifiSmeWifiOffCfmSend

  DESCRIPTION
    After receiving CSR_WIFI_SME_WIFI_OFF_REQ, if the chip is connected to a
    network, the SME will perform a disconnect operation, will send a
    CSR_WIFI_SME_MEDIA_STATUS_IND with
    CSR_WIFI_SME_MEDIA_STATUS_DISCONNECTED, and then will call
    CSR_WIFI_SME_WIFI_OFF_CFM when the chip is off.

  PARAMETERS
    queue  - Destination Task Queue
    status - Reports the result of the request

*******************************************************************************/
#define CsrWifiSmeWifiOffCfmCreate(msg__, dst__, src__, status__) \
    msg__ = (CsrWifiSmeWifiOffCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeWifiOffCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_WIFI_OFF_CFM, dst__, src__); \
    msg__->status = (status__);

#define CsrWifiSmeWifiOffCfmSendTo(dst__, src__, status__) \
    { \
        CsrWifiSmeWifiOffCfm *msg__; \
        CsrWifiSmeWifiOffCfmCreate(msg__, dst__, src__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeWifiOffCfmSend(dst__, status__) \
    CsrWifiSmeWifiOffCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeWifiOnReqSend

  DESCRIPTION
    The wireless manager application calls this primitive to turn on the
    Wi-Fi chip.
    If the Wi-Fi chip is currently off, the SME turns the Wi-Fi chip on,
    downloads the patch file (if any), and programs the initial MIB settings
    (if supplied by the WMA).
    The patch file is not provided with the SME API; its downloading is
    automatic and handled internally by the system.
    The MIB settings, when provided, override the default values that the
    firmware loads from EEPROM.
    If the Wi-Fi chip is already on, the SME takes no action and returns a
    successful status in the confirm.

  PARAMETERS
    queue         - Message Source Task Queue (Cfm's will be sent to this Queue)
    address       - Optionally specifies a station MAC address.
                    In normal use, the manager should set the address to 0xFF
                    0xFF 0xFF 0xFF 0xFF 0xFF, which will cause the chip to use
                    the MAC address in the MIB
    mibFilesCount - Number of provided data blocks with initial MIB values
    mibFiles      - Points to the first data block with initial MIB values.
                    These data blocks are typically the contents of the provided
                    files ufmib.dat and localmib.dat, available from the host
                    file system, if they exist.
                    These files typically contain radio tuning and calibration
                    values.
                    More values can be created using the Host Tools.

*******************************************************************************/
#define CsrWifiSmeWifiOnReqCreate(msg__, dst__, src__, address__, mibFilesCount__, mibFiles__) \
    msg__ = (CsrWifiSmeWifiOnReq *) CsrPmemAlloc(sizeof(CsrWifiSmeWifiOnReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_WIFI_ON_REQ, dst__, src__); \
    msg__->address = (address__); \
    msg__->mibFilesCount = (mibFilesCount__); \
    msg__->mibFiles = (mibFiles__);

#define CsrWifiSmeWifiOnReqSendTo(dst__, src__, address__, mibFilesCount__, mibFiles__) \
    { \
        CsrWifiSmeWifiOnReq *msg__; \
        CsrWifiSmeWifiOnReqCreate(msg__, dst__, src__, address__, mibFilesCount__, mibFiles__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeWifiOnReqSend(src__, address__, mibFilesCount__, mibFiles__) \
    CsrWifiSmeWifiOnReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, address__, mibFilesCount__, mibFiles__)
#else
#define CsrWifiSmeWifiOnReqSend(src__, address__, mibFilesCount__, mibFiles__) \
    CsrWifiSmeWifiOnReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, address__, mibFilesCount__, mibFiles__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeWifiOnIndSend

  DESCRIPTION
    The SME sends this primitive to all tasks that have registered to receive
    it once the chip becomes available and ready to use.

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface Identifier; unique identifier of an interface
    address      - Current MAC address

*******************************************************************************/
#define CsrWifiSmeWifiOnIndCreate(msg__, dst__, src__, interfaceTag__, address__) \
    msg__ = (CsrWifiSmeWifiOnInd *) CsrPmemAlloc(sizeof(CsrWifiSmeWifiOnInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_WIFI_ON_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->address = (address__);

#define CsrWifiSmeWifiOnIndSendTo(dst__, src__, interfaceTag__, address__) \
    { \
        CsrWifiSmeWifiOnInd *msg__; \
        CsrWifiSmeWifiOnIndCreate(msg__, dst__, src__, interfaceTag__, address__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeWifiOnIndSend(dst__, interfaceTag__, address__) \
    CsrWifiSmeWifiOnIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, address__)

/*******************************************************************************

  NAME
    CsrWifiSmeWifiOnCfmSend

  DESCRIPTION
    The SME sends this primitive to the task that has sent the request once
    the chip has been initialised and is available for use.

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Interface Identifier; unique identifier of an interface
    status       - Reports the result of the request
    address      - Current MAC address

*******************************************************************************/
#define CsrWifiSmeWifiOnCfmCreate(msg__, dst__, src__, interfaceTag__, status__, address__) \
    msg__ = (CsrWifiSmeWifiOnCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeWifiOnCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_PRIM, CSR_WIFI_SME_WIFI_ON_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__); \
    msg__->address = (address__);

#define CsrWifiSmeWifiOnCfmSendTo(dst__, src__, interfaceTag__, status__, address__) \
    { \
        CsrWifiSmeWifiOnCfm *msg__; \
        CsrWifiSmeWifiOnCfmCreate(msg__, dst__, src__, interfaceTag__, status__, address__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_PRIM, msg__); \
    }

#define CsrWifiSmeWifiOnCfmSend(dst__, interfaceTag__, status__, address__) \
    CsrWifiSmeWifiOnCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__, address__)


#ifdef __cplusplus
}
#endif

#endif /* CSR_WIFI_SME_LIB_H__ */
