/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#ifndef CSR_WIFI_SME_AP_LIB_H__
#define CSR_WIFI_SME_AP_LIB_H__

#include "csr_synergy.h"

#include "csr_types.h"
#include "csr_pmem.h"
#include "csr_sched.h"
#include "csr_util.h"
#include "csr_msg_transport.h"

#include "csr_wifi_lib.h"

#include "csr_wifi_sme_ap_prim.h"
#include "csr_wifi_sme_task.h"
#ifdef CSR_WIFI_NME_ENABLE
#include "csr_wifi_nme_task.h"
#endif


#ifdef __cplusplus
extern "C" {
#endif

#ifndef CSR_WIFI_AP_ENABLE
#error CSR_WIFI_AP_ENABLE MUST be defined inorder to use csr_wifi_sme_ap_lib.h
#endif

/*----------------------------------------------------------------------------*
 *  CsrWifiSmeApFreeUpstreamMessageContents
 *
 *  DESCRIPTION
 *      Free the allocated memory in a CSR_WIFI_SME_AP upstream message. Does not
 *      free the message itself, and can only be used for upstream messages.
 *
 *  PARAMETERS
 *      Deallocates the resources in a CSR_WIFI_SME_AP upstream message
 *----------------------------------------------------------------------------*/
void CsrWifiSmeApFreeUpstreamMessageContents(CsrUint16 eventClass, void *message);

/*----------------------------------------------------------------------------*
 *  CsrWifiSmeApFreeDownstreamMessageContents
 *
 *  DESCRIPTION
 *      Free the allocated memory in a CSR_WIFI_SME_AP downstream message. Does not
 *      free the message itself, and can only be used for downstream messages.
 *
 *  PARAMETERS
 *      Deallocates the resources in a CSR_WIFI_SME_AP downstream message
 *----------------------------------------------------------------------------*/
void CsrWifiSmeApFreeDownstreamMessageContents(CsrUint16 eventClass, void *message);

/*----------------------------------------------------------------------------*
 * Enum to string functions
 *----------------------------------------------------------------------------*/
const CsrCharString *CsrWifiSmeApAccessTypeToString(CsrWifiSmeApAccessType value);
const CsrCharString *CsrWifiSmeApAuthSupportToString(CsrWifiSmeApAuthSupport value);
const CsrCharString *CsrWifiSmeApAuthTypeToString(CsrWifiSmeApAuthType value);
const CsrCharString *CsrWifiSmeApTypeToString(CsrWifiSmeApType value);


/*----------------------------------------------------------------------------*
 * CsrPrim Type toString function.
 * Converts a message type to the String name of the Message
 *----------------------------------------------------------------------------*/
const CsrCharString *CsrWifiSmeApPrimTypeToString(CsrPrim msgType);

/*----------------------------------------------------------------------------*
 * Lookup arrays for PrimType name Strings
 *----------------------------------------------------------------------------*/
extern const CsrCharString *const CsrWifiSmeApUpstreamPrimNames[CSR_WIFI_SME_AP_PRIM_UPSTREAM_COUNT];
extern const CsrCharString *const CsrWifiSmeApDownstreamPrimNames[CSR_WIFI_SME_AP_PRIM_DOWNSTREAM_COUNT];

/*----------------------------------------------------------------------------*
 * Pretty Print a Prim Stucture to a String
 *----------------------------------------------------------------------------*/
CsrSize CsrWifiSmeApSnprintf(void *msg, CsrCharString *str, CsrSize strLength);

/*******************************************************************************

  NAME
    CsrWifiSmeApBeaconingStartReqSend

  DESCRIPTION
    This primitive requests the SME to start AP or GO functionality

  PARAMETERS
    queue               - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag        -
    groupFormation      - Set to FALSE, if Not in a group fomration phase, set
                          to TRUE , during group formation phase. During group
                          formation, NOA should not be applied.
    apType              - apType : Legacy AP or P2PGO
    cloakSsid           - cloakSsid flag.
    ssid                - ssid.
    apCredentials       - AP security credeitals used to advertise in beacon
                          /probe response
    accessType          - Specifies whether the MAC addresses from the list
                          should be allowed or denied
    macAddressListCount - Number of MAC addresses
    macAddressList      - List of MAC addresses
    valuesLength        - Length of values
    values              - Encoded Psids, Indexes and Data

*******************************************************************************/
#define CsrWifiSmeApBeaconingStartReqCreate(msg__, dst__, src__, interfaceTag__, groupFormation__, apType__, cloakSsid__, ssid__, apCredentials__, accessType__, macAddressListCount__, macAddressList__, valuesLength__, values__) \
    msg__ = (CsrWifiSmeApBeaconingStartReq *) CsrPmemAlloc(sizeof(CsrWifiSmeApBeaconingStartReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_BEACONING_START_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->groupFormation = (groupFormation__); \
    msg__->apType = (apType__); \
    msg__->cloakSsid = (cloakSsid__); \
    msg__->ssid = (ssid__); \
    msg__->apCredentials = (apCredentials__); \
    msg__->accessType = (accessType__); \
    msg__->macAddressListCount = (macAddressListCount__); \
    msg__->macAddressList = (macAddressList__); \
    msg__->valuesLength = (valuesLength__); \
    msg__->values = (values__);

#define CsrWifiSmeApBeaconingStartReqSendTo(dst__, src__, interfaceTag__, groupFormation__, apType__, cloakSsid__, ssid__, apCredentials__, accessType__, macAddressListCount__, macAddressList__, valuesLength__, values__) \
    { \
        CsrWifiSmeApBeaconingStartReq *msg__; \
        CsrWifiSmeApBeaconingStartReqCreate(msg__, dst__, src__, interfaceTag__, groupFormation__, apType__, cloakSsid__, ssid__, apCredentials__, accessType__, macAddressListCount__, macAddressList__, valuesLength__, values__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeApBeaconingStartReqSend(src__, interfaceTag__, groupFormation__, apType__, cloakSsid__, ssid__, apCredentials__, accessType__, macAddressListCount__, macAddressList__, valuesLength__, values__) \
    CsrWifiSmeApBeaconingStartReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__, groupFormation__, apType__, cloakSsid__, ssid__, apCredentials__, accessType__, macAddressListCount__, macAddressList__, valuesLength__, values__)
#else
#define CsrWifiSmeApBeaconingStartReqSend(src__, interfaceTag__, groupFormation__, apType__, cloakSsid__, ssid__, apCredentials__, accessType__, macAddressListCount__, macAddressList__, valuesLength__, values__) \
    CsrWifiSmeApBeaconingStartReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__, groupFormation__, apType__, cloakSsid__, ssid__, apCredentials__, accessType__, macAddressListCount__, macAddressList__, valuesLength__, values__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeApBeaconingStartCfmSend

  DESCRIPTION
    This primitive confirms the completion of the request along with the
    status

  PARAMETERS
    queue             - Destination Task Queue
    interfaceTag      -
    status            -
    secIeLength       -
    secIe             -
    errorValuesLength - Length of errorValues
    errorValues       - Encoded Psids, Indexes and Status Code

*******************************************************************************/
#define CsrWifiSmeApBeaconingStartCfmCreate(msg__, dst__, src__, interfaceTag__, status__, secIeLength__, secIe__, errorValuesLength__, errorValues__) \
    msg__ = (CsrWifiSmeApBeaconingStartCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeApBeaconingStartCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_BEACONING_START_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__); \
    msg__->secIeLength = (secIeLength__); \
    msg__->secIe = (secIe__); \
    msg__->errorValuesLength = (errorValuesLength__); \
    msg__->errorValues = (errorValues__);

#define CsrWifiSmeApBeaconingStartCfmSendTo(dst__, src__, interfaceTag__, status__, secIeLength__, secIe__, errorValuesLength__, errorValues__) \
    { \
        CsrWifiSmeApBeaconingStartCfm *msg__; \
        CsrWifiSmeApBeaconingStartCfmCreate(msg__, dst__, src__, interfaceTag__, status__, secIeLength__, secIe__, errorValuesLength__, errorValues__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#define CsrWifiSmeApBeaconingStartCfmSend(dst__, interfaceTag__, status__, secIeLength__, secIe__, errorValuesLength__, errorValues__) \
    CsrWifiSmeApBeaconingStartCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__, secIeLength__, secIe__, errorValuesLength__, errorValues__)

/*******************************************************************************

  NAME
    CsrWifiSmeApBeaconingStopReqSend

  DESCRIPTION
    This primitive requests the SME to STOP AP or P2PGO operation

  PARAMETERS
    queue        - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag -

*******************************************************************************/
#define CsrWifiSmeApBeaconingStopReqCreate(msg__, dst__, src__, interfaceTag__) \
    msg__ = (CsrWifiSmeApBeaconingStopReq *) CsrPmemAlloc(sizeof(CsrWifiSmeApBeaconingStopReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_BEACONING_STOP_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__);

#define CsrWifiSmeApBeaconingStopReqSendTo(dst__, src__, interfaceTag__) \
    { \
        CsrWifiSmeApBeaconingStopReq *msg__; \
        CsrWifiSmeApBeaconingStopReqCreate(msg__, dst__, src__, interfaceTag__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeApBeaconingStopReqSend(src__, interfaceTag__) \
    CsrWifiSmeApBeaconingStopReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__)
#else
#define CsrWifiSmeApBeaconingStopReqSend(src__, interfaceTag__) \
    CsrWifiSmeApBeaconingStopReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeApBeaconingStopCfmSend

  DESCRIPTION
    This primitive confirms AP or P2PGO operation is terminated

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag -
    status       -

*******************************************************************************/
#define CsrWifiSmeApBeaconingStopCfmCreate(msg__, dst__, src__, interfaceTag__, status__) \
    msg__ = (CsrWifiSmeApBeaconingStopCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeApBeaconingStopCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_BEACONING_STOP_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__);

#define CsrWifiSmeApBeaconingStopCfmSendTo(dst__, src__, interfaceTag__, status__) \
    { \
        CsrWifiSmeApBeaconingStopCfm *msg__; \
        CsrWifiSmeApBeaconingStopCfmCreate(msg__, dst__, src__, interfaceTag__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#define CsrWifiSmeApBeaconingStopCfmSend(dst__, interfaceTag__, status__) \
    CsrWifiSmeApBeaconingStopCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeApErrorIndSend

  DESCRIPTION
    This primitve is sent by SME to indicate some error in AP operationi
    after AP operations were started successfully and continuing the AP
    operation may lead to undesired behaviour. It is the responsibility of
    the upper layers to stop AP operation if needed

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag - Range 0-1
    apType       -
    status       - Contains the error status

*******************************************************************************/
#define CsrWifiSmeApErrorIndCreate(msg__, dst__, src__, interfaceTag__, apType__, status__) \
    msg__ = (CsrWifiSmeApErrorInd *) CsrPmemAlloc(sizeof(CsrWifiSmeApErrorInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_ERROR_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->apType = (apType__); \
    msg__->status = (status__);

#define CsrWifiSmeApErrorIndSendTo(dst__, src__, interfaceTag__, apType__, status__) \
    { \
        CsrWifiSmeApErrorInd *msg__; \
        CsrWifiSmeApErrorIndCreate(msg__, dst__, src__, interfaceTag__, apType__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#define CsrWifiSmeApErrorIndSend(dst__, interfaceTag__, apType__, status__) \
    CsrWifiSmeApErrorIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, apType__, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeApStaConnectStartIndSend

  DESCRIPTION
    This primitive indicates that a stations request to join the group/BSS is
    accepted

  PARAMETERS
    queue          - Destination Task Queue
    interfaceTag   -
    peerMacAddress -

*******************************************************************************/
#define CsrWifiSmeApStaConnectStartIndCreate(msg__, dst__, src__, interfaceTag__, peerMacAddress__) \
    msg__ = (CsrWifiSmeApStaConnectStartInd *) CsrPmemAlloc(sizeof(CsrWifiSmeApStaConnectStartInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_STA_CONNECT_START_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->peerMacAddress = (peerMacAddress__);

#define CsrWifiSmeApStaConnectStartIndSendTo(dst__, src__, interfaceTag__, peerMacAddress__) \
    { \
        CsrWifiSmeApStaConnectStartInd *msg__; \
        CsrWifiSmeApStaConnectStartIndCreate(msg__, dst__, src__, interfaceTag__, peerMacAddress__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#define CsrWifiSmeApStaConnectStartIndSend(dst__, interfaceTag__, peerMacAddress__) \
    CsrWifiSmeApStaConnectStartIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, peerMacAddress__)

/*******************************************************************************

  NAME
    CsrWifiSmeApStaDisconnectReqSend

  DESCRIPTION
    This primitive tells SME to deauth ot disassociate a particular station
    within BSS

  PARAMETERS
    queue          - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag   -
    deauthReason   -
    disassocReason -
    peerMacaddress -
    keepBlocking   - If TRUE, the station is blocked. If FALSE and the station
                     is connected, disconnect the station. If FALSE and the
                     station is not connected, no action is taken.

*******************************************************************************/
#define CsrWifiSmeApStaDisconnectReqCreate(msg__, dst__, src__, interfaceTag__, deauthReason__, disassocReason__, peerMacaddress__, keepBlocking__) \
    msg__ = (CsrWifiSmeApStaDisconnectReq *) CsrPmemAlloc(sizeof(CsrWifiSmeApStaDisconnectReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_STA_DISCONNECT_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->deauthReason = (deauthReason__); \
    msg__->disassocReason = (disassocReason__); \
    msg__->peerMacaddress = (peerMacaddress__); \
    msg__->keepBlocking = (keepBlocking__);

#define CsrWifiSmeApStaDisconnectReqSendTo(dst__, src__, interfaceTag__, deauthReason__, disassocReason__, peerMacaddress__, keepBlocking__) \
    { \
        CsrWifiSmeApStaDisconnectReq *msg__; \
        CsrWifiSmeApStaDisconnectReqCreate(msg__, dst__, src__, interfaceTag__, deauthReason__, disassocReason__, peerMacaddress__, keepBlocking__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeApStaDisconnectReqSend(src__, interfaceTag__, deauthReason__, disassocReason__, peerMacaddress__, keepBlocking__) \
    CsrWifiSmeApStaDisconnectReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__, deauthReason__, disassocReason__, peerMacaddress__, keepBlocking__)
#else
#define CsrWifiSmeApStaDisconnectReqSend(src__, interfaceTag__, deauthReason__, disassocReason__, peerMacaddress__, keepBlocking__) \
    CsrWifiSmeApStaDisconnectReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__, deauthReason__, disassocReason__, peerMacaddress__, keepBlocking__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeApStaDisconnectCfmSend

  DESCRIPTION
    This primitive confirms the station is disconnected

  PARAMETERS
    queue          - Destination Task Queue
    interfaceTag   -
    status         -
    peerMacaddress -

*******************************************************************************/
#define CsrWifiSmeApStaDisconnectCfmCreate(msg__, dst__, src__, interfaceTag__, status__, peerMacaddress__) \
    msg__ = (CsrWifiSmeApStaDisconnectCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeApStaDisconnectCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_STA_DISCONNECT_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__); \
    msg__->peerMacaddress = (peerMacaddress__);

#define CsrWifiSmeApStaDisconnectCfmSendTo(dst__, src__, interfaceTag__, status__, peerMacaddress__) \
    { \
        CsrWifiSmeApStaDisconnectCfm *msg__; \
        CsrWifiSmeApStaDisconnectCfmCreate(msg__, dst__, src__, interfaceTag__, status__, peerMacaddress__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#define CsrWifiSmeApStaDisconnectCfmSend(dst__, interfaceTag__, status__, peerMacaddress__) \
    CsrWifiSmeApStaDisconnectCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__, peerMacaddress__)

/*******************************************************************************

  NAME
    CsrWifiSmeApStaNotifyIndSend

  DESCRIPTION
    This primitive indicates that a station has joined or a previously joined
    station has left the BSS/group

  PARAMETERS
    queue             - Destination Task Queue
    interfaceTag      -
    mediaStatus       -
    peerMacAddress    -
    peerDeviceAddress -
    disassocReason    -
    deauthReason      -
    WpsRegistration   -
    secIeLength       -
    secIe             -
    groupKeyId        -
    seqNumber         -

*******************************************************************************/
#define CsrWifiSmeApStaNotifyIndCreate(msg__, dst__, src__, interfaceTag__, mediaStatus__, peerMacAddress__, peerDeviceAddress__, disassocReason__, deauthReason__, WpsRegistration__, secIeLength__, secIe__, groupKeyId__, seqNumber__) \
    msg__ = (CsrWifiSmeApStaNotifyInd *) CsrPmemAlloc(sizeof(CsrWifiSmeApStaNotifyInd)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_STA_NOTIFY_IND, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->mediaStatus = (mediaStatus__); \
    msg__->peerMacAddress = (peerMacAddress__); \
    msg__->peerDeviceAddress = (peerDeviceAddress__); \
    msg__->disassocReason = (disassocReason__); \
    msg__->deauthReason = (deauthReason__); \
    msg__->WpsRegistration = (WpsRegistration__); \
    msg__->secIeLength = (secIeLength__); \
    msg__->secIe = (secIe__); \
    msg__->groupKeyId = (groupKeyId__); \
    CsrMemCpy(msg__->seqNumber, (seqNumber__), sizeof(CsrUint16) * 8);

#define CsrWifiSmeApStaNotifyIndSendTo(dst__, src__, interfaceTag__, mediaStatus__, peerMacAddress__, peerDeviceAddress__, disassocReason__, deauthReason__, WpsRegistration__, secIeLength__, secIe__, groupKeyId__, seqNumber__) \
    { \
        CsrWifiSmeApStaNotifyInd *msg__; \
        CsrWifiSmeApStaNotifyIndCreate(msg__, dst__, src__, interfaceTag__, mediaStatus__, peerMacAddress__, peerDeviceAddress__, disassocReason__, deauthReason__, WpsRegistration__, secIeLength__, secIe__, groupKeyId__, seqNumber__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#define CsrWifiSmeApStaNotifyIndSend(dst__, interfaceTag__, mediaStatus__, peerMacAddress__, peerDeviceAddress__, disassocReason__, deauthReason__, WpsRegistration__, secIeLength__, secIe__, groupKeyId__, seqNumber__) \
    CsrWifiSmeApStaNotifyIndSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, mediaStatus__, peerMacAddress__, peerDeviceAddress__, disassocReason__, deauthReason__, WpsRegistration__, secIeLength__, secIe__, groupKeyId__, seqNumber__)

/*******************************************************************************

  NAME
    CsrWifiSmeApWpsRegistrationFinishedReqSend

  DESCRIPTION
    This primitive tells SME that WPS registration procedure has finished

  PARAMETERS
    queue        - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag -

*******************************************************************************/
#define CsrWifiSmeApWpsRegistrationFinishedReqCreate(msg__, dst__, src__, interfaceTag__) \
    msg__ = (CsrWifiSmeApWpsRegistrationFinishedReq *) CsrPmemAlloc(sizeof(CsrWifiSmeApWpsRegistrationFinishedReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_WPS_REGISTRATION_FINISHED_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__);

#define CsrWifiSmeApWpsRegistrationFinishedReqSendTo(dst__, src__, interfaceTag__) \
    { \
        CsrWifiSmeApWpsRegistrationFinishedReq *msg__; \
        CsrWifiSmeApWpsRegistrationFinishedReqCreate(msg__, dst__, src__, interfaceTag__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeApWpsRegistrationFinishedReqSend(src__, interfaceTag__) \
    CsrWifiSmeApWpsRegistrationFinishedReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__)
#else
#define CsrWifiSmeApWpsRegistrationFinishedReqSend(src__, interfaceTag__) \
    CsrWifiSmeApWpsRegistrationFinishedReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeApWpsRegistrationFinishedCfmSend

  DESCRIPTION
    A confirm for UNIFI_MGT_AP_WPS_REGISTRATION_FINISHED.request

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag -
    status       -

*******************************************************************************/
#define CsrWifiSmeApWpsRegistrationFinishedCfmCreate(msg__, dst__, src__, interfaceTag__, status__) \
    msg__ = (CsrWifiSmeApWpsRegistrationFinishedCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeApWpsRegistrationFinishedCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_WPS_REGISTRATION_FINISHED_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__);

#define CsrWifiSmeApWpsRegistrationFinishedCfmSendTo(dst__, src__, interfaceTag__, status__) \
    { \
        CsrWifiSmeApWpsRegistrationFinishedCfm *msg__; \
        CsrWifiSmeApWpsRegistrationFinishedCfmCreate(msg__, dst__, src__, interfaceTag__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#define CsrWifiSmeApWpsRegistrationFinishedCfmSend(dst__, interfaceTag__, status__) \
    CsrWifiSmeApWpsRegistrationFinishedCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__)

/*******************************************************************************

  NAME
    CsrWifiSmeApWpsRegistrationStartedReqSend

  DESCRIPTION
    This primitive tells SME that WPS registration procedure has started

  PARAMETERS
    queue                    - Message Source Task Queue (Cfm's will be sent to this Queue)
    interfaceTag             -
    SelectedDevicePasswordId -
    SelectedconfigMethod     -

*******************************************************************************/
#define CsrWifiSmeApWpsRegistrationStartedReqCreate(msg__, dst__, src__, interfaceTag__, SelectedDevicePasswordId__, SelectedconfigMethod__) \
    msg__ = (CsrWifiSmeApWpsRegistrationStartedReq *) CsrPmemAlloc(sizeof(CsrWifiSmeApWpsRegistrationStartedReq)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_WPS_REGISTRATION_STARTED_REQ, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->SelectedDevicePasswordId = (SelectedDevicePasswordId__); \
    msg__->SelectedconfigMethod = (SelectedconfigMethod__);

#define CsrWifiSmeApWpsRegistrationStartedReqSendTo(dst__, src__, interfaceTag__, SelectedDevicePasswordId__, SelectedconfigMethod__) \
    { \
        CsrWifiSmeApWpsRegistrationStartedReq *msg__; \
        CsrWifiSmeApWpsRegistrationStartedReqCreate(msg__, dst__, src__, interfaceTag__, SelectedDevicePasswordId__, SelectedconfigMethod__); \
        CsrMsgTransport(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#ifdef CSR_WIFI_NME_ENABLE
#define CsrWifiSmeApWpsRegistrationStartedReqSend(src__, interfaceTag__, SelectedDevicePasswordId__, SelectedconfigMethod__) \
    CsrWifiSmeApWpsRegistrationStartedReqSendTo(CSR_WIFI_NME_IFACEQUEUE, src__, interfaceTag__, SelectedDevicePasswordId__, SelectedconfigMethod__)
#else
#define CsrWifiSmeApWpsRegistrationStartedReqSend(src__, interfaceTag__, SelectedDevicePasswordId__, SelectedconfigMethod__) \
    CsrWifiSmeApWpsRegistrationStartedReqSendTo(CSR_WIFI_SME_IFACEQUEUE, src__, interfaceTag__, SelectedDevicePasswordId__, SelectedconfigMethod__)
#endif
/*******************************************************************************

  NAME
    CsrWifiSmeApWpsRegistrationStartedCfmSend

  DESCRIPTION
    A confirm for UNIFI_MGT_AP_WPS_REGISTRATION_STARTED.request

  PARAMETERS
    queue        - Destination Task Queue
    interfaceTag -
    status       -

*******************************************************************************/
#define CsrWifiSmeApWpsRegistrationStartedCfmCreate(msg__, dst__, src__, interfaceTag__, status__) \
    msg__ = (CsrWifiSmeApWpsRegistrationStartedCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeApWpsRegistrationStartedCfm)); \
    CsrWifiFsmEventInit(&msg__->common, CSR_WIFI_SME_AP_PRIM, CSR_WIFI_SME_AP_WPS_REGISTRATION_STARTED_CFM, dst__, src__); \
    msg__->interfaceTag = (interfaceTag__); \
    msg__->status = (status__);

#define CsrWifiSmeApWpsRegistrationStartedCfmSendTo(dst__, src__, interfaceTag__, status__) \
    { \
        CsrWifiSmeApWpsRegistrationStartedCfm *msg__; \
        CsrWifiSmeApWpsRegistrationStartedCfmCreate(msg__, dst__, src__, interfaceTag__, status__); \
        CsrSchedMessagePut(dst__, CSR_WIFI_SME_AP_PRIM, msg__); \
    }

#define CsrWifiSmeApWpsRegistrationStartedCfmSend(dst__, interfaceTag__, status__) \
    CsrWifiSmeApWpsRegistrationStartedCfmSendTo(dst__, CSR_WIFI_SME_IFACEQUEUE, interfaceTag__, status__)


#ifdef __cplusplus
}
#endif

#endif /* CSR_WIFI_SME_AP_LIB_H__ */
