/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#ifndef CSR_WIFI_NME_AP_PRIM_H__
#define CSR_WIFI_NME_AP_PRIM_H__

#include "csr_synergy.h"

#include "csr_types.h"
#include "csr_prim_defs.h"
#include "csr_sched.h"
#include "csr_wifi_common.h"
#include "csr_result.h"
#include "csr_wifi_fsm_event.h"
#include "csr_wifi_sme_prim.h"
#include "csr_wifi_sme_ap_prim.h"
#include "csr_wifi_nme_prim.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef CSR_WIFI_NME_ENABLE
#error CSR_WIFI_NME_ENABLE MUST be defined inorder to use csr_wifi_nme_ap_prim.h
#endif
#ifndef CSR_WIFI_AP_ENABLE
#error CSR_WIFI_AP_ENABLE MUST be defined inorder to use csr_wifi_nme_ap_prim.h
#endif

#define CSR_WIFI_NME_AP_PRIM                                            (0x0426)

typedef CsrPrim CsrWifiNmeApPrim;


/*******************************************************************************

  NAME
    CsrWifiNmeApPersCredentialType

  DESCRIPTION
    NME Credential Types

 VALUES
    CSR_WIFI_NME_AP_CREDENTIAL_TYPE_PSK
                   - Use PSK as credential.
    CSR_WIFI_NME_AP_CREDENTIAL_TYPE_PASSPHRASE
                   - Use the specified passphrase as credential

*******************************************************************************/
typedef CsrUint8 CsrWifiNmeApPersCredentialType;
#define CSR_WIFI_NME_AP_CREDENTIAL_TYPE_PSK          ((CsrWifiNmeApPersCredentialType) 0x00)
#define CSR_WIFI_NME_AP_CREDENTIAL_TYPE_PASSPHRASE   ((CsrWifiNmeApPersCredentialType) 0x01)


/*******************************************************************************

  NAME
    CsrWifiNmeApAuthPers

  DESCRIPTION

  MEMBERS
    authSupport                     - Credential type value (as defined in the
                                      enumeration type).
    pskOrPassphrase                 - Credential type value (as defined in the
                                      enumeration type).
    authPers_credentials            - Union containing credentials which depends
                                      on credentialType parameter.
    authPers_credentialspsk         -
    authPers_credentialspassphrase  -

*******************************************************************************/
typedef struct
{
    CsrWifiSmeApAuthSupportMask    authSupport;
    CsrWifiNmeApPersCredentialType pskOrPassphrase;
    union
    {
        CsrWifiNmePsk        psk;
        CsrWifiNmePassphrase passphrase;
    } authPers_credentials;
} CsrWifiNmeApAuthPers;

/*******************************************************************************

  NAME
    CsrWifiNmeApCredentials

  DESCRIPTION
    Structure containing the Credentials data.

  MEMBERS
    authType                     - Authentication type
    nmeAuthType                  - Authentication parameters
    nmeAuthTypeopenSystemEmpty   -
    nmeAuthTypeauthwep           -
    nmeAuthTypeauthTypePersonal  -

*******************************************************************************/
typedef struct
{
    CsrWifiSmeApAuthType authType;
    union
    {
        CsrWifiSmeEmpty      openSystemEmpty;
        CsrWifiSmeWepAuth    authwep;
        CsrWifiNmeApAuthPers authTypePersonal;
    } nmeAuthType;
} CsrWifiNmeApCredentials;


/* Downstream */
#define CSR_WIFI_NME_AP_PRIM_DOWNSTREAM_LOWEST            (0x0000)

#define CSR_WIFI_NME_AP_WPS_REGISTER_REQ                  ((CsrWifiNmeApPrim) (0x0000 + CSR_WIFI_NME_AP_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_NME_AP_START_REQ                         ((CsrWifiNmeApPrim) (0x0001 + CSR_WIFI_NME_AP_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_NME_AP_STOP_REQ                          ((CsrWifiNmeApPrim) (0x0002 + CSR_WIFI_NME_AP_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_NME_AP_STA_REMOVE_REQ                    ((CsrWifiNmeApPrim) (0x0003 + CSR_WIFI_NME_AP_PRIM_DOWNSTREAM_LOWEST))


#define CSR_WIFI_NME_AP_PRIM_DOWNSTREAM_HIGHEST           (0x0003 + CSR_WIFI_NME_AP_PRIM_DOWNSTREAM_LOWEST)

/* Upstream */
#define CSR_WIFI_NME_AP_PRIM_UPSTREAM_LOWEST              (0x0000 + CSR_PRIM_UPSTREAM)

#define CSR_WIFI_NME_AP_WPS_REGISTER_CFM                  ((CsrWifiNmeApPrim) (0x0000 + CSR_WIFI_NME_AP_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_NME_AP_START_CFM                         ((CsrWifiNmeApPrim) (0x0001 + CSR_WIFI_NME_AP_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_NME_AP_STOP_CFM                          ((CsrWifiNmeApPrim) (0x0002 + CSR_WIFI_NME_AP_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_NME_AP_STOP_IND                          ((CsrWifiNmeApPrim) (0x0003 + CSR_WIFI_NME_AP_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_NME_AP_STATION_IND                       ((CsrWifiNmeApPrim) (0x0004 + CSR_WIFI_NME_AP_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_NME_AP_START_IND                         ((CsrWifiNmeApPrim) (0x0005 + CSR_WIFI_NME_AP_PRIM_UPSTREAM_LOWEST))

#define CSR_WIFI_NME_AP_PRIM_UPSTREAM_HIGHEST             (0x0005 + CSR_WIFI_NME_AP_PRIM_UPSTREAM_LOWEST)

#define CSR_WIFI_NME_AP_PRIM_DOWNSTREAM_COUNT             (CSR_WIFI_NME_AP_PRIM_DOWNSTREAM_HIGHEST + 1 - CSR_WIFI_NME_AP_PRIM_DOWNSTREAM_LOWEST)
#define CSR_WIFI_NME_AP_PRIM_UPSTREAM_COUNT               (CSR_WIFI_NME_AP_PRIM_UPSTREAM_HIGHEST + 1 - CSR_WIFI_NME_AP_PRIM_UPSTREAM_LOWEST)

/*******************************************************************************

  NAME
    CsrWifiNmeApWpsRegisterReq

  DESCRIPTION
    This primitive allows the NME to accept the WPS registration from an
    enrollee. Such registration procedure can be cancelled by sending
    CSR_WIFI_NME_WPS_CANCEL.request.

  MEMBERS
    common                   - Common header for use with the CsrWifiFsm Module
    interfaceTag             - Interface Identifier; unique identifier of an
                               interface
    selectedDevicePasswordId - Selected password type
    selectedConfigMethod     - Selected WPS configuration method type
    pin                      - PIN value.
                               Relevant if selected device password ID is PIN.4
                               digit pin is passed by sending the pin digits in
                               pin[0]..pin[3] and rest of the contents filled
                               with '-'.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent         common;
    CsrUint16               interfaceTag;
    CsrWifiSmeWpsDpid       selectedDevicePasswordId;
    CsrWifiSmeWpsConfigType selectedConfigMethod;
    CsrUint8                pin[8];
} CsrWifiNmeApWpsRegisterReq;

/*******************************************************************************

  NAME
    CsrWifiNmeApStartReq

  DESCRIPTION
    This primitive requests NME to started the AP operation.

  MEMBERS
    common              - Common header for use with the CsrWifiFsm Module
    interfaceTag        - Interface identifier; unique identifier of an
                          interface
    apType              - AP Type specifies the Legacy AP or P2P GO operation
    cloakSsid           - Indicates whether the SSID should be cloaked (hidden
                          and not broadcast in beacon) or not
    ssid                - Service Set Identifier
    apCredentials       - Security credential configuration.
    accessType          - Specifies whether the MAC addresses from the list
                          should be allowed or denied
    macAddressListCount - Number of MAC addresses
    macAddressList      - List of MAC addresses
    valuesLength        - Length of values
    values              - Encoded Psids, Indexes and Data

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent         common;
    CsrUint16               interfaceTag;
    CsrWifiSmeApType        apType;
    CsrBool                 cloakSsid;
    CsrWifiSsid             ssid;
    CsrWifiNmeApCredentials apCredentials;
    CsrWifiSmeApAccessType  accessType;
    CsrUint8                macAddressListCount;
    CsrWifiMacAddress      *macAddressList;
    CsrUint32               valuesLength;
    CsrUint8               *values;
} CsrWifiNmeApStartReq;

/*******************************************************************************

  NAME
    CsrWifiNmeApStopReq

  DESCRIPTION
    This primitive requests NME to stop the AP operation.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface identifier; unique identifier of an interface

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
} CsrWifiNmeApStopReq;

/*******************************************************************************

  NAME
    CsrWifiNmeApStaRemoveReq

  DESCRIPTION
    This primitive disconnects a connected station. If keepBlocking is set to
    TRUE, the station with the specified MAC address is not allowed to
    connect. If the requested station is not already connected,it may be
    blocked based on keepBlocking parameter.

  MEMBERS
    common        - Common header for use with the CsrWifiFsm Module
    interfaceTag  - Interface Identifier; unique identifier of an interface
    staMacAddress - Mac Address of the station to be disconnected or blocked
    keepBlocking  - If TRUE, the station is blocked. If FALSE and the station is
                    connected, disconnect the station. If FALSE and the station
                    is not connected, no action is taken.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrUint16         interfaceTag;
    CsrWifiMacAddress staMacAddress;
    CsrBool           keepBlocking;
} CsrWifiNmeApStaRemoveReq;

/*******************************************************************************

  NAME
    CsrWifiNmeApWpsRegisterCfm

  DESCRIPTION
    This primitive reports the result of WPS procedure.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface identifier; unique identifier of an interface
    status       - Status of the request.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrResult       status;
} CsrWifiNmeApWpsRegisterCfm;

/*******************************************************************************

  NAME
    CsrWifiNmeApStartCfm

  DESCRIPTION
    This primitive reports the result of CSR_WIFI_NME_AP_START.request.

  MEMBERS
    common            - Common header for use with the CsrWifiFsm Module
    interfaceTag      - Interface identifier; unique identifier of an interface
    status            - Status of the request.
    ssid              - Service Set Identifier
    errorValuesLength - Length of errorValues
    errorValues       - Encoded Psids, Indexes and Status Code

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrResult       status;
    CsrWifiSsid     ssid;
    CsrUint32       errorValuesLength;
    CsrUint8       *errorValues;
} CsrWifiNmeApStartCfm;

/*******************************************************************************

  NAME
    CsrWifiNmeApStopCfm

  DESCRIPTION
    This primitive confirms that the AP operation is stopped. NME shall send
    this primitive in response to the request even if AP operation has
    already been stopped

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface identifier; unique identifier of an interface
    status       - Status of the request.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrResult       status;
} CsrWifiNmeApStopCfm;

/*******************************************************************************

  NAME
    CsrWifiNmeApStopInd

  DESCRIPTION
    Indicates that AP operation had stopped either because of a stop request
    from the application or because of an internal error.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface Identifier; unique identifier of an interface
    apType       - Reports AP Type (P2PGO or AP)
    status       - Error Status

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent  common;
    CsrUint16        interfaceTag;
    CsrWifiSmeApType apType;
    CsrResult        status;
} CsrWifiNmeApStopInd;

/*******************************************************************************

  NAME
    CsrWifiNmeApStationInd

  DESCRIPTION
    This primitive indicates that a station has joined or a previously joined
    station has left the BSS/group

  MEMBERS
    common            - Common header for use with the CsrWifiFsm Module
    interfaceTag      - Interface Identifier; unique identifier of an interface
    mediaStatus       - Indicates whether the station is connected or
                        disconnected
    peerMacAddress    - MAC address of the station
    peerDeviceAddress - P2P Device Address

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent       common;
    CsrUint16             interfaceTag;
    CsrWifiSmeMediaStatus mediaStatus;
    CsrWifiMacAddress     peerMacAddress;
    CsrWifiMacAddress     peerDeviceAddress;
} CsrWifiNmeApStationInd;

/*******************************************************************************

  NAME
    CsrWifiNmeApStartInd

  DESCRIPTION
    This primitive nidicates to the interested applications that AP activity
    is started successfully <\br> In case of a failure it will not be sent.

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Interface identifier; unique identifier of an interface
    apType       - Reports AP Type (P2PGO or AP)
    ssid         - Service Set Identifier

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent  common;
    CsrUint16        interfaceTag;
    CsrWifiSmeApType apType;
    CsrWifiSsid      ssid;
} CsrWifiNmeApStartInd;


#ifdef __cplusplus
}
#endif

#endif /* CSR_WIFI_NME_AP_PRIM_H__ */
