/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef __LINUX_UNIFI_WEXT_H__
#define __LINUX_UNIFI_WEXT_H__ 1

#include "csr_synergy.h"

#include <linux/kernel.h>
#include <net/iw_handler.h>
#include "csr_wifi_sme_prim.h"

#ifdef CSR_WIFI_AP_ENABLE
#include "csr_wifi_sme_ap_prim.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
 *      wext.c
 */
/* A few details needed for WEP (Wireless Equivalent Privacy) */
#define UNIFI_MAX_KEY_SIZE      16
#define NUM_WEPKEYS              4
#define SMALL_KEY_SIZE           5
#define LARGE_KEY_SIZE          13
typedef struct wep_key_t
{
    int           len;
    unsigned char key[UNIFI_MAX_KEY_SIZE];  /* 40-bit and 104-bit keys */
} wep_key_t;

#ifdef CSR_SUPPORT_WEXT_AP
typedef struct
{
    CsrUint8 rxStbc;
    CsrBool  rifsModeAllowed;
} CsrWifiWextHtParams;

typedef struct
{
    CsrUint8               phySupportedBitmap;
    CsrUint16              beaconInterval;
    CsrUint8               dtimPeriod;
    CsrWifiSmePreambleType preamble;
    CsrBool                shortSlotTimeEnabled;
    CsrUint8               apMaxConnections;
    CsrUint16              maxListenInterval;
    CsrUint8               ctsProtectionType;
    CsrBool                wmmEnabled;
    CsrWifiSmeApAccessType accessType;
    CsrUint8               macAddressListCount;
    CsrWifiMacAddress     *macAddressList;
    CsrBool                wpsEnabled;
    CsrWifiWextHtParams    apHtParams;
} CsrWifiWextApMacConfig;

typedef struct
{
    CsrUint16 apGroupkeyTimeout;
    CsrBool   apStrictGtkRekey;
    CsrUint16 apGmkTimeout;
    CsrUint16 apResponseTimeout;
    CsrUint8  apRetransLimit;
} CsrWifiWextApConfig;


typedef CsrUint8 CsrWifiWextApAuthSupportMask;
typedef CsrUint16 CsrWifiWextApRsnCapabilitiesMask;
typedef CsrUint16 CsrWifiWextApWapiCapabilitiesMask;
typedef CsrUint8 CsrWifiWextApPersCredentialType;

typedef struct
{
    CsrUint16 encryptionMode;
    CsrUint8  psk[32];
} CsrWifiWextPsk;

typedef struct
{
    CsrUint16      encryptionMode;
    CsrCharString *passphrase;
} CsrWifiWextPassphrase;

typedef struct
{
    CsrWifiWextApAuthSupportMask    authSupport;
    CsrWifiWextApPersCredentialType pskOrPassphrase;
    union
    {
        CsrWifiWextPsk        psk;
        CsrWifiWextPassphrase passphrase;
    } authPers_credentials;
} CsrWifiWextApAuthPers;

/*******************************************************************************

  NAME
    CsrWifiSmeApPhySupport

  DESCRIPTION
    Define bits for CsrWifiSmeApPhySupportMask

 VALUES
    CSR_WIFI_SME_AP_PHY_SUPPORT_A - 802.11a. It is not supported in the current
                                    release.
    CSR_WIFI_SME_AP_PHY_SUPPORT_B - 802.11b
    CSR_WIFI_SME_AP_PHY_SUPPORT_G - 802.11g
    CSR_WIFI_SME_AP_PHY_SUPPORT_N - 802.11n

*******************************************************************************/

typedef CsrUint8 CsrWifiSmeApPhySupport;
#define CSR_WIFI_SME_AP_PHY_SUPPORT_A   ((CsrWifiSmeApPhySupport) 0x01)
#define CSR_WIFI_SME_AP_PHY_SUPPORT_B   ((CsrWifiSmeApPhySupport) 0x02)
#define CSR_WIFI_SME_AP_PHY_SUPPORT_G   ((CsrWifiSmeApPhySupport) 0x04)
#define CSR_WIFI_SME_AP_PHY_SUPPORT_N   ((CsrWifiSmeApPhySupport) 0x08)

/********************************************************************************/

typedef struct
{
    CsrWifiFsmEvent common;
    CsrResult       status;
} CsrWifiNmeApConfigSetCfm;

typedef struct
{
    CsrWifiSmeP2pGroupCapabilityMask groupCapability;
    CsrBool                          opPsEnabled;
    CsrUint8                         ctWindow;
    CsrWifiSmeP2pNoaConfigMethod     noaConfigMethod;
    CsrBool                          allowNoaWithNonP2pDevices;
} CsrWifiSmeApP2pGoConfig;

/* WMM Access categorys */
#define CSR_WIFI_TE_WFA_AC_BE 1
#define CSR_WIFI_TE_WFA_AC_BK 2
#define CSR_WIFI_TE_WFA_AC_VI 3
#define CSR_WIFI_TE_WFA_AC_VO 4

#endif

#define UNIFI_SCAN_ACTIVE       0
#define UNIFI_SCAN_PASSIVE      1
#define UNIFI_MAX_SSID_LEN      32

#define MAX_WPA_IE_LEN 64
#define MAX_RSN_IE_LEN 255

/*
 * Function to register in the netdev to report wireless stats.
 */
struct iw_statistics *unifi_get_wireless_stats(struct net_device *dev);

void uf_sme_wext_set_defaults(os_linux_priv_t *priv);


/*
 *      wext_events.c
 */
/* Functions to generate Wireless Extension events */
void wext_send_scan_results_event(os_linux_priv_t *priv, CsrUint16 InterfaceTag);
void wext_send_assoc_event(os_linux_priv_t *priv, CsrUint16 InterfaceTag, unsigned char *bssid,
                           unsigned char *req_ie, int req_ie_len,
                           unsigned char *resp_ie, int resp_ie_len,
                           unsigned char *scan_ie, unsigned int scan_ie_len);
void wext_send_disassoc_event(os_linux_priv_t *priv, CsrUint16 InterfaceTag);
void wext_send_michaelmicfailure_event(os_linux_priv_t *priv,
                                       CsrUint16 count, CsrWifiMacAddress address,
                                       CsrWifiSmeKeyType keyType, CsrUint16 interfaceTag);
void wext_send_pmkid_candidate_event(os_linux_priv_t *priv, CsrWifiMacAddress bssid, CsrBool preauth_allowed, CsrUint16 interfaceTag);
void wext_send_started_event(os_linux_priv_t *priv, CsrUint16 interfaceTag);


static inline int uf_iwe_stream_add_point(struct iw_request_info *info, char *start, char *stop,
                                          struct iw_event *piwe, char *extra)
{
    char *new_start;

    new_start = iwe_stream_add_point(
#if defined(IW_REQUEST_FLAG_COMPAT)
        info,
#endif
        start, stop, piwe, extra);
    if (unlikely(new_start == start))
    {
        return -E2BIG;
    }

    return new_start - start;
}

static inline int uf_iwe_stream_add_event(struct iw_request_info *info, char *start, char *stop,
                                          struct iw_event *piwe, int len)
{
    char *new_start;

    new_start = iwe_stream_add_event(
#if defined(IW_REQUEST_FLAG_COMPAT)
        info,
#endif
        start, stop, piwe, len);
    if (unlikely(new_start == start))
    {
        return -E2BIG;
    }

    return new_start - start;
}

static inline int uf_iwe_stream_add_value(struct iw_request_info *info, char *stream, char *start,
                                          char *stop, struct iw_event *piwe, int len)
{
    char *new_start;

    new_start = iwe_stream_add_value(
#if defined(IW_REQUEST_FLAG_COMPAT)
        info,
#endif
        stream, start, stop, piwe, len);
    if (unlikely(new_start == start))
    {
        return -E2BIG;
    }

    return new_start - start;
}

#ifdef __cplusplus
}
#endif
#endif /* __LINUX_UNIFI_WEXT_H__ */
