/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef __UNIFI_OS_LINUX_H__
#define __UNIFI_OS_LINUX_H__ 1

#include "csr_synergy.h"

#include <linux/kernel.h>
#include <linux/time.h>
#include <linux/list.h>
#include <linux/delay.h>
#include <linux/string.h>

/*
 * Needed for core/signals.c
 */
#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Define INLINE directive*/
#define INLINE      inline

/* Malloc and free */
#define CSR_WIFI_ALIGN_BYTES    4

/* Spinlocks. These will move to framework extenstions */
typedef spinlock_t CsrSpinLock;
typedef unsigned long CsrSpinLockFlags;

/*
 * Byte Order
 * Note that __le*_to_cpu and __cpu_to_le* return an unsigned value!
 */
#ifdef __KERNEL__
#define unifi2host_16(n)    (__le16_to_cpu((n)))
#define unifi2host_32(n)    (__le32_to_cpu((n)))
#define host2unifi_16(n)    (__cpu_to_le16((n)))
#define host2unifi_32(n)    (__cpu_to_le32((n)))
#endif

/* Module parameters */
extern int unifi_debug;


#ifdef __cplusplus
}
#endif
#endif /* __UNIFI_OS_LINUX_H__ */
