/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef __LINUX_UNIFI_NATIVE_H__
#define __LINUX_UNIFI_NATIVE_H__ 1

#include "csr_synergy.h"

#include <linux/kernel.h>
#include <linux/if_arp.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 *      scan.c wext.c autojoin.c
 */

#define IE_VECTOR_MAXLEN 1024

/*
 * Utility functions
 */
unsigned char *unifi_find_info_element(int                  id,
                                             char *info,
                                             int                  len);
int unifi_add_info_element(unsigned char       *info,
                           int                  ie_id,
                           const unsigned char *ie_data,
                           int                  ie_len);

/*
 *      autojoin.c
 */
/* Higher level fns */
int unifi_autojoin(os_linux_priv_t *priv, const char *ssid);
/*
int unifi_do_scan(os_linux_priv_t *priv, int scantype, CSR_BSS_TYPE bsstype,
                  const char *ssid, int ssid_len);
*/
int unifi_set_powermode(os_linux_priv_t *priv);
int unifi_join_bss(os_linux_priv_t *priv, unsigned char *macaddr);
int unifi_leave(os_linux_priv_t *priv);
unsigned int unifi_get_wmm_bss_capabilities(os_linux_priv_t *priv,
                                            unsigned char *ie_vector,
                                            int ie_len, int *ap_capabilities);

/*
 *      mlme.c
 */
/* Abort an MLME operation - useful in error recovery */
int uf_abort_mlme(os_linux_priv_t *priv);

/*
 * Utility functions
 */
const char *lookup_reason_code(int reason);
const char *lookup_result_code(int result);


/*
 *      sme_native.c
 */
int uf_sme_init(os_linux_priv_t *priv);
void uf_sme_deinit(os_linux_priv_t *priv);
int sme_sys_suspend(os_linux_priv_t *priv);
int sme_sys_resume(os_linux_priv_t *priv);
int sme_mgt_wifi_on(os_linux_priv_t *priv);

/* Callback for event logging to SME clients (unifi_manager) */
void sme_native_log_event(ul_client_t *client,
                          const u8 *sig_packed, int sig_len,
                          const CsrWifiHipBulkDataParam *bulkdata,
                          int dir);

/* Task to query statistics from the MIB */
#define UF_SME_STATS_WQ_TIMEOUT     2000    /* in msecs */
void uf_sme_stats_wq(struct work_struct *work);

void uf_native_process_udi_signal(ul_client_t *pcli,
                                  const u8 *packed_signal,
                                  int packed_signal_len,
                                  const CsrWifiHipBulkDataParam *bulkdata, int dir);


#ifdef UNIFI_SNIFF_ARPHRD
/*
 * monitor.c
 */
int uf_start_sniff(os_linux_priv_t *priv);
/*
void ma_sniffdata_ind(void *ospriv,
                      const CSR_MA_SNIFFDATA_INDICATION *ind,
                      const CsrWifiHipBulkDataParam *bulkdata);
*/
#endif /* ARPHRD_IEEE80211_PRISM */

#ifdef __cplusplus
}
#endif
#endif /* __LINUX_UNIFI_NATIVE_H__ */
