/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#include "csr_synergy.h"
#include "csr_wifi_hip_unifi.h"
#include "os_linux_priv.h"

#include "csr_wifi_hip_log_text.h"

/*
 * ---------------------------------------------------------------------------
 *  uf_abort_mlme
 *
 *      Abort any MLME operation in progress.
 *      This is used in the error recovery mechanism.
 *
 *  Arguments:
 *      priv          Pointer to driver context.
 *
 *  Returns:
 *      0 on success.
 * ---------------------------------------------------------------------------
 */
int uf_abort_mlme(os_linux_priv_t *priv)
{
    ul_client_t *ul_cli;

    /* Ensure no MLME functions are waiting on a the mlme_event semaphore. */
    priv->io_aborted = 1;

    ul_cli = priv->netdev_client;
    if (ul_cli)
    {
        wake_up_interruptible(&ul_cli->udi_wq);
    }

    return 0;
} /* uf_abort_mlme() */
