/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef __OS_LINUX_SDIO_H__
#define __OS_LINUX_SDIO_H__

#include "csr_synergy.h"
#include "csr_sdio.h"

#ifdef CSR_WIFI_SUPPORT_MMC_DRIVER
#include <linux/mmc/core.h>
#include <linux/mmc/card.h>
#include <linux/mmc/host.h>
#include <linux/mmc/sdio_func.h>
#include <linux/mmc/sdio_ids.h>
#include <linux/mmc/sdio.h>
#endif /* CSR_WIFI_SUPPORT_MMC_DRIVER */

#ifdef __cplusplus
extern "C" {
#endif


/* This file is only intended to be used by HAL and should not be
 * included in any OS Linux specific code.
 *
 * The macros in this file extend the CsrSdio API so that it will
 * work with the Linux MMC driver.
 */

/* The _CSR_WIFI_HIP_LINUX_INSTALL_IRQ/csr_sdio_linux_install_irq and
 * _CSR_WIFI_HIP_LINUX_REMOVE_IRQ/csr_sdio_linux_remove_irq macros are
 * only supposed to be called from HAL.
 * HAL will only call these macros when the MMC driver is used, since
 * HAL already ensures that the SDIO function is enabled and disabled as
 * required, which would be the behavior in the SDIOemb driver if
 * these macros were invoked.
 */
int csr_sdio_linux_install_irq(CsrSdioFunction *sdio);
int csr_sdio_linux_remove_irq(CsrSdioFunction *sdio);
#define _CSR_WIFI_HIP_LINUX_INSTALL_IRQ(function)  csr_sdio_linux_install_irq(function)
#define _CSR_WIFI_HIP_LINUX_REMOVE_IRQ(function)   csr_sdio_linux_remove_irq(function)


/*
 * Claim/release SDIO
 *
 * These macros are only suppose to be called from HAL.
 *
 * For multifunction cards, we cannot grub the SDIO lock around the unifi_bh()
 * as this prevents other functions using SDIO.
 * Since some of CSR SDIO API is used regardless of trying to lock unifi_bh()
 * we have followed this scheme:
 * 1. If a function needs protection only when CSR_WIFI_SINGLE_FUNCTION is defined
 *    then we call CsrSdioClaim/CsrSdioRelease().
 * 2. If a function needs protection only when CSR_WIFI_SINGLE_FUNCTION is not defined
 *    then we call _sdio_claim_host/_sdio_claim_host(). Use of this should be restricted
 *    to the SDIO glue layer only (e.g. sdio_mmc.c).
 * 3. If a function needs protection, regardless of the CSR_WIFI_SINGLE_FUNCTION
 *    then we call directly the sdio_claim_host/sdio_release_host().
 *    Use of this must be restricted to the SDIO glue layer only (e.g. sdio_mmc.c).
 *
 * Note: The _func and function pointers are _not_ the same.
 * The former is the (struct sdio_func*) context, which restricts the use to the SDIO glue layer.
 * The latter is the (CsrSdioFunction*) context, which allows calls from all layers.
 */

#ifdef CSR_WIFI_SUPPORT_MMC_DRIVER

#ifdef CSR_WIFI_SINGLE_FUNCTION
#define _CsrSdioClaim(function)    sdio_claim_host((function)->priv);
#define _CsrSdioRelease(function)  sdio_release_host((function)->priv);

#define _sdio_claim_host(_func)
#define _sdio_release_host(_func)

#else
#define _CsrSdioClaim(function)
#define _CsrSdioRelease(function)

#define _sdio_claim_host(_func)     sdio_claim_host(_func)
#define _sdio_release_host(_func)   sdio_release_host(_func)

#endif /* CSR_WIFI_SINGLE_FUNCTION */

#else
#define _sdio_claim_host(_func)
#define _sdio_release_host(_func)

#define _CsrSdioClaim(function)
#define _CsrSdioRelease(function)

#endif /* CSR_WIFI_SUPPORT_MMC_DRIVER */


#ifdef __cplusplus
}
#endif
#endif /* __OS_LINUX_SDIO_H__ */
