/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef __OS_LINUX_PRIV_H__
#define __OS_LINUX_PRIV_H__ 1

#include "csr_synergy.h"
#include "csr_log_text_2.h"

#include "csr_result.h"
#include "csr_types.h"
#include "csr_sched.h"
#include "csr_wifi_vif_utils.h"

#include <linux/version.h>
#include <linux/module.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/wait.h>
#include <linux/sched.h>
#include <linux/delay.h>
#include <linux/netdevice.h>
#include <linux/wireless.h>
#include <linux/cdev.h>
#include <linux/kthread.h>
#include <linux/freezer.h>

#ifdef ANDROID_BUILD
#include <linux/wakelock.h>
#endif

#ifdef CSR_WIFI_SUPPORT_MMC_DRIVER
#include <linux/mmc/core.h>
#include <linux/mmc/card.h>
#include <linux/mmc/host.h>
#include <linux/mmc/sdio_func.h>
#include <linux/mmc/sdio_ids.h>
#include <linux/mmc/sdio.h>
#endif /* CSR_WIFI_SUPPORT_MMC_DRIVER */


#include <linux/fs.h>

#if defined CSR_WIFI_DRIVER_HYDRA && defined CSR_WIFI_DRIVER_USE_HYDRA_DRIVER
#include <hydra/service_driver.h>
#include <hydra/service.h>
#include <hydra/sdio.h>
#endif

#include "csr_wifi_hip_unifi_udi.h"
#include "csr_wifi_router_lib.h"
#include "unifiio.h"
#ifndef CSR_WIFI_HIP_TA_DISABLE
#include "csr_wifi_vif_utils.h"
#endif

#include "csr_wifi_hip.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef UNIFI_DEBUG
#ifdef CSR_LOG_ENABLE
void deinit_log_text(void);
void init_log_text(const char *trace_levels, int unifi_debug);

CSR_LOG_TEXT_HANDLE_DECLARE(CsrWifiOsLto);

/* These values must match the array positions below */
#define CSR_WIFI_OS_LTSO_INIT 1
#define CSR_WIFI_OS_LTSO_IOCTL 2
#define CSR_WIFI_OS_LTSO_UDI 3
#define CSR_WIFI_OS_LTSO_MIB 4
#define CSR_WIFI_OS_LTSO_WEXT 5
#define CSR_WIFI_OS_LTSO_SME 6
/* SDIO glue layer */
#define CSR_WIFI_OS_LTSO_SDIO 7
/* messages that report only control packets: */
#define CSR_WIFI_OS_LTSO_RXC 8
#define CSR_WIFI_OS_LTSO_TXC 9
/* messages that report only data packets: */
#define CSR_WIFI_OS_LTSO_RXD 10
#define CSR_WIFI_OS_LTSO_TXD 11
/* messages that report both data and control packets: */
#define CSR_WIFI_OS_LTSO_RX 12
#define CSR_WIFI_OS_LTSO_TX 13
#define CSR_WIFI_OS_LTSO_DEF 14
#define CSR_WIFI_OS_LTSO_ROUTERCTRL 15

/* Positions must match the index values defined above.  But beware +1 offset */
#define CSR_WIFI_OS_SUBORIGINS {"INIT", "IOCTL", "UDI", "MIB", "WEXT", "SME", "SDIO", "RXC", "TXC", "RXD", "TXD", "RX", "TX", "DEF", "ROUTERCTRL"}

#endif
#endif

/* Define the os_linux_priv_t before include the unifi_native.h */
struct os_linux_priv;
typedef struct os_linux_priv os_linux_priv_t;
#ifdef CSR_SUPPORT_WEXT_AP
struct CsrWifiSmeApConfig;
typedef struct CsrWifiSmeApConfig CsrWifiSmeApConfig_t;
#endif
#ifdef CSR_SUPPORT_WEXT
typedef struct CsrWifiFixedTxRate CsrWifiFixedTxRate;
#endif

#ifdef CSR_SUPPORT_WEXT
#include "unifi_wext.h"
#endif

#include "unifi_clients.h"


#define UF_NETIF_TX_WAKE_ALL_QUEUES(_netdev)    netif_tx_wake_all_queues(_netdev)
#define UF_NETIF_TX_START_ALL_QUEUES(_netdev)   netif_tx_start_all_queues(_netdev)
#define UF_NETIF_TX_STOP_ALL_QUEUES(_netdev)    netif_tx_stop_all_queues(_netdev)


#ifdef CSR_NATIVE_LINUX
#include "sme_native/unifi_native.h"
#else
#include "unifi_sme.h"
#endif


/*
 * MAX_UNIFI_DEVS defines the maximum number of UniFi devices that can be present.
 * This number should be set to the number of SDIO slots supported by the SDIO
 * host controller on the platform.
 * Note: If MAX_UNIFI_DEVS value changes, fw_init[] needs to be corrected in drv.c
 */
/*ALSI_DL 20140206*/
/*#define MAX_UNIFI_DEVS  2*/
#define MAX_UNIFI_DEVS  3

/* Module parameter variables */
extern int buswidth;
extern int sdio_clock;
extern int use_5g;
extern int disable_hw_reset;
extern int no_helper;
extern int disable_power_control;
extern int sme_debug;
extern int fw_init[MAX_UNIFI_DEVS];
extern int sdio_byte_mode;
extern int sdio_block_size;
extern int run_bh_once;
extern CsrWifiHipCardParams config_params;
extern int default_vif;

#ifdef ANDROID_BUILD
/* wake lock to prevent suspend while resuming and while turning wifi on */
extern struct wake_lock unifi_sdio_wake_lock;
#endif


#ifdef CSR_SUPPORT_WEXT_AP
struct CsrWifiSmeApConfig
{
    CsrWifiSsid             ssid;
    CsrUint16               channel;
    CsrWifiNmeApCredentials credentials;
    CsrUint8                max_connections;
    CsrUint8                if_index;
};
#endif
#ifdef CSR_SUPPORT_WEXT

#define CSR_WIFI_WEXT_RATE_TYPE_NONE  0
#define CSR_WIFI_WEXT_RATE_TYPE_BASIC 1
#define CSR_WIFI_WEXT_RATE_TYPE_OFDM  2
#define CSR_WIFI_WEXT_RATE_TYPE_MCS   3

struct CsrWifiFixedTxRate
{
    CsrBool  fixedTxRate;
    CsrUint8 setRate;
    CsrUint8 txRate;
    CsrUint8 type;
};
#endif


typedef struct os_linux_store_m4_info
{
    CsrUint16                  interfaceTag;
    CsrWifiMacAddress          dmac;
    CsrWifiMacAddress          smac;
    CsrUint16                  senderProcessId;
    CsrWifiHipMaPacketPriority priority;
    CsrUint16                  protocol;
    CsrBool                    cfmRequested;
    CsrUint8                   macHeaderOffset;
} os_linux_store_m4_info;


typedef CsrUint32 os_linux_netdev_state;
#define OS_LINUX_NETDEV_STATE_UNREGISTERED       ((os_linux_netdev_state) 0x0)
#define OS_LINUX_NETDEV_STATE_REGISTERED         ((os_linux_netdev_state) 0x1)
#define OS_LINUX_NETDEV_STATE_REGISTERED_STOPPED ((os_linux_netdev_state) 0x2)

typedef struct netInterface_priv
{
    CsrUint16               InterfaceTag;
    struct os_linux_priv   *privPtr;
    struct work_struct      send_m4_ready_task;
    struct net_device_stats stats;
    unsigned int            rx_stats_dropped_frames;
    __be32                  sta_ip_address;
    CsrUint8                interfaceMode;
    /*
    * Flag to reflect state of CONNECTED indication signal.
    * This indicates whether we are "joined" an Access Point (i.e. have
    * nominated an AP and are receiving beacons) but give no indication
    * of whether we are authenticated and/or associated.
    */
    enum
    {
        UnifiConnectedUnknown = -1,
        UnifiNotConnected = 0,
        UnifiConnected = 1,
    } connected;
#ifdef CSR_SUPPORT_WEXT
    /* Tracks when we are waiting for a netdevice state change callback */
    CsrBool wait_netdev_change;
    /* True if we have successfully registered for netdev callbacks */
    CsrBool netdev_callback_registered;
#endif /* CSR_SUPPORT_WEXT */
    os_linux_netdev_state netdev_state;
#define UNIFI_MAX_MULTICAST_ADDRESSES 10
    /* The multicast addresses list that the thread needs to set. */
    u8 mc_list[UNIFI_MAX_MULTICAST_ADDRESSES * ETH_ALEN];
    /* The multicast addresses count that the thread needs to set. */
    int mc_list_count;

    /* Buffered M4 signal to take care of WPA race condition */
#define CSR_WIFI_EAPOL_M4_NULL_HOST_TAG     0xffffffff
    CsrWifiMacAddress       m4_peer_mac_addr;
    CsrUint32               m4_hostTag;
    CsrWifiHipBulkDataParam m4_bulk_data;
    os_linux_store_m4_info  m4_info;
    CsrUint32               m4_pending_hostTag;

    /* UNIFI_CFG related parameters */
    uf_cfg_bcast_packet_filter_t packet_filters;
    unsigned char               *filter_tclas_ies;
#ifdef CSR_SUPPORT_WEXT
    CsrWifiFixedTxRate fixed_tx_rate;
#endif
} netInterface_priv_t;


CsrInt32 CsrHipResultToStatus(CsrResult csrResult);
CsrResult send_ma_pkt_request(os_linux_priv_t *os_linux, netInterface_priv_t *interfacePriv, struct sk_buff *skb, const struct ethhdr *ehdr);


/*
 * Some instance data utility functions
 */
int uf_find_priv(os_linux_priv_t *priv);
int uf_find_netdev_priv(netInterface_priv_t *priv);
os_linux_priv_t *uf_get_instance(int inst);
void uf_put_instance(int inst);
void uf_add_os_device(int bus_id, struct device *os_device);
void uf_remove_os_device(int bus_id);


/* Allocating function for other interfaces */
CsrBool uf_alloc_netdevice_for_other_interfaces(os_linux_priv_t *priv, CsrUint16 interfaceTag);

int uf_run_unifihelper(os_linux_priv_t *priv);

/*
 * Functions to create and delete the device nodes.
 */
int uf_create_device_nodes(os_linux_priv_t *priv, int bus_id);
void uf_destroy_device_nodes(os_linux_priv_t *priv);

/*
 * Unifi Linux functions
 */
void ul_init_clients(os_linux_priv_t *priv);

/* Configuration flags */
#define CLI_USING_WIRE_FORMAT   0x0002
#define CLI_SME_USERSPACE       0x0020
#define CLI_LOG_HOST            0x0040
#define CLI_LOG_HOST_ALL        0x0080
ul_client_t *ul_register_client(os_linux_priv_t *priv,
                                unsigned int     configuration,
                                udi_event_t      udi_event_clbk);
int ul_deregister_client(ul_client_t *pcli);

int ul_send_signal_unpacked(os_linux_priv_t         *priv,
                            netInterface_priv_t     *interfacePriv,
                            CSR_SIGNAL              *sigptr,
                            CsrWifiHipBulkDataParam *bulkdata);
int ul_send_signal_raw(os_linux_priv_t *priv,
                       unsigned char *sigptr, int siglen,
                       CsrWifiHipBulkDataParam *bulkdata);

void ul_log_config_ind(os_linux_priv_t *priv, u8 *conf_param, int len);


/*
 * Data plane operations
 */
/*
 *      data_tx.c
 */
int uf_verify_m4(os_linux_priv_t *priv, const unsigned char *packet,
                 unsigned int length);

/*
 *      netdev.c
 */

#ifndef P80211_OUI_LEN
#define P80211_OUI_LEN  3
#endif
typedef struct
{
    u8  dsap;     /* always 0xAA */
    u8  ssap;     /* always 0xAA */
    u8  ctrl;     /* always 0x03 */
    u8  oui[P80211_OUI_LEN];      /* organizational universal id */
    u16 protocol;
} __attribute__ ((packed)) llc_snap_hdr_t;
int skb_add_llc_snap(struct net_device *dev, struct sk_buff *skb, int proto);

int skb_80211_to_ether(os_linux_priv_t *priv, struct sk_buff *skb,
                       const unsigned char *daddr, const unsigned char *saddr,
                       CsrWifiHipBulkDataParam *bulkdata);

int uf_register_netdev(os_linux_priv_t *priv, CsrUint16 interfaceTag);
void uf_unregister_netdev(os_linux_priv_t *priv, CsrUint16 interfaceTag);

void uf_net_get_name(struct net_device *dev, char *name, int len);
void uf_resume_data_plane(os_linux_priv_t *priv,  CsrUint16 interfaceTag, CsrWifiHipPortType portType,
                          CsrWifiMacAddress *peer_address);

/*
 *      inet.c
 */
void uf_register_inet_notifier(void);
void uf_unregister_inet_notifier(void);


/* EAPOL PDUS */
#ifndef ETH_P_PAE
#define ETH_P_PAE 0x888e
#endif
#ifndef ETH_P_WAI
#define ETH_P_WAI 0x88b4
#endif

/*
 * putest.c
 */
int unifi_putest_start(os_linux_priv_t *priv, unsigned char *arg);
int unifi_putest_cmd52_block_read(os_linux_priv_t *priv, unsigned char *arg);
int unifi_putest_stop(os_linux_priv_t *priv, unsigned char *arg);
int unifi_putest_set_sdio_clock(os_linux_priv_t *priv, unsigned char *arg);
int unifi_putest_cmd52_read(os_linux_priv_t *priv, unsigned char *arg);
int unifi_putest_coredump_prepare(os_linux_priv_t *priv, unsigned char *arg);
int unifi_putest_cmd52_write(os_linux_priv_t *priv, unsigned char *arg);
int unifi_putest_gp_read16(os_linux_priv_t *priv, unsigned char *arg);
int unifi_putest_gp_write16(os_linux_priv_t *priv, unsigned char *arg);

int unifi_putest_dl_fw(os_linux_priv_t *priv, unsigned char *arg);
int unifi_putest_dl_fw_buff(os_linux_priv_t *priv, unsigned char *arg);

void linux_ta_indicate_protocol(os_linux_priv_t                   *priv,
                                CsrUint16                          interfaceTag,
                                CsrWifiRouterCtrlTrafficPacketType packet_type,
                                CsrWifiRouterCtrlProtocolDirection direction,
                                const CsrWifiMacAddress           *src_addr);
void linux_ta_indicate_sampling(os_linux_priv_t *priv, CsrUint16 interfaceTag, CsrWifiRouterCtrlTrafficStats *stats);


/* Macro for formatting a MAC address with a prefix string */
#define UF_TRACE_MAC(priv, lvl, msg, addr) \
    CSR_LOG_TEXT_CRITICAL((CSR_WIFI_HIP_LOG_ID, (lvl), "unifi%d: %s %02x-%02x-%02x-%02x-%02x-%02x\n", priv ? priv->instance : 0, msg, \
                           *(((CsrUint8 *) addr) + 0),  \
                           *(((CsrUint8 *) addr) + 1),  \
                           *(((CsrUint8 *) addr) + 2),  \
                           *(((CsrUint8 *) addr) + 3),  \
                           *(((CsrUint8 *) addr) + 4),  \
                           *(((CsrUint8 *) addr) + 5))

#define UF_TRACE_MAC_UDBG1(priv, msg, addr) \
    CSR_LOG_TEXT_CRITICAL((CSR_WIFI_HIP_LOG_ID, CSR_WIFI_HIP_UDBG1, "unifi%d: %s %02x-%02x-%02x-%02x-%02x-%02x\n", priv ? priv->instance : 0, msg, \
                           *(((CsrUint8 *) addr) + 0), \
                           *(((CsrUint8 *) addr) + 1), \
                           *(((CsrUint8 *) addr) + 2), \
                           *(((CsrUint8 *) addr) + 3), \
                           *(((CsrUint8 *) addr) + 4), \
                           *(((CsrUint8 *) addr) + 5) \
                           ))

#define UF_TRACE_MAC_UDBG5(priv, msg, addr) \
    CSR_LOG_TEXT_CRITICAL((CSR_WIFI_HIP_LOG_ID, CSR_WIFI_HIP_UDBG5, "unifi%d: %s %02x-%02x-%02x-%02x-%02x-%02x\n", priv ? priv->instance : 0, msg, \
                           *(((CsrUint8 *) addr) + 0), \
                           *(((CsrUint8 *) addr) + 1), \
                           *(((CsrUint8 *) addr) + 2), \
                           *(((CsrUint8 *) addr) + 3), \
                           *(((CsrUint8 *) addr) + 4), \
                           *(((CsrUint8 *) addr) + 5) \
                           ))

#define UF_TRACE_MAC_UDBG6(priv, msg, addr) \
    CSR_LOG_TEXT_CRITICAL((CSR_WIFI_HIP_LOG_ID, CSR_WIFI_HIP_UDBG6, "unifi%d: %s %02x-%02x-%02x-%02x-%02x-%02x\n", priv ? priv->instance : 0, msg, \
                           *(((CsrUint8 *) addr) + 0), \
                           *(((CsrUint8 *) addr) + 1), \
                           *(((CsrUint8 *) addr) + 2), \
                           *(((CsrUint8 *) addr) + 3), \
                           *(((CsrUint8 *) addr) + 4), \
                           *(((CsrUint8 *) addr) + 5) \
                           ))

typedef CsrUint32 os_linux_state;
#define OS_LINUX_STATE_IDLE                ((os_linux_state) 0x0)
#define OS_LINUX_STATE_ACTIVATED           ((os_linux_state) 0x1)
#define OS_LINUX_STATE_WIFI_ON_IN_PROGRESS ((os_linux_state) 0x2)
#define OS_LINUX_STATE_WIFI_ON_DONE        ((os_linux_state) 0x3)
#define OS_LINUX_STATE_UF_READY            ((os_linux_state) 0x4)

/* The device major number to use when registering the udi driver */
#define UNIFI_NAME      "unifi"

struct os_linux_priv
{
    void *hip_handle;

    os_linux_state state;

    CsrSchedQid sme_synergy_sched_queue;

    CsrUint32 sdio_block_size;

    /* Index into Unifi_instances[] for this device. */
    int instance;
    /* Reference count for this instance */
    int ref_count;

    /* Char device related structures */
    struct cdev    unifi_cdev;
    struct cdev    unifiudi_cdev;
    struct device *unifi_device;

    /* For multiple interface support */
    struct net_device        *netdev[CSR_WIFI_MAX_INTERFACES];
    struct netInterface_priv *interfacePriv[CSR_WIFI_MAX_INTERFACES];

    CsrUint8 totalInterfaceCount;

    int prev_queue;

    /* Name of node under /proc */
    char proc_entry_name[64];

    /* Our list of unifi linux clients. */
    ul_client_t ul_clients[MAX_UDI_CLIENTS];

    /* Mutex to protect using the logging hook after UDI client is gone */
    struct semaphore udi_logging_mutex;
    /* Pointer to the ul_clients[] array */
    ul_client_t *logging_client;

    /* A ul_client_t* used to send the netdev related MIB requests. */
    ul_client_t *netdev_client;

    /* The SME ul_client_t pointer. */
    ul_client_t *sme_cli;

    /* Flag to say that an operation was aborted */
    int io_aborted;

#define UNIFI_INIT_NONE         0x00
#define UNIFI_INIT_IN_PROGRESS  0x01
#define UNIFI_INIT_FW_DOWNLOADED 0x02
#define UNIFI_INIT_COMPLETED    0x04
    unsigned char init_progress;
    unsigned char init_progress_save; /* saved during cold suspend */

    CsrUint32 fw_build;

#ifdef CSR_SUPPORT_SME
    wait_queue_head_t sme_request_wq;
    /* Semaphore to protect the SME blocking requests */
    struct semaphore sme_sem;
    /* Structure to hold the SME blocking requests data*/
    sme_reply_t sme_reply;
    /* Which SME message we are waiting for.
     * This may contain a value only while the sme_sem is held
     * by the corresponding request */
    enum sme_reply_type expected_reply;


    /* Structure to hold a traffic protocol indication */
    struct ta_ind
    {
        struct work_struct                 task;
        CsrWifiRouterCtrlTrafficPacketType packet_type;
        CsrWifiRouterCtrlProtocolDirection direction;
        CsrWifiMacAddress                  src_addr;
        int                                in_use;
        CsrUint16                          interfaceTag;
    } ta_ind_work;

    struct ta_sample_ind
    {
        struct work_struct            task;
        CsrWifiRouterCtrlTrafficStats stats;
        int                           in_use;
        CsrUint16                     interfaceTag;
    } ta_sample_ind_work;

    CsrWifiRouterCtrlSmeVersions sme_versions;

    /* Userspace TaskId for the SME Set when a wifi on req is received */
    CsrSchedQid CSR_WIFI_SME_IFACEQUEUE;

    /*
     * The SME installs filters to ask for specific MA-PACKET.req
     * to be passed to different SME components.
     */
#define MAX_MA_PACKET_IND_FILTERS      8
    sme_ma_packet_ind_filter_t sme_ma_packet_ind_filters[MAX_MA_PACKET_IND_FILTERS];
    unsigned int               num_of_ma_packet_subscriptions;

    /* The structure that holds all the connection configuration. */
    CsrWifiSmeConnectionConfig connection_config;

    CsrUint32 scanInformationElementsLength;
    CsrUint8 *scanInformationElements;


#ifdef CSR_SUPPORT_WEXT
    int                  ignore_bssid_join;
    struct iw_statistics wext_wireless_stats;
    int                  wep_tx_key_index;
    wep_key_t            wep_keys[NUM_WEPKEYS];
#ifdef CSR_SUPPORT_WEXT_AP
    CsrWifiWextApMacConfig ap_mac_config;
    CsrWifiWextApConfig    group_sec_config;
    CsrWifiSmeApConfig_t   ap_config;
#endif

    struct work_struct sme_config_task;
#endif /* CSR_SUPPORT_WEXT */
#endif /* CSR_SUPPORT_SME */


#ifdef CSR_SME_USERSPACE
    void *smepriv;
#endif /* CSR_SME_USERSPACE */


    /*
     * The workqueue to offload the TA run
     * and the multicast addresses list set
     */
    struct workqueue_struct *unifi_workqueue;
    struct work_struct       multicast_list_task;

    int ptest_mode;     /* Set when in production test mode */
    int coredump_mode;     /* Set when SME has requested a coredump */

    /* Spinlock to protect M4 data */
    spinlock_t m4_lock;

#if defined CSR_WIFI_DRIVER_HYDRA && defined CSR_WIFI_DRIVER_USE_HYDRA_DRIVER
    int                     hydra_service_enabled;
    struct hydra_sdio_func *hyfn;
#endif
};

void uf_release_instance(int inst);
CsrResult uf_add_instance(CsrUint32 *instance);
os_linux_priv_t *uf_find_instance(int inst);

CsrResult register_unifi_linux(void *hip_handle, int bus_id);
void unregister_unifi_linux(int bus_id);


/*
 * Functions to allocate and free an ethernet device.
 */
os_linux_priv_t *uf_alloc_netdevice(int bus_id);
int uf_free_netdevice(os_linux_priv_t *priv);

void indicate_rx_skb(os_linux_priv_t *priv, CsrUint16 ifTag, CsrUint8 *dst_a, CsrUint8 *src_a, struct sk_buff *skb,
                     CsrWifiHipBulkDataParam *bulkdata, CsrResult receptionResult, CsrInt16 rssi, CsrInt16 snr, CsrUint16 rate);

void os_linux_net_data_free(void *ospriv, CsrWifiHipBulkDataDesc *bulk_data_slot);
void os_linux_net_data_free_all(void *ospriv, CsrWifiHipBulkDataParam *bulk_data);
CsrResult os_linux_net_data_malloc(void *ospriv, CsrWifiHipBulkDataDesc *bulk_data_slot, unsigned int size);


/*
 *  Flow control handling
 */
void os_linux_flow_control_resume_cb(void *osLayerContext, CsrUint16 interfaceTag, CsrUint16 aid, CsrWifiHipTrafficQueue queue);
void os_linux_flow_control_pause_cb(void *osLayerContext, CsrUint16 interfaceTag, CsrUint16 aid, CsrWifiHipTrafficQueue queue);

#ifdef CSR_NATIVE_LINUX
#define CSR_WIFI_HIP_IEEE80211_FCTL_TO_DS       0x0100
#define CSR_WIFI_HIP_IEEE80211_FCTL_FROM_DS     0x0200

#define CSR_WIFI_HIP_IEEE80211_HAS_TO_DS(fc)   (((fc & CSR_WIFI_HIP_IEEE80211_FCTL_TO_DS)) ? 1 : 0)
#define CSR_WIFI_HIP_IEEE80211_HAS_FROM_DS(fc) (((fc & CSR_WIFI_HIP_IEEE80211_FCTL_FROM_DS)) ? 1 : 0)
#endif

#if defined CSR_WIFI_DRIVER_HYDRA && defined CSR_WIFI_DRIVER_USE_HYDRA_DRIVER
CsrResult uf_start_hydra_wlan_service(os_linux_priv_t *linux_priv);
void uf_stop_hydra_wlan_service(os_linux_priv_t *linux_priv);
#endif

#ifdef __cplusplus
}
#endif
#endif /* __OS_LINUX_PRIV_H__ */
