/*****************************************************************************

            (c) Cambridge Silicon Radio Limited 2010
            All rights reserved

            Refer to LICENSE.txt included with this source for details
            on the license terms.

*****************************************************************************/

#include "csr_synergy.h"

#include <linux/kernel.h>
#include <linux/version.h>


#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 33)
#include <linux/autoconf.h>
#elif LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 16)
#include <linux/config.h>
#endif

#include <linux/slab.h>

#include "csr_panic.h"
#include "csr_pmem.h"

#ifdef CSR_PMEM_DEBUG
#undef CsrPmemAlloc
void *CsrPmemAlloc(CsrSize size)
{
    return CsrPmemAllocDebug(size, "n/a", 0);
}

void *CsrPmemAllocDebug(CsrSize size,
    const CsrCharString *file, CsrUint32 line)
#else
void *CsrPmemAlloc(CsrSize size)
#endif
{
    void *ret;

#ifdef CSR_PMEM_DEBUG
    CSR_UNUSED(file);
    CSR_UNUSED(line);
#endif

    ret = kmalloc(size, GFP_KERNEL);
    if (!ret)
    {
        CsrPanic(CSR_TECH_FW, CSR_PANIC_FW_HEAP_EXHAUSTION,
            "out of memory");
    }

    return ret;
}

void CsrPmemFree(void *ptr)
{
    if (ptr == NULL)
    {
        return;
    }

    kfree(ptr);
}
