/*
 * mxc_mlb_ext.h
 *
 * Copyright 2012-2013 CETITEC GmbH. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#ifndef MXC_MLB_EXT
#define MXC_MLB_EXT

#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/initval.h>

#include "mxc_mlb.h"
#include <linux/cdev.h>
#include <linux/fsl_devices.h>

#define MLB_STATIC_MINOR_DEVS	3
#define MLB_MAX_SYNC_DEVICES	6
/* 3 for control, async and isoc; 6 for dynamically allocated sync channels */
#define MLB_MAX_DEVICES	(MLB_STATIC_MINOR_DEVS + MLB_MAX_SYNC_DEVICES)

#define MLB_USE_MFE

#ifdef MLB_USE_MFE
#define FCNT_VALUE 6		/* 2^FCNT_VALUE = frames per sub-buffer */
#else
#define FCNT_VALUE 0
#endif

#define SYNC_BUFFER_DEP_MIN (2 * (1<<FCNT_VALUE) * 4)
#define SYNC_BUFFER_DEP (4 * (1<<FCNT_VALUE) * 4)
#define BUF_RING_NODES 10

enum channelmode {
	MLB_RDONLY,
	MLB_WRONLY,
	MLB_RDWR
};

struct mlb_data {
	struct mlb_dev_info *devinfo;
	struct clk *clk_mlb3p;
	struct clk *clk_mlb6p;
	struct cdev cdev;
	struct class *class;	/* device class */
	dev_t firstdev;
	void __iomem *membase;	/* mlb module base address */
	u32 irq_ahb0;
	u32 irq_ahb1;
	u32 irq_mlb;
	struct device *dev;
};

extern u32 number_sync_channels;

s32 mlb_start_tx(struct mlb_data *drvdata, int minor, u32 buf_addr);

void mxc_mlb150_chan_setaddr(struct mlb_data *drvdata, int minor,
			unsigned int caddr);
int mxc_mlb150_chan_startup(struct mlb_data *drvdata, int minor,
			enum channelmode mode,
			unsigned int audio_channels);
int mxc_mlb150_chan_shutdown(struct mlb_data *drvdata, int minor,
			enum channelmode mode);
int mxc_mlb150_do_open(struct mlb_data *drvdata, int minor,
		u8 **buf_virt, u32 *buf_phys);
int mxc_mlb150_do_release(struct mlb_data *drvdata, int minor,
			enum channelmode mode);

void ext_set_drvdata(struct mlb_data *drvdata);

void ext_start_rx(unsigned int minor, unsigned int channel_type, u32 *rpos);
void ext_start_tx(unsigned int minor, unsigned int channel_type);

/* interface to syncsound */

int
register_syncsound_callbacks(void (*playback_callback) (u32 *,
							struct snd_pcm_substream
							*),
			     void (*capture_callback) (u32 *,
						       struct snd_pcm_substream
						       *));
void unregister_syncsound_callbacks(void);

int register_syncsound_substream(int sync_device_index,
				 struct snd_pcm_substream *substream);
int unregister_syncsound_substream(int sync_device_index);

int syncsound_open(int sync_device_index, enum channelmode mode, u8 **buf_virt,
			u32 *buf_phys);
int syncsound_release(int sync_device_index);
int syncsound_chan_startup(int sync_device_index, unsigned int audio_channels);
int syncsound_chan_shutdown(int sync_device_index);
u32 syncsound_get_num_devices(void);
int syncsound_start_playback(int sync_device_index, u32 phy_addr);

void *alloc_ext_mem(size_t buf_size, dma_addr_t *dma_handle);
int mmap_ext_mem(struct vm_area_struct *vma, void *cpu_addr,
		 dma_addr_t dma_addr, size_t size);
void free_ext_mem(size_t buf_size, void *buf, dma_addr_t dma_handle);

#endif /* MXC_MLB_EXT */
