/*
 * Copyright (C) 2012 Mentor Graphics Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */
#include <linux/export.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/delay.h>
#include <linux/io.h>
#include <linux/err.h>
#include <linux/platform_device.h>
#include <linux/clk.h>
#include <linux/clk-provider.h>
#include <linux/clkdev.h>

#include "ipu-prv.h"

struct ipu_irt {
	u32 module;
	spinlock_t lock;
	int use_count;
	struct ipu_soc *ipu;
};


int ipu_irt_enable(struct ipu_irt *irt)
{
	unsigned long flags;

	spin_lock_irqsave(&irt->lock, flags);

	if (!irt->use_count)
		ipu_module_enable(irt->ipu, irt->module);

	irt->use_count++;

	spin_unlock_irqrestore(&irt->lock, flags);

	return 0;
}
EXPORT_SYMBOL_GPL(ipu_irt_enable);

int ipu_irt_disable(struct ipu_irt *irt)
{
	unsigned long flags;

	spin_lock_irqsave(&irt->lock, flags);

	irt->use_count--;

	if (!irt->use_count)
		ipu_module_disable(irt->ipu, irt->module);

	if (irt->use_count < 0)
		irt->use_count = 0;

	spin_unlock_irqrestore(&irt->lock, flags);

	return 0;
}
EXPORT_SYMBOL_GPL(ipu_irt_disable);

struct ipu_irt *ipu_irt_get(struct ipu_soc *ipu)
{
	return ipu->irt_priv;
}
EXPORT_SYMBOL_GPL(ipu_irt_get);

void ipu_irt_put(struct ipu_irt *irt)
{
}
EXPORT_SYMBOL_GPL(ipu_irt_put);

int ipu_irt_init(struct ipu_soc *ipu, struct device *dev, u32 module)
{
	struct ipu_irt *irt;

	irt = devm_kzalloc(dev, sizeof(*irt), GFP_KERNEL);
	if (!irt)
		return -ENOMEM;

	ipu->irt_priv = irt;

	spin_lock_init(&irt->lock);
	irt->module = module;
	irt->ipu = ipu;

	return 0;
}

void ipu_irt_exit(struct ipu_soc *ipu)
{
}
