/*
 * Copyright (C) 2013 Robert Bosch Car Multimedia GmbH
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __TI_DS90UB92X_H
#define __TI_DS90UB92X_H

#include <linux/types.h>

enum {
	GPIO_FUNCTION,
	GPIO_INPUT,
	GPIO_OUTPUT_LOCAL,
	GPIO_OUTPUT_REMOTE,
};

struct gpio_bridge {
	unsigned char	base;
#define TI_MAX_PINS	32
	unsigned char	pin_num;
	unsigned char	gpio_direction[TI_MAX_PINS];
};

struct i2c_bridge {
	unsigned int num;
#define TI_MAX_I2C_SLAVES 7
	unsigned char address[TI_MAX_I2C_SLAVES];
	unsigned char alias[TI_MAX_I2C_SLAVES];
};

enum {
	VIDEO_BITFMT_18BIT,
	VIDEO_BITFMT_24BIT,
	VIDEO_BITFMT_INVALID,
};

enum {
	VIDEO_BITMSB_LSB,
	VIDEO_BITMSB_MSB,
	VIDEO_BITMSB_INVALID,
};

struct video_bridge {
	unsigned int bitfmt;	/* 0: 18bits	1: 24bits */
	unsigned int bitmsb;	/* 0: LSBS	1: MSBS */
};

struct ds90uh926q_data {
	struct gpio_bridge gpio;
};

struct ds90ub927q_data {
	unsigned int bcmode;
	unsigned int lfmode;
	unsigned int rx_irq;
	unsigned int des_slave_addr;

	struct gpio_bridge gpio;
	struct i2c_bridge i2c;
	struct video_bridge video;
};

struct ds90ub92x_device {
	int power_pin;
	enum of_gpio_flags power_active;
	struct i2c_client *client;
	void *chip_data; /* Chip data pointer */
};

#endif /* __TI_DS90UB92X_H */
