/***********************************************************************
 * \file: masca_util_rspc_scramble_table.h
 *
 * \version:
 *
 * \release:
 *
 * Interface description for the RSPC (Read Solomon Product like Correction)
 * library.
 *
 * \component: UTIL Library (UTIL LIB)
 *
 * \author          Kurt Gieske kgieske (at) de.adit-jv.com
 * \author          Simon Maleyka smaleyka (at) de.adit-jv.com
 * \author          Christoph Gellner cgellner (at) de.adit-jv.com
 * \author          sundhar.ashokan@in.bosch.com
 * \author          saurabh.arora@in.bosch.com
 * Copyright (C) 2013 ADIT Corporation
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 ***********************************************************************/

#ifndef __MASCA_UTIL_RSPC_SCRAMBLE_TABLE_H_
#define __MASCA_UTIL_RSPC_SCRAMBLE_TABLE_H_

#include "masca_util_rspc.h"

#ifdef UTIL_RSPC_CDED_BYTE_SWAP
static const unsigned char util_rspc_yellowbook_scrambler[2340] = {
	0x80, 0x01, 0x60, 0x00, 0x28, 0x00, 0x1e, 0x00, 0x08, 0x80, 0x06, 0x60,
							 0x02, 0xa8, 0x81, 0xfe,
	0x60, 0x80, 0x28, 0x60, 0x1e, 0x28, 0x88, 0x9e, 0x66, 0x68, 0xaa, 0xae,
							 0x7f, 0xfc, 0xe0, 0x01,
	0x48, 0x00, 0x36, 0x00, 0x16, 0x80, 0x0e, 0xe0, 0x04, 0xc8, 0x83, 0x56,
							 0xe1, 0x7e, 0x48, 0xe0,
	0x36, 0x48, 0x96, 0xb6, 0xee, 0xf6, 0xcc, 0xc6, 0xd5, 0x52, 0x9f, 0xfd,
							 0xa8, 0x01, 0x7e, 0x00,
	0x20, 0x80, 0x18, 0x60, 0x0a, 0x28, 0x87, 0x9e, 0x62, 0x28, 0xa9, 0x9e,
							 0x7e, 0xa8, 0xa0, 0xfe,
	0x78, 0x40, 0x22, 0x30, 0x19, 0x94, 0x4a, 0xaf, 0x37, 0xfc, 0xd6, 0x01,
							 0x5e, 0x80, 0x38, 0xe0,
	0x12, 0x48, 0x8d, 0xb6, 0xe5, 0xb6, 0xcb, 0xb6, 0xd7, 0x36, 0xde, 0x56,
							 0xd8, 0xbe, 0x5a, 0x70,
	0x3b, 0xa4, 0x53, 0x3b, 0x7d, 0x53, 0xe1, 0xfd, 0x88, 0x81, 0x66, 0x60,
							 0x2a, 0xa8, 0x9f, 0xfe,
	0x68, 0x00, 0x2e, 0x00, 0x1c, 0x80, 0x09, 0x60, 0x06, 0xe8, 0x82, 0xce,
							 0x61, 0xd4, 0x68, 0x9f,
	0x2e, 0x68, 0x9c, 0xae, 0x69, 0x7c, 0xee, 0xe1, 0x4c, 0xc8, 0xb5, 0x56,
							 0xf7, 0xfe, 0x46, 0x00,
	0x32, 0x80, 0x15, 0xe0, 0x0f, 0x88, 0x84, 0x26, 0xe3, 0x1a, 0x09, 0x4b,
							 0x46, 0xf7, 0xb2, 0xc6,
	0xf5, 0xd2, 0x87, 0x9d, 0xa2, 0x29, 0xf9, 0x9e, 0x42, 0xa8, 0xb1, 0xfe,
							 0x74, 0x80, 0x27, 0x60,
	0x1a, 0x68, 0x8b, 0xae, 0x67, 0x3c, 0xea, 0x51, 0x4f, 0xbc, 0xf4, 0x31,
							 0x47, 0x14, 0x72, 0x4f,
	0x25, 0xb4, 0x5b, 0xb7, 0xbb, 0x36, 0xf3, 0x56, 0xc5, 0x7e, 0x53, 0xe0,
							 0x3d, 0x08, 0x91, 0xc6,
	0xec, 0x92, 0x8d, 0x6d, 0xa5, 0xed, 0xbb, 0x8d, 0xb3, 0x25, 0x35, 0x5b,
							 0x57, 0xfb, 0x7e, 0x03,
	0xe0, 0x81, 0x48, 0x60, 0x36, 0x28, 0x96, 0x9e, 0x6e, 0xe8, 0xac, 0xce,
							 0x7d, 0x54, 0x61, 0xff,
	0x28, 0x80, 0x1e, 0x60, 0x08, 0xa8, 0x86, 0x7e, 0x62, 0xa0, 0x29, 0xf8,
							 0x9e, 0x82, 0xa8, 0xe1,
	0x7e, 0x48, 0xa0, 0xb6, 0xf8, 0x76, 0xc2, 0x26, 0xd1, 0x9a, 0x1c, 0xab,
							 0x49, 0x7f, 0x36, 0xe0,
	0x16, 0xc8, 0x8e, 0xd6, 0xe4, 0xde, 0x4b, 0x58, 0xb7, 0x7a, 0x36, 0x63,
							 0xd6, 0xa9, 0xde, 0xfe,
	0x58, 0xc0, 0x3a, 0x50, 0x13, 0xbc, 0xcd, 0x31, 0x55, 0xd4, 0x7f, 0x9f,
							 0x20, 0x28, 0x98, 0x1e,
	0x6a, 0x08, 0xaf, 0x86, 0xfc, 0x22, 0x81, 0x19, 0xe0, 0xca, 0x08, 0x57,
							 0x86, 0x3e, 0x62, 0x90,
	0x29, 0xec, 0xde, 0x8d, 0x98, 0xe5, 0x2a, 0x4b, 0x5f, 0xb7, 0xb8, 0x36,
							 0xf2, 0x16, 0xc5, 0x8e,
	0x53, 0xa4, 0x7d, 0x3b, 0x61, 0xd3, 0xe8, 0x9d, 0x8e, 0x69, 0xe4, 0xae,
							 0x4b, 0x7c, 0xf7, 0x61,
	0x46, 0x68, 0xb2, 0xae, 0x75, 0xfc, 0xe7, 0x81, 0x4a, 0x20, 0x37, 0x98,
							 0x96, 0x2a, 0x2e, 0x9f,
	0x1c, 0xe8, 0x89, 0x4e, 0x66, 0xf4, 0x6a, 0xc7, 0xaf, 0xd2, 0xbc, 0x1d,
							 0xb1, 0x09, 0xf4, 0xc6,
	0xc7, 0x52, 0x92, 0x7d, 0xad, 0xa1, 0x7d, 0xb8, 0xa1, 0xb2, 0xb8, 0xb5,
							 0x32, 0x77, 0x95, 0xa6,
	0xef, 0xba, 0x0c, 0x33, 0xc5, 0x15, 0x13, 0xcf, 0x0d, 0x14, 0x45, 0xcf,
							 0x33, 0x94, 0x55, 0x2f,
	0x3f, 0xdc, 0xd0, 0x19, 0xdc, 0x0a, 0x19, 0x07, 0x8a, 0xc2, 0xa7, 0xd1,
							 0x7a, 0x1c, 0xe3, 0x89,
	0xc9, 0x26, 0xd6, 0xda, 0x1e, 0xdb, 0x48, 0xdb, 0x76, 0x5b, 0x66, 0xbb,
							 0x6a, 0xf3, 0xef, 0xc5,
	0x0c, 0x13, 0xc5, 0x0d, 0x93, 0xc5, 0x2d, 0x13, 0xdd, 0xcd, 0x99, 0x95,
							 0x2a, 0xaf, 0x1f, 0xfc,
	0xc8, 0x01, 0x56, 0x00, 0x3e, 0x80, 0x10, 0xe0, 0x0c, 0x48, 0x85, 0x36,
							 0xe3, 0xd6, 0xc9, 0x1e,
	0x56, 0xc8, 0xbe, 0xd6, 0xf0, 0xde, 0x44, 0x58, 0xb3, 0x3a, 0x35, 0x53,
							 0xd7, 0xfd, 0x9e, 0x01,
	0x68, 0x80, 0x2e, 0x60, 0x1c, 0xa8, 0x89, 0x7e, 0x66, 0xe0, 0x2a, 0xc8,
							 0x9f, 0xd6, 0xe8, 0x1e,
	0x4e, 0x08, 0xb4, 0x86, 0xf7, 0x62, 0x86, 0x69, 0xe2, 0xae, 0x49, 0xfc,
							 0xf6, 0x81, 0x46, 0xe0,
	0x32, 0xc8, 0x95, 0xd6, 0xef, 0x9e, 0x4c, 0x28, 0xb5, 0x1e, 0x77, 0xc8,
							 0xa6, 0x16, 0xfa, 0x8e,
	0x43, 0xe4, 0x71, 0x0b, 0x64, 0xc7, 0xab, 0x52, 0xbf, 0x7d, 0xb0, 0x61,
							 0x74, 0x28, 0xa7, 0x1e,
	0x7a, 0x48, 0xa3, 0xb6, 0xf9, 0x36, 0xc2, 0xd6, 0xd1, 0xde, 0x5c, 0x98,
							 0xb9, 0x6a, 0x32, 0xef,
	0x15, 0xcc, 0xcf, 0x95, 0x14, 0x2f, 0x0f, 0x1c, 0xc4, 0x49, 0xd3, 0x36,
							 0xdd, 0x56, 0xd9, 0xfe,
	0x5a, 0x80, 0x3b, 0xe0, 0x13, 0x08, 0x8d, 0x46, 0xe5, 0xf2, 0x8b, 0x85,
							 0x27, 0x23, 0xda, 0x59,
	0xdb, 0xba, 0x1b, 0x33, 0xcb, 0x55, 0x17, 0x7f, 0x0e, 0x60, 0x04, 0xa8,
							 0x83, 0x7e, 0x61, 0x60,
	0x28, 0xe8, 0x9e, 0x4e, 0x68, 0xb4, 0x6e, 0x77, 0xac, 0xa6, 0xfd, 0x7a,
							 0x01, 0xe3, 0xc0, 0x89,
	0xd0, 0x66, 0xdc, 0x2a, 0x19, 0x1f, 0x0a, 0xc8, 0x87, 0xd6, 0xe2, 0x1e,
							 0x49, 0x88, 0xb6, 0xa6,
	0xf6, 0xfa, 0x06, 0xc3, 0xc2, 0xd1, 0x51, 0xdc, 0xfc, 0x99, 0xc1, 0x6a,
							 0x10, 0xef, 0x0c, 0x4c,
	0xc5, 0x35, 0x13, 0xd7, 0x8d, 0x1e, 0x65, 0xc8, 0xab, 0x96, 0xff, 0x2e,
							 0x40, 0x5c, 0xf0, 0x39,
	0xc4, 0x12, 0x93, 0x0d, 0xad, 0x45, 0x3d, 0xf3, 0xd1, 0x85, 0x1c, 0xa3,
							 0xc9, 0x79, 0xd6, 0xe2,
	0x9e, 0xc9, 0xe8, 0xd6, 0xce, 0x5e, 0x54, 0xb8, 0xbf, 0x72, 0xb0, 0x65,
							 0x34, 0x2b, 0x57, 0x1f,
	0x3e, 0x48, 0x90, 0xb6, 0xec, 0x76, 0xcd, 0x26, 0xd5, 0xda, 0x1f, 0x9b,
							 0x48, 0x2b, 0x76, 0x1f,
	0x26, 0x88, 0x9a, 0xe6, 0xeb, 0xca, 0x0f, 0x17, 0x84, 0x4e, 0x63, 0x34,
							 0x69, 0x57, 0xae, 0xfe,
	0x7c, 0xc0, 0x21, 0x50, 0x18, 0xfc, 0xca, 0x41, 0x57, 0xb0, 0x3e, 0x34,
							 0x50, 0x97, 0xbc, 0x6e,
	0x71, 0x2c, 0xe4, 0xdd, 0x8b, 0x59, 0xe7, 0x7a, 0x0a, 0x63, 0xc7, 0xa9,
							 0xd2, 0x3e, 0x5d, 0x90,
	0x39, 0xac, 0xd2, 0xbd, 0x9d, 0xf1, 0x69, 0x84, 0x6e, 0xa3, 0xec, 0xf9,
							 0xcd, 0x42, 0x95, 0xf1,
	0x6f, 0x84, 0x6c, 0x23, 0xed, 0x19, 0xcd, 0xca, 0x15, 0x97, 0x8f, 0xae,
							 0x64, 0x3c, 0xeb, 0x11,
	0x4f, 0x4c, 0xf4, 0x75, 0x07, 0x27, 0x82, 0x5a, 0x21, 0xbb, 0x58, 0xb3,
							 0xfa, 0x75, 0x03, 0xa7,
	0x81, 0x3a, 0x20, 0xd3, 0xd8, 0x5d, 0x9a, 0x39, 0xeb, 0x92, 0x8f, 0x2d,
							 0xa4, 0x5d, 0xbb, 0x39,
	0xf3, 0x52, 0x85, 0x7d, 0xa3, 0xe1, 0x79, 0x08, 0xa2, 0xc6, 0xf9, 0xd2,
							 0x82, 0x9d, 0xa1, 0xe9,
	0xf8, 0x8e, 0x42, 0x64, 0x71, 0xab, 0x64, 0xbf, 0x2b, 0x70, 0x1f, 0x64,
							 0x48, 0x6b, 0x76, 0x2f,
	0x26, 0x9c, 0xda, 0xe9, 0xdb, 0xce, 0x5b, 0x14, 0x7b, 0x4f, 0x23, 0x74,
							 0x59, 0x67, 0xba, 0xea,
	0x33, 0xcf, 0x15, 0x14, 0x4f, 0xcf, 0x34, 0x14, 0x57, 0x0f, 0x3e, 0x44,
							 0x50, 0xb3, 0xfc, 0x75,
	0x01, 0x27, 0x80, 0xda, 0x20, 0x5b, 0x58, 0x3b, 0x7a, 0x13, 0xe3, 0x8d,
							 0x89, 0x25, 0x26, 0xdb,
	0x5a, 0xdb, 0x7b, 0xdb, 0x63, 0x1b, 0x69, 0x4b, 0x6e, 0xf7, 0xac, 0xc6,
							 0xfd, 0x52, 0x81, 0xfd,
	0xa0, 0x81, 0x78, 0x60, 0x22, 0x28, 0x99, 0x9e, 0x6a, 0xa8, 0xaf, 0xfe,
							 0x7c, 0x00, 0x21, 0x00,
	0x18, 0xc0, 0x0a, 0x50, 0x07, 0xbc, 0xc2, 0x31, 0x51, 0x94, 0x7c, 0xaf,
							 0x21, 0x7c, 0xd8, 0xe1,
	0x5a, 0x48, 0xbb, 0xb6, 0xf3, 0x36, 0xc5, 0x56, 0xd3, 0xfe, 0x5d, 0x00,
							 0x39, 0xc0, 0x12, 0x90,
	0x0d, 0xec, 0xc5, 0x8d, 0x93, 0xa5, 0x2d, 0x3b, 0x5d, 0xd3, 0xf9, 0x9d,
							 0x82, 0xa9, 0xe1, 0xfe,
	0x48, 0x80, 0x36, 0x60, 0x16, 0xa8, 0x8e, 0xfe, 0x64, 0xc0, 0x2b, 0x50,
							 0x1f, 0x7c, 0xc8, 0x61,
	0x56, 0x28, 0xbe, 0x9e, 0x70, 0xe8, 0xa4, 0x4e, 0x7b, 0x34, 0x63, 0x57,
							 0xa9, 0x7e, 0x7e, 0xe0,
	0x20, 0xc8, 0x98, 0x56, 0xea, 0x3e, 0x4f, 0x90, 0x34, 0x2c, 0xd7, 0x1d,
							 0x9e, 0x49, 0xe8, 0xb6,
	0xce, 0x76, 0xd4, 0xa6, 0xdf, 0x7a, 0x18, 0x63, 0xca, 0x29, 0xd7, 0x9e,
							 0x5e, 0x28, 0xb8, 0x9e,
	0x72, 0x68, 0xa5, 0xae, 0x7b, 0xbc, 0xe3, 0x31, 0x49, 0x54, 0x76, 0xff,
							 0x26, 0xc0, 0x1a, 0xd0,
	0x0b, 0xdc, 0xc7, 0x19, 0xd2, 0x4a, 0x1d, 0xb7, 0x89, 0xb6, 0xe6, 0xb6,
							 0xca, 0xf6, 0xd7, 0xc6,
	0xde, 0x12, 0x98, 0x8d, 0xaa, 0x65, 0x3f, 0xab, 0x50, 0x3f, 0x3c, 0x10,
							 0x11, 0x0c, 0xcc, 0xc5,
	0x15, 0x53, 0xcf, 0xfd, 0x94, 0x01, 0x6f, 0x00, 0x2c, 0x40, 0x1d, 0x30,
							 0x09, 0xd4, 0x46, 0x9f,
	0x32, 0xe8, 0x95, 0xce, 0x6f, 0x94, 0x6c, 0x2f, 0x2d, 0x1c, 0xdd, 0xc9,
							 0xd9, 0x96, 0xda, 0xae,
	0x5b, 0xfc, 0xfb, 0x01, 0x43, 0x40, 0x31, 0x70, 0x14, 0xe4, 0x4f, 0x4b,
							 0x74, 0x77, 0xa7, 0x26,
	0xfa, 0x5a, 0x03, 0xbb, 0x41, 0x33, 0xf0, 0xd5, 0x04, 0x5f, 0x03, 0x38,
							 0x81, 0x52, 0xa0, 0xfd,
	0xb8, 0x41, 0x72, 0x30, 0x25, 0x94, 0x5b, 0xaf, 0x3b, 0x3c, 0xd3, 0x51,
							 0x5d, 0x7c, 0xf9, 0xe1,
	0x42, 0x88, 0xb1, 0xe6, 0xf4, 0x8a, 0x07, 0x67, 0x82, 0x6a, 0x21, 0xaf,
							 0x18, 0xbc, 0xca, 0x71,
	0x57, 0xa4, 0x7e, 0x3b, 0x60, 0x93, 0xe8, 0x6d, 0x8e, 0x2d, 0xa4, 0x9d,
							 0xbb, 0x69, 0xf3, 0x6e,
	0x45, 0x6c, 0xf3, 0xed, 0x85, 0x0d, 0xa3, 0xc5, 0x39, 0x13, 0xd2, 0xcd,
							 0x9d, 0xd5, 0x29, 0x9f,
	0x1e, 0xa8, 0x88, 0xfe, 0x66, 0x40, 0x2a, 0xb0, 0x1f, 0xf4, 0x48, 0x07,
							 0xb6, 0x02, 0xb6, 0x81,
	0x76, 0xe0, 0x26, 0xc8, 0x9a, 0xd6, 0xeb, 0xde, 0x4f, 0x18, 0xb4, 0x4a,
							 0x37, 0x37, 0x96, 0x56,
	0xee, 0xbe, 0x4c, 0xf0, 0x35, 0x44, 0x57, 0xf3, 0xfe, 0x05, 0x00, 0x83,
							 0xc0, 0x61, 0x50, 0x28,
	0xbc, 0x1e, 0x71, 0x08, 0xa4, 0xc6, 0xfb, 0x52, 0x83, 0x7d, 0xa1, 0x61,
							 0x78, 0xe8, 0xa2, 0x4e,
	0x79, 0xb4, 0x62, 0xb7, 0xa9, 0xf6, 0xfe, 0x86, 0xc0, 0xe2, 0x90, 0x49,
							 0xec, 0x36, 0xcd, 0x16,
	0xd5, 0xce, 0x5f, 0x94, 0x78, 0x2f, 0x22, 0x1c, 0xd9, 0x89, 0xda, 0xa6,
							 0xdb, 0xfa, 0x1b, 0x03,
	0xcb, 0x41, 0x57, 0x70, 0x3e, 0x64, 0x50, 0xab, 0x7c, 0x7f, 0x21, 0x20,
							 0x18, 0xd8, 0x8a, 0x5a,
	0x27, 0xbb, 0x5a, 0x33, 0xfb, 0x95, 0x03, 0x2f, 0x01, 0x5c, 0xc0, 0xf9,
							 0xd0, 0x42, 0x9c, 0x31,
	0x69, 0x14, 0x6e, 0xcf, 0x2c, 0xd4, 0x5d, 0x5f, 0x39, 0xf8, 0x92, 0x82,
							 0xad, 0xe1, 0x7d, 0x88,
	0xa1, 0xa6, 0xf8, 0xba, 0x02, 0x73, 0xc1, 0xa5, 0x10, 0xbb, 0x4c, 0x73,
							 0xf5, 0x25, 0x07, 0xdb,
	0x42, 0x1b, 0x71, 0x8b, 0x64, 0xa7, 0xab, 0x7a, 0x3f, 0x63, 0xd0, 0x69,
							 0xdc, 0x2e, 0x59, 0x1c,
	0xfa, 0xc9, 0xc3, 0xd6, 0xd1, 0x1e, 0x5c, 0xc8, 0xb9, 0x56, 0xf2, 0xfe,
							 0x45, 0xc0, 0x33, 0x90,
	0x15, 0x2c, 0xcf, 0xdd, 0x94, 0x19, 0xef, 0x0a, 0x0c, 0x47, 0x85, 0x32,
							 0xa3, 0xd5, 0x39, 0x1f,
	0x12, 0xc8, 0x8d, 0xd6, 0xe5, 0x9e, 0x4b, 0xa8, 0xb7, 0x3e, 0x76, 0x50,
							 0x26, 0xbc, 0xda, 0xf1,
	0x5b, 0xc4, 0x7b, 0x13, 0xe3, 0x4d, 0x89, 0x75, 0x26, 0xe7, 0x9a, 0xca,
							 0x2b, 0xd7, 0x9f, 0x1e,
	0x68, 0x48, 0xae, 0x36, 0xfc, 0x96, 0xc1, 0x6e, 0x50, 0xec, 0xfc, 0x4d,
							 0x81, 0x35, 0x20, 0xd7,
	0x98, 0x5e, 0x6a, 0x38, 0xaf, 0x92, 0xbc, 0x2d, 0xb1, 0x1d, 0xb4, 0xc9,
							 0xf7, 0x56, 0xc6, 0x7e,
	0x52, 0xa0, 0x3d, 0xf8, 0x91, 0x82, 0xac, 0xa1, 0x7d, 0x78, 0xa1, 0xe2,
							 0xb8, 0x89, 0xf2, 0x66,
	0xc5, 0xaa, 0x13, 0xbf, 0x0d, 0x30, 0x05, 0xd4, 0x43, 0x9f, 0x31, 0x28,
							 0x94, 0xde, 0x6f, 0x58,
	0xac, 0x7a, 0x3d, 0x23, 0xd1, 0xd9, 0xdc, 0x9a, 0x19, 0x6b, 0x4a, 0xef,
							 0x37, 0xcc, 0xd6, 0x15,
	0x1e, 0x8f, 0x08, 0xe4, 0x46, 0x4b, 0x72, 0xb7, 0xa5, 0xf6, 0xfb, 0x86,
							 0xc3, 0x22, 0x91, 0x59,
	0xec, 0xfa, 0x0d, 0x43, 0xc5, 0xf1, 0x53, 0x84, 0x7d, 0x23, 0xe1, 0xd9,
							 0xc8, 0x9a, 0x16, 0x6b,
	0x4e, 0xaf, 0x34, 0xfc, 0xd7, 0x41, 0x5e, 0x70, 0x38, 0xa4, 0x52, 0x7b,
							 0x7d, 0xa3, 0xe1, 0xb9,
	0xc8, 0xb2, 0x96, 0x75, 0x2e, 0xa7, 0x9c, 0xfa, 0x29, 0x43, 0xde, 0xf1,
							 0x58, 0xc4, 0x7a, 0x53,
	0xe3, 0xbd, 0x89, 0x31, 0x66, 0xd4, 0x6a, 0xdf, 0x2f, 0xd8, 0x9c, 0x1a,
							 0x29, 0x0b, 0x5e, 0xc7,
	0xb8, 0xd2, 0xb2, 0x5d, 0xb5, 0xb9, 0xf7, 0xb2, 0x86, 0x35, 0x22, 0x97,
							 0x99, 0xee, 0x6a, 0x8c,
	0xef, 0xe5, 0x0c, 0x0b, 0x45, 0x07, 0xb3, 0xc2, 0xb5, 0x11, 0x77, 0xcc,
							 0xe6, 0x15, 0x0a, 0x8f,
	0x07, 0xe4, 0x42, 0x0b, 0x71, 0x87, 0xa4, 0xa2, 0xbb, 0x79, 0xf3, 0x62,
							 0x85, 0x69, 0xe3, 0xee,
	0x49, 0x0c, 0xf6, 0xc5, 0x06, 0xd3, 0xc2, 0xdd, 0x91, 0xd9, 0xec, 0x9a,
							 0x0d, 0x6b, 0x45, 0xef,
	0x33, 0x8c, 0xd5, 0x25, 0x1f, 0xdb, 0x48, 0x1b, 0x76, 0x0b, 0x66, 0x87,
							 0xaa, 0xe2, 0xbf, 0xc9,
	0xf0, 0x16, 0xc4, 0x0e, 0x53, 0x04, 0x7d, 0x43, 0xe1, 0xf1, 0x48, 0x84,
							 0x76, 0x63, 0xe6, 0xa9,
	0xca, 0xfe, 0x57, 0xc0, 0x3e, 0x10, 0x10, 0x8c, 0xcc, 0x65, 0x15, 0x2b,
							 0x4f, 0xdf, 0x34, 0x18,
	0x97, 0x0a, 0x2e, 0x47, 0x9c, 0xb2, 0xa9, 0x75, 0x3e, 0xe7, 0x90, 0xca,
							 0x2c, 0x57, 0x9d, 0x3e,
	0x69, 0xd0, 0x2e, 0x9c, 0xdc, 0xe9, 0xd9, 0x4e, 0x5a, 0xf4, 0x7b, 0xc7,
							 0xa3, 0x12, 0xb9, 0x4d,
	0xb2, 0xf5, 0x35, 0xc7, 0x97, 0x92, 0xae, 0x2d, 0xbc, 0x9d, 0xb1, 0x69,
							 0xf4, 0xee, 0x47, 0x4c,
	0xf2, 0x75, 0x05, 0xa7, 0x83, 0xba, 0x21, 0x33, 0xd8, 0xd5, 0x1a, 0x5f,
							 0x0b, 0xb8, 0x87, 0x32,
	0xa2, 0x55, 0x39, 0xbf, 0x12, 0xb0, 0x0d, 0xf4, 0x45, 0x87, 0xb3, 0xa2,
							 0xb5, 0x39, 0xf7, 0xd2,
	0x86, 0x1d, 0xa2, 0x89, 0xf9, 0xe6, 0xc2, 0x8a, 0x11, 0xe7, 0x8c, 0x8a,
							 0x25, 0x67, 0x9b, 0xea,
	0x2b, 0x0f, 0x1f, 0x44, 0x48, 0x73, 0xf6, 0x25, 0x06, 0x9b, 0x42, 0xeb,
							 0x71, 0xcf, 0x24, 0x94,
	0x5b, 0x6f, 0x3b, 0x6c, 0xd3, 0x6d, 0x9d, 0x6d, 0xa9, 0xed, 0xbe, 0x8d,
							 0xb0, 0xe5, 0x34, 0x4b,
	0x57, 0x37, 0xbe, 0x56, 0xf0, 0xbe, 0x44, 0x70, 0x33, 0x24, 0x55, 0x5b,
							 0x7f, 0xfb, 0x60, 0x03,
	0xe8, 0x01, 0x4e, 0x00, 0x34, 0x80, 0x17, 0x60, 0x0e, 0x68, 0x84, 0xae,
							 0x63, 0x7c, 0xe9, 0x61,
	0x4e, 0xe8, 0xb4, 0xce, 0x77, 0x54, 0x66, 0x7f, 0x2a, 0xa0, 0x1f, 0xf8,
							 0x88, 0x02, 0xa6, 0x01,
	0x7a, 0x80, 0x23, 0xe0, 0x19, 0x08, 0x8a, 0xc6, 0xe7, 0xd2, 0x8a, 0x1d,
							 0xa7, 0x89, 0xfa, 0x26,
	0xc3, 0x9a, 0x11, 0x2b, 0x4c, 0xdf, 0x35, 0x58, 0x97, 0xfa, 0x2e, 0x03,
							 0xdc, 0x81, 0x59, 0x60,
	0x3a, 0xe8, 0x93, 0xce, 0x6d, 0x14, 0x6d, 0xcf, 0x2d, 0x94, 0x5d, 0xaf,
							 0x39, 0xbc, 0xd2, 0xb1,
	0x5d, 0xf4, 0x79, 0x87, 0xa2, 0xa2, 0xb9, 0xf9, 0xf2, 0x82, 0x85, 0xe1,
							 0x63, 0x88, 0xa9, 0x26,
	0xfe, 0xda, 0x00, 0xdb, 0x40, 0x5b, 0x70, 0x3b, 0x64, 0x13, 0xeb, 0x0d,
							 0x8f, 0x45, 0x24, 0x73,
	0xdb, 0x25, 0x1b, 0x5b, 0x4b, 0x7b, 0x77, 0x63, 0xe6, 0x69, 0xca, 0xae,
							 0x57, 0xfc, 0xfe, 0x01,
	0x40, 0x80, 0x30, 0x60, 0x14, 0x28, 0x8f, 0x1e, 0x64, 0x48, 0xab, 0x36,
							 0xff, 0x56, 0xc0, 0x7e,
	0x50, 0x20, 0x3c, 0x18, 0x91, 0x0a, 0x2c, 0xc7, 0x9d, 0x52, 0xa9, 0xfd,
							 0xbe, 0x81, 0x70, 0xe0,
	0x24, 0x48, 0x9b, 0x36, 0xeb, 0x56, 0xcf, 0x7e, 0x54, 0x60, 0x3f, 0x28,
							 0x90, 0x5e, 0x6c, 0x38,
	0xad, 0x12, 0xbd, 0xcd, 0xb1, 0x95, 0x34, 0xaf, 0x17, 0x7c, 0xce, 0x61,
							 0x54, 0xa8, 0xbf, 0x7e,
	0x70, 0x60, 0x24, 0x28, 0x9b, 0x1e, 0x6b, 0x48, 0xaf, 0x76, 0xfc, 0x66,
							 0xc1, 0x2a, 0x10, 0xdf,
	0x0c, 0x58, 0x85, 0x3a, 0x23, 0xd3, 0xd9, 0x1d, 0x9a, 0xc9, 0xeb, 0xd6,
							 0xcf, 0x1e, 0x54, 0x48,
	0xbf, 0x36, 0xf0, 0x56, 0xc4, 0x3e, 0x53, 0x10, 0x3d, 0x4c, 0xd1, 0xf5,
							 0x1c, 0x87, 0x89, 0x62,
	0xa6, 0xe9, 0xfa, 0xce, 0x43, 0xd4, 0x71, 0x1f, 0x24, 0xc8, 0x9b, 0x56,
							 0xeb, 0x7e, 0x4f, 0x60,
	0x34, 0x68, 0x97, 0x2e, 0x6e, 0x5c, 0xec, 0xb9, 0xcd, 0x72, 0x95, 0xe5,
							 0x2f, 0x8b, 0x5c, 0x27,
	0xb9, 0x1a, 0x32, 0xcb, 0x55, 0xd7, 0xbf, 0x9e, 0x70, 0x28, 0xa4, 0x1e,
							 0x7b, 0x08, 0xa3, 0x46,
	0xf9, 0x72, 0x82, 0xe5, 0x21, 0xcb, 0x58, 0x97, 0xba, 0x6e, 0x73, 0xac,
							 0xe5, 0x3d, 0x8b, 0xd1,
	0x67, 0x1c, 0xea, 0x49, 0xcf, 0xb6, 0xd4, 0x36, 0xdf, 0x16, 0xd8, 0x4e,
							 0x5a, 0x34, 0x7b, 0x97,
	0xa3, 0x2e, 0x79, 0x5c, 0xe2, 0xf9, 0xc9, 0xc2, 0x96, 0x91, 0x6e, 0xec,
							 0xec, 0xcd, 0x8d, 0x55,
	0x25, 0xff, 0x1b, 0x80, 0x0b, 0x20, 0x07, 0x58, 0x82, 0x7a, 0x21, 0xa3,
							 0xd8, 0xb9, 0xda, 0x72,
	0x9b, 0xa5, 0x2b, 0x3b, 0x5f, 0x53, 0xf8, 0x7d, 0x82, 0x21, 0x61, 0x98,
							 0xa8, 0xaa, 0x3e, 0x7f,
	0x10, 0xa0, 0x0c, 0x78, 0x85, 0x22, 0xa3, 0xd9, 0xf9, 0x1a, 0x02, 0xcb,
							 0x41, 0xd7, 0xb0, 0x9e,
	0x74, 0x68, 0xa7, 0x2e, 0x7a, 0x5c, 0xe3, 0xb9, 0xc9, 0x32, 0x96, 0xd5,
							 0x2e, 0xdf, 0x1c, 0xd8,
	0x89, 0x5a, 0x26, 0xfb, 0x5a, 0xc3, 0xfb, 0xd1, 0x43, 0x1c, 0xf1, 0x49,
		 0xc4, 0xf6, 0xd3, 0x46, 0xdd, 0x72, 0x99, 0xe5
};
#else
static const unsigned char util_rspc_yellowbook_scrambler[2340] = { 0x01,
		0x80, 0x00,
		0x60, 0x00, 0x28, 0x00, 0x1E, 0x80, 0x08, 0x60, 0x06, 0xA8,
		0x02, 0xFE, 0x81, 0x80, 0x60, 0x60, 0x28, 0x28, 0x1E, 0x9E,
		0x88, 0x68, 0x66, 0xAE, 0xAA, 0xFC, 0x7F, 0x01, 0xE0, 0x00,
		0x48, 0x00, 0x36, 0x80, 0x16, 0xE0, 0x0E, 0xC8, 0x04, 0x56,
		0x83, 0x7E, 0xE1, 0xE0, 0x48, 0x48, 0x36, 0xB6, 0x96, 0xF6,
		0xEE, 0xC6, 0xCC, 0x52, 0xD5, 0xFD, 0x9F, 0x01, 0xA8, 0x00,
		0x7E, 0x80, 0x20, 0x60, 0x18, 0x28, 0x0A, 0x9E, 0x87, 0x28,
		0x62, 0x9E, 0xA9, 0xA8, 0x7E, 0xFE, 0xA0, 0x40, 0x78, 0x30,
		0x22, 0x94, 0x19, 0xAF, 0x4A, 0xFC, 0x37, 0x01, 0xD6, 0x80,
		0x5E, 0xE0, 0x38, 0x48, 0x12, 0xB6, 0x8D, 0xB6, 0xE5, 0xB6,
		0xCB, 0x36, 0xD7, 0x56, 0xDE, 0xBE, 0xD8, 0x70, 0x5A, 0xA4,
		0x3B, 0x3B, 0x53, 0x53, 0x7D, 0xFD, 0xE1, 0x81, 0x88, 0x60,
		0x66, 0xA8, 0x2A, 0xFE, 0x9F, 0x00, 0x68, 0x00, 0x2E, 0x80,
		0x1C, 0x60, 0x09, 0xE8, 0x06, 0xCE, 0x82, 0xD4, 0x61, 0x9F,
		0x68, 0x68, 0x2E, 0xAE, 0x9C, 0x7C, 0x69, 0xE1, 0xEE, 0xC8,
		0x4C, 0x56, 0xB5, 0xFE, 0xF7, 0x00, 0x46, 0x80, 0x32, 0xE0,
		0x15, 0x88, 0x0F, 0x26, 0x84, 0x1A, 0xE3, 0x4B, 0x09, 0xF7,
		0x46, 0xC6, 0xB2, 0xD2, 0xF5, 0x9D, 0x87, 0x29, 0xA2, 0x9E,
		0xF9, 0xA8, 0x42, 0xFE, 0xB1, 0x80, 0x74, 0x60, 0x27, 0x68,
		0x1A, 0xAE, 0x8B, 0x3C, 0x67, 0x51, 0xEA, 0xBC, 0x4F, 0x31,
		0xF4, 0x14, 0x47, 0x4F, 0x72, 0xB4, 0x25, 0xB7, 0x5B, 0x36,
		0xBB, 0x56, 0xF3, 0x7E, 0xC5, 0xE0, 0x53, 0x08, 0x3D, 0xC6,
		0x91, 0x92, 0xEC, 0x6D, 0x8D, 0xED, 0xA5, 0x8D, 0xBB, 0x25,
		0xB3, 0x5B, 0x35, 0xFB, 0x57, 0x03, 0x7E, 0x81, 0xE0, 0x60,
		0x48, 0x28, 0x36, 0x9E, 0x96, 0xE8, 0x6E, 0xCE, 0xAC, 0x54,
		0x7D, 0xFF, 0x61, 0x80, 0x28, 0x60, 0x1E, 0xA8, 0x08, 0x7E,
		0x86, 0xA0, 0x62, 0xF8, 0x29, 0x82, 0x9E, 0xE1, 0xA8, 0x48,
		0x7E, 0xB6, 0xA0, 0x76, 0xF8, 0x26, 0xC2, 0x9A, 0xD1, 0xAB,
		0x1C, 0x7F, 0x49, 0xE0, 0x36, 0xC8, 0x16, 0xD6, 0x8E, 0xDE,
		0xE4, 0x58, 0x4B, 0x7A, 0xB7, 0x63, 0x36, 0xA9, 0xD6, 0xFE,
		0xDE, 0xC0, 0x58, 0x50, 0x3A, 0xBC, 0x13, 0x31, 0xCD, 0xD4,
		0x55, 0x9F, 0x7F, 0x28, 0x20, 0x1E, 0x98, 0x08, 0x6A, 0x86,
		0xAF, 0x22, 0xFC, 0x19, 0x81, 0xCA, 0xE0, 0x57, 0x08, 0x3E,
		0x86, 0x90, 0x62, 0xEC, 0x29, 0x8D, 0xDE, 0xE5, 0x98, 0x4B,
		0x2A, 0xB7, 0x5F, 0x36, 0xB8, 0x16, 0xF2, 0x8E, 0xC5, 0xA4,
		0x53, 0x3B, 0x7D, 0xD3, 0x61, 0x9D, 0xE8, 0x69, 0x8E, 0xAE,
		0xE4, 0x7C, 0x4B, 0x61, 0xF7, 0x68, 0x46, 0xAE, 0xB2, 0xFC,
		0x75, 0x81, 0xE7, 0x20, 0x4A, 0x98, 0x37, 0x2A, 0x96, 0x9F,
		0x2E, 0xE8, 0x1C, 0x4E, 0x89, 0xF4, 0x66, 0xC7, 0x6A, 0xD2,
		0xAF, 0x1D, 0xBC, 0x09, 0xB1, 0xC6, 0xF4, 0x52, 0xC7, 0x7D,
		0x92, 0xA1, 0xAD, 0xB8, 0x7D, 0xB2, 0xA1, 0xB5, 0xB8, 0x77,
		0x32, 0xA6, 0x95, 0xBA, 0xEF, 0x33, 0x0C, 0x15, 0xC5, 0xCF,
		0x13, 0x14, 0x0D, 0xCF, 0x45, 0x94, 0x33, 0x2F, 0x55, 0xDC,
		0x3F, 0x19, 0xD0, 0x0A, 0xDC, 0x07, 0x19, 0xC2, 0x8A, 0xD1,
		0xA7, 0x1C, 0x7A, 0x89, 0xE3, 0x26, 0xC9, 0xDA, 0xD6, 0xDB,
		0x1E, 0xDB, 0x48, 0x5B, 0x76, 0xBB, 0x66, 0xF3, 0x6A, 0xC5,
		0xEF, 0x13, 0x0C, 0x0D, 0xC5, 0xC5, 0x93, 0x13, 0x2D, 0xCD,
		0xDD, 0x95, 0x99, 0xAF, 0x2A, 0xFC, 0x1F, 0x01, 0xC8, 0x00,
		0x56, 0x80, 0x3E, 0xE0, 0x10, 0x48, 0x0C, 0x36, 0x85, 0xD6,
		0xE3, 0x1E, 0xC9, 0xC8, 0x56, 0xD6, 0xBE, 0xDE, 0xF0, 0x58,
		0x44, 0x3A, 0xB3, 0x53, 0x35, 0xFD, 0xD7, 0x01, 0x9E, 0x80,
		0x68, 0x60, 0x2E, 0xA8, 0x1C, 0x7E, 0x89, 0xE0, 0x66, 0xC8,
		0x2A, 0xD6, 0x9F, 0x1E, 0xE8, 0x08, 0x4E, 0x86, 0xB4, 0x62,
		0xF7, 0x69, 0x86, 0xAE, 0xE2, 0xFC, 0x49, 0x81, 0xF6, 0xE0,
		0x46, 0xC8, 0x32, 0xD6, 0x95, 0x9E, 0xEF, 0x28, 0x4C, 0x1E,
		0xB5, 0xC8, 0x77, 0x16, 0xA6, 0x8E, 0xFA, 0xE4, 0x43, 0x0B,
		0x71, 0xC7, 0x64, 0x52, 0xAB, 0x7D, 0xBF, 0x61, 0xB0, 0x28,
		0x74, 0x1E, 0xA7, 0x48, 0x7A, 0xB6, 0xA3, 0x36, 0xF9, 0xD6,
		0xC2, 0xDE, 0xD1, 0x98, 0x5C, 0x6A, 0xB9, 0xEF, 0x32, 0xCC,
		0x15, 0x95, 0xCF, 0x2F, 0x14, 0x1C, 0x0F, 0x49, 0xC4, 0x36,
		0xD3, 0x56, 0xDD, 0xFE, 0xD9, 0x80, 0x5A, 0xE0, 0x3B, 0x08,
		0x13, 0x46, 0x8D, 0xF2, 0xE5, 0x85, 0x8B, 0x23, 0x27, 0x59,
		0xDA, 0xBA, 0xDB, 0x33, 0x1B, 0x55, 0xCB, 0x7F, 0x17, 0x60,
		0x0E, 0xA8, 0x04, 0x7E, 0x83, 0x60, 0x61, 0xE8, 0x28, 0x4E,
		0x9E, 0xB4, 0x68, 0x77, 0x6E, 0xA6, 0xAC, 0x7A, 0xFD, 0xE3,
		0x01, 0x89, 0xC0, 0x66, 0xD0, 0x2A, 0xDC, 0x1F, 0x19, 0xC8,
		0x0A, 0xD6, 0x87, 0x1E, 0xE2, 0x88, 0x49, 0xA6, 0xB6, 0xFA,
		0xF6, 0xC3, 0x06, 0xD1, 0xC2, 0xDC, 0x51, 0x99, 0xFC, 0x6A,
		0xC1, 0xEF, 0x10, 0x4C, 0x0C, 0x35, 0xC5, 0xD7, 0x13, 0x1E,
		0x8D, 0xC8, 0x65, 0x96, 0xAB, 0x2E, 0xFF, 0x5C, 0x40, 0x39,
		0xF0, 0x12, 0xC4, 0x0D, 0x93, 0x45, 0xAD, 0xF3, 0x3D, 0x85,
		0xD1, 0xA3, 0x1C, 0x79, 0xC9, 0xE2, 0xD6, 0xC9, 0x9E, 0xD6,
		0xE8, 0x5E, 0xCE, 0xB8, 0x54, 0x72, 0xBF, 0x65, 0xB0, 0x2B,
		0x34, 0x1F, 0x57, 0x48, 0x3E, 0xB6, 0x90, 0x76, 0xEC, 0x26,
		0xCD, 0xDA, 0xD5, 0x9B, 0x1F, 0x2B, 0x48, 0x1F, 0x76, 0x88,
		0x26, 0xE6, 0x9A, 0xCA, 0xEB, 0x17, 0x0F, 0x4E, 0x84, 0x34,
		0x63, 0x57, 0x69, 0xFE, 0xAE, 0xC0, 0x7C, 0x50, 0x21, 0xFC,
		0x18, 0x41, 0xCA, 0xB0, 0x57, 0x34, 0x3E, 0x97, 0x50, 0x6E,
		0xBC, 0x2C, 0x71, 0xDD, 0xE4, 0x59, 0x8B, 0x7A, 0xE7, 0x63,
		0x0A, 0xA9, 0xC7, 0x3E, 0xD2, 0x90, 0x5D, 0xAC, 0x39, 0xBD,
		0xD2, 0xF1, 0x9D, 0x84, 0x69, 0xA3, 0x6E, 0xF9, 0xEC, 0x42,
		0xCD, 0xF1, 0x95, 0x84, 0x6F, 0x23, 0x6C, 0x19, 0xED, 0xCA,
		0xCD, 0x97, 0x15, 0xAE, 0x8F, 0x3C, 0x64, 0x11, 0xEB, 0x4C,
		0x4F, 0x75, 0xF4, 0x27, 0x07, 0x5A, 0x82, 0xBB, 0x21, 0xB3,
		0x58, 0x75, 0xFA, 0xA7, 0x03, 0x3A, 0x81, 0xD3, 0x20, 0x5D,
		0xD8, 0x39, 0x9A, 0x92, 0xEB, 0x2D, 0x8F, 0x5D, 0xA4, 0x39,
		0xBB, 0x52, 0xF3, 0x7D, 0x85, 0xE1, 0xA3, 0x08, 0x79, 0xC6,
		0xA2, 0xD2, 0xF9, 0x9D, 0x82, 0xE9, 0xA1, 0x8E, 0xF8, 0x64,
		0x42, 0xAB, 0x71, 0xBF, 0x64, 0x70, 0x2B, 0x64, 0x1F, 0x6B,
		0x48, 0x2F, 0x76, 0x9C, 0x26, 0xE9, 0xDA, 0xCE, 0xDB, 0x14,
		0x5B, 0x4F, 0x7B, 0x74, 0x23, 0x67, 0x59, 0xEA, 0xBA, 0xCF,
		0x33, 0x14, 0x15, 0xCF, 0x4F, 0x14, 0x34, 0x0F, 0x57, 0x44,
		0x3E, 0xB3, 0x50, 0x75, 0xFC, 0x27, 0x01, 0xDA, 0x80, 0x5B,
		0x20, 0x3B, 0x58, 0x13, 0x7A, 0x8D, 0xE3, 0x25, 0x89, 0xDB,
		0x26, 0xDB, 0x5A, 0xDB, 0x7B, 0x1B, 0x63, 0x4B, 0x69, 0xF7,
		0x6E, 0xC6, 0xAC, 0x52, 0xFD, 0xFD, 0x81, 0x81, 0xA0, 0x60,
		0x78, 0x28, 0x22, 0x9E, 0x99, 0xA8, 0x6A, 0xFE, 0xAF, 0x00,
		0x7C, 0x00, 0x21, 0xC0, 0x18, 0x50, 0x0A, 0xBC, 0x07, 0x31,
		0xC2, 0x94, 0x51, 0xAF, 0x7C, 0x7C, 0x21, 0xE1, 0xD8, 0x48,
		0x5A, 0xB6, 0xBB, 0x36, 0xF3, 0x56, 0xC5, 0xFE, 0xD3, 0x00,
		0x5D, 0xC0, 0x39, 0x90, 0x12, 0xEC, 0x0D, 0x8D, 0xC5, 0xA5,
		0x93, 0x3B, 0x2D, 0xD3, 0x5D, 0x9D, 0xF9, 0xA9, 0x82, 0xFE,
		0xE1, 0x80, 0x48, 0x60, 0x36, 0xA8, 0x16, 0xFE, 0x8E, 0xC0,
		0x64, 0x50, 0x2B, 0x7C, 0x1F, 0x61, 0xC8, 0x28, 0x56, 0x9E,
		0xBE, 0xE8, 0x70, 0x4E, 0xA4, 0x34, 0x7B, 0x57, 0x63, 0x7E,
		0xA9, 0xE0, 0x7E, 0xC8, 0x20, 0x56, 0x98, 0x3E, 0xEA, 0x90,
		0x4F, 0x2C, 0x34, 0x1D, 0xD7, 0x49, 0x9E, 0xB6, 0xE8, 0x76,
		0xCE, 0xA6, 0xD4, 0x7A, 0xDF, 0x63, 0x18, 0x29, 0xCA, 0x9E,
		0xD7, 0x28, 0x5E, 0x9E, 0xB8, 0x68, 0x72, 0xAE, 0xA5, 0xBC,
		0x7B, 0x31, 0xE3, 0x54, 0x49, 0xFF, 0x76, 0xC0, 0x26, 0xD0,
		0x1A, 0xDC, 0x0B, 0x19, 0xC7, 0x4A, 0xD2, 0xB7, 0x1D, 0xB6,
		0x89, 0xB6, 0xE6, 0xF6, 0xCA, 0xC6, 0xD7, 0x12, 0xDE, 0x8D,
		0x98, 0x65, 0xAA, 0xAB, 0x3F, 0x3F, 0x50, 0x10, 0x3C, 0x0C,
		0x11, 0xC5, 0xCC, 0x53, 0x15, 0xFD, 0xCF, 0x01, 0x94, 0x00,
		0x6F, 0x40, 0x2C, 0x30, 0x1D, 0xD4, 0x09, 0x9F, 0x46, 0xE8,
		0x32, 0xCE, 0x95, 0x94, 0x6F, 0x2F, 0x6C, 0x1C, 0x2D, 0xC9,
		0xDD, 0x96, 0xD9, 0xAE, 0xDA, 0xFC, 0x5B, 0x01, 0xFB, 0x40,
		0x43, 0x70, 0x31, 0xE4, 0x14, 0x4B, 0x4F, 0x77, 0x74, 0x26,
		0xA7, 0x5A, 0xFA, 0xBB, 0x03, 0x33, 0x41, 0xD5, 0xF0, 0x5F,
		0x04, 0x38, 0x03, 0x52, 0x81, 0xFD, 0xA0, 0x41, 0xB8, 0x30,
		0x72, 0x94, 0x25, 0xAF, 0x5B, 0x3C, 0x3B, 0x51, 0xD3, 0x7C,
		0x5D, 0xE1, 0xF9, 0x88, 0x42, 0xE6, 0xB1, 0x8A, 0xF4, 0x67,
		0x07, 0x6A, 0x82, 0xAF, 0x21, 0xBC, 0x18, 0x71, 0xCA, 0xA4,
		0x57, 0x3B, 0x7E, 0x93, 0x60, 0x6D, 0xE8, 0x2D, 0x8E, 0x9D,
		0xA4, 0x69, 0xBB, 0x6E, 0xF3, 0x6C, 0x45, 0xED, 0xF3, 0x0D,
		0x85, 0xC5, 0xA3, 0x13, 0x39, 0xCD, 0xD2, 0xD5, 0x9D, 0x9F,
		0x29, 0xA8, 0x1E, 0xFE, 0x88, 0x40, 0x66, 0xB0, 0x2A, 0xF4,
		0x1F, 0x07, 0x48, 0x02, 0xB6, 0x81, 0xB6, 0xE0, 0x76, 0xC8,
		0x26, 0xD6, 0x9A, 0xDE, 0xEB, 0x18, 0x4F, 0x4A, 0xB4, 0x37,
		0x37, 0x56, 0x96, 0xBE, 0xEE, 0xF0, 0x4C, 0x44, 0x35, 0xF3,
		0x57, 0x05, 0xFE, 0x83, 0x00, 0x61, 0xC0, 0x28, 0x50, 0x1E,
		0xBC, 0x08, 0x71, 0xC6, 0xA4, 0x52, 0xFB, 0x7D, 0x83, 0x61,
		0xA1, 0xE8, 0x78, 0x4E, 0xA2, 0xB4, 0x79, 0xB7, 0x62, 0xF6,
		0xA9, 0x86, 0xFE, 0xE2, 0xC0, 0x49, 0x90, 0x36, 0xEC, 0x16,
		0xCD, 0xCE, 0xD5, 0x94, 0x5F, 0x2F, 0x78, 0x1C, 0x22, 0x89,
		0xD9, 0xA6, 0xDA, 0xFA, 0xDB, 0x03, 0x1B, 0x41, 0xCB, 0x70,
		0x57, 0x64, 0x3E, 0xAB, 0x50, 0x7F, 0x7C, 0x20, 0x21, 0xD8,
		0x18, 0x5A, 0x8A, 0xBB, 0x27, 0x33, 0x5A, 0x95, 0xFB, 0x2F,
		0x03, 0x5C, 0x01, 0xF9, 0xC0, 0x42, 0xD0, 0x31, 0x9C, 0x14,
		0x69, 0xCF, 0x6E, 0xD4, 0x2C, 0x5F, 0x5D, 0xF8, 0x39, 0x82,
		0x92, 0xE1, 0xAD, 0x88, 0x7D, 0xA6, 0xA1, 0xBA, 0xF8, 0x73,
		0x02, 0xA5, 0xC1, 0xBB, 0x10, 0x73, 0x4C, 0x25, 0xF5, 0xDB,
		0x07, 0x1B, 0x42, 0x8B, 0x71, 0xA7, 0x64, 0x7A, 0xAB, 0x63,
		0x3F, 0x69, 0xD0, 0x2E, 0xDC, 0x1C, 0x59, 0xC9, 0xFA, 0xD6,
		0xC3, 0x1E, 0xD1, 0xC8, 0x5C, 0x56, 0xB9, 0xFE, 0xF2, 0xC0,
		0x45, 0x90, 0x33, 0x2C, 0x15, 0xDD, 0xCF, 0x19, 0x94, 0x0A,
		0xEF, 0x47, 0x0C, 0x32, 0x85, 0xD5, 0xA3, 0x1F, 0x39, 0xC8,
		0x12, 0xD6, 0x8D, 0x9E, 0xE5, 0xA8, 0x4B, 0x3E, 0xB7, 0x50,
		0x76, 0xBC, 0x26, 0xF1, 0xDA, 0xC4, 0x5B, 0x13, 0x7B, 0x4D,
		0xE3, 0x75, 0x89, 0xE7, 0x26, 0xCA, 0x9A, 0xD7, 0x2B, 0x1E,
		0x9F, 0x48, 0x68, 0x36, 0xAE, 0x96, 0xFC, 0x6E, 0xC1, 0xEC,
		0x50, 0x4D, 0xFC, 0x35, 0x81, 0xD7, 0x20, 0x5E, 0x98, 0x38,
		0x6A, 0x92, 0xAF, 0x2D, 0xBC, 0x1D, 0xB1, 0xC9, 0xB4, 0x56,
		0xF7, 0x7E, 0xC6, 0xA0, 0x52, 0xF8, 0x3D, 0x82, 0x91, 0xA1,
		0xAC, 0x78, 0x7D, 0xE2, 0xA1, 0x89, 0xB8, 0x66, 0xF2, 0xAA,
		0xC5, 0xBF, 0x13, 0x30, 0x0D, 0xD4, 0x05, 0x9F, 0x43, 0x28,
		0x31, 0xDE, 0x94, 0x58, 0x6F, 0x7A, 0xAC, 0x23, 0x3D, 0xD9,
		0xD1, 0x9A, 0xDC, 0x6B, 0x19, 0xEF, 0x4A, 0xCC, 0x37, 0x15,
		0xD6, 0x8F, 0x1E, 0xE4, 0x08, 0x4B, 0x46, 0xB7, 0x72, 0xF6,
		0xA5, 0x86, 0xFB, 0x22, 0xC3, 0x59, 0x91, 0xFA, 0xEC, 0x43,
		0x0D, 0xF1, 0xC5, 0x84, 0x53, 0x23, 0x7D, 0xD9, 0xE1, 0x9A,
		0xC8, 0x6B, 0x16, 0xAF, 0x4E, 0xFC, 0x34, 0x41, 0xD7, 0x70,
		0x5E, 0xA4, 0x38, 0x7B, 0x52, 0xA3, 0x7D, 0xB9, 0xE1, 0xB2,
		0xC8, 0x75, 0x96, 0xA7, 0x2E, 0xFA, 0x9C, 0x43, 0x29, 0xF1,
		0xDE, 0xC4, 0x58, 0x53, 0x7A, 0xBD, 0xE3, 0x31, 0x89, 0xD4,
		0x66, 0xDF, 0x6A, 0xD8, 0x2F, 0x1A, 0x9C, 0x0B, 0x29, 0xC7,
		0x5E, 0xD2, 0xB8, 0x5D, 0xB2, 0xB9, 0xB5, 0xB2, 0xF7, 0x35,
		0x86, 0x97, 0x22, 0xEE, 0x99, 0x8C, 0x6A, 0xE5, 0xEF, 0x0B,
		0x0C, 0x07, 0x45, 0xC2, 0xB3, 0x11, 0xB5, 0xCC, 0x77, 0x15,
		0xE6, 0x8F, 0x0A, 0xE4, 0x07, 0x0B, 0x42, 0x87, 0x71, 0xA2,
		0xA4, 0x79, 0xBB, 0x62, 0xF3, 0x69, 0x85, 0xEE, 0xE3, 0x0C,
		0x49, 0xC5, 0xF6, 0xD3, 0x06, 0xDD, 0xC2, 0xD9, 0x91, 0x9A,
		0xEC, 0x6B, 0x0D, 0xEF, 0x45, 0x8C, 0x33, 0x25, 0xD5, 0xDB,
		0x1F, 0x1B, 0x48, 0x0B, 0x76, 0x87, 0x66, 0xE2, 0xAA, 0xC9,
		0xBF, 0x16, 0xF0, 0x0E, 0xC4, 0x04, 0x53, 0x43, 0x7D, 0xF1,
		0xE1, 0x84, 0x48, 0x63, 0x76, 0xA9, 0xE6, 0xFE, 0xCA, 0xC0,
		0x57, 0x10, 0x3E, 0x8C, 0x10, 0x65, 0xCC, 0x2B, 0x15, 0xDF,
		0x4F, 0x18, 0x34, 0x0A, 0x97, 0x47, 0x2E, 0xB2, 0x9C, 0x75,
		0xA9, 0xE7, 0x3E, 0xCA, 0x90, 0x57, 0x2C, 0x3E, 0x9D, 0xD0,
		0x69, 0x9C, 0x2E, 0xE9, 0xDC, 0x4E, 0xD9, 0xF4, 0x5A, 0xC7,
		0x7B, 0x12, 0xA3, 0x4D, 0xB9, 0xF5, 0xB2, 0xC7, 0x35, 0x92,
		0x97, 0x2D, 0xAE, 0x9D, 0xBC, 0x69, 0xB1, 0xEE, 0xF4, 0x4C,
		0x47, 0x75, 0xF2, 0xA7, 0x05, 0xBA, 0x83, 0x33, 0x21, 0xD5,
		0xD8, 0x5F, 0x1A, 0xB8, 0x0B, 0x32, 0x87, 0x55, 0xA2, 0xBF,
		0x39, 0xB0, 0x12, 0xF4, 0x0D, 0x87, 0x45, 0xA2, 0xB3, 0x39,
		0xB5, 0xD2, 0xF7, 0x1D, 0x86, 0x89, 0xA2, 0xE6, 0xF9, 0x8A,
		0xC2, 0xE7, 0x11, 0x8A, 0x8C, 0x67, 0x25, 0xEA, 0x9B, 0x0F,
		0x2B, 0x44, 0x1F, 0x73, 0x48, 0x25, 0xF6, 0x9B, 0x06, 0xEB,
		0x42, 0xCF, 0x71, 0x94, 0x24, 0x6F, 0x5B, 0x6C, 0x3B, 0x6D,
		0xD3, 0x6D, 0x9D, 0xED, 0xA9, 0x8D, 0xBE, 0xE5, 0xB0, 0x4B,
		0x34, 0x37, 0x57, 0x56, 0xBE, 0xBE, 0xF0, 0x70, 0x44, 0x24,
		0x33, 0x5B, 0x55, 0xFB, 0x7F, 0x03, 0x60, 0x01, 0xE8, 0x00,
		0x4E, 0x80, 0x34, 0x60, 0x17, 0x68, 0x0E, 0xAE, 0x84, 0x7C,
		0x63, 0x61, 0xE9, 0xE8, 0x4E, 0xCE, 0xB4, 0x54, 0x77, 0x7F,
		0x66, 0xA0, 0x2A, 0xF8, 0x1F, 0x02, 0x88, 0x01, 0xA6, 0x80,
		0x7A, 0xE0, 0x23, 0x08, 0x19, 0xC6, 0x8A, 0xD2, 0xE7, 0x1D,
		0x8A, 0x89, 0xA7, 0x26, 0xFA, 0x9A, 0xC3, 0x2B, 0x11, 0xDF,
		0x4C, 0x58, 0x35, 0xFA, 0x97, 0x03, 0x2E, 0x81, 0xDC, 0x60,
		0x59, 0xE8, 0x3A, 0xCE, 0x93, 0x14, 0x6D, 0xCF, 0x6D, 0x94,
		0x2D, 0xAF, 0x5D, 0xBC, 0x39, 0xB1, 0xD2, 0xF4, 0x5D, 0x87,
		0x79, 0xA2, 0xA2, 0xF9, 0xB9, 0x82, 0xF2, 0xE1, 0x85, 0x88,
		0x63, 0x26, 0xA9, 0xDA, 0xFE, 0xDB, 0x00, 0x5B, 0x40, 0x3B,
		0x70, 0x13, 0x64, 0x0D, 0xEB, 0x45, 0x8F, 0x73, 0x24, 0x25,
		0xDB, 0x5B, 0x1B, 0x7B, 0x4B, 0x63, 0x77, 0x69, 0xE6, 0xAE,
		0xCA, 0xFC, 0x57, 0x01, 0xFE, 0x80, 0x40, 0x60, 0x30, 0x28,
		0x14, 0x1E, 0x8F, 0x48, 0x64, 0x36, 0xAB, 0x56, 0xFF, 0x7E,
		0xC0, 0x20, 0x50, 0x18, 0x3C, 0x0A, 0x91, 0xC7, 0x2C, 0x52,
		0x9D, 0xFD, 0xA9, 0x81, 0xBE, 0xE0, 0x70, 0x48, 0x24, 0x36,
		0x9B, 0x56, 0xEB, 0x7E, 0xCF, 0x60, 0x54, 0x28, 0x3F, 0x5E,
		0x90, 0x38, 0x6C, 0x12, 0xAD, 0xCD, 0xBD, 0x95, 0xB1, 0xAF,
		0x34, 0x7C, 0x17, 0x61, 0xCE, 0xA8, 0x54, 0x7E, 0xBF, 0x60,
		0x70, 0x28, 0x24, 0x1E, 0x9B, 0x48, 0x6B, 0x76, 0xAF, 0x66,
		0xFC, 0x2A, 0xC1, 0xDF, 0x10, 0x58, 0x0C, 0x3A, 0x85, 0xD3,
		0x23, 0x1D, 0xD9, 0xC9, 0x9A, 0xD6, 0xEB, 0x1E, 0xCF, 0x48,
		0x54, 0x36, 0xBF, 0x56, 0xF0, 0x3E, 0xC4, 0x10, 0x53, 0x4C,
		0x3D, 0xF5, 0xD1, 0x87, 0x1C, 0x62, 0x89, 0xE9, 0xA6, 0xCE,
		0xFA, 0xD4, 0x43, 0x1F, 0x71, 0xC8, 0x24, 0x56, 0x9B, 0x7E,
		0xEB, 0x60, 0x4F, 0x68, 0x34, 0x2E, 0x97, 0x5C, 0x6E, 0xB9,
		0xEC, 0x72, 0xCD, 0xE5, 0x95, 0x8B, 0x2F, 0x27, 0x5C, 0x1A,
		0xB9, 0xCB, 0x32, 0xD7, 0x55, 0x9E, 0xBF, 0x28, 0x70, 0x1E,
		0xA4, 0x08, 0x7B, 0x46, 0xA3, 0x72, 0xF9, 0xE5, 0x82, 0xCB,
		0x21, 0x97, 0x58, 0x6E, 0xBA, 0xAC, 0x73, 0x3D, 0xE5, 0xD1,
		0x8B, 0x1C, 0x67, 0x49, 0xEA, 0xB6, 0xCF, 0x36, 0xD4, 0x16,
		0xDF, 0x4E, 0xD8, 0x34, 0x5A, 0x97, 0x7B, 0x2E, 0xA3, 0x5C,
		0x79, 0xF9, 0xE2, 0xC2, 0xC9, 0x91, 0x96, 0xEC, 0x6E, 0xCD,
		0xEC, 0x55, 0x8D, 0xFF, 0x25, 0x80, 0x1B, 0x20, 0x0B, 0x58,
		0x07, 0x7A, 0x82, 0xA3, 0x21, 0xB9, 0xD8, 0x72, 0xDA, 0xA5,
		0x9B, 0x3B, 0x2B, 0x53, 0x5F, 0x7D, 0xF8, 0x21, 0x82, 0x98,
		0x61, 0xAA, 0xA8, 0x7F, 0x3E, 0xA0, 0x10, 0x78, 0x0C, 0x22,
		0x85, 0xD9, 0xA3, 0x1A, 0xF9, 0xCB, 0x02, 0xD7, 0x41, 0x9E,
		0xB0, 0x68, 0x74, 0x2E, 0xA7, 0x5C, 0x7A, 0xB9, 0xE3, 0x32,
		0xC9, 0xD5, 0x96, 0xDF, 0x2E, 0xD8, 0x1C, 0x5A, 0x89, 0xFB,
		0x26, 0xC3, 0x5A, 0xD1, 0xFB, 0x1C, 0x43, 0x49, 0xF1, 0xF6,
		0xC4, 0x46, 0xD3, 0x72, 0xDD, 0xE5, 0x99, };
#endif

#endif /* __MASCA_UTIL_RSPC_SCRAMBLE_TABLE_H_ */
