/*
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef MASCA_TRACE_H
#define MASCA_TRACE_H

#include <linux/kernel.h>

#define ENABLE_TRACE
#undef ENABLE_TRACE


/*** SM traces ***/
#define SM_TE_DRIVEE02(string, args...)	\
	pr_err("Drive SM - LOAD_FAILED load state "string, ##args)
#define SM_TE_DRIVEE03(string, args...)	\
	pr_err("Drive SM - ROM hash read state failed "string, ##args)
#define SM_TA_TRACE(string, args...) pr_alert(string, ##args)
#define SM_TE_TRACE(string, args...) pr_err(string, ##args)
#ifdef ENABLE_TRACE
#define SM_TI_TRACE(string, args...) pr_info(string, ##args)
#define SM_TD_TRACE(string, args...) pr_debug(string, ##args)
#else
#define SM_TI_TRACE(string, args...)
#define SM_TD_TRACE(string, args...)
#endif /*ENABLE_TRACE*/


/*** ATAPI traces ***/
#ifdef ENABLE_TRACE
#define ATAPI_TD_TRACE(string, args...)	pr_info(string, ##args)
#define ATAPI_TD_TOC(string, args...)	pr_info(string, ##args)
#define ATAPI_TD_INQ(string, args...)	pr_info(string, ##args)
#else
#define ATAPI_TD_TRACE(string, args...)
#define ATAPI_TD_TOC(string, args...)
#define ATAPI_TD_INQ(string, args...)
#endif /*ENABLE_TRACE*/

/*** command handler traces ***/
#define CMD_TA_TRACE(string, args...)	pr_alert(string, ##args)
#define CMD_TE_TRACE(string, args...)	pr_err(string, ##args)
#ifdef ENABLE_TRACE
#define CMD_TI_TRACE(string, args...) pr_info(string, ##args)
#define CMD_TD_TRACE(string, args...) pr_debug(string, ##args)
#endif /*ENABLE_TRACE*/

/*** Diag command handler traces ***/
#define DIAG_TA_TRACE(string, args...) pr_alert(string, ##args)
#define DIAG_TE_TRACE(string, args...) pr_err(string, ##args)
#ifdef ENABLE_TRACE
#define DIAG_TI_TRACE(string, args...) pr_info(string, ##args)
#define DIAG_TD_TRACE(string, args...) pr_debug(string, ##args)
#else
#define DIAG_TI_TRACE(string, args...)
#define DIAG_TD_TRACE(string, args...)
#endif /*ENABLE_TRACE*/

/*** Dispatch handler traces ***/
#define DISP_TA_TRACE(string, args...) pr_alert(string, ##args)
#define DISP_TE_TRACE(string, args...) pr_err(string, ##args)
#ifdef ENABLE_TRACE
#define DISP_TI_TRACE(string, args...) pr_info(string, ##args)
#define DISP_TD_TRACE(string, args...) pr_debug(string, ##args)
#else
#define DISP_TI_TRACE(string, args...)
#define DISP_TD_TRACE(string, args...)
#endif /*ENABLE_TRACE*/

/*** Drive Manager traces ***/
#define DRV_MNGR_TA_TRACE(string, args...) pr_alert(string, ##args)
#define DRV_MNGR_TE_TRACE(string, args...) pr_err(string, ##args)
#ifdef ENABLE_TRACE
#define DRV_MNGR_TI_TRACE(string, args...) pr_info(string, ##args)
#define DRV_MNGR_TD_TRACE(string, args...) pr_info(string, ##args)
#else
#define DRV_MNGR_TI_TRACE(string, args...)
#define DRV_MNGR_TD_TRACE(string, args...)
#endif /*ENABLE_TRACE*/

/*** HAL handler traces ***/
#define HAL_TA_TRACE(string, args...) pr_alert(string, ##args)
#define HAL_TE_TRACE(string, args...) pr_err(string, ##args)
#ifdef ENABLE_TRACE
#define HAL_TI_TRACE(string, args...) pr_info(string, ##args)
#define HAL_TD_TRACE(string, args...) pr_debug(string, ##args)
#define SPI_HISTORY(string, args...) pr_debug(string, ##args)
#else
#define HAL_TI_TRACE(string, args...)
#define HAL_TD_TRACE(string, args...)
#define SPI_HISTORY(string, args...)
#endif /*ENABLE_TRACE*/
#ifdef FUNC_ENTRY
#define ENTRY_FUNC_HAL(string, args...) pr_debug(string, ##args)
#else
#define ENTRY_FUNC_HAL(string, args...)
#endif /* FUNC_ENTRY_EXIT */

/*** Interpreter handler traces ***/
#define INTE_TA_TRACE(string, args...) pr_alert(string, ##args)
#define INTE_TE_TRACE(string, args...) pr_err(string, ##args)
#ifdef ENABLE_TRACE
#define INTE_TI_TRACE(string, args...) pr_info(string, ##args)
#define INTE_TD_TRACE(string, args...) pr_debug(string, ##args)
#else
#define INTE_TI_TRACE(string, args...)
#define INTE_TD_TRACE(string, args...)
#endif /*ENABLE_TRACE*/

/*** SCSI handler traces ***/
#define SCSI_HND_TA_TRACE(string, args...) pr_alert(string, ##args)
#define SCSI_HND_TE_TRACE(string, args...) pr_err(string, ##args)
#ifdef ENABLE_TRACE
#define SCSI_HND_TI_TRACE(string, args...) pr_info(string, ##args)
#define SCSI_HND_TD_TRACE(string, args...) pr_debug(string, ##args)
#else
#define SCSI_HND_TI_TRACE(string, args...)
#define SCSI_HND_TD_TRACE(string, args...)
#endif /*ENABLE_TRACE*/

/*** SCSI block dev handler traces ***/
#define SCSI_BLK_TA_TRACE(string, args...) pr_alert(string, ##args)
#define SCSI_BLK_TE_TRACE(string, args...) pr_err(string, ##args)
#ifdef ENABLE_TRACE
#define SCSI_BLK_TI_TRACE(string, args...) pr_info(string, ##args)
#define SCSI_BLK_TD_TRACE(string, args...) pr_debug(string, ##args)
#else
#define SCSI_BLK_TI_TRACE(string, args...)
#define SCSI_BLK_TD_TRACE(string, args...)
#endif /*ENABLE_TRACE*/

/* MASCA main trace */
#define MAIN_TA_TRACE(string, args...) pr_alert(string, ##args)
#define MAIN_TE_TRACE(string, args...) pr_err(string, ##args)
#ifdef ENABLE_TRACE
#define MAIN_TI_TRACE(string, args...) pr_info(string, ##args)
#define MAIN_TD_TRACE(string, args...) pr_debug(string, ##args)
#else
#define MAIN_TI_TRACE(string, args...)
#define MAIN_TD_TRACE(string, args...)
#endif /*ENABLE_TRACE*/

/* Block reader trace */
#define BLKRDR_TR_A(string, args...) pr_alert(string, ##args)
#define BLKRDR_TR_E(string, args...) pr_err(string, ##args)
#ifdef ENABLE_TRACE
#define BLKRDR_TR_I(string, args...) pr_info(string, ##args)
#define BLKRDR_TR_D(string, args...) pr_debug(string, ##args)
#else
#define BLKRDR_TR_I(string, args...)
#define BLKRDR_TR_D(string, args...)
#endif

 /*Util rspc trace*/
#ifdef ENABLE_TRACE
#define RSPC_TD_TRACE(string, args...) pr_err(string, ##args)
#else
#define RSPC_TD_TRACE(string, args...)
#endif

/* SSI trace*/
#ifdef ENABLE_TRACE
#define SSI_TD_TRACE(string, args...) pr_err(string, ##args)
#else
#define SSI_TD_TRACE(string, args...)
#endif

/*DMA trace*/
#define DMA_TR_A(string, args...) pr_alert(string, ##args)
#define DMA_TR_E(string, args...) pr_err(string, ##args)
#ifdef ENABLE_TRACE
#define DMA_TR_I(string, args...) pr_info(string, ##args)
#define DMA_TR_D(string, args...) pr_debug(string, ##args)
#else
#define DMA_TR_I(string, args...)
#define DMA_TR_D(string, args...)
#endif

/*SPI trace*/
#ifdef ENABLE_TRACE
#define SPI_TR_D(string, args...) pr_alert(string, ##args)
#else
#define SPI_TR_D(string, args...)
#endif

#endif /* MASCA_TRACE_H */
