/*
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef MASCA_SSI_H
#define MASCA_SSI_H

#include "../sound/soc/fsl/imx-ssi.h"

#define SSI3_BASE_ADDR	0x02030000	/*SSI3 register base address*/
					/*Address of SSI3_SSI_STX0*/
#define SSI3_OFFSET	0x2C

#define CCM_BASE_ADDR	0x20C4000	/*Clock Controller Module base address*/
#define CCM_CCGR5_OFFET	0x7C		/*CCM Clock Gating Register 5 offset*/
#define SSI3_CLK_EN	0xc00000

/*Masca SSI functions*/
extern void masca_ssi_on(void);
extern void masca_ssi_off(void);
extern bool masca_ssi_is_on(void);

#endif /* MASCA_SSI_H */
