/*
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
#ifndef MASCA_SM_I_H
#define MASCA_SM_I_H

#include "masca_dispatch.h"

/*Get Event Media Status */
#define MASCA_EJECT_REQ		0x01
#define MASCA_NEW_MEDIA		0x02
#define MASCA_MEDIA_REMOVAL	0x03
#define MASCA_MEDIA_CHANGED	0x04
#define MASCA_MEDCHG_INSERTED	0x06
#define MASCA_MEDIA_REM_SLT	0x10
#define MASCA_NO_CHANGE		0x00
#define MASCA_CD_PREVEJECT	0x09 /* EJECT + 0x08 */
#define MASCA_CD_PREVINSERT	0x0a /* INSERT + 0x08 */

/*Get Event Power Status */
#define	PWRCHG_SUCCESS		0x01
#define PWRCHG_FAIL		0x02

#define USR_PLAY_CMD		0x01
#define USR_PAUSE_CMD		0x02

enum masca_sm_voltage_state {
	UNDER_VOLTAGE,
	CRITICAL_UNDER_VOLTAGE,
	NORMAL_VOLTAGE,
	OVER_VOLTAGE,
	MAX_VOLT_STATE
};

enum masca_sm_temperature_state {
	UNDER_TEMPERATURE,
	NORMAL_TEMPERATURE,
	OVER_TEMPERATURE,
	MAX_TEMP_STATE
};

enum masca_sm_drive_state {
	SM_NO_CD,
	SM_INSERTING,
	SM_INSERTED,
	SM_LOADING,
	SM_ACCESSIBLE,
	SM_EJECTING,
	SM_MAX_DRV_STATE
};

enum masca_sm_disc_state {
	SM_PLAYING,
	SM_PAUSED,
	SM_STOPPED,
	SM_MAX_DISC_STATE
};

enum masca_sm_module_state {
	SUSPENDED,
	NORMAL,
	MAX_MODULE_STATE
};

enum masca_sm_pwr_state {
	SM_PWR_ACTIVE = 0x01,
	SM_PWR_IDLE,
	SM_PWR_STANDBY,
	SM_PWR_SLEEP,
	SM_MAX_PWR
};

enum masca_ign_aud_status {
	IGN_AUD_TOC_NOT_READY,
	IGN_AUD_DISABLE,
	IGN_AUD_DISABLE_TOC_READ,
	IGN_AUD_DISABLE_TOC_READY,
	IGN_AUD_ENABLE,
	IGN_AUD_ENABLE_TOC_READ,
	IGN_AUD_ENABLE_TOC_READY,
	IGN_AUD_MAX
};

enum masca_last_sess {
	OPEN,
	CLOSED
};

enum masca_drive_status {
	DRV_MSG_READING_CD,
	DRV_MSG_TOC_READY,
	DRV_MSG_POWER_FAIL,
	DRV_MSG_DISC_INS,
	DRV_MSG_MAX
};

enum masca_play_mode {
	PLAY_MODE_CONTINUOUS,
	PLAY_MODE_NON_CONTINUOUS
};

struct masca_sm_state {
	enum masca_sm_voltage_state	sm_volt_state;
	enum masca_sm_temperature_state	sm_temp_state;
	enum masca_sm_drive_state	sm_drive_state;
	enum masca_sm_module_state	sm_driver_state;
	enum masca_sm_disc_state	sm_disc_state;
	enum masca_sm_pwr_state		sm_pwr_state;
};

extern enum masca_media_type		type_of_disc;
extern enum masca_media_type		present_cd_type;
extern enum masca_media_status	media_status;
extern char usr_pause_cmd;

extern void masca_sm_init(const struct masca_configuration * const p_config);

extern enum masca_error masca_sm_cmd_reply(
		const struct masca_drv_response_info * const p_response_info,
		struct masca_event_info * const p_evt_info);

extern enum masca_error masca_sm_event(
			const unsigned int evt_pattern,
			const struct masca_drv_event_info * const p_drv_event,
			struct masca_event_info * const p_evt_info);

extern void masca_sm_get_state(struct masca_sm_state * const p_sm_state);

extern enum masca_error masca_sm_get_session_info(
			struct masca_session_info ** const p_info_session);

extern enum masca_error masca_sm_get_toc(
				struct masca_cd_toc ** const p_info_toc);

extern enum masca_error masca_sm_get_cd_text(
				struct masca_cd_text ** const p_info_text);

extern void masca_sm_get_media_type(enum masca_media_type * const p_mda_type);

extern enum masca_error masca_sm_get_cd_capacity(
				unsigned int * const p_cd_capacity);

extern enum masca_media_status masca_sm_get_media_status(void);

extern enum masca_error masca_get_evt_notification(
				const struct masca_output * const p_output,
				unsigned char * const p_buffer,
				const unsigned int buf_length);

extern enum masca_error masca_read_subchannel(
				const struct masca_output * const p_output,
				unsigned char * const p_buffer,
				const unsigned int buf_length);

extern void masca_update_evt_stat(char evnt_stat);

extern void masca_update_power_evt(char pwr_stat);

extern void masca_sm_update_power_status(char pwr_status);

extern void masca_update_drive_temperature(void);
extern void masca_sm_set_ign_aud_status(enum masca_ign_aud_status ign_status);
extern enum masca_ign_aud_status masca_sm_get_ign_aud_status(void);
extern enum masca_error masca_drive_send_ignore_audio_cmd(bool ign_audio);
extern void masca_set_last_cmd_ign_bit(bool cmd_ign_bit);
extern bool masca_get_last_cmd_ign_bit(void);
extern void masca_sm_update_last_sess_state(enum masca_last_sess);
extern enum masca_last_sess masca_sm_get_last_sess_state(void);
extern enum masca_drive_status masca_get_drive_status(void);
extern void masca_update_drive_status(enum masca_drive_status stat);
extern void masca_update_play_mode(enum masca_play_mode mode);
extern enum masca_play_mode masca_get_play_mode(void);
#endif/*end of MASCA_SM_I_H*/

