/*
 * MASCA Main File
 *
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "masca_blkdev.h"
#include "masca_scsi_handler.h"
#include "masca_hal.h"
#include "masca_ssi.h"
#include "masca_spidev.h"

struct masca_configuration	masca_config;

static int __init masca_main_init(void)
{
	if (masca_spi_init() < 0)
		return -EIO;

	if (MASCA_OK  != masca_core_init()) {
		MAIN_TA_TRACE("Error: SCSI Handler Intialisation failed\n");
		masca_spi_exit();
		return -EIO;
	}

	if (MASCA_OK != masca_initialize_hal()) {
			MAIN_TA_TRACE("Error: HAL Intitialization failed\n");
		masca_core_deinit();
		masca_spi_exit();
			return -EIO;
	}

	if (masca_scsi_init() < 0) {
		MAIN_TA_TRACE("Error: Block device registration failed\n");
		masca_deinitialize_hal();
		masca_core_deinit();
		masca_spi_exit();
		return -EIO;
	}

	return 0;
}

static void __exit masca_main_exit(void)
{
	masca_scsi_deinit();
	masca_core_deinit();
	masca_spi_exit();
	masca_deinitialize_hal();
}

module_init(masca_main_init);
module_exit(masca_main_exit);

MODULE_DESCRIPTION("GEN3 MASCA DRIVER");
MODULE_LICENSE("GPL v2");
