/*
 * masca_interface.h file
 *
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef MASCA_INTERFACE_H
#define MASCA_INTERFACE_H
#include "masca_common_types.h"

enum masca_media {
	MASCA_CD_CDDA = 0,
	MASCA_CD_CDROM,
	MASCA_CD_BAD_MEDIA,
	MASCA_MAX_MEDIA
};

enum masca_evt_type {
/* defined but support to this is decided later*/
	MASCA_DRIVE_POWERON_RESET = 0,
/*signalled when mount happens due to auto reinsert*/
	MASCA_TDE_AUTO_MOUNT,
	MASCA_DRIVE_UNDER_VOLT,
	MASCA_DRIVE_NORMAL_VOLT,
	MASCA_DRIVE_OVER_TEMP,
	MASCA_DRIVE_NORMAL_TEMP,
	MASCA_NO_CD,
	MASCA_CD_INSERTING,
	MASCA_CD_INSERTED,
	MASCA_CD_LOADING,
	MASCA_CD_EJECTING,
	MASCA_CD_IN_SLOT,
	MASCA_CD_TRACK_END,
	MASCA_CD_END,
	MASCA_CD_PLAY_POS,
	MASCA_CD_PLAY_COMPLETE,
	MASCA_CD_TOC_ERROR,
/*signaled when user prevents the CD from spinning or disc has problems*/
	MASCA_CD_DEFECTIVE,
/*signalled when the gets stuck while inserting or ejecting*/
	MASCA_MECHA_LOAD_ERR,
	MASCA_BLOCK_UNREADABLE,
	MASCA_NO_EVT,
	MASCA_UNKNOWN_EVT
};

struct masca_evt_info {
	enum masca_evt_type    masca_event;
	enum masca_media       media_type;
	unsigned int               cd_hash_id;
	/*in logical block address format, for event indicating current play
	 position in the track MASCA_CD_PLAY_POS */
	unsigned int               info;
};

#endif /*end of MASCA_INTERFACE_H*/
