/*
 * masca_event_config.h file exports some macros for masca processing
 *
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef MASCA_EVENT_CONFIG_H
#define MASCA_EVENT_CONFIG_H

/*these preprocessors indicate the events allocated to each of the
classes, the classes should use only the allocated events*/
#define DRIVE_MANAGER_EVENT_MASK	0x0003FFFF
#define SM_EVENT_MASK			0x003C0000
#define CMD_HANDLER_EVENT_MASK		0x3FC00000
#define DIAG_HANDLER_EVENT_MASK		0xC0000000

/*define here the events of individual classes*/
/*events related to driver manager*/
#define DRV_MNGR_RCV_MESSAGE		0x01
#define DRV_MNGR_SM_UPDATE		0x02
#define SLOT_DIAGNOSTIC_TMOUT		0x04
#define SLOT_TOC_TEXT_HASH_TMOUT	0x08
#define SLOT_EJECT_TMOUT		0x10
#define SLOT_DRV_CTRL_TMOUT		0x20
#define BLOCK_READ_COMPLETE		0x40
#define BLOCK_READ_FAILED		0x80
#define BLOCK_READER_IDLE		0x100
#define EVENT_Q_UP			0x200
#define SLOT_RESPONSE_UPDATE		0x400
#define SLOT_ABORT_UPDATE		0x800
#define PLAY_RANGE_COMPLETE		0x1000
#define DISC_END_REACHED		0x2000
#define SLOT_BLOCK_READ_TMOUT		0x4000
#define BLOCK_READ_REQ			0x8000
#define BLOCK_READ_RESUME		0x10000

/*events related to state machine*/
#define SM_EVENT_UPDATE			0x40000
#define SM_EVENT_RESUME			0x100000
#define SM_EVENT_SUSPEND		0x200000

/*events related to command handler*/
#define CMD_HANDLER_REINSERT		0x400000
#define CMD_HANDLER_DSK_STOP		0x800000
#define CMD_FROM_QUEUE			0x1000000
#define CMD_ABORT			0x2000000
#define CMD_HNDLR_DSK_PAUSE		0x4000000

/*events related to diagnostic command handler*/
#define DIAG_CMD_FROM_QUEUE		0x40000000
#define DIAG_CMD_ABORT			0x80000000

#endif/*end of MASCA_EVENT_CONFIG_H*/

