/*
 * masca_drv_mngr_slot.h file exports drive manager slot API's.
 *
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef MASCA_DRV_MNGR_SLOT_H_
#define MASCA_DRV_MNGR_SLOT_H_

enum masca_slot_num {
	SLOT_DIAGNOSTIC = 0,
	SLOT_EJECT,
	SLOT_DRV_CTRL,
	SLOT_TOC_TEXT_HASH,
	SLOT_BLK_RD,
	SLOT_MAX_NUM
};

enum masca_slot_state {
	SLOT_IDLE = 0,
	SLOT_PAUSED,
	SLOT_EXECUTING,
	SLOT_MAX_STATE
};

struct masca_cmd_slot {
	struct masca_drv_cmd_info          app_cmd_info;
	enum masca_slot_state            slot_stat;
	unsigned int                         slot_tmout;
	enum masca_error                 hw_response;
	bool                        abort_slot;
};


struct masca_slot_class {
	enum masca_cmd (*get_cmd_func) (void);
	enum masca_error (*exec_func)(const struct masca_drv_cmd_info *
					const p_cmd_info,
					struct masca_drv_response_info *
					const p_response_info);
	void (*rcv_func)(const struct masca_intrptr_msg_info_list *
					const p_list,
			const struct masca_intrptr_rjt_cmd_list *
			const p_rjt_cmds,
			const struct masca_intrptr_msg_info * const p_msg,
			struct masca_drv_response_info * const p_response_info);

	bool (*event_func)(unsigned int evt_ptn_slot,
					struct masca_drv_response_info *
					const p_response_info);
	void (*pause_func)(void);
	void (*resume_func)
			(struct masca_drv_response_info *
						const p_response_info);
	void (*abort_func)
			(struct masca_drv_response_info * const p_response_info,
						enum masca_error abort_reason);
};

/*Exported APIs for diagnostic slot which handles all diagnostic
 * messages*/
enum masca_cmd masca_get_diag_cmd(void);

void masca_init_diag(const unsigned int retry_cnt,
				const unsigned int reset_cnt,
				const unsigned int response_tmout);

enum masca_error
masca_tx_diag(const struct masca_drv_cmd_info * const p_cmd_info,
		 struct masca_drv_response_info * const p_response_info);


void masca_rx_diag(const struct masca_intrptr_msg_info_list * const p_list,
		const struct masca_intrptr_rjt_cmd_list * const p_rjt_cmds,
		const struct masca_intrptr_msg_info * const p_msg,
		struct masca_drv_response_info * const p_response_info);

void masca_pause_diag(void);

void masca_resume_diag(struct masca_drv_response_info * const p_response_info);

void masca_abort_diag(struct masca_drv_response_info * const p_response_info,
				enum masca_error              abort_reason);


bool masca_evt_diag(unsigned int evt_ptn_slot,
				struct masca_drv_response_info * const
							p_response_info);

/*Exported APIs for drive control slot which handles all drive control commands
except eject*/
enum masca_cmd masca_get_drvctrl_cmd(void);

void masca_init_drvctrl(const unsigned int retry_cnt,
				const unsigned int reset_cnt,
				const unsigned int response_tmout);

enum masca_error
masca_tx_drvctrl(const struct masca_drv_cmd_info * const p_cmd_info,
			struct masca_drv_response_info * const p_response_info);

void masca_rx_drvctrl(
		const struct masca_intrptr_msg_info_list * const p_list,
		const struct masca_intrptr_rjt_cmd_list * const p_rjt_cmds,
		const struct masca_intrptr_msg_info * const p_msg,
		struct masca_drv_response_info * const p_response_info);

void masca_pause_drvctrl(void);

void
masca_resume_drvctrl(struct masca_drv_response_info * const p_response_info);

void masca_abort_drvctrl(struct masca_drv_response_info * const p_response_info,
					enum masca_error abort_reason);

bool masca_evt_drvctrl(unsigned int evt_ptn_slot,
				struct masca_drv_response_info * const
							p_response_info);

void masca_reset_play_sm(void);
void masca_stop_play_sm(void);

/*Exported APIs for toc text reading slot which includes sector read for
  determining hash of CDROM */
enum masca_cmd masca_get_toctexthash_cmd(void);

void masca_init_toc_text_hash(const unsigned int retry_cnt,
					const unsigned int reset_cnt,
					const unsigned int response_tmout);

enum masca_error masca_tx_toctexthash(
			const struct masca_drv_cmd_info * const p_cmd_info,
			struct masca_drv_response_info * const p_response_info);

void masca_rx_toctexthash(
		const struct masca_intrptr_msg_info_list * const p_list,
		const struct masca_intrptr_rjt_cmd_list * const p_rjt_cmds,
		const struct masca_intrptr_msg_info * const p_msg,
		struct masca_drv_response_info * const p_response_info);
void masca_pause_toctexthash(void);

void masca_resume_toctexthash(struct masca_drv_response_info * const
							p_response_info);
void
masca_abort_toctexthash(struct masca_drv_response_info * const p_response_info,
					enum masca_error abort_reason);

bool masca_evt_toctexthash(unsigned int evt_ptn_slot,
				struct masca_drv_response_info * const
							p_response_info);

void masca_get_cd_toc(struct masca_cd_toc ** const pp_toc);


/*Exported APIs for eject handling slot*/

enum masca_cmd masca_get_eject_cmd(void);

void masca_init_eject(const unsigned int retry_cnt,
				const unsigned int reset_cnt,
				const unsigned int response_tmout);

enum masca_error
masca_fill_eject(const struct masca_drv_cmd_info * const p_cmd_info);

enum masca_error masca_tx_eject(
			const struct masca_drv_cmd_info * const p_cmd_info,
			struct masca_drv_response_info * const p_response_info);

void masca_rx_eject(const struct masca_intrptr_msg_info_list * const p_list,
		   const struct masca_intrptr_rjt_cmd_list * const p_rjt_cmds,
		   const struct masca_intrptr_msg_info * const p_msg,
		   struct masca_drv_response_info * const p_response_info);

void masca_pause_eject(void);

void masca_resume_eject(struct masca_drv_response_info * const p_response_info);

void masca_abort_eject(struct masca_drv_response_info * const p_response_info,
					enum masca_error abort_reason);

bool masca_evt_eject(unsigned int evt_ptn_slot,
			struct masca_drv_response_info * const p_response_info);

/*Exported APIs for slot controlling block reader*/
void masca_init_blkrd(const unsigned int retry_cnt,
				const unsigned int reset_cnt,
				const unsigned int response_tmout);
enum masca_cmd masca_get_blkrd_cmd(void);
enum masca_error
masca_tx_blkrd(const struct masca_drv_cmd_info * const p_cmd_info,
			struct masca_drv_response_info * const p_response_info);
void masca_rx_blkrd(
		const struct masca_intrptr_msg_info_list * const p_list,
		const struct masca_intrptr_rjt_cmd_list * const p_rjt_cmds,
		const struct masca_intrptr_msg_info * const p_msg,
		struct masca_drv_response_info * const p_response_info);

void masca_pause_blkrd(void);
void masca_resume_blkrd(struct masca_drv_response_info * const p_response_info);
void masca_abort_blkrd(struct masca_drv_response_info * const p_response_info,
				enum masca_error              abort_reason);
bool masca_evt_blkrd(unsigned int evt_ptn_slot,
				struct masca_drv_response_info * const
							p_response_info);
void masca_blkrd_set_spin_speed(enum masca_spin_speed spin_speed);

void masca_drv_mngr_blkrd_cache_disable(bool drv_mngr_disable_cache);

#endif /* MASCA_DRV_MNGR_SLOT_H_ */

