/*
 * masca_drv_mngr_internal.h file exports drive management related API's.
 *
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef MASCA_DRV_MNGR_INTERNAL_H_
#define MASCA_DRV_MNGR_INTERNAL_H_


#define MAX_SEARCH_MSGS		10

struct masca_msg_search {
	unsigned char num_messages;
	enum masca_intrptr_decode_msg search_msg[MAX_SEARCH_MSGS];
};

struct masca_last_evt {
	enum masca_intrptr_decode_msg disc_event;
	enum masca_intrptr_decode_msg disc_load_err_event;
	enum masca_intrptr_decode_msg volt_event;
	enum masca_intrptr_decode_msg temp_event;
	enum masca_intrptr_decode_msg trk_end_event;
	enum masca_intrptr_decode_msg toc_event;
	enum masca_intrptr_decode_msg dsk_defect_evt;
};

void masca_init_tx_rx(const enum masca_slot_num slot_no,
				const unsigned int retry_cnt,
				const unsigned int reset_cnt);

void masca_send_cmd(const enum masca_slot_num slot_no,
				const enum masca_intrptr_cmd cmd_to_drive,
				const unsigned int play_pos,
				const unsigned char trk_no,
				const unsigned char blk_cnt);

void masca_send_diag_cmd(const enum masca_slot_num slot_no,
				const enum masca_intrptr_cmd cmd_to_drive,
				const unsigned int inst_date_write,
				unsigned char * const p_write_sticker);

enum masca_error
masca_rcv_response(
		const enum masca_slot_num slot_no,
		const struct masca_intrptr_msg_info_list * const p_list,
		const struct masca_intrptr_rjt_cmd_list * const p_rjt_cmds);

enum masca_error masca_evt_tmout(const enum masca_slot_num slot_no,
					bool * const p_is_rst_cnt_change);

void masca_abort_unit(const enum masca_slot_num slot_no);

void masca_reload_rty_cnt(const enum masca_slot_num slot_no);

bool masca_is_msg_prsnt(const struct masca_msg_search * const p_msg_search,
			const struct masca_intrptr_msg_info_list * const p_list,
			enum masca_intrptr_decode_msg * const p_msg_intrptr,
			const enum masca_msg_relation msg_relation);

bool masca_chk_msg(const struct masca_intrptr_msg_info_list * const p_list,
			const enum masca_intrptr_decode_msg msg_intrptr);

void masca_tx_cmd(const struct masca_intrptr_cmd_info * const p_cmd);
void masca_chk_slot_response(
		struct masca_cmd_slot * const p_slot,
		const struct masca_intrptr_msg_info_list * const p_list,
		const struct masca_intrptr_rjt_cmd_list * const p_rjt_cmds);
enum masca_error masca_fill_slot(struct masca_cmd_slot * const p_slot,
			   const struct masca_drv_cmd_info * const p_cmd_info,
			   bool *const p_to_execute);

bool masca_retry_slot(const enum masca_slot_num slot_no,
				struct masca_cmd_slot * const p_slot,
				struct masca_drv_response_info *
						const p_response_info);

void masca_get_last_event(struct masca_last_evt * const p_lst_evt);
void masca_get_cur_pos(struct masca_drv_play_info ** const p_position);

void masca_evt_gen_init(void);

void
masca_chk_for_events(const struct masca_intrptr_msg_info_list * const p_list,
			const struct masca_intrptr_msg_info * const p_msg,
			struct masca_drv_event_info * const p_evt_info);
void masca_handle_event_q(const unsigned int q_evt_ptn,
			 struct masca_drv_event_info * const p_evt_info);
void masca_tx_cmd(const struct masca_intrptr_cmd_info * const p_cmd);

#endif /* MASCA_DRV_MNGR_INTERNAL_H_ */
