
/*
 * MASCA Drive Manager Configuration File
 *
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "masca_common_types.h"
#include "masca_helper.h"
#include "masca_interpreter.h"
#include "masca_drv_mngr.h"
#include "masca_drv_mngr_slot.h"
#include "masca_drv_mngr_cnfg.h"

/*!!!!!!!!!!!!!!!!!!!!!!!!!!IMPORTANT!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/*This array should be in order of MASCA_intrptr_cmd enums              */
/*!!!!!!!!!!!!!!!!!!!!!!!!!!IMPORTANT!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
const struct masca_drive_response drv_responses[CMD_MAX] = {
	{{VERSION_INFO                  , MESSAGE_MAX},             MASCA_OR},
	{{FEATURE_INFO                  , MESSAGE_MAX},             MASCA_OR},
	{{MECHANICAL_INIT_COMPLETE      , DRIVE_POWER_OK},          MASCA_AND},
	{{SYS_TOC                       , MESSAGE_MAX},             MASCA_OR},
	{{MULTISESSION_PLAYBACK_ENABLED , MESSAGE_MAX},             MASCA_OR},
	{{MULTISESSION_PLAYBACK_DISABLED, MESSAGE_MAX},             MASCA_OR},
	{{MESSAGE_MAX                   , MESSAGE_MAX},             MASCA_OR},
	{{MESSAGE_MAX                   , MESSAGE_MAX},             MASCA_OR},
	{{TRACK_AUDIO                   , MESSAGE_MAX},             MASCA_OR},
	{{TRACK_START                   , MESSAGE_MAX},             MASCA_OR},
	{{MESSAGE_MAX                   , MESSAGE_MAX},             MASCA_OR},
	{{MESSAGE_MAX                   , MESSAGE_MAX},             MASCA_OR},
	{{AUDIO_TRACKS_IGNORED		, MESSAGE_MAX},             MASCA_OR},
	{{AUDIO_TRACKS_CONSIDERED	, MESSAGE_MAX},             MASCA_OR},
	{{TRACK_NAME                    , MESSAGE_MAX},             MASCA_OR},
	{{AUTHOR_NAME                   , MESSAGE_MAX},             MASCA_OR},
	{{ALBUM_NAME                    , MESSAGE_MAX},             MASCA_OR},
	{{TRACK_DURATION                , MESSAGE_MAX},             MASCA_OR},
	{{TRACK_ATTRIBUTES              , MESSAGE_MAX},             MASCA_OR},
	{{DISC_PAUSED                   , MUTE_ON    },             MASCA_AND},
	{{DISC_PAUSED                   , MESSAGE_MAX},             MASCA_OR},
	{{DISC_STOPPED                  , MESSAGE_MAX},             MASCA_OR},
	{{DISC_SEARCHING                , MESSAGE_MAX},             MASCA_OR},
	{{DISC_SEARCHING                , MESSAGE_MAX},             MASCA_OR},
	{{DISC_SEARCHING                , MESSAGE_MAX},             MASCA_OR},
	{{DISC_SEARCHING                , MESSAGE_MAX},             MASCA_OR},
	{{DISC_INSERTING                , DISC_INSERTED},           MASCA_OR},
	{{DISC_EJECTING                 , MESSAGE_MAX},             MASCA_OR},
	{{DISC_PLAYING                  , MESSAGE_MAX},             MASCA_OR},
	{{DISC_PLAYING                  , DISC_PLAYMODE_CONTINOUS}, MASCA_AND},
	{{DISC_PLAYING                  , DISC_PLAYMODE_CONTINOUS}, MASCA_AND},
	{{DISC_PLAYING                  , DISC_PLAYMODE_CONTINOUS}, MASCA_AND},
	{{DISC_PLAYMODE_CONTINOUS       , MESSAGE_MAX},             MASCA_OR},
	{{DSP_INIT_SUCCESSFUL           , MESSAGE_MAX},             MASCA_OR},
	{{DRIVE_SPEED_1X                , MESSAGE_MAX},             MASCA_OR},
	{{DRIVE_SPEED_HALF_MAXIMUM      , MESSAGE_MAX},             MASCA_OR},
	{{DISC_PLAYING                  , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_TEMPERATURE              , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_LASER_CURRENT            , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_SWITCH_STATUS            , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_ADJUSTMENT               , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_C1C2_ERR_COUNT_ON        , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_CD_TEXT_OFF              , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_CD_TEXT_MODE2            , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_TIME_READOUT             , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_EJECT_LOAD_CYCLES        , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_JUMP_COUNTER             , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_EEPROM_READOUT           , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_WRITE_STICKER            , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_READ_STICKER             , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_JITTER_MEASURE           , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_VERTICAL_DEV_MEASURE     , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_ECCENTRIC_MEASURE        , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_REFLECTIVE_MEASURE       , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_INTERNAL_SELF_TEST       , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_EXTERNAL_SDRAM_TEST      , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_INIT_LASER_CURRENT       , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_NUM_READ_ERRS            , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_DATE_PRODUCTION_READ     , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_DATE_INSTALL_WRITE       , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_DATE_INSTALL_READ        , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_SERIAL_NO_READ           , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_STATUS_MSG_ERR_HISTROY   , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_STATUS_MSG_LAST_ERRS     , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_USED_CD_TYPE_COUNT       , MESSAGE_MAX},             MASCA_OR},
	{{DIAG_USER_PROFILE_USED_CDS    , MESSAGE_MAX},             MASCA_OR}
};

/*!!!!!!!!!!!!!!!!!!!IMPORTANT!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/*Always match the below array according to the order of MASCA_cmd */
/*!!!!!!!!!!!!!!!!!!!IMPORTANT!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/*This array maps the application commands with the interpreter commands*/

const struct masca_drv_cmd_map app_cmd_mapping[MAX_COMMAND] = {
	{CMD_PLAY,             SLOT_DRV_CTRL},
	{CMD_PLAY_CONTINUOUS,  SLOT_DRV_CTRL},
	{CMD_PLAY,             SLOT_DRV_CTRL},
	{CMD_PLAY_CONTINUOUS,  SLOT_DRV_CTRL},
	{CMD_PAUSE_MUTE,       SLOT_DRV_CTRL},
	{CMD_FAST_SEARCH_FWD,  SLOT_DRV_CTRL},
	{CMD_FAST_SEARCH_FWD,  SLOT_DRV_CTRL},
	{CMD_SEARCH_FWD,       SLOT_DRV_CTRL},
	{CMD_SEARCH_FWD,       SLOT_DRV_CTRL},
	{CMD_SEARCH_BWD,       SLOT_DRV_CTRL},
	{CMD_SEARCH_BWD,       SLOT_DRV_CTRL},
	{CMD_FAST_SEARCH_BWD,  SLOT_DRV_CTRL},
	{CMD_FAST_SEARCH_BWD,  SLOT_DRV_CTRL},
	{CMD_INSERT,           SLOT_EJECT},
	{CMD_EJECT,            SLOT_EJECT},
	{CMD_SYS_STAT,		SLOT_EJECT},
	{CMD_STOP,             SLOT_DRV_CTRL},
	{CMD_SYS_STAT,         SLOT_EJECT},
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_STOP,             SLOT_DRV_CTRL},
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_MAX,              SLOT_BLK_RD  },
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_VERSION_INFO,     SLOT_DIAGNOSTIC},
	{CMD_MAX,              SLOT_TOC_TEXT_HASH},
	{CMD_MAX,              SLOT_TOC_TEXT_HASH},
	{CMD_MAX,              SLOT_TOC_TEXT_HASH},
	{CMD_MAX,              SLOT_BLK_RD  },
	{CMD_RESUME,           SLOT_DRV_CTRL},
	{CMD_STOP,             SLOT_DRV_CTRL},
	{CMD_EN_IGN_AUDIO,     SLOT_DRV_CTRL},
	{CMD_DIS_IGN_AUDIO,    SLOT_DRV_CTRL},
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_MAX,              SLOT_MAX_NUM },
	{CMD_GET_TEMPERATURE,  SLOT_DIAGNOSTIC},
	{CMD_GET_LASER_CURRENT, SLOT_DIAGNOSTIC},
	{CMD_GET_SWITCH_STATUS, SLOT_DIAGNOSTIC},
	{CMD_ADJUSTMENT,       SLOT_DIAGNOSTIC},
	{CMD_CD_TEXT_OFF,      SLOT_DIAGNOSTIC},
	{CMD_CD_TEXT_MODE2,    SLOT_DIAGNOSTIC},
	{CMD_C1C2_ERR_COUNT_ON, SLOT_DIAGNOSTIC},
	{CMD_TIME_READOUT,     SLOT_DIAGNOSTIC},
	{CMD_EJECT_LOAD_CYCLES, SLOT_DIAGNOSTIC},
	{CMD_JUMP_COUNTER,     SLOT_DIAGNOSTIC},
	{CMD_EEPROM_READOUT,   SLOT_DIAGNOSTIC},
	{CMD_WRITE_STICKER,    SLOT_DIAGNOSTIC},
	{CMD_READ_STICKER,     SLOT_DIAGNOSTIC},
	{CMD_JITTER_MEASURE,   SLOT_DIAGNOSTIC},
	{CMD_VERTICAL_DEV_MEASURE,  SLOT_DIAGNOSTIC},
	{CMD_ECCENTRIC_MEASURE,     SLOT_DIAGNOSTIC},
	{CMD_REFLECTIVE_MEASURE,    SLOT_DIAGNOSTIC},
	{CMD_INTERNAL_SELF_TEST,    SLOT_DIAGNOSTIC},
	{CMD_EXTERNAL_SDRAM_TEST,   SLOT_DIAGNOSTIC},
	{CMD_INIT_LASER_CURRENT,    SLOT_DIAGNOSTIC},
	{CMD_NUM_READ_ERRS,         SLOT_DIAGNOSTIC},
	{CMD_DATE_PRODUCTION_READ,  SLOT_DIAGNOSTIC},
	{CMD_DATE_INSTALL_WRITE,    SLOT_DIAGNOSTIC},
	{CMD_DATE_INSTALL_READ,     SLOT_DIAGNOSTIC},
	{CMD_SERIAL_NO_READ,        SLOT_DIAGNOSTIC},
	{CMD_STATUS_MSG_ERR_HISTROY, SLOT_DIAGNOSTIC},
	{CMD_STATUS_MSG_LAST_ERRS,  SLOT_DIAGNOSTIC},
	{CMD_USED_CD_TYPE_COUNT,    SLOT_DIAGNOSTIC},
	{CMD_USER_PROFILE_USED_CDS, SLOT_DIAGNOSTIC},
	{CMD_MAX,		    SLOT_MAX_NUM },
	{CMD_MAX,		    SLOT_MAX_NUM },
	{CMD_PLAY_NON_CONTINUOUS,   SLOT_DRV_CTRL}
};
