/*
 * masca_drv_mngr.h file exports drive management related API's.
 *
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef MASCA_DRV_MNGR_I_H
#define MASCA_DRV_MNGR_I_H

#define MAX_TEMPERATURE_SIZE		2 /* Temperature current byte size*/
#define MAX_LASER_CUR_SIZE		4 /* Laser current byte size*/
#define MAX_SWITCH_STATUS_SIZE		1 /* Switch status byte size*/
#define MAX_DIAG_ADJUST_SIZE		9 /* Diag adjustment byte size*/
#define MAX_CMD_RECEIVE_SIZE		1 /* cmd recevied byte size*/
#define MAX_C1C2_ERR_CNT_SIZE		4 /* c1c2 error count byte size*/
#define MAX_DIAG_TIME_READOUT_SIZE	101 /* as per diag design spec value
						 time readout byte
						 size is 178 bytes.
						 But from the drive 101 bytes
						 of information recevied*/
#define MAX_EJT_LD_CYC_SIZE		3 /* eject load cycles byte size*/
#define MAX_EEPROM_READOUT_SIZE		129/* as per diag design spec value
						EEPROM readout is 276 byte size.
						But from the drive 129 bytes
						of information recevied */
#define MAX_WRITE_STICKER_SIZE		2 /* write sticker byte size*/
#define MAX_READ_STICKER_SIZE		18/* Read sticker byte size*/
#define MAX_JITTER_MEASURE_SIZE		1 /* Jitter measurement byte size*/
#define MAX_VER_DEV_SIZE		2 /* vertical deviation byte size*/
#define MAX_ECCENTRICITY_SIZE		2 /* eccentricity byte size*/
#define MAX_REFLECTIVE_SIZE		1 /* Reflectivity byte size*/
#define MAX_INTER_SELF_SIZE		1 /* Internal self test byte size*/
#define MAX_EXTER_SDRAM_TEST_SIZE	1 /* External SDRAM test byte size*/
#define MAX_INTI_LASER_CUR_SIZE		3 /* Initial laser current byte size*/
#define MAX_NO_READ_ERRS_SIZE		3 /* No. of read errors byte size*/
#define MAX_DATE_PROD_INSTALL_SIZE	4 /* Date production/installation
						byte size*/
#define MAX_SERIAL_NO_SIZE		4  /* Serial number byte size*/
#define MAX_MSG_ERR_HIS_SIZE		75 /* as per diag design spec value
						Status msg err history errors
						byte size is 38 bytes.
						But from the drive 75 bytes
						of information recevied*/
#define MAX_MSG_LAST_ERRS_SIZE		13 /* as per diag design spec value
						Status msg last error
						byte size is 11 bytes.
						But from the drive 13 bytes
						of information recevied*/
#define MAX_CD_TYPE_CNT_SIZE		13 /* Used CD type counter byte size*/
#define MAX_PROFIL_USED_CD_SIZE		7  /* Used profile used CDs byte size*/
#define RANGE_COUNT			2

union masca_diag_param {
	unsigned char	laser_current[MAX_LASER_CUR_SIZE];
	unsigned char	switch_status;
	unsigned char	cmd_recevied;
	struct masca_adjustment		diag_adjust;
	unsigned char	c1c2_err_count[MAX_C1C2_ERR_CNT_SIZE];
	unsigned char	temperature[MAX_TEMPERATURE_SIZE];
	unsigned char	time_readout[MAX_DIAG_TIME_READOUT_SIZE];
	unsigned char	eject_load_cycles[MAX_EJT_LD_CYC_SIZE];
	struct masca_jump_counter	jump_cnt;
	unsigned char	eeprom_readout[MAX_EEPROM_READOUT_SIZE];
	unsigned char	write_sticker_no[MAX_WRITE_STICKER_SIZE];
	unsigned char	read_sticker_no[MAX_READ_STICKER_SIZE];
	unsigned char	jitter_measure;
	unsigned char	vertical_dev_measure[MAX_VER_DEV_SIZE];
	unsigned char	eccentric_measure[MAX_ECCENTRICITY_SIZE];
	unsigned char	reflective_measure;
	unsigned char	internal_self_test;
	unsigned char	external_sdram_test;
	unsigned char	init_laser_current[MAX_INTI_LASER_CUR_SIZE];
	unsigned char	num_read_errs[MAX_NO_READ_ERRS_SIZE];
	unsigned char	date_product_install_read[MAX_DATE_PROD_INSTALL_SIZE];
	unsigned char	serial_no_read[MAX_SERIAL_NO_SIZE];
	unsigned char	status_msg_err_histroy[MAX_MSG_ERR_HIS_SIZE];
	unsigned char	status_msg_last_errs[MAX_MSG_LAST_ERRS_SIZE];
	unsigned char	used_cd_type_cnt[MAX_CD_TYPE_CNT_SIZE];
	unsigned char	user_profile_used_cds[MAX_PROFIL_USED_CD_SIZE];
	unsigned char	spi_req_his_len;
};

struct masca_drv_cmd_params {
	union masca_param_collection drv_param;
	struct masca_cd_toc *p_cd_toc;
	struct masca_cd_text *p_cd_text;
	struct masca_session_info *p_cd_session_info;
};

struct masca_drv_cmd_info {
	enum masca_cmd command;
	struct masca_drv_cmd_params command_param;
	int reply_id;
};

union masca_drv_response_param {
	struct masca_version_info cd_version_info;
	union masca_diag_param cd_diag_params;
};

struct masca_drv_response_info {
	enum masca_cmd drv_cmd_response;
	enum masca_error response_error;
	union masca_drv_response_param response_param;
	int response_id;
};

enum masca_drv_event {
	DRV_DISC_ABSENT,
	DRV_DISC_INSERTING,
	DRV_DISC_INSERTED,
	DRV_DISC_TOC_READY,
	DRV_DISC_READING_TOC,
	DRV_DISC_TOC_ERROR,
	DRV_DISC_PLAYING,
	DRV_DISC_PAUSED,
	DRV_DISC_STOPPED,
	DRV_DISC_PLAY_INFO,
	DRV_TRACK_END,
	DRV_DISC_END,
	DRV_PLAY_RANGE_END,
	DRV_DISC_EJECTING,
	DRV_DISC_IN_SLOT,
	DRV_DISC_DEFECTIVE,
	DRV_MECHANIC_LOAD_ERR,
	DRV_UNDER_VOLT,
	DRV_NORMAL_VOLT,
	DRV_OVER_TEMP,
	DRV_NORMAL_TEMP,
	DRV_NO_EVENT
};

struct masca_drv_play_info {
	unsigned char abs_min;
	unsigned char abs_sec;
	unsigned char rel_min;
	unsigned char rel_sec;
	unsigned char trk_playing;
	unsigned char index;
};

struct masca_drv_event_info {
	enum masca_drv_event		drv_event;
	struct masca_drv_play_info	play_position;
};

enum routetype {
	ROUTE_CDDA,
	ROUTE_CDROM,
	ROUTE_MAX
};

/*There is no session info support from hardware*/
#define SESSION_INFO_NO_SUPPORT

void masca_drv_mngr_init(const struct masca_configuration * const p_config);
void masca_drv_mngr_deinit(void);

enum masca_error
masca_drive_mngr_cmd(const struct masca_drv_cmd_info * const p_cmd_info,
			struct masca_drv_response_info * const p_response_info);

enum masca_error masca_drive_mngr_event(const unsigned int event_pattern,
			struct masca_drv_event_info * const p_evt_info,
			struct masca_drv_response_info * const p_response_info);

void masca_drive_mngr_abort(const enum masca_cmd abort_command);
void masca_drive_mngr_sleep(void);
void masca_drive_mngr_wakeup(void);
void masca_drv_mngr_flush_buffers(void);
void masca_drv_mngr_disable_cache(bool drv_mngr_disable_cache);
#endif /*end of MASCA_DRV_MNGR_I_H*/
