/*
 * boottime_internal.h
 *
 * Copyright (C) Robert Bosch Car Multimedia GmbH Hildesheim 2013
 * Author: Jonas Oester (jonas.oester@de.bosch.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __boottime_internal_h
#define __boottime_internal_h

void mxc_get_boottime(u32 *first_ts, u32 *ts_rate);

#ifdef CONFIG_RBCM_BL_TIMESTAMP
u32 *imx6q_get_timestamp_table(size_t *sizep);
#endif

extern int init_boottime_impl(void);
extern int exit_boottime_impl(void);

#define TIMESTAMP_TABLE_TAG_MIN			0xcf30000
#define TIMESTAMP_TABLE_TAG_MAX			(TIMESTAMP_TABLE_TAG_MIN + 0xff)
#define TIMESTAMP_TABLE_TAG_INIT1		(TIMESTAMP_TABLE_TAG_MIN + 0x01)
#define TIMESTAMP_TABLE_TAG_INIT2		(TIMESTAMP_TABLE_TAG_MIN + 0x02)
#define TIMESTAMP_TABLE_TAG_AFTER_HW_INIT	(TIMESTAMP_TABLE_TAG_MIN + 0x03)
#define TIMESTAMP_TABLE_TAG_AFTER_PROMPT	(TIMESTAMP_TABLE_TAG_MIN + 0x04)
#define TIMESTAMP_TABLE_TAG_AFTER_BTM_CHECK	(TIMESTAMP_TABLE_TAG_MIN + 0x05)
#define TIMESTAMP_TABLE_TAG_AFTER_KERNEL	(TIMESTAMP_TABLE_TAG_MIN + 0x06)
#define TIMESTAMP_TABLE_TAG_AFTER_DTB		(TIMESTAMP_TABLE_TAG_MIN + 0x07)
#define TIMESTAMP_TABLE_TAG_AFTER_EMMC_WAKEUP	(TIMESTAMP_TABLE_TAG_MIN + 0x08)
#define TIMESTAMP_TABLE_TAG_AFTER_DTB_PARSE	(TIMESTAMP_TABLE_TAG_MIN + 0x09)
#define TIMESTAMP_TABLE_NOT_USED		0xdeadb007

#endif
