/*
 * adv7182.h - ADV7182 video Decoder driver
 *
 * Copyright 2013-2014 Robert Bosch Engineering and Business solutions Ltd.
 *			Inc. All Rights Reserved.
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
*/

#ifndef _ADV7182_H
#define _ADV7182_H

#define ADV7182_RESET_ACTIVE		0
#define ADV7182_RESET_DEACTIVE		1
#define ADV7182_PWRDN_ACTIVE		0
#define ADV7182_PWRDN_DEACTIVE		1
#define ADV7182_SUCCESS			0
#define ADV7182_GPIO_ERR_INVALID_PIN	-101
#define ADV7182_GPIO_ERR_REQ		-102
#define ADV7182_GPIO_ERR_DIR_OUT	-103
#define ADV7182_GPIO_ERR_DIR_IN		-104
#define ADV7182_GPIO_ERR_INVALID_DIR	-105
#define ADV7182_GPIO_DIR_OUT		1
#define ADV7182_GPIO_DIR_IN		2
#define ADV7182_GPIO_RST_NAME		"RESET_ADV7182"
#define ADV7182_GPIO_PWR_DN_NAME	"PWR_DN_ADV7182"
#define IF_NAME				"adv7182"
#define ADV7182_IN_LOCK              (1 << 0)
#define ADV7182_LOST_LOCK            (1 << 1)
#define ADV7182_FSC_LOCK             (1 << 2)
#define ADV7182_AD_RESULT_BIT        4
#define ADV7182_AD_RESULT_MASK       (0x7 << ADV7182_AD_RESULT_BIT)
#define ADV7182_AD_NTSC              0
#define ADV7182_AD_NTSC_4_43         1
#define ADV7182_AD_PAL_M             2
#define ADV7182_AD_PAL_60            3
#define ADV7182_AD_PAL               4
#define ADV7182_AD_SECAM             5
#define ADV7182_AD_PAL_N             6
#define ADV7182_AD_SECAM_525         7
#define ADV7182_INT_CONFIG_1           0x40     /* Interrupt Config 1 */
#define ADV7182_INT_STATUS_1           0x42     /* Interrupt Status 1 (r/o) */
#define ADV7182_INT_SD_LOCK          (1 << 0)
#define ADV7182_INT_SD_UNLOCK        (1 << 1)
#define ADV7182_INT_CLEAR_1            0x43     /* Interrupt Clear 1 (w/o) */
#define ADV7182_INT_MASK_1             0x44     /* Interrupt Mask 1 */
#define ADV7182_INT_STATUS_2           0x46     /* Interrupt Status 2 (r/o) */
#define ADV7182_INT_CLEAR_2            0x47     /* Interrupt Clear 2 (w/o) */
#define ADV7182_INT_MASK_2             0x48     /* Interrupt Mask 2 */
#define ADV7182_INT_RAW_STATUS_3       0x49   /* Interrupt Raw Status 3 (r/o) */
#define ADV7182_INT_SD_V_LOCK        (1 << 1)
#define ADV7182_INT_STATUS_3           0x4a   /* Interrupt Status 3 (r/o) */
#define ADV7182_INT_SD_V_LOCK_CHNG   (1 << 1)
#define ADV7182_INT_SD_AD_CHNG       (1 << 3)
#define ADV7182_INT_CLEAR_3            0x4b     /* Interrupt Clear 3 (w/o) */
#define ADV7182_INT_MASK_3             0x4c     /* Interrupt Mask 3 */
#define ADV7182_INPUT_INDEX_DEF		0x07
#define ADV7182_MAX_REG			82  /* Number of reg to be configured */

/*Register Address*/
#define ADV_REG_ADDR_INSEL		0x00
#define ADV_REG_ADDR_ADC_SWITCH2	0xC4
#define ADV_REG_ADDR_ADC_SWITCH1	0xC3
#define ADV_REG_ADDR_ADC_SWITCH3	0x60
#define ADV_REG_ADDR_ADC_CTRL		0x3A
#define ADV_REG_ADDR_ADC_VID_SEL	0x07
#define ADV_REG_ADDR_ADC_ADI_CTRL2	0x1D
#define ADV_REG_ADDR_ADC_OUT_CTRL_EXTD	0x04
#define ADV_REG_ADDR_ADC_OUT_CTRL	0x03
#define ADV_REG_ADDR_CONTRAST		0x08
#define ADV_REG_ADDR_BRIGHTNESS		0x0A
#define ADV_REG_ADDR_SHARPNESS		0xFB
#define ADV_REG_ADDR_DEF_COLOR_Y	0x0C
#define ADV_REG_ADDR_DEF_COLOR_CR_CB	0x0D
#define ADV_REG_ADDR_NTSC_END		0xE6
#define ADV_REG_ADDR_PAL_END		0xE9
#define ADV_REG_ADDR_LOCK_CNT		0x51
#define ADV_REG_ADDR_DRIVE_STRENGTH	0xF4
#define ADV_REG_ADDR_PWR		0x0F
#define ADV_REG_ADDR_VID_SEL1		0x01
#define ADV_REG_ADDR_VID_SEL2		0x02
#define ADV_REG_ADDR_HUE		0x0B
#define ADV_REG_ADDR_ADI_CTRL1		0x0E
#define ADV_REG_STATUS_1		0x10
#define ADV_REG_IDENT			0x11
#define ADV_REG_ADDR_STATUS1		0x13
#define ADV_REG_ADDR_ANA_CLAMP_CTRL	0x14
#define ADV_REG_ADDR_DIG_CLAMP_CTRL	0x15
#define ADV_REG_ADDR_SHAP_FIL_CTRL1	0x17
#define ADV_REG_ADDR_SHAP_FIL_CTRL2	0x18
#define ADV_REG_ADDR_COMB_FIL_CTRL	0x19
#define ADV_REG_ADDR_PIX_DELAY		0x27
#define ADV_REG_ADDR_MISC_GAIN_CTRL	0x2B
#define ADV_REG_ADDR_AGC_MOD_CTRL	0x2C
#define ADV_REG_ADDR_CHR_GAIN_CTRL1	0x2D
#define ADV_REG_ADDR_CHR_GAIN_CTRL2	0x2E
#define ADV_REG_ADDR_LUM_GAIN_CTRL1	0x2F
#define ADV_REG_ADDR_LUM_GAIN_CTRL2	0x30
#define ADV_REG_ADDR_VS_CTRL1		0x31
#define ADV_REG_ADDR_VS_CTRL2		0x32
#define ADV_REG_ADDR_VS_CTRL3		0x33
#define ADV_REG_ADDR_HS_CTRL1		0x34
#define ADV_REG_ADDR_HS_CTRL2		0x35
#define ADV_REG_ADDR_HS_CTRL3		0x36
#define ADV_REG_ADDR_POL		0x37
#define ADV_REG_ADDR_NTSC_CMB_CTRL	0x38
#define ADV_REG_ADDR_PAL_CMB_CTRL	0x39
#define ADV_REG_ADDR_WIN_CTRL		0x3D
#define ADV_REG_ADDR_RESAMPLE_CTRL	0x41
#define ADV_REG_ADDR_CTI_DNR_CTRL1	0x4D
#define ADV_REG_ADDR_CTI_DNR_CTRL2	0x4E
#define ADV_REG_ADDR_DNR_NOISE_THR1	0x50
#define ADV_REG_ADDR_OUT_SYNC_SEL1	0x6A
#define ADV_REG_ADDR_OUT_SYNC_SEL2	0x6B
#define ADV_REG_ADDR_FREE_RUN_LEN1	0x8F
#define ADV_REG_ADDR_CCAP1_STATUS	0x99
#define ADV_REG_ADDR_CCAP2_STATUS	0x9A
#define ADV_REG_ADDR_LETBOX1_STATUS	0x9B
#define ADV_REG_ADDR_LETBOX2_STATUS	0x9C
#define ADV_REG_ADDR_LETBOX3_STATUS	0x9D
#define ADV_REG_ADDR_CRC_ENABLE		0xB2
#define ADV_REG_ADDR_LETBOX1_CTRL	0xDC
#define ADV_REG_ADDR_LETBOX2_CTRL	0xDD
#define ADV_REG_ADDR_ST_NOISE_STATUS1	0xDE
#define ADV_REG_ADDR_ST_NOISE_STATUS2	0xDF
#define ADV_REG_ADDR_SD_CB_CHN_OFFSET	0xE1
#define ADV_REG_ADDR_SD_CR_CHN_OFFSET	0xE2
#define ADV_REG_ADDR_SD_CB_CHN_SAT	0xE3
#define ADV_REG_ADDR_SD_CR_CHN_SAT	0xE4
#define ADV_REG_ADDR_NTSC_VSB		0xE5
#define ADV_REG_ADDR_NTSC_VSE		0xE6
#define ADV_REG_ADDR_NTSC_FLD_TGLE	0xE7
#define ADV_REG_ADDR_PAL_VSB		0xE8
#define ADV_REG_ADDR_PAL_VSE		0xE9
#define ADV_REG_ADDR_PAL_FLD_TGLE	0xEA
#define ADV_REG_ADDR_VBLK_CTRL1		0xEB
#define ADV_REG_ADDR_VBLK_CTRL2		0xEC
#define ADV_REG_ADDR_AFE_CTRL1		0xF3
#define ADV_REG_ADDR_IF_CLMP_CTRL1	0xF8
#define ADV_REG_ADDR_VS_MODE_CTRL	0xF9
#define ADV_REG_ADDR_DNR_NOISE_THR2	0xFC
#define ADV_REG_ADDR_CSI_TX_SLAVE	0xFE
#define ADV_REG_ADI_RST_CLAMP		0x9C
#define ADV_REG_ADI_IBIAS_AFE		0x52
#define ADV_REG_ADI_RES_CIR		0x5F
#define ADV_REG_ADI_CLAMP_ADJ		0x5A
#define ADV_REG_ADI_DIFF_MODE		0x60
#define ADV_REG_ADI_AGC_ADJ1		0xB6
#define ADV_REG_ADI_AGC_ADJ2		0xC0
#define ADV_REG_ADI_FST_LCK		0xD9
#define ADV_REG_ADI_ENA_FST_LCK		0xE0
#define ADV_REG_ADI_ENA_ACE		0x80
#define ADV_REG_ADI_ACE_CTRL5		0x84

/*Default values*/
#define ADV_INSEL_DEFAULT		0x0e
#define ADV_ADC_SWITCH2_VAL		0x80
#define ADV_ADC_SWITCH1_VAL		0x01
#define ADV_ADC_SWITCH3_VAL		0xB2
#define ADV_ADC_CTRL_VAL		0x01
#define ADV_ADC_VID_SEL_AUTO		0x7F
#define ADV_ADC_ADI_CTRL2_VAL		0x40
#define ADV_ADC_OUT_CTRL_EXTD_DEFAULT	0x35
#define ADV_ADC_OUT_CTRL_DEFAULT	0x0c
#define ADV_CONTRAST_DEFAULT		0x80
#define ADV_BRIGHTNESS_DEFAULT		0x00
#define ADV_SHARPNESS_DEFAULT		0x40
#define ADV_COLOR_Y_DEFAULT		0x36
#define ADV_COLOR_CR_CB_DEFAULT		0x7C
#define ADV_LOCK_CNT_VAL		0xA4
#define ADV_DRIVE_STRENGTH_VAL		0x3F
#define ADV_PWR_ON			0x00
#define ADV_PWR_OFF			0x20
#define ADV_VID_SEL1_DEFAULT		0xc8
#define ADV_VID_SEL2_DEFAULT		0x04
#define ADV_HUE_DEFAULT			0x00
#define ADV_ADI_CTRL1_DEFAULT		0x00
#define ADV_STATUS1_DEFAULT		0x00
#define ADV_ANA_CLAMP_CTRL_DEFAULT	0x10
#define ADV_DIG_CLAMP_CTRL_DEFAULT	0x00
#define ADV_SHAP_FIL_CTRL1_VAL		0x41
#define ADV_SHAP_FIL_CTRL2_DEFAULT	0x93
#define ADV_COMB_FIL_CTRL_DEFAULT	0xf1
#define ADV_PIX_DELAY_DEFAULT		0x58
#define ADV_MISC_GAIN_CTRL_DEFAULT	0xE1
#define ADV_AGC_MOD_CTRL_DEFAULT	0xAE
#define ADV_CHR_GAIN_CTRL1_DEFAULT	0xF4
#define ADV_CHR_GAIN_CTRL2_DEFAULT	0x00
#define ADV_LUM_GAIN_CTRL1_DEFAULT	0xF0
#define ADV_LUM_GAIN_CTRL2_DEFAULT	0x00
#define ADV_VS_CTRL1_DEFAULT		0x02
#define ADV_VS_CTRL2_DEFAULT		0x41
#define ADV_VS_CTRL3_DEFAULT		0x84
#define ADV_HS_CTRL1_DEFAULT		0x00
#define ADV_HS_CTRL2_DEFAULT		0x02
#define ADV_HS_CTRL3_DEFAULT		0x00
#define ADV_POL_DEFAULT			0x01
#define ADV_NTSC_CMB_CTRL_DEFAULT	0x80
#define ADV_PAL_CMB_CTRL_DEFAULT	0xC0
#define ADV_WIN_CTRL_DEFAULT		0x22
#define ADV_RESAMPLE_CTRL_DEFAULT	0x01
#define ADV_CTI_DNR_CTRL1_DEFAULT	0xEF
#define ADV_CTI_DNR_CTRL2_DEFAULT	0x08
#define ADV_DNR_NOISE_THR1_DEFAULT	0x08
#define ADV_OUT_SYNC_SEL1_DEFAULT	0x00
#define ADV_OUT_SYNC_SEL2_DEFAULT	0x12
#define ADV_FREE_RUN_LEN1_DEFAULT	0x00
#define ADV_CCAP1_STATUS_DEFAULT	0x00
#define ADV_CCAP2_STATUS_DEFAULT	0x00
#define ADV_LETBOX1_STATUS_DEFAULT	0x00
#define ADV_LETBOX2_STATUS_DEFAULT	0x00
#define ADV_LETBOX3_STATUS_DEFAULT	0x00
#define ADV_CRC_ENABLE_DEFAULT		0x1C
#define ADV_LETBOX1_CTRL_DEFAULT	0xAC
#define ADV_LETBOX2_CTRL_DEFAULT	0xCC
#define ADV_ST_NOISE_STATUS1_DEFAULT	0x00
#define ADV_ST_NOISE_STATUS2_DEFAULT	0x00
#define ADV_SD_CB_CHN_OFFSET_DEFAULT	0x80
#define ADV_SD_CR_CHN_OFFSET_DEFAULT	0x80
#define ADV_SD_CB_CHN_SAT_DEFAULT	0x80
#define ADV_SD_CR_CHN_SAT_DEFAULT	0x80
#define ADV_NTSC_VSB_DEFAULT		0x25
#define ADV_NTSC_VSE_VAL		0x44
#define ADV_NTSC_FLD_TGLE_DEFAULT	0x63
#define ADV_PAL_VSB_DEFAULT		0x65
#define ADV_PAL_VSE_VAL			0x14
#define ADV_PAL_FLD_TGLE_DEFAULT	0x63
#define ADV_VBLK_CTRL1_DEFAULT		0x55
#define ADV_VBLK_CTRL2_DEFAULT		0x55
#define ADV_AFE_CTRL1_DEFAULT		0x00
#define ADV_IF_CLMP_CTRL1_DEFAULT	0x00
#define ADV_VS_MODE_CTRL_DEFAULT	0x03
#define ADV_DNR_NOISE_THR2_DEFAULT	0x04
#define ADV_CSI_TX_SLAVE_DEFAULT	0x00
#define ADV_ADI_RST_CLAMPDEFAULT1	0x80
#define ADV_ADI_RST_CLAMPDEFAULT2	0x00
#define ADV_ADI_RST_CLAMPDEFAULT3	0xFF
#define ADV_ADI_OUT_CTRL_EXTD_DEFAULT	0x07
#define ADV_ADI_IBIAS_AFE_DEFAULT	0xC0
#define ADV_ADI_RES_CIR_DEFAULT		0xA8
#define ADV_ADI_CLAMP_ADJ_DEFAULT	0x90
#define ADV_ADI_DIFF_MODE_DEFAULT	0xB0
#define ADV_ADI_AGC_ADJ1_DEFAULT	0x08
#define ADV_ADI_AGC_ADJ2_DEFAULT	0xA0
#define ADV_ADI_FST_LCK_DEFAULT		0x44
#define ADV_ADI_USR_SUB_MAP_40		0x40
#define ADV_ADI_ENA_FST_LCK		0x01
#define ADV_ADI_ENA_ACE			0x80
#define ADV_ADI_DIS_ACE			0x00
#define ADV_ADI_INT_REG_MAP		0x20
#define ADV_INTR_CONFIG_1		0xd1
#define ADV_ADI_ACE_CHROMA_GAIN_OFF	0x00

/*!
 * Maintains the information on the current state of the sensor.
 */
struct adv7182_dev {
	struct v4l2_int_device *v4l2_int_device;
	struct i2c_client *i2c_client;
	struct v4l2_of_bus_parallel bus_cfg;
	struct v4l2_pix_format pix;
	struct v4l2_captureparm streamcap;
	int rev_id;
	bool on;

	bool locked;       /* locked to signal */
	bool lock_status_change; /* there was a lock status change */

	/* control settings */
	int brightness;
	int hue;
	int contrast;
	int saturation;
	int red;
	int green;
	int blue;
	int ae_mode;

	bool cvbs;
	int gpio_pwrdn;
	v4l2_std_id std_id;
	/*!* Standard index of adv7182. */
	int video_idx;
	/* Current analog input mux */
	int current_input;
	/* Mutex lock for sequential access*/
	struct mutex mutex;
	/* Store ACE register value for all inputs used when switching source */
	u8 chn_ace[9];
} adv7182_data;

struct adv7182_inputs_t {
	const char *desc;   /* Analog input description */
	u8 insel;           /* insel bits to select this input */
};

/*! List of input video formats supported. The video formats is corresponding
 * with v4l2 id in video_fmt_t
 */
enum {
	adv7182_NTSC = 0,	/*!< Locked on (M) NTSC video signal. */
	adv7182_PAL,		/*!< (B, G, H, I, N)PAL video signal. */
};

/*! Number of video standards supported (including 'not locked' signal). */
#define adv7182_STD_MAX		(adv7182_PAL + 1)

/*! Video format structure. */
struct video_fmt_t {
	int v4l2_id;		/*!< Video for linux ID. */
	char name[16];		/*!< Name (e.g., "NTSC", "PAL", etc.) */
	u16 raw_width;		/*!< Raw width. */
	u16 raw_height;		/*!< Raw height. */
	u16 active_width;	/*!< Active width. */
	u16 active_height;	/*!< Active height. */
};

#endif
