 /* Neonode Zforce touch device IOCTL interfaces.
 *
 * Copyright (c) 2014 Robert Bosch Car Multimedia GmbH
 *
 * This source code is provided as a sample only and has not gone
 * through full internal testing. This sample code is provided "as is",
 * with no  warranties for the functionality of the code, nor
 * any warranties concerning side effects when using the code. The
 * intention of this code is reference example for internal evaluation only.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the term of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __ZFORCE_IOCTL_H
#define __ZFORCE_IOCTL_H

#define ZFORCE_IOCTLDEV_NAME "zforce_hwcheck"

#define ZFORCE_IOC_MAGIC 'Z'

/* HW check ioctls */
/* Get version and status information (StatusRequest) */
#define ZFORCE_HWCHECKDEV_IOC_WR_GVER \
	_IOWR(ZFORCE_IOC_MAGIC, 0x01, unsigned char)
/* Get LED level (LEDLevelRequest)*/
#define ZFORCE_HWCHECKDEV_IOC_WR_LEDL \
	_IOWR(ZFORCE_IOC_MAGIC, 0x02, unsigned char)
/* Get open / short circuit LED information (OpenShortRequest) */
#define ZFORCE_HWCHECKDEV_IOC_WR_OPNS \
	_IOWR(ZFORCE_IOC_MAGIC, 0x03, unsigned char)
/* Get low signal information (LowSignalNotification) */
#define ZFORCE_HWCHECKDEV_IOC_WR_LOWS \
	_IOWR(ZFORCE_IOC_MAGIC, 0x04, unsigned char)
/* Switch to boot loader / firmware update mode (ForceI2CBootMode)*/
#define ZFORCE_HWCHECKDEV_IOC_WR_BOOTMODE \
	_IOWR(ZFORCE_IOC_MAGIC, 0x05, unsigned char)

/* Download / Boot mode ioctls */
/* Requests the boot loader version from the target */
#define ZFORCE_HWCHECKDEV_IOC_WR_BL_TX_VERSION \
	_IOWR(ZFORCE_IOC_MAGIC, 0x40, unsigned char)
/* A memory segment (512B in Flash) addressed by ADDR is erased. */
#define ZFORCE_HWCHECKDEV_IOC_WR_BL_ERASE_SEGMENT \
	_IOWR(ZFORCE_IOC_MAGIC, 0x41, unsigned char)
/* The entire application area is erased. */
#define ZFORCE_HWCHECKDEV_IOC_WR_BL_ERASE_APP \
	_IOWR(ZFORCE_IOC_MAGIC, 0x42, unsigned char)
/* Bytes of data are programmed starting at address ADDR */
#define ZFORCE_HWCHECKDEV_IOC_WR_BL_RX_DATA_BLOCK \
	_IOWR(ZFORCE_IOC_MAGIC, 0x43, unsigned char)
/* Target resets and jumps to zForce FW if validation is OK */
#define ZFORCE_HWCHECKDEV_IOC_WR_BL_JUMP2APP \
	_IOWR(ZFORCE_IOC_MAGIC, 0x44, unsigned char)
/* Validates the checksum of the App, does not jump to app after */
#define ZFORCE_HWCHECKDEV_IOC_WR_BL_VALIDATEAPP \
	_IOWR(ZFORCE_IOC_MAGIC, 0x45, unsigned char)

/* Hardware control */
/* Set reset signal */
#define ZFORCE_HWCHECKDEV_IOC_WR_SET_RESET \
	_IOWR(ZFORCE_IOC_MAGIC, 0x60, unsigned char)

#define ZFORCE_BUF_LEN 256+1 /* length + 256 Bytes */

#endif
