/*
 * Copyright (C) 2013 Mentor Graphics Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Module Name:    mfw_gst_drm_plane.c
 *
 * Description:    Implementation of DRM Plane FB operations
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */

#include <gst/gst.h>
#include <gst/base/gstpushsrc.h>
#include <stdint.h>
#include <linux/videodev2.h>

#include "mfw_gst_v4lsrc.h"
#include "mfw_gst_drm_plane.h"
#include "mfw_gst_src_drm_plane.h"

gboolean drm_plane_init(MFWGstV4LSrc *v4l)
{
	v4l->fb_priv = mfw_gst_drm_plane_init();
	if (!v4l->fb_priv)
		return FALSE;

	return TRUE;
}

void drm_plane_release(MFWGstV4LSrc *v4l)
{
	mfw_gst_drm_plane_release(v4l->fb_priv);
}

gboolean drm_plane_open(MFWGstV4LSrc *v4l)
{
	return mfw_gst_drm_plane_open(v4l->fb_priv,
				      v4l->disp_type,
				      v4l->preview_width + v4l->preview_left,
				      v4l->preview_height + v4l->preview_top);
}

gboolean drm_plane_close(MFWGstV4LSrc *v4l)
{
	return mfw_gst_drm_plane_close(v4l->fb_priv);
}

gboolean drm_plane_set_global_alpha(MFWGstV4LSrc *v4l,
				    gint alphaVal, gboolean enable)
{
	return mfw_gst_drm_plane_set_global_alpha(v4l->fb_priv,
						  alphaVal, enable);
}

gboolean drm_plane_set_colorkey(MFWGstV4LSrc *v4l,
				gulong *colorSrc, gboolean enable)
{
	return mfw_gst_drm_plane_set_colorkey(v4l->fb_priv,
					      colorSrc, enable);
}


#if 0
gboolean drm_plane_get_bounds(MFWGstV4LSrc *v4l)
{
	return mfw_gst_drm_plane_get_bounds(v4l->fb_priv,
			&v4l->fullscreen_width,
			&v4l->fullscreen_height);
}
#endif

gboolean drm_plane_setup(MFWGstV4LSrc *v4l,
				struct v4l2_crop *crop)
{
	return mfw_gst_drm_plane_setup(v4l->fb_priv,
			FALSE,
			v4l->fd_v4l,
			crop);
}
