#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <jack/jack.h>
#include <jack/control.h>


int main(int argc, char* argv[])
{
	jack_client_t* client;
	jack_backend_command_t backend_cmd;

	if (argc < 3) {
		printf("usage: %s [server_name [server_name ...] command]", argv[0]);
		return 1;
	}

	char server_name[JACK_PARAM_STRING_MAX+1];
	memset(server_name, 0, sizeof(server_name));
	strncpy(server_name, argv[1], (sizeof(server_name) -1));

	backend_cmd.cmd = atoi(argv[2]);
	backend_cmd.arg = 0;

	const jack_options_t options = (jack_options_t) (JackNoStartServer | JackServerName);
	jack_status_t status;

	printf("Connecting to JACK server %s\n", server_name);
	client = jack_client_open("backend_cmd", options, &status, server_name);
	printf("Calling backend command with cmd = %d\n", backend_cmd.cmd);
	jack_client_audio_backend_command(client, backend_cmd);

	jack_client_close(client);

	return 0;
}
