#!/usr/bin/env bash
######################################################################
#FILE: .*_unit-test_.*_aborting.sh
#SW-COMPONENT: Tooling
#DESCRIPTION: Generate and execute unit tests of the component
#             Executed by call from execute_unit-tests.py
#COPYRIGHT: (C) 2019 Robert Bosch GmbH
#
#The reproduction, distribution and utilization of this file as
#well as the communication of its contents to others without express
#authorization is prohibited. Offenders will be held liable for the
#payment of damages. All rights reserved in the event of the grant
#of a patent, utility model or design.
######################################################################
set -eu
OUTNAME=`basename "${0%.*}"`.xml
BASEDIR=$(realpath $(dirname "$0"))
WORKSPACEROOT=${BASEDIR}
while [ ! -d ${WORKSPACEROOT}/qnx-sdp ] && [ "${#WORKSPACEROOT}" -gt 0 ]; do
  WORKSPACEROOT=${WORKSPACEROOT%/*}
done
if [ ! -d ${WORKSPACEROOT}/qnx-sdp ] ; then echo "bad workspaceroot: ${WORKSPACEROOT}, exiting";  exit 2; fi
STOPONFAILURE=true

cd "${BASEDIR}"

# Define or compute the waflock_hash value
waflock_hash=$(echo -n "${WORKSPACEROOT}" | md5sum | cut -d ' ' -f 1)

# Define a unique build directory for Linux unit tests
BUILD_DIR="build_x86_64"

# Define a unique WAFLOCK for unit tests
WAFLOCK=".lock-waf_utest_${waflock_hash}_build"
WAFLOCK=${WAFLOCK} ./waf configure --platform=linux --prefix=/usr --libdir=/usr/lib --clients=32 --ports-per-application=256 --ports-per-server=256 --disable-graph-latency-callback --debug --gcov --out="${BUILD_DIR}"
WAFLOCK=${WAFLOCK} ./waf build
RESULT=$?

UTESTS="
${BUILD_DIR}/utest/jack_utest
"
set +eu

# enfore to use own libjack-server and not the one potentially installed on the host system
for UTEST in $UTESTS; do
  LD_LIBRARY_PATH="${BUILD_DIR}/common" ./$UTEST  --gtest_output=xml:$OUTNAME
  RETVAL=$?
  ((RESULT+=$RETVAL))
  if [[ $RETVAL -ne 0 ]] && $STOPONFAILURE ; then exit $RETVAL; fi
done

echo "RESULT: "${RESULT}
exit $RESULT
