/**
 * @swcomponent
 * @{
 * @file JackAlsaOptionParser.h
 * @brief Headerfile for C variables and funtions for Parsing Jack options
 * @copyright (C) 2024 Robert Bosch GmbH.
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 * @}
 */

#include <vector>

#ifdef __cplusplus
extern "C" 
{
#endif
    struct array_string_t
    {
        enum flags {
            none,
            discard_duplicate,
        };

        std::vector<char*> data;
    };
    void SetUserOptionState(const struct array_string_t& target_state_param, size_t device_index, target_state_t& target_state);
    struct array_string_t array_string_split(const char *str, const char sep, array_string_t::flags flags = array_string_t::none);
#ifdef __cplusplus
}
#endif