// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License"); you may not
// use this file except in compliance with the License. You may obtain a copy of
// the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
// WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
// License for the specific language governing permissions and limitations under
// the License.

// !!! GENERATED - DO NOT MODIFY !!!
// To update this file, use generate_test_values.py.

#ifndef DICE_KNOWN_TEST_VALUES_H_
#define DICE_KNOWN_TEST_VALUES_H_


namespace dice {
namespace test {

constexpr uint8_t kExpectedCdiAttest_ZeroInput[32] = {
    0xfb, 0xfc, 0x67, 0x97, 0x71, 0x34, 0x2e, 0xea, 0xcb, 0x90, 0x86,
    0x59, 0xce, 0x49, 0xd6, 0xb6, 0x3b, 0x45, 0x35, 0xda, 0x2c, 0x51,
    0x43, 0x3d, 0x7f, 0x04, 0xef, 0xa6, 0x31, 0x9e, 0x0c, 0x19};

constexpr uint8_t kExpectedCdiSeal_ZeroInput[32] = {
    0x8f, 0xf8, 0xb2, 0x25, 0x71, 0x32, 0x5e, 0x7d, 0xef, 0xef, 0xbf,
    0xea, 0x8d, 0xf1, 0xc9, 0xf3, 0x4b, 0xf4, 0xd9, 0xee, 0x03, 0xb7,
    0x5b, 0x78, 0x82, 0x19, 0xc6, 0xb1, 0xef, 0x49, 0xbd, 0xc5};

// $ openssl x509 -inform DER -noout -text -certopt ext_parse
// Certificate:
//     Data:
//         Version: 3 (0x2)
//         Serial Number:
//             67:c2:2a:88:59:06:2b:98:68:18:e8:e7:2b:0b:cd:9f:59:34:9c:89
//         Signature Algorithm: ED25519
//         Issuer: serialNumber = 7a06eee41b789f4863d86b8778b1a201a6fedd56
//         Validity
//             Not Before: Mar 22 23:59:59 2018 GMT
//             Not After : Dec 31 23:59:59 9999 GMT
//         Subject: serialNumber = 67c22a8859062b986818e8e72b0bcd9f59349c89
//         Subject Public Key Info:
//             Public Key Algorithm: ED25519
//                 ED25519 Public-Key:
//                 pub:
//                     0d:14:e5:de:29:2e:b1:c8:b3:1b:ea:e4:3a:b5:5d:
//                     8e:9d:c0:14:b7:3e:aa:83:b9:25:a0:78:8c:c6:2e:
//                     5c:8d
//         X509v3 extensions:
//             X509v3 Authority Key Identifier:
//                 keyid:7A:06:EE:E4:1B:78:9F:48:63:D8:6B:87:78:B1:A2:01:A6:FE:DD:56
//
//             X509v3 Subject Key Identifier:
//                 67:C2:2A:88:59:06:2B:98:68:18:E8:E7:2B:0B:CD:9F:59:34:9C:89
//             X509v3 Key Usage: critical
//                 Certificate Sign
//             X509v3 Basic Constraints: critical
//                 CA:TRUE
//             1.3.6.1.4.1.11129.2.1.24: critical
//     0:d=0  hl=3 l= 209 cons: SEQUENCE
//     3:d=1  hl=2 l=  66 cons:  cont [ 0 ]
//     5:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0010 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0020 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0030 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//    71:d=1  hl=2 l=  66 cons:  cont [ 3 ]
//    73:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0010 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0020 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0030 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//   139:d=1  hl=2 l=  66 cons:  cont [ 4 ]
//   141:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0010 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0020 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0030 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//   207:d=1  hl=2 l=   3 cons:  cont [ 6 ]
//   209:d=2  hl=2 l=   1 prim:   ENUMERATED        :00
//
//     Signature Algorithm: ED25519
//          70:23:a8:a3:78:fe:5f:8c:8d:83:49:95:ff:ee:e6:12:39:9c:
//          4d:a0:49:f6:4b:4f:f7:02:1e:9f:97:0c:bd:3b:7f:94:78:26:
//          09:fe:f2:91:7c:a4:dd:90:07:cc:95:a8:bc:4a:f4:84:69:ec:
//          24:a4:9e:b7:01:0e:81:3a:a3:0a
constexpr uint8_t kExpectedX509Ed25519Cert_ZeroInput[638] = {
    0x30, 0x82, 0x02, 0x7a, 0x30, 0x82, 0x02, 0x2c, 0xa0, 0x03, 0x02, 0x01,
    0x02, 0x02, 0x14, 0x67, 0xc2, 0x2a, 0x88, 0x59, 0x06, 0x2b, 0x98, 0x68,
    0x18, 0xe8, 0xe7, 0x2b, 0x0b, 0xcd, 0x9f, 0x59, 0x34, 0x9c, 0x89, 0x30,
    0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x30, 0x33, 0x31, 0x31, 0x30, 0x2f,
    0x06, 0x03, 0x55, 0x04, 0x05, 0x13, 0x28, 0x37, 0x61, 0x30, 0x36, 0x65,
    0x65, 0x65, 0x34, 0x31, 0x62, 0x37, 0x38, 0x39, 0x66, 0x34, 0x38, 0x36,
    0x33, 0x64, 0x38, 0x36, 0x62, 0x38, 0x37, 0x37, 0x38, 0x62, 0x31, 0x61,
    0x32, 0x30, 0x31, 0x61, 0x36, 0x66, 0x65, 0x64, 0x64, 0x35, 0x36, 0x30,
    0x20, 0x17, 0x0d, 0x31, 0x38, 0x30, 0x33, 0x32, 0x32, 0x32, 0x33, 0x35,
    0x39, 0x35, 0x39, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32,
    0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x33, 0x31,
    0x31, 0x30, 0x2f, 0x06, 0x03, 0x55, 0x04, 0x05, 0x13, 0x28, 0x36, 0x37,
    0x63, 0x32, 0x32, 0x61, 0x38, 0x38, 0x35, 0x39, 0x30, 0x36, 0x32, 0x62,
    0x39, 0x38, 0x36, 0x38, 0x31, 0x38, 0x65, 0x38, 0x65, 0x37, 0x32, 0x62,
    0x30, 0x62, 0x63, 0x64, 0x39, 0x66, 0x35, 0x39, 0x33, 0x34, 0x39, 0x63,
    0x38, 0x39, 0x30, 0x2a, 0x30, 0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x03,
    0x21, 0x00, 0x0d, 0x14, 0xe5, 0xde, 0x29, 0x2e, 0xb1, 0xc8, 0xb3, 0x1b,
    0xea, 0xe4, 0x3a, 0xb5, 0x5d, 0x8e, 0x9d, 0xc0, 0x14, 0xb7, 0x3e, 0xaa,
    0x83, 0xb9, 0x25, 0xa0, 0x78, 0x8c, 0xc6, 0x2e, 0x5c, 0x8d, 0xa3, 0x82,
    0x01, 0x4e, 0x30, 0x82, 0x01, 0x4a, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d,
    0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x7a, 0x06, 0xee, 0xe4, 0x1b,
    0x78, 0x9f, 0x48, 0x63, 0xd8, 0x6b, 0x87, 0x78, 0xb1, 0xa2, 0x01, 0xa6,
    0xfe, 0xdd, 0x56, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16,
    0x04, 0x14, 0x67, 0xc2, 0x2a, 0x88, 0x59, 0x06, 0x2b, 0x98, 0x68, 0x18,
    0xe8, 0xe7, 0x2b, 0x0b, 0xcd, 0x9f, 0x59, 0x34, 0x9c, 0x89, 0x30, 0x0e,
    0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02,
    0x02, 0x04, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff,
    0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x81, 0xe6, 0x06, 0x0a,
    0x2b, 0x06, 0x01, 0x04, 0x01, 0xd6, 0x79, 0x02, 0x01, 0x18, 0x01, 0x01,
    0xff, 0x04, 0x81, 0xd4, 0x30, 0x81, 0xd1, 0xa0, 0x42, 0x04, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xa3, 0x42, 0x04, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4,
    0x42, 0x04, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0x03, 0x0a, 0x01, 0x00,
    0x30, 0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x03, 0x41, 0x00, 0x70, 0x23,
    0xa8, 0xa3, 0x78, 0xfe, 0x5f, 0x8c, 0x8d, 0x83, 0x49, 0x95, 0xff, 0xee,
    0xe6, 0x12, 0x39, 0x9c, 0x4d, 0xa0, 0x49, 0xf6, 0x4b, 0x4f, 0xf7, 0x02,
    0x1e, 0x9f, 0x97, 0x0c, 0xbd, 0x3b, 0x7f, 0x94, 0x78, 0x26, 0x09, 0xfe,
    0xf2, 0x91, 0x7c, 0xa4, 0xdd, 0x90, 0x07, 0xcc, 0x95, 0xa8, 0xbc, 0x4a,
    0xf4, 0x84, 0x69, 0xec, 0x24, 0xa4, 0x9e, 0xb7, 0x01, 0x0e, 0x81, 0x3a,
    0xa3, 0x0a};

// $ openssl x509 -inform DER -noout -text -certopt ext_parse
// Certificate:
//     Data:
//         Version: 3 (0x2)
//         Serial Number:
//             7c:7d:c0:a3:c1:e7:8d:4e:68:bc:c1:a2:32:9e:f9:1c:a8:12:44:91
//         Signature Algorithm: ecdsa-with-SHA512
//         Issuer: serialNumber = 4c514d88db0f81d57beb96177e3d7ea4aa581e66
//         Validity
//             Not Before: Mar 22 23:59:59 2018 GMT
//             Not After : Dec 31 23:59:59 9999 GMT
//         Subject: serialNumber = 7c7dc0a3c1e78d4e68bcc1a2329ef91ca8124491
//         Subject Public Key Info:
//             Public Key Algorithm: id-ecPublicKey
//                 Public-Key: (256 bit)
//                 pub:
//                     04:4f:3b:4e:82:c4:5a:da:08:45:89:c2:19:7b:af:
//                     1f:37:6e:ac:40:e1:fd:49:b0:24:06:02:ae:c2:69:
//                     54:1c:6b:e7:eb:40:19:ab:55:c6:6b:c8:8b:b8:b4:
//                     69:ad:7e:e8:58:9e:07:d2:f8:bc:88:8e:b3:11:c2:
//                     df:97:3b:1b:4a
//                 ASN1 OID: prime256v1
//                 NIST CURVE: P-256
//         X509v3 extensions:
//             X509v3 Authority Key Identifier:
//                 keyid:4C:51:4D:88:DB:0F:81:D5:7B:EB:96:17:7E:3D:7E:A4:AA:58:1E:66
//
//             X509v3 Subject Key Identifier:
//                 7C:7D:C0:A3:C1:E7:8D:4E:68:BC:C1:A2:32:9E:F9:1C:A8:12:44:91
//             X509v3 Key Usage: critical
//                 Certificate Sign
//             X509v3 Basic Constraints: critical
//                 CA:TRUE
//             1.3.6.1.4.1.11129.2.1.24: critical
//     0:d=0  hl=3 l= 209 cons: SEQUENCE
//     3:d=1  hl=2 l=  66 cons:  cont [ 0 ]
//     5:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0010 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0020 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0030 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//    71:d=1  hl=2 l=  66 cons:  cont [ 3 ]
//    73:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0010 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0020 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0030 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//   139:d=1  hl=2 l=  66 cons:  cont [ 4 ]
//   141:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0010 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0020 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//       0030 - 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00 ................
//   207:d=1  hl=2 l=   3 cons:  cont [ 6 ]
//   209:d=2  hl=2 l=   1 prim:   ENUMERATED        :00
//
//     Signature Algorithm: ecdsa-with-SHA512
//          30:44:02:20:5c:20:d4:32:af:59:4b:44:fc:49:e5:d4:5d:b6:
//          fe:9c:ac:55:02:74:8b:66:c8:8c:f5:9a:70:8a:97:3c:bc:e0:
//          02:20:66:83:d1:78:8c:75:44:83:90:c7:1e:d7:4c:98:1f:10:
//          7f:14:6a:45:c0:1c:48:99:ce:6e:8f:6d:d3:dc:f3:93
constexpr uint8_t kExpectedX509P256Cert_ZeroInput[705] = {
    0x30, 0x82, 0x02, 0xbd, 0x30, 0x82, 0x02, 0x62, 0xa0, 0x03, 0x02, 0x01,
    0x02, 0x02, 0x14, 0x7c, 0x7d, 0xc0, 0xa3, 0xc1, 0xe7, 0x8d, 0x4e, 0x68,
    0xbc, 0xc1, 0xa2, 0x32, 0x9e, 0xf9, 0x1c, 0xa8, 0x12, 0x44, 0x91, 0x30,
    0x0c, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x04, 0x05,
    0x00, 0x30, 0x33, 0x31, 0x31, 0x30, 0x2f, 0x06, 0x03, 0x55, 0x04, 0x05,
    0x13, 0x28, 0x34, 0x63, 0x35, 0x31, 0x34, 0x64, 0x38, 0x38, 0x64, 0x62,
    0x30, 0x66, 0x38, 0x31, 0x64, 0x35, 0x37, 0x62, 0x65, 0x62, 0x39, 0x36,
    0x31, 0x37, 0x37, 0x65, 0x33, 0x64, 0x37, 0x65, 0x61, 0x34, 0x61, 0x61,
    0x35, 0x38, 0x31, 0x65, 0x36, 0x36, 0x30, 0x20, 0x17, 0x0d, 0x31, 0x38,
    0x30, 0x33, 0x32, 0x32, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x18,
    0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35,
    0x39, 0x35, 0x39, 0x5a, 0x30, 0x33, 0x31, 0x31, 0x30, 0x2f, 0x06, 0x03,
    0x55, 0x04, 0x05, 0x13, 0x28, 0x37, 0x63, 0x37, 0x64, 0x63, 0x30, 0x61,
    0x33, 0x63, 0x31, 0x65, 0x37, 0x38, 0x64, 0x34, 0x65, 0x36, 0x38, 0x62,
    0x63, 0x63, 0x31, 0x61, 0x32, 0x33, 0x32, 0x39, 0x65, 0x66, 0x39, 0x31,
    0x63, 0x61, 0x38, 0x31, 0x32, 0x34, 0x34, 0x39, 0x31, 0x30, 0x59, 0x30,
    0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08,
    0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04,
    0x4f, 0x3b, 0x4e, 0x82, 0xc4, 0x5a, 0xda, 0x08, 0x45, 0x89, 0xc2, 0x19,
    0x7b, 0xaf, 0x1f, 0x37, 0x6e, 0xac, 0x40, 0xe1, 0xfd, 0x49, 0xb0, 0x24,
    0x06, 0x02, 0xae, 0xc2, 0x69, 0x54, 0x1c, 0x6b, 0xe7, 0xeb, 0x40, 0x19,
    0xab, 0x55, 0xc6, 0x6b, 0xc8, 0x8b, 0xb8, 0xb4, 0x69, 0xad, 0x7e, 0xe8,
    0x58, 0x9e, 0x07, 0xd2, 0xf8, 0xbc, 0x88, 0x8e, 0xb3, 0x11, 0xc2, 0xdf,
    0x97, 0x3b, 0x1b, 0x4a, 0xa3, 0x82, 0x01, 0x4e, 0x30, 0x82, 0x01, 0x4a,
    0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80,
    0x14, 0x4c, 0x51, 0x4d, 0x88, 0xdb, 0x0f, 0x81, 0xd5, 0x7b, 0xeb, 0x96,
    0x17, 0x7e, 0x3d, 0x7e, 0xa4, 0xaa, 0x58, 0x1e, 0x66, 0x30, 0x1d, 0x06,
    0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x7c, 0x7d, 0xc0, 0xa3,
    0xc1, 0xe7, 0x8d, 0x4e, 0x68, 0xbc, 0xc1, 0xa2, 0x32, 0x9e, 0xf9, 0x1c,
    0xa8, 0x12, 0x44, 0x91, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01,
    0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x02, 0x04, 0x30, 0x0f, 0x06, 0x03,
    0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01,
    0xff, 0x30, 0x81, 0xe6, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0xd6,
    0x79, 0x02, 0x01, 0x18, 0x01, 0x01, 0xff, 0x04, 0x81, 0xd4, 0x30, 0x81,
    0xd1, 0xa0, 0x42, 0x04, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa3, 0x42, 0x04,
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0x42, 0x04, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xa6, 0x03, 0x0a, 0x01, 0x00, 0x30, 0x0c, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x04, 0x03, 0x04, 0x05, 0x00, 0x03, 0x47, 0x00, 0x30,
    0x44, 0x02, 0x20, 0x5c, 0x20, 0xd4, 0x32, 0xaf, 0x59, 0x4b, 0x44, 0xfc,
    0x49, 0xe5, 0xd4, 0x5d, 0xb6, 0xfe, 0x9c, 0xac, 0x55, 0x02, 0x74, 0x8b,
    0x66, 0xc8, 0x8c, 0xf5, 0x9a, 0x70, 0x8a, 0x97, 0x3c, 0xbc, 0xe0, 0x02,
    0x20, 0x66, 0x83, 0xd1, 0x78, 0x8c, 0x75, 0x44, 0x83, 0x90, 0xc7, 0x1e,
    0xd7, 0x4c, 0x98, 0x1f, 0x10, 0x7f, 0x14, 0x6a, 0x45, 0xc0, 0x1c, 0x48,
    0x99, 0xce, 0x6e, 0x8f, 0x6d, 0xd3, 0xdc, 0xf3, 0x93};

constexpr uint8_t kExpectedX509P384Cert_ZeroInput[0] = {};

constexpr uint8_t kExpectedCborEd25519Cert_ZeroInput[441] = {
    0x84, 0x43, 0xa1, 0x01, 0x27, 0xa0, 0x59, 0x01, 0x6e, 0xa8, 0x01, 0x78,
    0x28, 0x37, 0x61, 0x30, 0x36, 0x65, 0x65, 0x65, 0x34, 0x31, 0x62, 0x37,
    0x38, 0x39, 0x66, 0x34, 0x38, 0x36, 0x33, 0x64, 0x38, 0x36, 0x62, 0x38,
    0x37, 0x37, 0x38, 0x62, 0x31, 0x61, 0x32, 0x30, 0x31, 0x61, 0x36, 0x66,
    0x65, 0x64, 0x64, 0x35, 0x36, 0x02, 0x78, 0x28, 0x36, 0x37, 0x63, 0x32,
    0x32, 0x61, 0x38, 0x38, 0x35, 0x39, 0x30, 0x36, 0x32, 0x62, 0x39, 0x38,
    0x36, 0x38, 0x31, 0x38, 0x65, 0x38, 0x65, 0x37, 0x32, 0x62, 0x30, 0x62,
    0x63, 0x64, 0x39, 0x66, 0x35, 0x39, 0x33, 0x34, 0x39, 0x63, 0x38, 0x39,
    0x3a, 0x00, 0x47, 0x44, 0x50, 0x58, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a,
    0x00, 0x47, 0x44, 0x53, 0x58, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x00,
    0x47, 0x44, 0x54, 0x58, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x47,
    0x44, 0x56, 0x41, 0x00, 0x3a, 0x00, 0x47, 0x44, 0x57, 0x58, 0x2d, 0xa5,
    0x01, 0x01, 0x03, 0x27, 0x04, 0x81, 0x02, 0x20, 0x06, 0x21, 0x58, 0x20,
    0x0d, 0x14, 0xe5, 0xde, 0x29, 0x2e, 0xb1, 0xc8, 0xb3, 0x1b, 0xea, 0xe4,
    0x3a, 0xb5, 0x5d, 0x8e, 0x9d, 0xc0, 0x14, 0xb7, 0x3e, 0xaa, 0x83, 0xb9,
    0x25, 0xa0, 0x78, 0x8c, 0xc6, 0x2e, 0x5c, 0x8d, 0x3a, 0x00, 0x47, 0x44,
    0x58, 0x41, 0x20, 0x58, 0x40, 0xf9, 0x9b, 0xd6, 0xdb, 0xc1, 0x24, 0x71,
    0x53, 0xc1, 0x0f, 0x88, 0x1c, 0x0f, 0x5f, 0x33, 0xbf, 0x02, 0x23, 0xd2,
    0x22, 0x32, 0x71, 0x24, 0x41, 0xb1, 0x28, 0xd3, 0x83, 0xde, 0x32, 0x1b,
    0x67, 0xc0, 0x9a, 0x1f, 0x45, 0x91, 0xc4, 0x20, 0xdc, 0xc9, 0xd6, 0x21,
    0x21, 0xec, 0xa3, 0xd3, 0x89, 0x7a, 0x24, 0x4d, 0xcb, 0xe1, 0x1a, 0x0f,
    0x9a, 0xb7, 0x9f, 0x67, 0x09, 0x3f, 0xee, 0x56, 0x0f};

constexpr uint8_t kExpectedCborP256Cert_ZeroInput[0] = {};

constexpr uint8_t kExpectedCborP384Cert_ZeroInput[542] = {
    0x84, 0x44, 0xa1, 0x01, 0x38, 0x22, 0xa0, 0x59, 0x01, 0xb2, 0xa8, 0x01,
    0x78, 0x28, 0x30, 0x34, 0x63, 0x32, 0x36, 0x35, 0x66, 0x65, 0x30, 0x36,
    0x66, 0x66, 0x32, 0x33, 0x30, 0x65, 0x33, 0x39, 0x62, 0x36, 0x33, 0x32,
    0x32, 0x65, 0x65, 0x61, 0x39, 0x65, 0x30, 0x31, 0x30, 0x37, 0x31, 0x31,
    0x66, 0x62, 0x36, 0x36, 0x62, 0x34, 0x02, 0x78, 0x28, 0x34, 0x30, 0x63,
    0x62, 0x34, 0x66, 0x30, 0x36, 0x34, 0x61, 0x36, 0x38, 0x64, 0x34, 0x30,
    0x37, 0x61, 0x30, 0x62, 0x33, 0x39, 0x30, 0x61, 0x62, 0x63, 0x63, 0x30,
    0x35, 0x61, 0x33, 0x34, 0x62, 0x66, 0x63, 0x38, 0x61, 0x66, 0x33, 0x33,
    0x66, 0x3a, 0x00, 0x47, 0x44, 0x50, 0x58, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3a, 0x00, 0x47, 0x44, 0x53, 0x58, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a,
    0x00, 0x47, 0x44, 0x54, 0x58, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x00,
    0x47, 0x44, 0x56, 0x41, 0x00, 0x3a, 0x00, 0x47, 0x44, 0x57, 0x58, 0x71,
    0xa6, 0x01, 0x02, 0x03, 0x38, 0x22, 0x04, 0x81, 0x02, 0x20, 0x02, 0x21,
    0x58, 0x30, 0x77, 0x19, 0x6b, 0xa5, 0x84, 0xeb, 0x79, 0x46, 0xd2, 0xfb,
    0xb0, 0xd5, 0xc8, 0x31, 0xc7, 0xad, 0x91, 0x37, 0x5e, 0x11, 0x28, 0xdb,
    0x23, 0x8c, 0xc1, 0xc6, 0x7f, 0xae, 0x5e, 0x07, 0x10, 0x95, 0x5b, 0x17,
    0xb5, 0xd5, 0x08, 0x12, 0x31, 0x06, 0xba, 0x31, 0x31, 0x10, 0x43, 0x71,
    0x51, 0xde, 0x22, 0x58, 0x30, 0x03, 0x25, 0xa9, 0x76, 0x29, 0x67, 0x9d,
    0x6b, 0xa9, 0x01, 0xb1, 0x22, 0xa0, 0x4b, 0xee, 0xf7, 0xb3, 0xe1, 0x52,
    0xfc, 0xe0, 0x3c, 0xdc, 0x5d, 0x1b, 0x58, 0x16, 0x69, 0xdd, 0x44, 0x24,
    0x67, 0xbf, 0x21, 0xd7, 0x47, 0xf3, 0x13, 0xd1, 0x47, 0x6c, 0x4b, 0xd3,
    0x05, 0xb5, 0x29, 0xa0, 0xf1, 0x3a, 0x00, 0x47, 0x44, 0x58, 0x41, 0x20,
    0x58, 0x60, 0xb0, 0xb7, 0x0f, 0x47, 0xfa, 0xba, 0xca, 0x05, 0x16, 0x4f,
    0x1e, 0xd1, 0x73, 0x15, 0x94, 0x17, 0xcd, 0x6b, 0x3c, 0x0e, 0x18, 0x77,
    0xc0, 0x6e, 0x53, 0x97, 0xf2, 0x03, 0xb9, 0xbb, 0x82, 0xde, 0xe0, 0x2d,
    0xb3, 0xc8, 0x0e, 0x7a, 0x5e, 0xb0, 0x74, 0x15, 0xbe, 0x25, 0x6a, 0x7c,
    0x90, 0x30, 0x80, 0x0c, 0x90, 0x20, 0x00, 0xc5, 0x42, 0xbf, 0xf7, 0x4e,
    0x1b, 0xd8, 0xe2, 0xe4, 0x32, 0xd5, 0xf3, 0x8e, 0x1e, 0x59, 0x9f, 0x1e,
    0x71, 0x8e, 0xc3, 0x2e, 0x50, 0x8a, 0xa0, 0x02, 0xa4, 0xd3, 0xe6, 0x8c,
    0x68, 0xbb, 0x5e, 0x33, 0xfd, 0x81, 0x12, 0xa7, 0xdc, 0x68, 0xc7, 0x7a,
    0x4b, 0xfa};

constexpr uint8_t kExpectedCdiAttest_HashOnlyInput[32] = {
    0x08, 0x4e, 0xf4, 0x06, 0xc6, 0x9b, 0xa7, 0x4b, 0x1e, 0x24, 0xd0,
    0x62, 0xf9, 0xab, 0x8a, 0x8d, 0x89, 0xda, 0x6e, 0x03, 0xe4, 0xc6,
    0xb1, 0x22, 0x85, 0x7c, 0xf7, 0x4f, 0xd6, 0xa4, 0xbe, 0xe5};

constexpr uint8_t kExpectedCdiSeal_HashOnlyInput[32] = {
    0x90, 0xc9, 0xa2, 0x86, 0x5d, 0xf4, 0xfa, 0x58, 0x30, 0x64, 0x3d,
    0x6c, 0xae, 0xf0, 0x7c, 0x76, 0xae, 0xaa, 0x15, 0x61, 0x98, 0x28,
    0xf1, 0xbd, 0xa7, 0xf7, 0x44, 0x82, 0xe2, 0xf0, 0xae, 0x1e};

// $ openssl x509 -inform DER -noout -text -certopt ext_parse
// Certificate:
//     Data:
//         Version: 3 (0x2)
//         Serial Number:
//             0d:04:0e:2f:46:00:52:a5:31:1c:1b:91:db:f9:b4:40:83:32:ec:29
//         Signature Algorithm: ED25519
//         Issuer: serialNumber = 475708eb3b426f386cfce8f3baf5439046278dfa
//         Validity
//             Not Before: Mar 22 23:59:59 2018 GMT
//             Not After : Dec 31 23:59:59 9999 GMT
//         Subject: serialNumber = 0d040e2f460052a5311c1b91dbf9b4408332ec29
//         Subject Public Key Info:
//             Public Key Algorithm: ED25519
//                 ED25519 Public-Key:
//                 pub:
//                     5a:39:49:67:8c:d3:0e:88:ab:1c:dd:f7:15:55:d5:
//                     bf:d3:f0:b8:47:25:a9:58:e1:b9:da:4e:b5:f1:38:
//                     9a:5a
//         X509v3 extensions:
//             X509v3 Authority Key Identifier:
//                 keyid:47:57:08:EB:3B:42:6F:38:6C:FC:E8:F3:BA:F5:43:90:46:27:8D:FA
//
//             X509v3 Subject Key Identifier:
//                 0D:04:0E:2F:46:00:52:A5:31:1C:1B:91:DB:F9:B4:40:83:32:EC:29
//             X509v3 Key Usage: critical
//                 Certificate Sign
//             X509v3 Basic Constraints: critical
//                 CA:TRUE
//             1.3.6.1.4.1.11129.2.1.24: critical
//     0:d=0  hl=3 l= 209 cons: SEQUENCE
//     3:d=1  hl=2 l=  66 cons:  cont [ 0 ]
//     5:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - b7 d4 0c cb 22 5b a5 78-8f 98 ff 9e 86 93 75 f6 ...."[.x......u.
//       0010 - 90 ac 50 cf 9e bd 0a fe-b1 d9 c2 4e 52 19 e4 de ..P........NR...
//       0020 - 29 e5 61 f3 f9 29 e8 40-87 7a dd 17 48 05 89 7e ).a..).@.z..H..~
//       0030 - 2b cb 54 79 cc 66 f1 b3-13 29 0c 68 96 b2 bb 8f +.Ty.f...).h....
//    71:d=1  hl=2 l=  66 cons:  cont [ 3 ]
//    73:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - cf 99 7b ea 2e 2c 86 a0-7b 52 09 c8 b5 3c 41 12 ..{..,..{R...<A.
//       0010 - 29 28 1a 82 0d 49 9c 95-cb 0b 1b 31 1a 01 9c f2 )(...I.....1....
//       0020 - 66 1a d9 b5 ce 52 59 cb-f4 81 9b 21 af 32 5d 07 f....RY....!.2].
//       0030 - a0 1e 91 59 6f 06 55 10-8e 2e 08 88 52 28 86 7f ...Yo.U.....R(..
//   139:d=1  hl=2 l=  66 cons:  cont [ 4 ]
//   141:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - 22 52 60 17 ef 2c a1 f6-cb ed 39 d5 e2 aa 65 20 "R`..,....9...e
//       0010 - fb ad 82 93 e5 78 23 22-97 c1 6e 6a 4e 36 d7 6a .....x#"..njN6.j
//       0020 - 61 39 08 21 d4 fe 92 5f-36 2d eb 5d bb 32 8b e3 a9.!..._6-.].2..
//       0030 - 94 4f be 1b 21 f9 cc 23-73 41 b6 b9 b6 98 d0 bc .O..!..#sA......
//   207:d=1  hl=2 l=   3 cons:  cont [ 6 ]
//   209:d=2  hl=2 l=   1 prim:   ENUMERATED        :00
//
//     Signature Algorithm: ED25519
//          27:68:51:a1:be:41:b7:90:03:8d:ce:ce:9c:35:9c:69:ff:f7:
//          7c:14:fb:8d:59:06:71:cf:39:d8:c9:8e:95:79:70:f2:8f:89:
//          af:4d:92:a7:40:c8:fb:85:2a:7c:21:3d:09:8a:d4:f2:25:96:
//          cd:f6:29:06:73:98:db:70:74:08
constexpr uint8_t kExpectedX509Ed25519Cert_HashOnlyInput[638] = {
    0x30, 0x82, 0x02, 0x7a, 0x30, 0x82, 0x02, 0x2c, 0xa0, 0x03, 0x02, 0x01,
    0x02, 0x02, 0x14, 0x0d, 0x04, 0x0e, 0x2f, 0x46, 0x00, 0x52, 0xa5, 0x31,
    0x1c, 0x1b, 0x91, 0xdb, 0xf9, 0xb4, 0x40, 0x83, 0x32, 0xec, 0x29, 0x30,
    0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x30, 0x33, 0x31, 0x31, 0x30, 0x2f,
    0x06, 0x03, 0x55, 0x04, 0x05, 0x13, 0x28, 0x34, 0x37, 0x35, 0x37, 0x30,
    0x38, 0x65, 0x62, 0x33, 0x62, 0x34, 0x32, 0x36, 0x66, 0x33, 0x38, 0x36,
    0x63, 0x66, 0x63, 0x65, 0x38, 0x66, 0x33, 0x62, 0x61, 0x66, 0x35, 0x34,
    0x33, 0x39, 0x30, 0x34, 0x36, 0x32, 0x37, 0x38, 0x64, 0x66, 0x61, 0x30,
    0x20, 0x17, 0x0d, 0x31, 0x38, 0x30, 0x33, 0x32, 0x32, 0x32, 0x33, 0x35,
    0x39, 0x35, 0x39, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32,
    0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x33, 0x31,
    0x31, 0x30, 0x2f, 0x06, 0x03, 0x55, 0x04, 0x05, 0x13, 0x28, 0x30, 0x64,
    0x30, 0x34, 0x30, 0x65, 0x32, 0x66, 0x34, 0x36, 0x30, 0x30, 0x35, 0x32,
    0x61, 0x35, 0x33, 0x31, 0x31, 0x63, 0x31, 0x62, 0x39, 0x31, 0x64, 0x62,
    0x66, 0x39, 0x62, 0x34, 0x34, 0x30, 0x38, 0x33, 0x33, 0x32, 0x65, 0x63,
    0x32, 0x39, 0x30, 0x2a, 0x30, 0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x03,
    0x21, 0x00, 0x5a, 0x39, 0x49, 0x67, 0x8c, 0xd3, 0x0e, 0x88, 0xab, 0x1c,
    0xdd, 0xf7, 0x15, 0x55, 0xd5, 0xbf, 0xd3, 0xf0, 0xb8, 0x47, 0x25, 0xa9,
    0x58, 0xe1, 0xb9, 0xda, 0x4e, 0xb5, 0xf1, 0x38, 0x9a, 0x5a, 0xa3, 0x82,
    0x01, 0x4e, 0x30, 0x82, 0x01, 0x4a, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d,
    0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x47, 0x57, 0x08, 0xeb, 0x3b,
    0x42, 0x6f, 0x38, 0x6c, 0xfc, 0xe8, 0xf3, 0xba, 0xf5, 0x43, 0x90, 0x46,
    0x27, 0x8d, 0xfa, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16,
    0x04, 0x14, 0x0d, 0x04, 0x0e, 0x2f, 0x46, 0x00, 0x52, 0xa5, 0x31, 0x1c,
    0x1b, 0x91, 0xdb, 0xf9, 0xb4, 0x40, 0x83, 0x32, 0xec, 0x29, 0x30, 0x0e,
    0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02,
    0x02, 0x04, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff,
    0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x81, 0xe6, 0x06, 0x0a,
    0x2b, 0x06, 0x01, 0x04, 0x01, 0xd6, 0x79, 0x02, 0x01, 0x18, 0x01, 0x01,
    0xff, 0x04, 0x81, 0xd4, 0x30, 0x81, 0xd1, 0xa0, 0x42, 0x04, 0x40, 0xb7,
    0xd4, 0x0c, 0xcb, 0x22, 0x5b, 0xa5, 0x78, 0x8f, 0x98, 0xff, 0x9e, 0x86,
    0x93, 0x75, 0xf6, 0x90, 0xac, 0x50, 0xcf, 0x9e, 0xbd, 0x0a, 0xfe, 0xb1,
    0xd9, 0xc2, 0x4e, 0x52, 0x19, 0xe4, 0xde, 0x29, 0xe5, 0x61, 0xf3, 0xf9,
    0x29, 0xe8, 0x40, 0x87, 0x7a, 0xdd, 0x17, 0x48, 0x05, 0x89, 0x7e, 0x2b,
    0xcb, 0x54, 0x79, 0xcc, 0x66, 0xf1, 0xb3, 0x13, 0x29, 0x0c, 0x68, 0x96,
    0xb2, 0xbb, 0x8f, 0xa3, 0x42, 0x04, 0x40, 0xcf, 0x99, 0x7b, 0xea, 0x2e,
    0x2c, 0x86, 0xa0, 0x7b, 0x52, 0x09, 0xc8, 0xb5, 0x3c, 0x41, 0x12, 0x29,
    0x28, 0x1a, 0x82, 0x0d, 0x49, 0x9c, 0x95, 0xcb, 0x0b, 0x1b, 0x31, 0x1a,
    0x01, 0x9c, 0xf2, 0x66, 0x1a, 0xd9, 0xb5, 0xce, 0x52, 0x59, 0xcb, 0xf4,
    0x81, 0x9b, 0x21, 0xaf, 0x32, 0x5d, 0x07, 0xa0, 0x1e, 0x91, 0x59, 0x6f,
    0x06, 0x55, 0x10, 0x8e, 0x2e, 0x08, 0x88, 0x52, 0x28, 0x86, 0x7f, 0xa4,
    0x42, 0x04, 0x40, 0x22, 0x52, 0x60, 0x17, 0xef, 0x2c, 0xa1, 0xf6, 0xcb,
    0xed, 0x39, 0xd5, 0xe2, 0xaa, 0x65, 0x20, 0xfb, 0xad, 0x82, 0x93, 0xe5,
    0x78, 0x23, 0x22, 0x97, 0xc1, 0x6e, 0x6a, 0x4e, 0x36, 0xd7, 0x6a, 0x61,
    0x39, 0x08, 0x21, 0xd4, 0xfe, 0x92, 0x5f, 0x36, 0x2d, 0xeb, 0x5d, 0xbb,
    0x32, 0x8b, 0xe3, 0x94, 0x4f, 0xbe, 0x1b, 0x21, 0xf9, 0xcc, 0x23, 0x73,
    0x41, 0xb6, 0xb9, 0xb6, 0x98, 0xd0, 0xbc, 0xa6, 0x03, 0x0a, 0x01, 0x00,
    0x30, 0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x03, 0x41, 0x00, 0x27, 0x68,
    0x51, 0xa1, 0xbe, 0x41, 0xb7, 0x90, 0x03, 0x8d, 0xce, 0xce, 0x9c, 0x35,
    0x9c, 0x69, 0xff, 0xf7, 0x7c, 0x14, 0xfb, 0x8d, 0x59, 0x06, 0x71, 0xcf,
    0x39, 0xd8, 0xc9, 0x8e, 0x95, 0x79, 0x70, 0xf2, 0x8f, 0x89, 0xaf, 0x4d,
    0x92, 0xa7, 0x40, 0xc8, 0xfb, 0x85, 0x2a, 0x7c, 0x21, 0x3d, 0x09, 0x8a,
    0xd4, 0xf2, 0x25, 0x96, 0xcd, 0xf6, 0x29, 0x06, 0x73, 0x98, 0xdb, 0x70,
    0x74, 0x08};

// $ openssl x509 -inform DER -noout -text -certopt ext_parse
// Certificate:
//     Data:
//         Version: 3 (0x2)
//         Serial Number:
//             68:49:58:d9:ae:a7:2e:bf:7c:06:af:20:03:b6:44:47:82:4a:62:71
//         Signature Algorithm: ecdsa-with-SHA512
//         Issuer: serialNumber = 1be5687933db3d9cd5fca729e81d6685465a7bf1
//         Validity
//             Not Before: Mar 22 23:59:59 2018 GMT
//             Not After : Dec 31 23:59:59 9999 GMT
//         Subject: serialNumber = 684958d9aea72ebf7c06af2003b64447824a6271
//         Subject Public Key Info:
//             Public Key Algorithm: id-ecPublicKey
//                 Public-Key: (256 bit)
//                 pub:
//                     04:fe:9d:b2:f9:28:09:c3:04:12:85:dc:d3:70:6f:
//                     22:1c:72:b6:c4:4f:de:93:ee:fd:fb:6d:57:18:fc:
//                     8f:6f:0b:09:1a:19:ea:10:7e:a9:38:f4:45:33:c1:
//                     66:5b:bc:fc:0a:6e:98:99:72:88:c1:ad:0e:15:c2:
//                     85:77:75:00:0b
//                 ASN1 OID: prime256v1
//                 NIST CURVE: P-256
//         X509v3 extensions:
//             X509v3 Authority Key Identifier:
//                 keyid:1B:E5:68:79:33:DB:3D:9C:D5:FC:A7:29:E8:1D:66:85:46:5A:7B:F1
//
//             X509v3 Subject Key Identifier:
//                 68:49:58:D9:AE:A7:2E:BF:7C:06:AF:20:03:B6:44:47:82:4A:62:71
//             X509v3 Key Usage: critical
//                 Certificate Sign
//             X509v3 Basic Constraints: critical
//                 CA:TRUE
//             1.3.6.1.4.1.11129.2.1.24: critical
//     0:d=0  hl=3 l= 209 cons: SEQUENCE
//     3:d=1  hl=2 l=  66 cons:  cont [ 0 ]
//     5:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - b7 d4 0c cb 22 5b a5 78-8f 98 ff 9e 86 93 75 f6 ...."[.x......u.
//       0010 - 90 ac 50 cf 9e bd 0a fe-b1 d9 c2 4e 52 19 e4 de ..P........NR...
//       0020 - 29 e5 61 f3 f9 29 e8 40-87 7a dd 17 48 05 89 7e ).a..).@.z..H..~
//       0030 - 2b cb 54 79 cc 66 f1 b3-13 29 0c 68 96 b2 bb 8f +.Ty.f...).h....
//    71:d=1  hl=2 l=  66 cons:  cont [ 3 ]
//    73:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - cf 99 7b ea 2e 2c 86 a0-7b 52 09 c8 b5 3c 41 12 ..{..,..{R...<A.
//       0010 - 29 28 1a 82 0d 49 9c 95-cb 0b 1b 31 1a 01 9c f2 )(...I.....1....
//       0020 - 66 1a d9 b5 ce 52 59 cb-f4 81 9b 21 af 32 5d 07 f....RY....!.2].
//       0030 - a0 1e 91 59 6f 06 55 10-8e 2e 08 88 52 28 86 7f ...Yo.U.....R(..
//   139:d=1  hl=2 l=  66 cons:  cont [ 4 ]
//   141:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - 22 52 60 17 ef 2c a1 f6-cb ed 39 d5 e2 aa 65 20 "R`..,....9...e
//       0010 - fb ad 82 93 e5 78 23 22-97 c1 6e 6a 4e 36 d7 6a .....x#"..njN6.j
//       0020 - 61 39 08 21 d4 fe 92 5f-36 2d eb 5d bb 32 8b e3 a9.!..._6-.].2..
//       0030 - 94 4f be 1b 21 f9 cc 23-73 41 b6 b9 b6 98 d0 bc .O..!..#sA......
//   207:d=1  hl=2 l=   3 cons:  cont [ 6 ]
//   209:d=2  hl=2 l=   1 prim:   ENUMERATED        :00
//
//     Signature Algorithm: ecdsa-with-SHA512
//          30:46:02:21:00:d0:ff:60:84:d4:74:47:eb:f4:29:86:c5:2a:
//          12:01:f9:7e:5b:ab:fd:fe:d3:11:75:bc:26:63:71:57:2b:b1:
//          c8:02:21:00:e0:16:72:65:b0:4a:92:ca:c6:c9:e2:0f:50:f0:
//          1c:70:01:64:a7:8d:7d:51:e9:59:fe:e6:7f:31:28:30:04:04
constexpr uint8_t kExpectedX509P256Cert_HashOnlyInput[707] = {
    0x30, 0x82, 0x02, 0xbf, 0x30, 0x82, 0x02, 0x62, 0xa0, 0x03, 0x02, 0x01,
    0x02, 0x02, 0x14, 0x68, 0x49, 0x58, 0xd9, 0xae, 0xa7, 0x2e, 0xbf, 0x7c,
    0x06, 0xaf, 0x20, 0x03, 0xb6, 0x44, 0x47, 0x82, 0x4a, 0x62, 0x71, 0x30,
    0x0c, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x04, 0x05,
    0x00, 0x30, 0x33, 0x31, 0x31, 0x30, 0x2f, 0x06, 0x03, 0x55, 0x04, 0x05,
    0x13, 0x28, 0x31, 0x62, 0x65, 0x35, 0x36, 0x38, 0x37, 0x39, 0x33, 0x33,
    0x64, 0x62, 0x33, 0x64, 0x39, 0x63, 0x64, 0x35, 0x66, 0x63, 0x61, 0x37,
    0x32, 0x39, 0x65, 0x38, 0x31, 0x64, 0x36, 0x36, 0x38, 0x35, 0x34, 0x36,
    0x35, 0x61, 0x37, 0x62, 0x66, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x31, 0x38,
    0x30, 0x33, 0x32, 0x32, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x18,
    0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35,
    0x39, 0x35, 0x39, 0x5a, 0x30, 0x33, 0x31, 0x31, 0x30, 0x2f, 0x06, 0x03,
    0x55, 0x04, 0x05, 0x13, 0x28, 0x36, 0x38, 0x34, 0x39, 0x35, 0x38, 0x64,
    0x39, 0x61, 0x65, 0x61, 0x37, 0x32, 0x65, 0x62, 0x66, 0x37, 0x63, 0x30,
    0x36, 0x61, 0x66, 0x32, 0x30, 0x30, 0x33, 0x62, 0x36, 0x34, 0x34, 0x34,
    0x37, 0x38, 0x32, 0x34, 0x61, 0x36, 0x32, 0x37, 0x31, 0x30, 0x59, 0x30,
    0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08,
    0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04,
    0xfe, 0x9d, 0xb2, 0xf9, 0x28, 0x09, 0xc3, 0x04, 0x12, 0x85, 0xdc, 0xd3,
    0x70, 0x6f, 0x22, 0x1c, 0x72, 0xb6, 0xc4, 0x4f, 0xde, 0x93, 0xee, 0xfd,
    0xfb, 0x6d, 0x57, 0x18, 0xfc, 0x8f, 0x6f, 0x0b, 0x09, 0x1a, 0x19, 0xea,
    0x10, 0x7e, 0xa9, 0x38, 0xf4, 0x45, 0x33, 0xc1, 0x66, 0x5b, 0xbc, 0xfc,
    0x0a, 0x6e, 0x98, 0x99, 0x72, 0x88, 0xc1, 0xad, 0x0e, 0x15, 0xc2, 0x85,
    0x77, 0x75, 0x00, 0x0b, 0xa3, 0x82, 0x01, 0x4e, 0x30, 0x82, 0x01, 0x4a,
    0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80,
    0x14, 0x1b, 0xe5, 0x68, 0x79, 0x33, 0xdb, 0x3d, 0x9c, 0xd5, 0xfc, 0xa7,
    0x29, 0xe8, 0x1d, 0x66, 0x85, 0x46, 0x5a, 0x7b, 0xf1, 0x30, 0x1d, 0x06,
    0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x68, 0x49, 0x58, 0xd9,
    0xae, 0xa7, 0x2e, 0xbf, 0x7c, 0x06, 0xaf, 0x20, 0x03, 0xb6, 0x44, 0x47,
    0x82, 0x4a, 0x62, 0x71, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01,
    0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x02, 0x04, 0x30, 0x0f, 0x06, 0x03,
    0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01,
    0xff, 0x30, 0x81, 0xe6, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0xd6,
    0x79, 0x02, 0x01, 0x18, 0x01, 0x01, 0xff, 0x04, 0x81, 0xd4, 0x30, 0x81,
    0xd1, 0xa0, 0x42, 0x04, 0x40, 0xb7, 0xd4, 0x0c, 0xcb, 0x22, 0x5b, 0xa5,
    0x78, 0x8f, 0x98, 0xff, 0x9e, 0x86, 0x93, 0x75, 0xf6, 0x90, 0xac, 0x50,
    0xcf, 0x9e, 0xbd, 0x0a, 0xfe, 0xb1, 0xd9, 0xc2, 0x4e, 0x52, 0x19, 0xe4,
    0xde, 0x29, 0xe5, 0x61, 0xf3, 0xf9, 0x29, 0xe8, 0x40, 0x87, 0x7a, 0xdd,
    0x17, 0x48, 0x05, 0x89, 0x7e, 0x2b, 0xcb, 0x54, 0x79, 0xcc, 0x66, 0xf1,
    0xb3, 0x13, 0x29, 0x0c, 0x68, 0x96, 0xb2, 0xbb, 0x8f, 0xa3, 0x42, 0x04,
    0x40, 0xcf, 0x99, 0x7b, 0xea, 0x2e, 0x2c, 0x86, 0xa0, 0x7b, 0x52, 0x09,
    0xc8, 0xb5, 0x3c, 0x41, 0x12, 0x29, 0x28, 0x1a, 0x82, 0x0d, 0x49, 0x9c,
    0x95, 0xcb, 0x0b, 0x1b, 0x31, 0x1a, 0x01, 0x9c, 0xf2, 0x66, 0x1a, 0xd9,
    0xb5, 0xce, 0x52, 0x59, 0xcb, 0xf4, 0x81, 0x9b, 0x21, 0xaf, 0x32, 0x5d,
    0x07, 0xa0, 0x1e, 0x91, 0x59, 0x6f, 0x06, 0x55, 0x10, 0x8e, 0x2e, 0x08,
    0x88, 0x52, 0x28, 0x86, 0x7f, 0xa4, 0x42, 0x04, 0x40, 0x22, 0x52, 0x60,
    0x17, 0xef, 0x2c, 0xa1, 0xf6, 0xcb, 0xed, 0x39, 0xd5, 0xe2, 0xaa, 0x65,
    0x20, 0xfb, 0xad, 0x82, 0x93, 0xe5, 0x78, 0x23, 0x22, 0x97, 0xc1, 0x6e,
    0x6a, 0x4e, 0x36, 0xd7, 0x6a, 0x61, 0x39, 0x08, 0x21, 0xd4, 0xfe, 0x92,
    0x5f, 0x36, 0x2d, 0xeb, 0x5d, 0xbb, 0x32, 0x8b, 0xe3, 0x94, 0x4f, 0xbe,
    0x1b, 0x21, 0xf9, 0xcc, 0x23, 0x73, 0x41, 0xb6, 0xb9, 0xb6, 0x98, 0xd0,
    0xbc, 0xa6, 0x03, 0x0a, 0x01, 0x00, 0x30, 0x0c, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x04, 0x03, 0x04, 0x05, 0x00, 0x03, 0x49, 0x00, 0x30,
    0x46, 0x02, 0x21, 0x00, 0xd0, 0xff, 0x60, 0x84, 0xd4, 0x74, 0x47, 0xeb,
    0xf4, 0x29, 0x86, 0xc5, 0x2a, 0x12, 0x01, 0xf9, 0x7e, 0x5b, 0xab, 0xfd,
    0xfe, 0xd3, 0x11, 0x75, 0xbc, 0x26, 0x63, 0x71, 0x57, 0x2b, 0xb1, 0xc8,
    0x02, 0x21, 0x00, 0xe0, 0x16, 0x72, 0x65, 0xb0, 0x4a, 0x92, 0xca, 0xc6,
    0xc9, 0xe2, 0x0f, 0x50, 0xf0, 0x1c, 0x70, 0x01, 0x64, 0xa7, 0x8d, 0x7d,
    0x51, 0xe9, 0x59, 0xfe, 0xe6, 0x7f, 0x31, 0x28, 0x30, 0x04, 0x04};

constexpr uint8_t kExpectedX509P384Cert_HashOnlyInput[0] = {};

constexpr uint8_t kExpectedCborEd25519Cert_HashOnlyInput[441] = {
    0x84, 0x43, 0xa1, 0x01, 0x27, 0xa0, 0x59, 0x01, 0x6e, 0xa8, 0x01, 0x78,
    0x28, 0x34, 0x37, 0x35, 0x37, 0x30, 0x38, 0x65, 0x62, 0x33, 0x62, 0x34,
    0x32, 0x36, 0x66, 0x33, 0x38, 0x36, 0x63, 0x66, 0x63, 0x65, 0x38, 0x66,
    0x33, 0x62, 0x61, 0x66, 0x35, 0x34, 0x33, 0x39, 0x30, 0x34, 0x36, 0x32,
    0x37, 0x38, 0x64, 0x66, 0x61, 0x02, 0x78, 0x28, 0x30, 0x64, 0x30, 0x34,
    0x30, 0x65, 0x32, 0x66, 0x34, 0x36, 0x30, 0x30, 0x35, 0x32, 0x61, 0x35,
    0x33, 0x31, 0x31, 0x63, 0x31, 0x62, 0x39, 0x31, 0x64, 0x62, 0x66, 0x39,
    0x62, 0x34, 0x34, 0x30, 0x38, 0x33, 0x33, 0x32, 0x65, 0x63, 0x32, 0x39,
    0x3a, 0x00, 0x47, 0x44, 0x50, 0x58, 0x40, 0xb7, 0xd4, 0x0c, 0xcb, 0x22,
    0x5b, 0xa5, 0x78, 0x8f, 0x98, 0xff, 0x9e, 0x86, 0x93, 0x75, 0xf6, 0x90,
    0xac, 0x50, 0xcf, 0x9e, 0xbd, 0x0a, 0xfe, 0xb1, 0xd9, 0xc2, 0x4e, 0x52,
    0x19, 0xe4, 0xde, 0x29, 0xe5, 0x61, 0xf3, 0xf9, 0x29, 0xe8, 0x40, 0x87,
    0x7a, 0xdd, 0x17, 0x48, 0x05, 0x89, 0x7e, 0x2b, 0xcb, 0x54, 0x79, 0xcc,
    0x66, 0xf1, 0xb3, 0x13, 0x29, 0x0c, 0x68, 0x96, 0xb2, 0xbb, 0x8f, 0x3a,
    0x00, 0x47, 0x44, 0x53, 0x58, 0x40, 0xcf, 0x99, 0x7b, 0xea, 0x2e, 0x2c,
    0x86, 0xa0, 0x7b, 0x52, 0x09, 0xc8, 0xb5, 0x3c, 0x41, 0x12, 0x29, 0x28,
    0x1a, 0x82, 0x0d, 0x49, 0x9c, 0x95, 0xcb, 0x0b, 0x1b, 0x31, 0x1a, 0x01,
    0x9c, 0xf2, 0x66, 0x1a, 0xd9, 0xb5, 0xce, 0x52, 0x59, 0xcb, 0xf4, 0x81,
    0x9b, 0x21, 0xaf, 0x32, 0x5d, 0x07, 0xa0, 0x1e, 0x91, 0x59, 0x6f, 0x06,
    0x55, 0x10, 0x8e, 0x2e, 0x08, 0x88, 0x52, 0x28, 0x86, 0x7f, 0x3a, 0x00,
    0x47, 0x44, 0x54, 0x58, 0x40, 0x22, 0x52, 0x60, 0x17, 0xef, 0x2c, 0xa1,
    0xf6, 0xcb, 0xed, 0x39, 0xd5, 0xe2, 0xaa, 0x65, 0x20, 0xfb, 0xad, 0x82,
    0x93, 0xe5, 0x78, 0x23, 0x22, 0x97, 0xc1, 0x6e, 0x6a, 0x4e, 0x36, 0xd7,
    0x6a, 0x61, 0x39, 0x08, 0x21, 0xd4, 0xfe, 0x92, 0x5f, 0x36, 0x2d, 0xeb,
    0x5d, 0xbb, 0x32, 0x8b, 0xe3, 0x94, 0x4f, 0xbe, 0x1b, 0x21, 0xf9, 0xcc,
    0x23, 0x73, 0x41, 0xb6, 0xb9, 0xb6, 0x98, 0xd0, 0xbc, 0x3a, 0x00, 0x47,
    0x44, 0x56, 0x41, 0x00, 0x3a, 0x00, 0x47, 0x44, 0x57, 0x58, 0x2d, 0xa5,
    0x01, 0x01, 0x03, 0x27, 0x04, 0x81, 0x02, 0x20, 0x06, 0x21, 0x58, 0x20,
    0x5a, 0x39, 0x49, 0x67, 0x8c, 0xd3, 0x0e, 0x88, 0xab, 0x1c, 0xdd, 0xf7,
    0x15, 0x55, 0xd5, 0xbf, 0xd3, 0xf0, 0xb8, 0x47, 0x25, 0xa9, 0x58, 0xe1,
    0xb9, 0xda, 0x4e, 0xb5, 0xf1, 0x38, 0x9a, 0x5a, 0x3a, 0x00, 0x47, 0x44,
    0x58, 0x41, 0x20, 0x58, 0x40, 0x82, 0x99, 0xff, 0x84, 0x55, 0xcb, 0xf9,
    0x99, 0x89, 0x48, 0x99, 0x12, 0x1d, 0x04, 0x40, 0xcf, 0x90, 0xa4, 0xbc,
    0x61, 0x4f, 0x0d, 0x2e, 0x77, 0x2e, 0x9c, 0x8f, 0xaa, 0xdd, 0xf4, 0x2f,
    0xe2, 0x14, 0xd2, 0x42, 0x4a, 0x02, 0x9e, 0x1d, 0x24, 0x72, 0x0b, 0x08,
    0xb6, 0x71, 0xc7, 0x76, 0x64, 0x25, 0xfb, 0x03, 0xcf, 0xd6, 0x6f, 0x2f,
    0x9a, 0x15, 0xc8, 0xad, 0x47, 0x9a, 0xf3, 0x16, 0x01};

constexpr uint8_t kExpectedCborP256Cert_HashOnlyInput[0] = {};

constexpr uint8_t kExpectedCborP384Cert_HashOnlyInput[542] = {
    0x84, 0x44, 0xa1, 0x01, 0x38, 0x22, 0xa0, 0x59, 0x01, 0xb2, 0xa8, 0x01,
    0x78, 0x28, 0x35, 0x64, 0x38, 0x62, 0x36, 0x62, 0x65, 0x37, 0x63, 0x65,
    0x33, 0x65, 0x64, 0x65, 0x36, 0x61, 0x32, 0x34, 0x31, 0x38, 0x30, 0x31,
    0x34, 0x35, 0x32, 0x33, 0x65, 0x36, 0x63, 0x39, 0x64, 0x63, 0x38, 0x37,
    0x65, 0x39, 0x38, 0x63, 0x63, 0x36, 0x02, 0x78, 0x28, 0x36, 0x35, 0x61,
    0x63, 0x35, 0x39, 0x36, 0x61, 0x62, 0x39, 0x39, 0x34, 0x30, 0x33, 0x61,
    0x38, 0x63, 0x37, 0x30, 0x32, 0x37, 0x35, 0x62, 0x31, 0x34, 0x62, 0x30,
    0x32, 0x33, 0x37, 0x33, 0x66, 0x66, 0x31, 0x34, 0x33, 0x66, 0x39, 0x31,
    0x65, 0x3a, 0x00, 0x47, 0x44, 0x50, 0x58, 0x40, 0xb7, 0xd4, 0x0c, 0xcb,
    0x22, 0x5b, 0xa5, 0x78, 0x8f, 0x98, 0xff, 0x9e, 0x86, 0x93, 0x75, 0xf6,
    0x90, 0xac, 0x50, 0xcf, 0x9e, 0xbd, 0x0a, 0xfe, 0xb1, 0xd9, 0xc2, 0x4e,
    0x52, 0x19, 0xe4, 0xde, 0x29, 0xe5, 0x61, 0xf3, 0xf9, 0x29, 0xe8, 0x40,
    0x87, 0x7a, 0xdd, 0x17, 0x48, 0x05, 0x89, 0x7e, 0x2b, 0xcb, 0x54, 0x79,
    0xcc, 0x66, 0xf1, 0xb3, 0x13, 0x29, 0x0c, 0x68, 0x96, 0xb2, 0xbb, 0x8f,
    0x3a, 0x00, 0x47, 0x44, 0x53, 0x58, 0x40, 0xcf, 0x99, 0x7b, 0xea, 0x2e,
    0x2c, 0x86, 0xa0, 0x7b, 0x52, 0x09, 0xc8, 0xb5, 0x3c, 0x41, 0x12, 0x29,
    0x28, 0x1a, 0x82, 0x0d, 0x49, 0x9c, 0x95, 0xcb, 0x0b, 0x1b, 0x31, 0x1a,
    0x01, 0x9c, 0xf2, 0x66, 0x1a, 0xd9, 0xb5, 0xce, 0x52, 0x59, 0xcb, 0xf4,
    0x81, 0x9b, 0x21, 0xaf, 0x32, 0x5d, 0x07, 0xa0, 0x1e, 0x91, 0x59, 0x6f,
    0x06, 0x55, 0x10, 0x8e, 0x2e, 0x08, 0x88, 0x52, 0x28, 0x86, 0x7f, 0x3a,
    0x00, 0x47, 0x44, 0x54, 0x58, 0x40, 0x22, 0x52, 0x60, 0x17, 0xef, 0x2c,
    0xa1, 0xf6, 0xcb, 0xed, 0x39, 0xd5, 0xe2, 0xaa, 0x65, 0x20, 0xfb, 0xad,
    0x82, 0x93, 0xe5, 0x78, 0x23, 0x22, 0x97, 0xc1, 0x6e, 0x6a, 0x4e, 0x36,
    0xd7, 0x6a, 0x61, 0x39, 0x08, 0x21, 0xd4, 0xfe, 0x92, 0x5f, 0x36, 0x2d,
    0xeb, 0x5d, 0xbb, 0x32, 0x8b, 0xe3, 0x94, 0x4f, 0xbe, 0x1b, 0x21, 0xf9,
    0xcc, 0x23, 0x73, 0x41, 0xb6, 0xb9, 0xb6, 0x98, 0xd0, 0xbc, 0x3a, 0x00,
    0x47, 0x44, 0x56, 0x41, 0x00, 0x3a, 0x00, 0x47, 0x44, 0x57, 0x58, 0x71,
    0xa6, 0x01, 0x02, 0x03, 0x38, 0x22, 0x04, 0x81, 0x02, 0x20, 0x02, 0x21,
    0x58, 0x30, 0x32, 0x81, 0xad, 0x61, 0x1e, 0x50, 0x96, 0x2b, 0x5e, 0xda,
    0xff, 0xee, 0x14, 0xa6, 0x44, 0x3d, 0xd9, 0xd1, 0x34, 0xf6, 0x64, 0xb7,
    0x61, 0x58, 0xf4, 0x9a, 0x58, 0xdb, 0xef, 0xa8, 0x87, 0x13, 0x26, 0x08,
    0x1b, 0xc7, 0xdd, 0xc5, 0x5b, 0x73, 0x42, 0xd6, 0x29, 0x87, 0x3f, 0x85,
    0xd0, 0xe4, 0x22, 0x58, 0x30, 0x60, 0x85, 0xd8, 0x42, 0x29, 0x1b, 0xc6,
    0xd9, 0xf6, 0x2f, 0x3a, 0xce, 0xa0, 0xb9, 0x40, 0xb8, 0x18, 0xde, 0xc2,
    0x5c, 0x90, 0xfb, 0x4b, 0x6d, 0x96, 0x42, 0x77, 0xe2, 0xf6, 0x58, 0x3d,
    0x37, 0xa7, 0x3d, 0x2e, 0xca, 0xd1, 0x2c, 0xa4, 0xd4, 0xa7, 0xaf, 0x25,
    0xc3, 0xb2, 0xe7, 0x34, 0xf5, 0x3a, 0x00, 0x47, 0x44, 0x58, 0x41, 0x20,
    0x58, 0x60, 0x84, 0x9a, 0x2e, 0x89, 0xeb, 0x6d, 0x61, 0x93, 0xe0, 0x0e,
    0xb9, 0x57, 0xc6, 0x84, 0x08, 0x28, 0x77, 0xeb, 0x9e, 0x39, 0xad, 0x74,
    0x78, 0xf3, 0x8f, 0xf7, 0xdf, 0xfa, 0xa2, 0xbf, 0x01, 0x4f, 0x94, 0x1a,
    0xa1, 0x27, 0xaa, 0x93, 0x57, 0xe4, 0x49, 0x07, 0xb9, 0xd7, 0x49, 0xdb,
    0x73, 0x1e, 0xa1, 0x7e, 0xf1, 0x19, 0x87, 0x8e, 0x5a, 0x89, 0xb7, 0x02,
    0x19, 0x13, 0xdb, 0x20, 0x3f, 0x5f, 0x49, 0xc9, 0xb7, 0xcf, 0x52, 0xc3,
    0xd2, 0xf7, 0x90, 0x52, 0xf7, 0xaa, 0x39, 0x66, 0x78, 0x7a, 0x5b, 0xb3,
    0xa7, 0xe9, 0x33, 0xc6, 0x4f, 0xe6, 0x78, 0xf3, 0x4b, 0x51, 0xf1, 0xed,
    0x15, 0xeb};

constexpr uint8_t kExpectedCdiAttest_DescriptorInput[32] = {
    0x20, 0xd5, 0x0c, 0x68, 0x5a, 0xd9, 0xe2, 0xdf, 0x77, 0x60, 0x78,
    0x68, 0x19, 0x00, 0x24, 0xc2, 0x04, 0x4f, 0xb8, 0xde, 0x79, 0xaa,
    0x9f, 0x5f, 0x12, 0xfc, 0xa8, 0xda, 0x37, 0x08, 0xa3, 0x10};

constexpr uint8_t kExpectedCdiSeal_DescriptorInput[32] = {
    0x90, 0xc9, 0xa2, 0x86, 0x5d, 0xf4, 0xfa, 0x58, 0x30, 0x64, 0x3d,
    0x6c, 0xae, 0xf0, 0x7c, 0x76, 0xae, 0xaa, 0x15, 0x61, 0x98, 0x28,
    0xf1, 0xbd, 0xa7, 0xf7, 0x44, 0x82, 0xe2, 0xf0, 0xae, 0x1e};

// $ openssl x509 -inform DER -noout -text -certopt ext_parse
// Certificate:
//     Data:
//         Version: 3 (0x2)
//         Serial Number:
//             52:1f:03:5c:21:e3:2f:16:74:1c:1e:ae:6b:de:d9:3c:e3:21:e0:df
//         Signature Algorithm: ED25519
//         Issuer: serialNumber = 475708eb3b426f386cfce8f3baf5439046278dfa
//         Validity
//             Not Before: Mar 22 23:59:59 2018 GMT
//             Not After : Dec 31 23:59:59 9999 GMT
//         Subject: serialNumber = 521f035c21e32f16741c1eae6bded93ce321e0df
//         Subject Public Key Info:
//             Public Key Algorithm: ED25519
//                 ED25519 Public-Key:
//                 pub:
//                     93:7f:d9:c0:4d:c6:bb:2e:1d:11:62:cd:5c:76:94:
//                     c7:db:02:54:0c:85:01:3a:01:ab:37:fa:ce:f9:6e:
//                     62:20
//         X509v3 extensions:
//             X509v3 Authority Key Identifier:
//                 keyid:47:57:08:EB:3B:42:6F:38:6C:FC:E8:F3:BA:F5:43:90:46:27:8D:FA
//
//             X509v3 Subject Key Identifier:
//                 52:1F:03:5C:21:E3:2F:16:74:1C:1E:AE:6B:DE:D9:3C:E3:21:E0:DF
//             X509v3 Key Usage: critical
//                 Certificate Sign
//             X509v3 Basic Constraints: critical
//                 CA:TRUE
//             1.3.6.1.4.1.11129.2.1.24: critical
//     0:d=0  hl=4 l= 426 cons: SEQUENCE
//     4:d=1  hl=2 l=  66 cons:  cont [ 0 ]
//     6:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - b7 d4 0c cb 22 5b a5 78-8f 98 ff 9e 86 93 75 f6 ...."[.x......u.
//       0010 - 90 ac 50 cf 9e bd 0a fe-b1 d9 c2 4e 52 19 e4 de ..P........NR...
//       0020 - 29 e5 61 f3 f9 29 e8 40-87 7a dd 17 48 05 89 7e ).a..).@.z..H..~
//       0030 - 2b cb 54 79 cc 66 f1 b3-13 29 0c 68 96 b2 bb 8f +.Ty.f...).h....
//    72:d=1  hl=2 l= 102 cons:  cont [ 1 ]
//    74:d=2  hl=2 l= 100 prim:   OCTET STRING
//       0000 - 6c 46 01 33 26 73 4b 22-65 fd fa 58 d7 57 3e 95 lF.3&sK"e..X.W>.
//       0010 - 59 e0 3a c3 b9 f7 c8 0e-98 80 8c f5 c4 b8 af e3 Y.:.............
//       0020 - 16 84 25 a5 35 5d 17 72-56 8f 8e ec 2f 5a 74 60 ..%.5].rV.../Zt`
//       0030 - 77 2a 6e 90 c0 4e 9f 87-6b f4 8d 9c 66 e3 0b d2 w*n..N..k...f...
//       0040 - 10 35 21 a8 1d a2 31 17-e7 0c df 18 f7 94 e4 d1 .5!...1.........
//       0050 - ca 32 7d f2 63 23 1d bc-84 74 61 db 87 f2 ab 72 .2}.c#...ta....r
//       0060 - ad af 08 f8                                       ....
//   176:d=1  hl=2 l=  66 cons:  cont [ 2 ]
//   178:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - 45 00 e9 5c bd 00 57 04-55 87 6c bd 2f ea 41 9c E..\..W.U.l./.A.
//       0010 - 66 42 51 41 bb 44 ed 0e-e9 66 cf d5 10 73 0d 4b fBQA.D...f...s.K
//       0020 - 48 e4 7a 53 35 01 0e 6d-15 55 c5 b7 d2 d5 36 b6 H.zS5..m.U....6.
//       0030 - bc 7e b0 f3 3d e6 19 78-62 eb 02 57 39 56 73 4f .~..=..xb..W9VsO
//   244:d=1  hl=2 l=  42 cons:  cont [ 3 ]
//   246:d=2  hl=2 l=  40 prim:   OCTET STRING
//       0000 - 1b 40 c1 a9 77 60 eb c3-67 f0 5f 6a e1 5e 20 c2   .@..w`..g._j.^
//       . 0010 - 51 68 4d 82 48 8b 03 32-16 79 88 14 37 78 7f 16
//       QhM.H..2.y..7x.. 0020 - 9a 06 fd c0 8a 15 80 62- .......b
//   288:d=1  hl=2 l=  66 cons:  cont [ 4 ]
//   290:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - 22 52 60 17 ef 2c a1 f6-cb ed 39 d5 e2 aa 65 20 "R`..,....9...e
//       0010 - fb ad 82 93 e5 78 23 22-97 c1 6e 6a 4e 36 d7 6a .....x#"..njN6.j
//       0020 - 61 39 08 21 d4 fe 92 5f-36 2d eb 5d bb 32 8b e3 a9.!..._6-.].2..
//       0030 - 94 4f be 1b 21 f9 cc 23-73 41 b6 b9 b6 98 d0 bc .O..!..#sA......
//   356:d=1  hl=2 l=  67 cons:  cont [ 5 ]
//   358:d=2  hl=2 l=  65 prim:   OCTET STRING
//       0000 - 92 d6 97 b3 83 df e7 8c-c7 bc 4a fc ea 76 c0 53 ..........J..v.S
//       0010 - 66 bd 2c 1e 10 31 90 80-11 2d 08 4d 7c 39 76 dc f.,..1...-.M|9v.
//       0020 - 73 e7 1c 16 62 d5 59 d7-49 2b 6a a2 36 67 57 d1 s...b.Y.I+j.6gW.
//       0030 - f2 f9 af 13 d7 a3 e4 d3-39 5b 02 78 b1 e0 09 70 ........9[.x...p
//       0040 - a2                                                .
//   425:d=1  hl=2 l=   3 cons:  cont [ 6 ]
//   427:d=2  hl=2 l=   1 prim:   ENUMERATED        :00
//
//     Signature Algorithm: ED25519
//          23:23:66:8c:b2:de:08:0a:fa:96:01:3f:5c:f3:87:ac:33:e0:
//          d0:86:9b:f5:6b:df:2c:6e:9e:63:a5:5c:dd:d4:55:27:df:7e:
//          6f:ad:6a:95:99:fd:0f:91:a9:44:25:42:c4:02:c5:ed:2a:b3:
//          72:23:4e:79:76:f9:13:6e:f7:00
constexpr uint8_t kExpectedX509Ed25519Cert_DescriptorInput[858] = {
    0x30, 0x82, 0x03, 0x56, 0x30, 0x82, 0x03, 0x08, 0xa0, 0x03, 0x02, 0x01,
    0x02, 0x02, 0x14, 0x52, 0x1f, 0x03, 0x5c, 0x21, 0xe3, 0x2f, 0x16, 0x74,
    0x1c, 0x1e, 0xae, 0x6b, 0xde, 0xd9, 0x3c, 0xe3, 0x21, 0xe0, 0xdf, 0x30,
    0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x30, 0x33, 0x31, 0x31, 0x30, 0x2f,
    0x06, 0x03, 0x55, 0x04, 0x05, 0x13, 0x28, 0x34, 0x37, 0x35, 0x37, 0x30,
    0x38, 0x65, 0x62, 0x33, 0x62, 0x34, 0x32, 0x36, 0x66, 0x33, 0x38, 0x36,
    0x63, 0x66, 0x63, 0x65, 0x38, 0x66, 0x33, 0x62, 0x61, 0x66, 0x35, 0x34,
    0x33, 0x39, 0x30, 0x34, 0x36, 0x32, 0x37, 0x38, 0x64, 0x66, 0x61, 0x30,
    0x20, 0x17, 0x0d, 0x31, 0x38, 0x30, 0x33, 0x32, 0x32, 0x32, 0x33, 0x35,
    0x39, 0x35, 0x39, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32,
    0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x33, 0x31,
    0x31, 0x30, 0x2f, 0x06, 0x03, 0x55, 0x04, 0x05, 0x13, 0x28, 0x35, 0x32,
    0x31, 0x66, 0x30, 0x33, 0x35, 0x63, 0x32, 0x31, 0x65, 0x33, 0x32, 0x66,
    0x31, 0x36, 0x37, 0x34, 0x31, 0x63, 0x31, 0x65, 0x61, 0x65, 0x36, 0x62,
    0x64, 0x65, 0x64, 0x39, 0x33, 0x63, 0x65, 0x33, 0x32, 0x31, 0x65, 0x30,
    0x64, 0x66, 0x30, 0x2a, 0x30, 0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x03,
    0x21, 0x00, 0x93, 0x7f, 0xd9, 0xc0, 0x4d, 0xc6, 0xbb, 0x2e, 0x1d, 0x11,
    0x62, 0xcd, 0x5c, 0x76, 0x94, 0xc7, 0xdb, 0x02, 0x54, 0x0c, 0x85, 0x01,
    0x3a, 0x01, 0xab, 0x37, 0xfa, 0xce, 0xf9, 0x6e, 0x62, 0x20, 0xa3, 0x82,
    0x02, 0x2a, 0x30, 0x82, 0x02, 0x26, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d,
    0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x47, 0x57, 0x08, 0xeb, 0x3b,
    0x42, 0x6f, 0x38, 0x6c, 0xfc, 0xe8, 0xf3, 0xba, 0xf5, 0x43, 0x90, 0x46,
    0x27, 0x8d, 0xfa, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16,
    0x04, 0x14, 0x52, 0x1f, 0x03, 0x5c, 0x21, 0xe3, 0x2f, 0x16, 0x74, 0x1c,
    0x1e, 0xae, 0x6b, 0xde, 0xd9, 0x3c, 0xe3, 0x21, 0xe0, 0xdf, 0x30, 0x0e,
    0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02,
    0x02, 0x04, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff,
    0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x82, 0x01, 0xc1, 0x06,
    0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0xd6, 0x79, 0x02, 0x01, 0x18, 0x01,
    0x01, 0xff, 0x04, 0x82, 0x01, 0xae, 0x30, 0x82, 0x01, 0xaa, 0xa0, 0x42,
    0x04, 0x40, 0xb7, 0xd4, 0x0c, 0xcb, 0x22, 0x5b, 0xa5, 0x78, 0x8f, 0x98,
    0xff, 0x9e, 0x86, 0x93, 0x75, 0xf6, 0x90, 0xac, 0x50, 0xcf, 0x9e, 0xbd,
    0x0a, 0xfe, 0xb1, 0xd9, 0xc2, 0x4e, 0x52, 0x19, 0xe4, 0xde, 0x29, 0xe5,
    0x61, 0xf3, 0xf9, 0x29, 0xe8, 0x40, 0x87, 0x7a, 0xdd, 0x17, 0x48, 0x05,
    0x89, 0x7e, 0x2b, 0xcb, 0x54, 0x79, 0xcc, 0x66, 0xf1, 0xb3, 0x13, 0x29,
    0x0c, 0x68, 0x96, 0xb2, 0xbb, 0x8f, 0xa1, 0x66, 0x04, 0x64, 0x6c, 0x46,
    0x01, 0x33, 0x26, 0x73, 0x4b, 0x22, 0x65, 0xfd, 0xfa, 0x58, 0xd7, 0x57,
    0x3e, 0x95, 0x59, 0xe0, 0x3a, 0xc3, 0xb9, 0xf7, 0xc8, 0x0e, 0x98, 0x80,
    0x8c, 0xf5, 0xc4, 0xb8, 0xaf, 0xe3, 0x16, 0x84, 0x25, 0xa5, 0x35, 0x5d,
    0x17, 0x72, 0x56, 0x8f, 0x8e, 0xec, 0x2f, 0x5a, 0x74, 0x60, 0x77, 0x2a,
    0x6e, 0x90, 0xc0, 0x4e, 0x9f, 0x87, 0x6b, 0xf4, 0x8d, 0x9c, 0x66, 0xe3,
    0x0b, 0xd2, 0x10, 0x35, 0x21, 0xa8, 0x1d, 0xa2, 0x31, 0x17, 0xe7, 0x0c,
    0xdf, 0x18, 0xf7, 0x94, 0xe4, 0xd1, 0xca, 0x32, 0x7d, 0xf2, 0x63, 0x23,
    0x1d, 0xbc, 0x84, 0x74, 0x61, 0xdb, 0x87, 0xf2, 0xab, 0x72, 0xad, 0xaf,
    0x08, 0xf8, 0xa2, 0x42, 0x04, 0x40, 0x45, 0x00, 0xe9, 0x5c, 0xbd, 0x00,
    0x57, 0x04, 0x55, 0x87, 0x6c, 0xbd, 0x2f, 0xea, 0x41, 0x9c, 0x66, 0x42,
    0x51, 0x41, 0xbb, 0x44, 0xed, 0x0e, 0xe9, 0x66, 0xcf, 0xd5, 0x10, 0x73,
    0x0d, 0x4b, 0x48, 0xe4, 0x7a, 0x53, 0x35, 0x01, 0x0e, 0x6d, 0x15, 0x55,
    0xc5, 0xb7, 0xd2, 0xd5, 0x36, 0xb6, 0xbc, 0x7e, 0xb0, 0xf3, 0x3d, 0xe6,
    0x19, 0x78, 0x62, 0xeb, 0x02, 0x57, 0x39, 0x56, 0x73, 0x4f, 0xa3, 0x2a,
    0x04, 0x28, 0x1b, 0x40, 0xc1, 0xa9, 0x77, 0x60, 0xeb, 0xc3, 0x67, 0xf0,
    0x5f, 0x6a, 0xe1, 0x5e, 0x20, 0xc2, 0x51, 0x68, 0x4d, 0x82, 0x48, 0x8b,
    0x03, 0x32, 0x16, 0x79, 0x88, 0x14, 0x37, 0x78, 0x7f, 0x16, 0x9a, 0x06,
    0xfd, 0xc0, 0x8a, 0x15, 0x80, 0x62, 0xa4, 0x42, 0x04, 0x40, 0x22, 0x52,
    0x60, 0x17, 0xef, 0x2c, 0xa1, 0xf6, 0xcb, 0xed, 0x39, 0xd5, 0xe2, 0xaa,
    0x65, 0x20, 0xfb, 0xad, 0x82, 0x93, 0xe5, 0x78, 0x23, 0x22, 0x97, 0xc1,
    0x6e, 0x6a, 0x4e, 0x36, 0xd7, 0x6a, 0x61, 0x39, 0x08, 0x21, 0xd4, 0xfe,
    0x92, 0x5f, 0x36, 0x2d, 0xeb, 0x5d, 0xbb, 0x32, 0x8b, 0xe3, 0x94, 0x4f,
    0xbe, 0x1b, 0x21, 0xf9, 0xcc, 0x23, 0x73, 0x41, 0xb6, 0xb9, 0xb6, 0x98,
    0xd0, 0xbc, 0xa5, 0x43, 0x04, 0x41, 0x92, 0xd6, 0x97, 0xb3, 0x83, 0xdf,
    0xe7, 0x8c, 0xc7, 0xbc, 0x4a, 0xfc, 0xea, 0x76, 0xc0, 0x53, 0x66, 0xbd,
    0x2c, 0x1e, 0x10, 0x31, 0x90, 0x80, 0x11, 0x2d, 0x08, 0x4d, 0x7c, 0x39,
    0x76, 0xdc, 0x73, 0xe7, 0x1c, 0x16, 0x62, 0xd5, 0x59, 0xd7, 0x49, 0x2b,
    0x6a, 0xa2, 0x36, 0x67, 0x57, 0xd1, 0xf2, 0xf9, 0xaf, 0x13, 0xd7, 0xa3,
    0xe4, 0xd3, 0x39, 0x5b, 0x02, 0x78, 0xb1, 0xe0, 0x09, 0x70, 0xa2, 0xa6,
    0x03, 0x0a, 0x01, 0x00, 0x30, 0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x03,
    0x41, 0x00, 0x23, 0x23, 0x66, 0x8c, 0xb2, 0xde, 0x08, 0x0a, 0xfa, 0x96,
    0x01, 0x3f, 0x5c, 0xf3, 0x87, 0xac, 0x33, 0xe0, 0xd0, 0x86, 0x9b, 0xf5,
    0x6b, 0xdf, 0x2c, 0x6e, 0x9e, 0x63, 0xa5, 0x5c, 0xdd, 0xd4, 0x55, 0x27,
    0xdf, 0x7e, 0x6f, 0xad, 0x6a, 0x95, 0x99, 0xfd, 0x0f, 0x91, 0xa9, 0x44,
    0x25, 0x42, 0xc4, 0x02, 0xc5, 0xed, 0x2a, 0xb3, 0x72, 0x23, 0x4e, 0x79,
    0x76, 0xf9, 0x13, 0x6e, 0xf7, 0x00};

// $ openssl x509 -inform DER -noout -text -certopt ext_parse
// Certificate:
//     Data:
//         Version: 3 (0x2)
//         Serial Number:
//             2c:0d:e9:55:c4:fa:08:2c:2c:3a:0b:40:66:59:af:a1:c1:c0:84:6c
//         Signature Algorithm: ecdsa-with-SHA512
//         Issuer: serialNumber = 1be5687933db3d9cd5fca729e81d6685465a7bf1
//         Validity
//             Not Before: Mar 22 23:59:59 2018 GMT
//             Not After : Dec 31 23:59:59 9999 GMT
//         Subject: serialNumber = 2c0de955c4fa082c2c3a0b406659afa1c1c0846c
//         Subject Public Key Info:
//             Public Key Algorithm: id-ecPublicKey
//                 Public-Key: (256 bit)
//                 pub:
//                     04:6d:1e:dd:35:38:70:c2:8a:01:df:80:b1:a5:ae:
//                     85:4b:7a:12:dd:11:f6:97:27:44:9b:27:f3:87:97:
//                     b3:e7:36:e6:42:87:8c:72:de:f7:af:2d:c6:23:00:
//                     b1:2b:4e:1c:f3:af:67:f0:9b:88:40:79:3b:09:78:
//                     30:51:65:38:61
//                 ASN1 OID: prime256v1
//                 NIST CURVE: P-256
//         X509v3 extensions:
//             X509v3 Authority Key Identifier:
//                 keyid:1B:E5:68:79:33:DB:3D:9C:D5:FC:A7:29:E8:1D:66:85:46:5A:7B:F1
//
//             X509v3 Subject Key Identifier:
//                 2C:0D:E9:55:C4:FA:08:2C:2C:3A:0B:40:66:59:AF:A1:C1:C0:84:6C
//             X509v3 Key Usage: critical
//                 Certificate Sign
//             X509v3 Basic Constraints: critical
//                 CA:TRUE
//             1.3.6.1.4.1.11129.2.1.24: critical
//     0:d=0  hl=4 l= 426 cons: SEQUENCE
//     4:d=1  hl=2 l=  66 cons:  cont [ 0 ]
//     6:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - b7 d4 0c cb 22 5b a5 78-8f 98 ff 9e 86 93 75 f6 ...."[.x......u.
//       0010 - 90 ac 50 cf 9e bd 0a fe-b1 d9 c2 4e 52 19 e4 de ..P........NR...
//       0020 - 29 e5 61 f3 f9 29 e8 40-87 7a dd 17 48 05 89 7e ).a..).@.z..H..~
//       0030 - 2b cb 54 79 cc 66 f1 b3-13 29 0c 68 96 b2 bb 8f +.Ty.f...).h....
//    72:d=1  hl=2 l= 102 cons:  cont [ 1 ]
//    74:d=2  hl=2 l= 100 prim:   OCTET STRING
//       0000 - 6c 46 01 33 26 73 4b 22-65 fd fa 58 d7 57 3e 95 lF.3&sK"e..X.W>.
//       0010 - 59 e0 3a c3 b9 f7 c8 0e-98 80 8c f5 c4 b8 af e3 Y.:.............
//       0020 - 16 84 25 a5 35 5d 17 72-56 8f 8e ec 2f 5a 74 60 ..%.5].rV.../Zt`
//       0030 - 77 2a 6e 90 c0 4e 9f 87-6b f4 8d 9c 66 e3 0b d2 w*n..N..k...f...
//       0040 - 10 35 21 a8 1d a2 31 17-e7 0c df 18 f7 94 e4 d1 .5!...1.........
//       0050 - ca 32 7d f2 63 23 1d bc-84 74 61 db 87 f2 ab 72 .2}.c#...ta....r
//       0060 - ad af 08 f8                                       ....
//   176:d=1  hl=2 l=  66 cons:  cont [ 2 ]
//   178:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - 45 00 e9 5c bd 00 57 04-55 87 6c bd 2f ea 41 9c E..\..W.U.l./.A.
//       0010 - 66 42 51 41 bb 44 ed 0e-e9 66 cf d5 10 73 0d 4b fBQA.D...f...s.K
//       0020 - 48 e4 7a 53 35 01 0e 6d-15 55 c5 b7 d2 d5 36 b6 H.zS5..m.U....6.
//       0030 - bc 7e b0 f3 3d e6 19 78-62 eb 02 57 39 56 73 4f .~..=..xb..W9VsO
//   244:d=1  hl=2 l=  42 cons:  cont [ 3 ]
//   246:d=2  hl=2 l=  40 prim:   OCTET STRING
//       0000 - 1b 40 c1 a9 77 60 eb c3-67 f0 5f 6a e1 5e 20 c2   .@..w`..g._j.^
//       . 0010 - 51 68 4d 82 48 8b 03 32-16 79 88 14 37 78 7f 16
//       QhM.H..2.y..7x.. 0020 - 9a 06 fd c0 8a 15 80 62- .......b
//   288:d=1  hl=2 l=  66 cons:  cont [ 4 ]
//   290:d=2  hl=2 l=  64 prim:   OCTET STRING
//       0000 - 22 52 60 17 ef 2c a1 f6-cb ed 39 d5 e2 aa 65 20 "R`..,....9...e
//       0010 - fb ad 82 93 e5 78 23 22-97 c1 6e 6a 4e 36 d7 6a .....x#"..njN6.j
//       0020 - 61 39 08 21 d4 fe 92 5f-36 2d eb 5d bb 32 8b e3 a9.!..._6-.].2..
//       0030 - 94 4f be 1b 21 f9 cc 23-73 41 b6 b9 b6 98 d0 bc .O..!..#sA......
//   356:d=1  hl=2 l=  67 cons:  cont [ 5 ]
//   358:d=2  hl=2 l=  65 prim:   OCTET STRING
//       0000 - 92 d6 97 b3 83 df e7 8c-c7 bc 4a fc ea 76 c0 53 ..........J..v.S
//       0010 - 66 bd 2c 1e 10 31 90 80-11 2d 08 4d 7c 39 76 dc f.,..1...-.M|9v.
//       0020 - 73 e7 1c 16 62 d5 59 d7-49 2b 6a a2 36 67 57 d1 s...b.Y.I+j.6gW.
//       0030 - f2 f9 af 13 d7 a3 e4 d3-39 5b 02 78 b1 e0 09 70 ........9[.x...p
//       0040 - a2                                                .
//   425:d=1  hl=2 l=   3 cons:  cont [ 6 ]
//   427:d=2  hl=2 l=   1 prim:   ENUMERATED        :00
//
//     Signature Algorithm: ecdsa-with-SHA512
//          30:46:02:21:00:a9:57:7d:ac:e0:80:8e:1c:7a:e1:4d:7d:2a:
//          52:d2:5e:fb:5a:7d:45:1e:fa:67:17:04:9e:b3:05:c2:34:f0:
//          7a:02:21:00:b7:3a:31:25:ae:1d:2b:06:8b:ba:44:d9:3a:bf:
//          8b:e2:3f:89:e2:a6:14:0c:fa:c2:b1:dd:0c:0a:78:ac:60:19
constexpr uint8_t kExpectedX509P256Cert_DescriptorInput[927] = {
    0x30, 0x82, 0x03, 0x9b, 0x30, 0x82, 0x03, 0x3e, 0xa0, 0x03, 0x02, 0x01,
    0x02, 0x02, 0x14, 0x2c, 0x0d, 0xe9, 0x55, 0xc4, 0xfa, 0x08, 0x2c, 0x2c,
    0x3a, 0x0b, 0x40, 0x66, 0x59, 0xaf, 0xa1, 0xc1, 0xc0, 0x84, 0x6c, 0x30,
    0x0c, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x04, 0x05,
    0x00, 0x30, 0x33, 0x31, 0x31, 0x30, 0x2f, 0x06, 0x03, 0x55, 0x04, 0x05,
    0x13, 0x28, 0x31, 0x62, 0x65, 0x35, 0x36, 0x38, 0x37, 0x39, 0x33, 0x33,
    0x64, 0x62, 0x33, 0x64, 0x39, 0x63, 0x64, 0x35, 0x66, 0x63, 0x61, 0x37,
    0x32, 0x39, 0x65, 0x38, 0x31, 0x64, 0x36, 0x36, 0x38, 0x35, 0x34, 0x36,
    0x35, 0x61, 0x37, 0x62, 0x66, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x31, 0x38,
    0x30, 0x33, 0x32, 0x32, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x18,
    0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35,
    0x39, 0x35, 0x39, 0x5a, 0x30, 0x33, 0x31, 0x31, 0x30, 0x2f, 0x06, 0x03,
    0x55, 0x04, 0x05, 0x13, 0x28, 0x32, 0x63, 0x30, 0x64, 0x65, 0x39, 0x35,
    0x35, 0x63, 0x34, 0x66, 0x61, 0x30, 0x38, 0x32, 0x63, 0x32, 0x63, 0x33,
    0x61, 0x30, 0x62, 0x34, 0x30, 0x36, 0x36, 0x35, 0x39, 0x61, 0x66, 0x61,
    0x31, 0x63, 0x31, 0x63, 0x30, 0x38, 0x34, 0x36, 0x63, 0x30, 0x59, 0x30,
    0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08,
    0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04,
    0x6d, 0x1e, 0xdd, 0x35, 0x38, 0x70, 0xc2, 0x8a, 0x01, 0xdf, 0x80, 0xb1,
    0xa5, 0xae, 0x85, 0x4b, 0x7a, 0x12, 0xdd, 0x11, 0xf6, 0x97, 0x27, 0x44,
    0x9b, 0x27, 0xf3, 0x87, 0x97, 0xb3, 0xe7, 0x36, 0xe6, 0x42, 0x87, 0x8c,
    0x72, 0xde, 0xf7, 0xaf, 0x2d, 0xc6, 0x23, 0x00, 0xb1, 0x2b, 0x4e, 0x1c,
    0xf3, 0xaf, 0x67, 0xf0, 0x9b, 0x88, 0x40, 0x79, 0x3b, 0x09, 0x78, 0x30,
    0x51, 0x65, 0x38, 0x61, 0xa3, 0x82, 0x02, 0x2a, 0x30, 0x82, 0x02, 0x26,
    0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80,
    0x14, 0x1b, 0xe5, 0x68, 0x79, 0x33, 0xdb, 0x3d, 0x9c, 0xd5, 0xfc, 0xa7,
    0x29, 0xe8, 0x1d, 0x66, 0x85, 0x46, 0x5a, 0x7b, 0xf1, 0x30, 0x1d, 0x06,
    0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x2c, 0x0d, 0xe9, 0x55,
    0xc4, 0xfa, 0x08, 0x2c, 0x2c, 0x3a, 0x0b, 0x40, 0x66, 0x59, 0xaf, 0xa1,
    0xc1, 0xc0, 0x84, 0x6c, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01,
    0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x02, 0x04, 0x30, 0x0f, 0x06, 0x03,
    0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01,
    0xff, 0x30, 0x82, 0x01, 0xc1, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01,
    0xd6, 0x79, 0x02, 0x01, 0x18, 0x01, 0x01, 0xff, 0x04, 0x82, 0x01, 0xae,
    0x30, 0x82, 0x01, 0xaa, 0xa0, 0x42, 0x04, 0x40, 0xb7, 0xd4, 0x0c, 0xcb,
    0x22, 0x5b, 0xa5, 0x78, 0x8f, 0x98, 0xff, 0x9e, 0x86, 0x93, 0x75, 0xf6,
    0x90, 0xac, 0x50, 0xcf, 0x9e, 0xbd, 0x0a, 0xfe, 0xb1, 0xd9, 0xc2, 0x4e,
    0x52, 0x19, 0xe4, 0xde, 0x29, 0xe5, 0x61, 0xf3, 0xf9, 0x29, 0xe8, 0x40,
    0x87, 0x7a, 0xdd, 0x17, 0x48, 0x05, 0x89, 0x7e, 0x2b, 0xcb, 0x54, 0x79,
    0xcc, 0x66, 0xf1, 0xb3, 0x13, 0x29, 0x0c, 0x68, 0x96, 0xb2, 0xbb, 0x8f,
    0xa1, 0x66, 0x04, 0x64, 0x6c, 0x46, 0x01, 0x33, 0x26, 0x73, 0x4b, 0x22,
    0x65, 0xfd, 0xfa, 0x58, 0xd7, 0x57, 0x3e, 0x95, 0x59, 0xe0, 0x3a, 0xc3,
    0xb9, 0xf7, 0xc8, 0x0e, 0x98, 0x80, 0x8c, 0xf5, 0xc4, 0xb8, 0xaf, 0xe3,
    0x16, 0x84, 0x25, 0xa5, 0x35, 0x5d, 0x17, 0x72, 0x56, 0x8f, 0x8e, 0xec,
    0x2f, 0x5a, 0x74, 0x60, 0x77, 0x2a, 0x6e, 0x90, 0xc0, 0x4e, 0x9f, 0x87,
    0x6b, 0xf4, 0x8d, 0x9c, 0x66, 0xe3, 0x0b, 0xd2, 0x10, 0x35, 0x21, 0xa8,
    0x1d, 0xa2, 0x31, 0x17, 0xe7, 0x0c, 0xdf, 0x18, 0xf7, 0x94, 0xe4, 0xd1,
    0xca, 0x32, 0x7d, 0xf2, 0x63, 0x23, 0x1d, 0xbc, 0x84, 0x74, 0x61, 0xdb,
    0x87, 0xf2, 0xab, 0x72, 0xad, 0xaf, 0x08, 0xf8, 0xa2, 0x42, 0x04, 0x40,
    0x45, 0x00, 0xe9, 0x5c, 0xbd, 0x00, 0x57, 0x04, 0x55, 0x87, 0x6c, 0xbd,
    0x2f, 0xea, 0x41, 0x9c, 0x66, 0x42, 0x51, 0x41, 0xbb, 0x44, 0xed, 0x0e,
    0xe9, 0x66, 0xcf, 0xd5, 0x10, 0x73, 0x0d, 0x4b, 0x48, 0xe4, 0x7a, 0x53,
    0x35, 0x01, 0x0e, 0x6d, 0x15, 0x55, 0xc5, 0xb7, 0xd2, 0xd5, 0x36, 0xb6,
    0xbc, 0x7e, 0xb0, 0xf3, 0x3d, 0xe6, 0x19, 0x78, 0x62, 0xeb, 0x02, 0x57,
    0x39, 0x56, 0x73, 0x4f, 0xa3, 0x2a, 0x04, 0x28, 0x1b, 0x40, 0xc1, 0xa9,
    0x77, 0x60, 0xeb, 0xc3, 0x67, 0xf0, 0x5f, 0x6a, 0xe1, 0x5e, 0x20, 0xc2,
    0x51, 0x68, 0x4d, 0x82, 0x48, 0x8b, 0x03, 0x32, 0x16, 0x79, 0x88, 0x14,
    0x37, 0x78, 0x7f, 0x16, 0x9a, 0x06, 0xfd, 0xc0, 0x8a, 0x15, 0x80, 0x62,
    0xa4, 0x42, 0x04, 0x40, 0x22, 0x52, 0x60, 0x17, 0xef, 0x2c, 0xa1, 0xf6,
    0xcb, 0xed, 0x39, 0xd5, 0xe2, 0xaa, 0x65, 0x20, 0xfb, 0xad, 0x82, 0x93,
    0xe5, 0x78, 0x23, 0x22, 0x97, 0xc1, 0x6e, 0x6a, 0x4e, 0x36, 0xd7, 0x6a,
    0x61, 0x39, 0x08, 0x21, 0xd4, 0xfe, 0x92, 0x5f, 0x36, 0x2d, 0xeb, 0x5d,
    0xbb, 0x32, 0x8b, 0xe3, 0x94, 0x4f, 0xbe, 0x1b, 0x21, 0xf9, 0xcc, 0x23,
    0x73, 0x41, 0xb6, 0xb9, 0xb6, 0x98, 0xd0, 0xbc, 0xa5, 0x43, 0x04, 0x41,
    0x92, 0xd6, 0x97, 0xb3, 0x83, 0xdf, 0xe7, 0x8c, 0xc7, 0xbc, 0x4a, 0xfc,
    0xea, 0x76, 0xc0, 0x53, 0x66, 0xbd, 0x2c, 0x1e, 0x10, 0x31, 0x90, 0x80,
    0x11, 0x2d, 0x08, 0x4d, 0x7c, 0x39, 0x76, 0xdc, 0x73, 0xe7, 0x1c, 0x16,
    0x62, 0xd5, 0x59, 0xd7, 0x49, 0x2b, 0x6a, 0xa2, 0x36, 0x67, 0x57, 0xd1,
    0xf2, 0xf9, 0xaf, 0x13, 0xd7, 0xa3, 0xe4, 0xd3, 0x39, 0x5b, 0x02, 0x78,
    0xb1, 0xe0, 0x09, 0x70, 0xa2, 0xa6, 0x03, 0x0a, 0x01, 0x00, 0x30, 0x0c,
    0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x04, 0x05, 0x00,
    0x03, 0x49, 0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xa9, 0x57, 0x7d, 0xac,
    0xe0, 0x80, 0x8e, 0x1c, 0x7a, 0xe1, 0x4d, 0x7d, 0x2a, 0x52, 0xd2, 0x5e,
    0xfb, 0x5a, 0x7d, 0x45, 0x1e, 0xfa, 0x67, 0x17, 0x04, 0x9e, 0xb3, 0x05,
    0xc2, 0x34, 0xf0, 0x7a, 0x02, 0x21, 0x00, 0xb7, 0x3a, 0x31, 0x25, 0xae,
    0x1d, 0x2b, 0x06, 0x8b, 0xba, 0x44, 0xd9, 0x3a, 0xbf, 0x8b, 0xe2, 0x3f,
    0x89, 0xe2, 0xa6, 0x14, 0x0c, 0xfa, 0xc2, 0xb1, 0xdd, 0x0c, 0x0a, 0x78,
    0xac, 0x60, 0x19};

constexpr uint8_t kExpectedX509P384Cert_DescriptorInput[0] = {};

constexpr uint8_t kExpectedCborEd25519Cert_DescriptorInput[667] = {
    0x84, 0x43, 0xa1, 0x01, 0x27, 0xa0, 0x59, 0x02, 0x50, 0xab, 0x01, 0x78,
    0x28, 0x34, 0x37, 0x35, 0x37, 0x30, 0x38, 0x65, 0x62, 0x33, 0x62, 0x34,
    0x32, 0x36, 0x66, 0x33, 0x38, 0x36, 0x63, 0x66, 0x63, 0x65, 0x38, 0x66,
    0x33, 0x62, 0x61, 0x66, 0x35, 0x34, 0x33, 0x39, 0x30, 0x34, 0x36, 0x32,
    0x37, 0x38, 0x64, 0x66, 0x61, 0x02, 0x78, 0x28, 0x35, 0x32, 0x31, 0x66,
    0x30, 0x33, 0x35, 0x63, 0x32, 0x31, 0x65, 0x33, 0x32, 0x66, 0x31, 0x36,
    0x37, 0x34, 0x31, 0x63, 0x31, 0x65, 0x61, 0x65, 0x36, 0x62, 0x64, 0x65,
    0x64, 0x39, 0x33, 0x63, 0x65, 0x33, 0x32, 0x31, 0x65, 0x30, 0x64, 0x66,
    0x3a, 0x00, 0x47, 0x44, 0x50, 0x58, 0x40, 0xb7, 0xd4, 0x0c, 0xcb, 0x22,
    0x5b, 0xa5, 0x78, 0x8f, 0x98, 0xff, 0x9e, 0x86, 0x93, 0x75, 0xf6, 0x90,
    0xac, 0x50, 0xcf, 0x9e, 0xbd, 0x0a, 0xfe, 0xb1, 0xd9, 0xc2, 0x4e, 0x52,
    0x19, 0xe4, 0xde, 0x29, 0xe5, 0x61, 0xf3, 0xf9, 0x29, 0xe8, 0x40, 0x87,
    0x7a, 0xdd, 0x17, 0x48, 0x05, 0x89, 0x7e, 0x2b, 0xcb, 0x54, 0x79, 0xcc,
    0x66, 0xf1, 0xb3, 0x13, 0x29, 0x0c, 0x68, 0x96, 0xb2, 0xbb, 0x8f, 0x3a,
    0x00, 0x47, 0x44, 0x51, 0x58, 0x64, 0x6c, 0x46, 0x01, 0x33, 0x26, 0x73,
    0x4b, 0x22, 0x65, 0xfd, 0xfa, 0x58, 0xd7, 0x57, 0x3e, 0x95, 0x59, 0xe0,
    0x3a, 0xc3, 0xb9, 0xf7, 0xc8, 0x0e, 0x98, 0x80, 0x8c, 0xf5, 0xc4, 0xb8,
    0xaf, 0xe3, 0x16, 0x84, 0x25, 0xa5, 0x35, 0x5d, 0x17, 0x72, 0x56, 0x8f,
    0x8e, 0xec, 0x2f, 0x5a, 0x74, 0x60, 0x77, 0x2a, 0x6e, 0x90, 0xc0, 0x4e,
    0x9f, 0x87, 0x6b, 0xf4, 0x8d, 0x9c, 0x66, 0xe3, 0x0b, 0xd2, 0x10, 0x35,
    0x21, 0xa8, 0x1d, 0xa2, 0x31, 0x17, 0xe7, 0x0c, 0xdf, 0x18, 0xf7, 0x94,
    0xe4, 0xd1, 0xca, 0x32, 0x7d, 0xf2, 0x63, 0x23, 0x1d, 0xbc, 0x84, 0x74,
    0x61, 0xdb, 0x87, 0xf2, 0xab, 0x72, 0xad, 0xaf, 0x08, 0xf8, 0x3a, 0x00,
    0x47, 0x44, 0x53, 0x58, 0x28, 0x1b, 0x40, 0xc1, 0xa9, 0x77, 0x60, 0xeb,
    0xc3, 0x67, 0xf0, 0x5f, 0x6a, 0xe1, 0x5e, 0x20, 0xc2, 0x51, 0x68, 0x4d,
    0x82, 0x48, 0x8b, 0x03, 0x32, 0x16, 0x79, 0x88, 0x14, 0x37, 0x78, 0x7f,
    0x16, 0x9a, 0x06, 0xfd, 0xc0, 0x8a, 0x15, 0x80, 0x62, 0x3a, 0x00, 0x47,
    0x44, 0x52, 0x58, 0x40, 0x45, 0x00, 0xe9, 0x5c, 0xbd, 0x00, 0x57, 0x04,
    0x55, 0x87, 0x6c, 0xbd, 0x2f, 0xea, 0x41, 0x9c, 0x66, 0x42, 0x51, 0x41,
    0xbb, 0x44, 0xed, 0x0e, 0xe9, 0x66, 0xcf, 0xd5, 0x10, 0x73, 0x0d, 0x4b,
    0x48, 0xe4, 0x7a, 0x53, 0x35, 0x01, 0x0e, 0x6d, 0x15, 0x55, 0xc5, 0xb7,
    0xd2, 0xd5, 0x36, 0xb6, 0xbc, 0x7e, 0xb0, 0xf3, 0x3d, 0xe6, 0x19, 0x78,
    0x62, 0xeb, 0x02, 0x57, 0x39, 0x56, 0x73, 0x4f, 0x3a, 0x00, 0x47, 0x44,
    0x54, 0x58, 0x40, 0x22, 0x52, 0x60, 0x17, 0xef, 0x2c, 0xa1, 0xf6, 0xcb,
    0xed, 0x39, 0xd5, 0xe2, 0xaa, 0x65, 0x20, 0xfb, 0xad, 0x82, 0x93, 0xe5,
    0x78, 0x23, 0x22, 0x97, 0xc1, 0x6e, 0x6a, 0x4e, 0x36, 0xd7, 0x6a, 0x61,
    0x39, 0x08, 0x21, 0xd4, 0xfe, 0x92, 0x5f, 0x36, 0x2d, 0xeb, 0x5d, 0xbb,
    0x32, 0x8b, 0xe3, 0x94, 0x4f, 0xbe, 0x1b, 0x21, 0xf9, 0xcc, 0x23, 0x73,
    0x41, 0xb6, 0xb9, 0xb6, 0x98, 0xd0, 0xbc, 0x3a, 0x00, 0x47, 0x44, 0x55,
    0x58, 0x41, 0x92, 0xd6, 0x97, 0xb3, 0x83, 0xdf, 0xe7, 0x8c, 0xc7, 0xbc,
    0x4a, 0xfc, 0xea, 0x76, 0xc0, 0x53, 0x66, 0xbd, 0x2c, 0x1e, 0x10, 0x31,
    0x90, 0x80, 0x11, 0x2d, 0x08, 0x4d, 0x7c, 0x39, 0x76, 0xdc, 0x73, 0xe7,
    0x1c, 0x16, 0x62, 0xd5, 0x59, 0xd7, 0x49, 0x2b, 0x6a, 0xa2, 0x36, 0x67,
    0x57, 0xd1, 0xf2, 0xf9, 0xaf, 0x13, 0xd7, 0xa3, 0xe4, 0xd3, 0x39, 0x5b,
    0x02, 0x78, 0xb1, 0xe0, 0x09, 0x70, 0xa2, 0x3a, 0x00, 0x47, 0x44, 0x56,
    0x41, 0x00, 0x3a, 0x00, 0x47, 0x44, 0x57, 0x58, 0x2d, 0xa5, 0x01, 0x01,
    0x03, 0x27, 0x04, 0x81, 0x02, 0x20, 0x06, 0x21, 0x58, 0x20, 0x93, 0x7f,
    0xd9, 0xc0, 0x4d, 0xc6, 0xbb, 0x2e, 0x1d, 0x11, 0x62, 0xcd, 0x5c, 0x76,
    0x94, 0xc7, 0xdb, 0x02, 0x54, 0x0c, 0x85, 0x01, 0x3a, 0x01, 0xab, 0x37,
    0xfa, 0xce, 0xf9, 0x6e, 0x62, 0x20, 0x3a, 0x00, 0x47, 0x44, 0x58, 0x41,
    0x20, 0x58, 0x40, 0xf6, 0x01, 0x7a, 0xc0, 0xf7, 0x8b, 0xb4, 0xf9, 0xbf,
    0x60, 0x98, 0x5b, 0xc5, 0x64, 0x15, 0x4f, 0xa3, 0x0d, 0x19, 0x3a, 0x5f,
    0xb2, 0x46, 0x0c, 0xc8, 0xfc, 0x40, 0x47, 0xa5, 0x87, 0xef, 0xd2, 0xdb,
    0xbd, 0x35, 0xb6, 0x87, 0x99, 0x22, 0xe1, 0x3f, 0x37, 0xe3, 0x71, 0x28,
    0x5a, 0xfa, 0xca, 0xcd, 0x5d, 0x44, 0x58, 0x45, 0xdf, 0xbb, 0x3d, 0x08,
    0x88, 0x9b, 0x0c, 0x3b, 0x06, 0x7c, 0x0e};

constexpr uint8_t kExpectedCborP256Cert_DescriptorInput[0] = {};

constexpr uint8_t kExpectedCborP384Cert_DescriptorInput[768] = {
    0x84, 0x44, 0xa1, 0x01, 0x38, 0x22, 0xa0, 0x59, 0x02, 0x94, 0xab, 0x01,
    0x78, 0x28, 0x35, 0x64, 0x38, 0x62, 0x36, 0x62, 0x65, 0x37, 0x63, 0x65,
    0x33, 0x65, 0x64, 0x65, 0x36, 0x61, 0x32, 0x34, 0x31, 0x38, 0x30, 0x31,
    0x34, 0x35, 0x32, 0x33, 0x65, 0x36, 0x63, 0x39, 0x64, 0x63, 0x38, 0x37,
    0x65, 0x39, 0x38, 0x63, 0x63, 0x36, 0x02, 0x78, 0x28, 0x36, 0x66, 0x31,
    0x33, 0x39, 0x63, 0x37, 0x62, 0x32, 0x62, 0x31, 0x36, 0x61, 0x63, 0x38,
    0x31, 0x30, 0x32, 0x34, 0x64, 0x35, 0x37, 0x34, 0x39, 0x36, 0x62, 0x31,
    0x62, 0x37, 0x61, 0x31, 0x33, 0x66, 0x64, 0x33, 0x65, 0x38, 0x30, 0x37,
    0x66, 0x3a, 0x00, 0x47, 0x44, 0x50, 0x58, 0x40, 0xb7, 0xd4, 0x0c, 0xcb,
    0x22, 0x5b, 0xa5, 0x78, 0x8f, 0x98, 0xff, 0x9e, 0x86, 0x93, 0x75, 0xf6,
    0x90, 0xac, 0x50, 0xcf, 0x9e, 0xbd, 0x0a, 0xfe, 0xb1, 0xd9, 0xc2, 0x4e,
    0x52, 0x19, 0xe4, 0xde, 0x29, 0xe5, 0x61, 0xf3, 0xf9, 0x29, 0xe8, 0x40,
    0x87, 0x7a, 0xdd, 0x17, 0x48, 0x05, 0x89, 0x7e, 0x2b, 0xcb, 0x54, 0x79,
    0xcc, 0x66, 0xf1, 0xb3, 0x13, 0x29, 0x0c, 0x68, 0x96, 0xb2, 0xbb, 0x8f,
    0x3a, 0x00, 0x47, 0x44, 0x51, 0x58, 0x64, 0x6c, 0x46, 0x01, 0x33, 0x26,
    0x73, 0x4b, 0x22, 0x65, 0xfd, 0xfa, 0x58, 0xd7, 0x57, 0x3e, 0x95, 0x59,
    0xe0, 0x3a, 0xc3, 0xb9, 0xf7, 0xc8, 0x0e, 0x98, 0x80, 0x8c, 0xf5, 0xc4,
    0xb8, 0xaf, 0xe3, 0x16, 0x84, 0x25, 0xa5, 0x35, 0x5d, 0x17, 0x72, 0x56,
    0x8f, 0x8e, 0xec, 0x2f, 0x5a, 0x74, 0x60, 0x77, 0x2a, 0x6e, 0x90, 0xc0,
    0x4e, 0x9f, 0x87, 0x6b, 0xf4, 0x8d, 0x9c, 0x66, 0xe3, 0x0b, 0xd2, 0x10,
    0x35, 0x21, 0xa8, 0x1d, 0xa2, 0x31, 0x17, 0xe7, 0x0c, 0xdf, 0x18, 0xf7,
    0x94, 0xe4, 0xd1, 0xca, 0x32, 0x7d, 0xf2, 0x63, 0x23, 0x1d, 0xbc, 0x84,
    0x74, 0x61, 0xdb, 0x87, 0xf2, 0xab, 0x72, 0xad, 0xaf, 0x08, 0xf8, 0x3a,
    0x00, 0x47, 0x44, 0x53, 0x58, 0x28, 0x1b, 0x40, 0xc1, 0xa9, 0x77, 0x60,
    0xeb, 0xc3, 0x67, 0xf0, 0x5f, 0x6a, 0xe1, 0x5e, 0x20, 0xc2, 0x51, 0x68,
    0x4d, 0x82, 0x48, 0x8b, 0x03, 0x32, 0x16, 0x79, 0x88, 0x14, 0x37, 0x78,
    0x7f, 0x16, 0x9a, 0x06, 0xfd, 0xc0, 0x8a, 0x15, 0x80, 0x62, 0x3a, 0x00,
    0x47, 0x44, 0x52, 0x58, 0x40, 0x45, 0x00, 0xe9, 0x5c, 0xbd, 0x00, 0x57,
    0x04, 0x55, 0x87, 0x6c, 0xbd, 0x2f, 0xea, 0x41, 0x9c, 0x66, 0x42, 0x51,
    0x41, 0xbb, 0x44, 0xed, 0x0e, 0xe9, 0x66, 0xcf, 0xd5, 0x10, 0x73, 0x0d,
    0x4b, 0x48, 0xe4, 0x7a, 0x53, 0x35, 0x01, 0x0e, 0x6d, 0x15, 0x55, 0xc5,
    0xb7, 0xd2, 0xd5, 0x36, 0xb6, 0xbc, 0x7e, 0xb0, 0xf3, 0x3d, 0xe6, 0x19,
    0x78, 0x62, 0xeb, 0x02, 0x57, 0x39, 0x56, 0x73, 0x4f, 0x3a, 0x00, 0x47,
    0x44, 0x54, 0x58, 0x40, 0x22, 0x52, 0x60, 0x17, 0xef, 0x2c, 0xa1, 0xf6,
    0xcb, 0xed, 0x39, 0xd5, 0xe2, 0xaa, 0x65, 0x20, 0xfb, 0xad, 0x82, 0x93,
    0xe5, 0x78, 0x23, 0x22, 0x97, 0xc1, 0x6e, 0x6a, 0x4e, 0x36, 0xd7, 0x6a,
    0x61, 0x39, 0x08, 0x21, 0xd4, 0xfe, 0x92, 0x5f, 0x36, 0x2d, 0xeb, 0x5d,
    0xbb, 0x32, 0x8b, 0xe3, 0x94, 0x4f, 0xbe, 0x1b, 0x21, 0xf9, 0xcc, 0x23,
    0x73, 0x41, 0xb6, 0xb9, 0xb6, 0x98, 0xd0, 0xbc, 0x3a, 0x00, 0x47, 0x44,
    0x55, 0x58, 0x41, 0x92, 0xd6, 0x97, 0xb3, 0x83, 0xdf, 0xe7, 0x8c, 0xc7,
    0xbc, 0x4a, 0xfc, 0xea, 0x76, 0xc0, 0x53, 0x66, 0xbd, 0x2c, 0x1e, 0x10,
    0x31, 0x90, 0x80, 0x11, 0x2d, 0x08, 0x4d, 0x7c, 0x39, 0x76, 0xdc, 0x73,
    0xe7, 0x1c, 0x16, 0x62, 0xd5, 0x59, 0xd7, 0x49, 0x2b, 0x6a, 0xa2, 0x36,
    0x67, 0x57, 0xd1, 0xf2, 0xf9, 0xaf, 0x13, 0xd7, 0xa3, 0xe4, 0xd3, 0x39,
    0x5b, 0x02, 0x78, 0xb1, 0xe0, 0x09, 0x70, 0xa2, 0x3a, 0x00, 0x47, 0x44,
    0x56, 0x41, 0x00, 0x3a, 0x00, 0x47, 0x44, 0x57, 0x58, 0x71, 0xa6, 0x01,
    0x02, 0x03, 0x38, 0x22, 0x04, 0x81, 0x02, 0x20, 0x02, 0x21, 0x58, 0x30,
    0xb4, 0x02, 0x19, 0x48, 0xca, 0xdd, 0x23, 0x4b, 0x92, 0x91, 0x22, 0x8d,
    0xa8, 0x80, 0x85, 0xc0, 0xf9, 0x23, 0xe4, 0x89, 0xbd, 0x91, 0x8d, 0xf3,
    0x8f, 0xa3, 0x73, 0x60, 0x70, 0x19, 0xc6, 0x33, 0x76, 0xbf, 0xd4, 0x60,
    0xfa, 0xdc, 0xde, 0x46, 0x58, 0x51, 0x13, 0x1d, 0x73, 0x81, 0x79, 0xff,
    0x22, 0x58, 0x30, 0x39, 0x79, 0x1b, 0x49, 0x6a, 0xcf, 0x37, 0x8f, 0xf4,
    0x1a, 0xc2, 0x29, 0xb5, 0x80, 0x2f, 0x7b, 0x2b, 0x0a, 0x27, 0x96, 0xb3,
    0xb2, 0xc1, 0xc6, 0x6f, 0xb4, 0x16, 0xa4, 0x78, 0x76, 0x73, 0x6f, 0xcb,
    0xf5, 0x7d, 0x26, 0xc2, 0x37, 0xe9, 0x58, 0x98, 0xeb, 0xef, 0x11, 0x7c,
    0x8d, 0x1d, 0x4b, 0x3a, 0x00, 0x47, 0x44, 0x58, 0x41, 0x20, 0x58, 0x60,
    0x12, 0xa5, 0xb9, 0xc3, 0xbf, 0x06, 0x10, 0x7d, 0x22, 0x4b, 0xc1, 0xd2,
    0x58, 0xce, 0xd8, 0x4c, 0x42, 0x48, 0x69, 0x58, 0xf0, 0x83, 0x4a, 0x54,
    0x39, 0x90, 0xec, 0x10, 0xef, 0x76, 0x2e, 0xb0, 0x33, 0x82, 0x6f, 0x93,
    0x2b, 0xc3, 0xb2, 0xc4, 0x6a, 0xcb, 0xde, 0x4c, 0x21, 0x62, 0x56, 0x07,
    0xc7, 0xb1, 0xd6, 0xde, 0xff, 0x95, 0x2c, 0xce, 0xbf, 0x3c, 0x0b, 0xdc,
    0xd0, 0xc5, 0x39, 0x6d, 0xc3, 0x59, 0x23, 0x7b, 0x54, 0x11, 0xf4, 0xb1,
    0x33, 0x66, 0x94, 0x47, 0x3c, 0x14, 0x99, 0x0a, 0xca, 0xa9, 0x84, 0xf4,
    0xc9, 0x24, 0xfd, 0x11, 0xe7, 0xcc, 0x37, 0x6f, 0x12, 0x2b, 0x1a, 0xa7};

}  // namespace test
}  // namespace dice

#endif  // DICE_KNOWN_TEST_VALUES_H_
