// Copyright (C) 2015-2017 Bayerische Motoren Werke Aktiengesellschaft (BMW AG)
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// steps to get this server working on the target
// 1. export VSOMEIP_CONFIGURATION=[path]/vsomeipUdpServer.json  -> this is telling where the configuration file is located
// 2. export VSOMEIP_APPLICATION_NAME = hello_world_client  -> this is telling what the server application is. The name is refereed in the json file
// 3. switch off the firewall
// 4. sudo route add -nv 237.60.1.1 dev eth1   -> this is required for service discovery
// 5. run someip_hello_world_service_out.out
#if !defined(someip_Gateway__INCLUDED_)
#define someip_Gateway__INCLUDED_

#ifndef VSOMEIP_ENABLE_SIGNAL_HANDLING
#include <csignal>
#endif
#include <vsomeip/vsomeip.hpp>
#include <chrono>
#include <thread>
#include <condition_variable>
#include <mutex>
#include <iostream>
#include "SomeIPMessageObserverItf.h"
//#include "SomeipMethodHandler.h"
#include "someip_MessageSenderItf.h"
#include "ThreadAdministration.h"
#include "../framework/DefineVector.h"
#include "someIP_MessageSender.h"

// _____________________________________________________________________________________
// map
#include "LayoutRequestMessageObserver.h"

// _____________________________________________________________________________________
// picture
#include "../feature_adapter/PictureExecutorItf.h"

class SomeIPGateway: public someip_MessageSenderItf {

public:
    void configureMessageSender();
    SomeIPGateway();
    ~SomeIPGateway();
    bool init();
    void start();
    void offerService();
    void stopOfferService();
    void offerEvents();
    void requestService();

    void stop();
    void terminate();
    void on_state_cbk(vsomeip::state_type_e _state);
    void on_availability_cbk_forSwipe(vsomeip::service_t _service, vsomeip::instance_t _instance, bool _is_available);
    void on_message_cbk(const std::shared_ptr<vsomeip::message>& _request);
    static  void sendEvent(vsomeip::service_t ServiceID, vsomeip::instance_t InstanceID, int EventID, short StreamStatus);
    virtual void sendEvent(vsomeip::service_t ServiceID, vsomeip::instance_t InstanceID, int EventID, std::shared_ptr<vsomeip::payload> Payload);

    virtual int offerEvent(vsomeip::service_t ServiceID, vsomeip::instance_t InstanceID, int EventID, std::set<vsomeip::eventgroup_t> Groups);
    virtual int sendEvent(vsomeip::service_t ServiceID, vsomeip::instance_t InstanceID, vsomeip::event_t eventID, std::vector<vsomeip::byte_t> data);
    static bool sendOldestPendingEventToCluster();


    /**
     * int getServiceID () { return ((int)service_id); } int getInstanceID() { return
     * ((int)service_instance_id); }
     */
    static void* MessageConsumer(void* Data);

    // _____________________________________________________________________________________
    // map
public:
    virtual void sendVideoStreamStatusEvent(short StreamStatus);
    void onLayoutRequestNoReturnMessage(const std::shared_ptr<vsomeip::message>& _request);
    void setLayoutRequestHandler(SomeIPMessageObserverItf* HandlerReference);

private:
    bool ServiceOffer_MapInClusterIsOffered;
    bool EventSubscription_MapInCLusterClientIsRegisteredForEvent;
    SomeIPMessageObserverItf* _pLayoutRequestHandlerReference;
    LayoutRequestMessageObserver oLayoutRequestMessageObserver;
    bool checkWhetherStreamStatusShallBeSent(short StreamStatus);
    LayoutRequestMessageObserver *oLayoutRequestObserver;

    // _____________________________________________________________________________________
    // picture
public:
    void storeMediaImageExecutorReference(PictureExecutorItf* MediaImageExecutorReference);
private:
    bool EventSubscription_ImageInCLusterClientIsRegisteredForEvent;
    PictureExecutorItf *m_MediaImageExecutorReference;
    // _____________________________________________________________________________________
    // swipe
public:
    vsomeip::byte_t getPayloadFromCombinationResponseMessage(std::shared_ptr<vsomeip::message> Response);
    void onClusterCombinationResponseMessage(const std::shared_ptr<vsomeip::message> &_response);
    void setClusterFadeInStatusHandler(SomeIPMessageObserverItf* HandlerReference);
    void setClusterCombinationServiceAvailabilityHandler(SomeIPMessageObserverItf* HandlerReference);
    virtual void sendIVIActionCombination(short TypeOfContents);
    bool ServiceAvailable_ClusterCombinationAvailable;
private:
    SomeIPMessageObserverItf* _pCombinationResponseHandlerReference;
    SomeIPMessageObserverItf* _pCombinationServiceAvailabilityHandlerReference;
    // _____________________________________________________________________________________
    // common
public:
    std::shared_ptr<vsomeip::runtime> rtm_;
    std::shared_ptr<vsomeip::application> app_;
private:
    bool SomeIPApplicationIsRegistered;
    bool stop_;
    std::mutex mutex_;
    std::condition_variable condition_;
    std::condition_variable notify_condition_;
    std::thread stop_thread_;

    static ThreadAdministration oObserverThread;

    bool checkWhetherAtLeastOneClientHasBeenRegisteredForEvent(vsomeip::service_t ServiceID);


    bool createMessageConsumer();
    static int uIntDLTTraceInjectionCallback(unsigned int service_id, void *data, unsigned int length);
    
    static someIP_MessageSender oSomeIPMessageSender; // someip frontend for sending methods to Cluster
//    static SomeipMethodHandler oMethodsToBeSentToClusterHandler; // prepare payload of the methods to be sent to Cluster
public:
    static SomeIPGateway* pSomeIPGateway;
};
#endif
