// Copyright 2014 Google Inc. All Rights Reserved.

#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_CORE_UTIL_SEM_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_CORE_UTIL_SEM_H

#if defined(__APPLE__) && defined(__MACH__)
#include <dispatch/dispatch.h>
#elif defined(WIN32)
#include <windows.h>
#else
#include <semaphore.h>
#endif

/**
 * Wrap a semaphore. Customize this to suit the target platform & OS.
 * The android implementation uses a standard linux semaphore.
 */
class Semaphore {
public:
    Semaphore();
    Semaphore(int value);
    ~Semaphore();
    bool down();
    bool up();
    /**
     * Changed by ADIT
     * Sets the timeout for sem_timedwait().
     * Sets the timeout to 0 to disable the timeout.
     * @param timeoutMs timeout in ms. Values exceeding WQUEUE_MAX_TOUT are limited to that max.
     * @param timeoutCallback pointer to function call if timeout occurs
     * @param ctx user context
     */
    void setOneshotTimeout(unsigned int timeoutMs, void (*timeoutCallback)(void*), void* ctx);
private:
#if defined(__APPLE__) && defined(__MACH__)
    dispatch_semaphore_t mSem;
#elif defined(WIN32)
    HANDLE mSem;
#else
    sem_t mSem;
    /**
     * Changed by ADIT
     */
    int mTimeoutMs;
    void (*mTimeoutCallback) (void*);
    void* mCtx;
#endif
};

#endif // ANDROID_AUTO_PROJECTION_PROTOCOL_CORE_UTIL_SEM_H
