// Copyright 2014 Google Inc. All Rights Reserved.

#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_CORE_UTIL_GALMUTEX_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_CORE_UTIL_GALMUTEX_H

#ifdef WIN32
#include <windows.h>
#else
#include <pthread.h>
#endif

// Customize this to be a mutex on your platform
class GalMutex {
public:
    GalMutex();
    ~GalMutex();
    void lock();
    void unlock();
private:
#ifdef WIN32
    CRITICAL_SECTION mCriticalSection;
#else
    pthread_mutex_t mGalMutex;
#endif
};

class Autolock {
public:
    Autolock(GalMutex* mutex);
    ~Autolock();
private:
    GalMutex* mGalMutex;
};

#endif // ANDROID_AUTO_PROJECTION_PROTOCOL_CORE_UTIL_GALMUTEX_H
