// Copyright 2020 Google Inc. All Rights Reserved.
#ifndef WIRELESS_ANDROID_AUTO_PROJECTION_PROTOCOL_RECEIVER_LIB_SRC_UTIL_MONOTONICCLOCK_H_
#define WIRELESS_ANDROID_AUTO_PROJECTION_PROTOCOL_RECEIVER_LIB_SRC_UTIL_MONOTONICCLOCK_H_

#include <cstdint>

namespace GalUtil {

/**
 * A class that returns a monotonically increasing time value as a value
 * expressed in milliseconds.
 *
 * This class may need be modified in order to be supported on your platform.
 */
class MonotonicClock {
 public:
  /**
   * Returns a monotonically increasing time, not strictly associated with any
   * epoch.
   */
  static int64_t GetCurrentMonoTimeMs();

  /** This method is used to assist in unit testing. */
  static void SetSimulatedTimeMs(int64_t newTimeMs);

 private:
  static int64_t sSimulatedTime;
};
}  // namespace GalUtil

#endif  // WIRELESS_ANDROID_AUTO_PROJECTION_PROTOCOL_RECEIVER_LIB_SRC_UTIL_MONOTONICCLOCK_H_
