#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_WIFI_PROJECTION_ENDPOINT_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_WIFI_PROJECTION_ENDPOINT_H

#include <set>
#include "IWifiProjectionCallbacks.h"
#include "ProtocolEndpointBase.h"
#include "common.h"

/**
 * This class implements an endpoint that handles Wifi projection related requests
 * over the GAL protocol. The call sequence would look something like this:
 * <br>
 * <pre>
 *      galReceiver->init();
 *      ... Initialization code ...
 *      WifiProjectionEndpoint* endpoint = new WifiProjectionEndpoint(serviceId,
 *              galReceiver->messageRouter(), carWifiBssid);
 *      endpoint->registerCallbacks(callbacks); //Subclassed from IWifiProjectionCallbacks;
 *      galReceiver->registerService(endpoint);
 *      ... Other Initialization code ...
 *      galReceiver->start();
 *      ... After receiving CarWifiCredentialsRequest message from mobile device,
 *      callbacks->onWifiCredentialsRequest() will be invoked and car wifi credentials would be
 *      sent to the mobile device. Then phone can use the password to connect to the car wifi
 *      and then starts wifi projection.
 * </pre>
 */
class WifiProjectionEndpoint : public ProtocolEndpointBase {
 public:
    WifiProjectionEndpoint(uint8_t id, MessageRouter *router,
                           const std::string& carWifiBssid) :
            ProtocolEndpointBase(id, router, false),
            mCarWifiBssid(carWifiBssid) {}

    void registerCallbacks(
            const shared_ptr<IWifiProjectionCallbacks>& callbacks);

    // ProtocolEndpointBase implementation.

    void addDiscoveryInfo(ServiceDiscoveryResponse* sdr);

    int routeMessage(uint8_t channelId, uint16_t type,
                     const shared_ptr<IoBuffer>& msg);

 private:
    void handleWifiCredentialsRequest();

    std::string mCarWifiBssid;
    shared_ptr<IWifiProjectionCallbacks> mCallbacks;
};

#endif  // ANDROID_AUTO_PROJECTION_PROTOCOL_WIFI_PROJECTION_ENDPOINT_H
