#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_IWIFI_PROJECTION_CALLBACKS_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_IWIFI_PROJECTION_CALLBACKS_H

#include "common.h"

struct CarWifiCredentialsStruct {
    std::string wifiSsid; /** SSID of car wifi */
    std::string wifiPassword; /** password of car wifi */
    int32_t wifiSecurityMode; /** encryption type of car wifi */

    /** The center frequencies of all supported wifi channels. */
    std::vector<int> supportedWifiChannels;
};

class IWifiProjectionCallbacks {
 public:
    virtual ~IWifiProjectionCallbacks() { }

    virtual void onWifiCredentialsRequest(
            CarWifiCredentialsStruct* wifiCreds) = 0;

    // TODO(b/154008173): Make these getter/setter methods pure virtual.
    virtual int getTcpReceiveBufferSize() {
        return -1;
    }

    // TODO(b/154008173): Make these getter/setter methods pure virtual.
    virtual int getTcpReadTimeout() {
        return -1;
    }

    // TODO(b/154008173): Make these getter/setter methods pure virtual.
    virtual int getTcpSendBufferSize() {
        return -1;
    }

    // TODO(b/154008173): Make these getter/setter methods pure virtual.
    virtual void setTcpReadTimeout(int timeoutMs) {}

    // TODO(b/154008173): Make these getter/setter methods pure virtual.
    virtual void setTcpSendBufferSize(int sendBufferSize) {}

    // TODO(b/154008173): Make these getter/setter methods pure virtual.
    virtual void setTcpReceiveBufferSize(int receiveBufferSize) {}
};

#endif  // ANDROID_AUTO_PROJECTION_PROTOCOL_IWIFI_PROJECTION_CALLBACKS_H
