#ifndef WIRELESS_ANDROID_AUTO_PROJECTION_PROTOCOL_RECEIVER_LIB_SRC_ICONNECTIONCONFIGURATIONLISTENER_H_
#define WIRELESS_ANDROID_AUTO_PROJECTION_PROTOCOL_RECEIVER_LIB_SRC_ICONNECTIONCONFIGURATIONLISTENER_H_

#include "common.h"

/**
 * @internal
 * This is an internal connection configuration callback mechanism. You should
 * not need to implement this interface.
 */
class IConnectionConfigurationListener {
 public:
    virtual ~IConnectionConfigurationListener() { }

    /**
     * This callback is invoked by MessageRouter when an MD has sent a
     * ConnectionConfigurationRequest, which will only be sent during
     * startup.
     */
    virtual void applyConnectionConfiguration(
            const ConnectionConfiguration& config) = 0;

    /**
     * This callback is invoked by MessageRouter during the construction of a
     * ServiceDiscoveryResponse. Classes which implement this method must
     * populate the provided ConnectionConfiguration with the correct values.
     */
    virtual ConnectionConfiguration getConnectionConfiguration() = 0;
};

#endif  // WIRELESS_ANDROID_AUTO_PROJECTION_PROTOCOL_RECEIVER_LIB_SRC_ICONNECTIONCONFIGURATIONLISTENER_H_
