#ifndef WIRELESS_ANDROID_AUTO_PROJECTION_PROTOCOL_RECEIVER_LIB_SRC_ICONNECTIONCONFIGURATIONCALLBACKS_H_
#define WIRELESS_ANDROID_AUTO_PROJECTION_PROTOCOL_RECEIVER_LIB_SRC_ICONNECTIONCONFIGURATIONCALLBACKS_H_

/**
 * This class is used to allow an MD to change the parameters of an active
 * connection (e.g. TCP socket used for wireless connections).
 */
class IConnectionConfigurationCallbacks {
public:
    virtual ~IConnectionConfigurationCallbacks() {}

    /**
     * Callback to get the receive buffer size of an active TCP socket.
     */
    virtual int onRetrieveTcpReceiveBufferSize() = 0;

    /**
     * Callback to get the read timeout duration of an active TCP socket.
     */
    virtual int onRetrieveTcpReadTimeout() = 0;

    /**
     * Callback to get the send buffer size of an active TCP socket.
     */
    virtual int onRetrieveTcpSendBufferSize() = 0;

    /**
     * Callback to change the read timeout of an active TCP socket to
     * {@param timeoutMs}.
     */
    virtual void onApplyTcpReadTimeout(int timeoutMs) = 0;

    /**
     * Callback to change the send buffer size of an active TCP socket to
     * {@param sendBufferSize}.
     */
    virtual void onApplyTcpSendBufferSize(int sendBufferSize) = 0;

    /**
     * Callback to change the receive buffer size of an active TCP socket to
     * {@param receiveBufferSize}.
     */
    virtual void onApplyTcpReceiveBufferSize(int receiveBufferSize) = 0;
};


#endif  // WIRELESS_ANDROID_AUTO_PROJECTION_PROTOCOL_RECEIVER_LIB_SRC_ICONNECTIONCONFIGURATIONCALLBACKS_H_
