#ifndef WIRELESS_ANDROID_AUTO_PROJECTION_PROTOCOL_RECEIVER_LIB_SRC_CONNECTIONCONFIGURATIONCALLBACKSADAPTER_H_
#define WIRELESS_ANDROID_AUTO_PROJECTION_PROTOCOL_RECEIVER_LIB_SRC_CONNECTIONCONFIGURATIONCALLBACKSADAPTER_H_

#include "IConnectionConfigurationListener.h"
#include "IConnectionConfigurationCallbacks.h"
#include "common.h"

class ConnectionConfigurationCallbacksAdapter :
        public IConnectionConfigurationListener {
public:
    ConnectionConfigurationCallbacksAdapter(
            shared_ptr<IConnectionConfigurationCallbacks> callback)
        : mCallback(callback) {}
     /**
     * This callback is invoked by MessageRouter when an MD has sent a
     * ConnectionConfigurationRequest, which will only be sent during
     * startup.
     */
    void applyConnectionConfiguration(
            const ConnectionConfiguration& config) override;

    /**
     * This callback is invoked by MessageRouter during the construction of a
     * ServiceDiscoveryResponse. Classes which implement this method must
     * populate the provided ConnectionConfiguration with the correct values.
     */
    ConnectionConfiguration getConnectionConfiguration() override;

private:
    shared_ptr<IConnectionConfigurationCallbacks> mCallback;
};


#endif  // WIRELESS_ANDROID_AUTO_PROJECTION_PROTOCOL_RECEIVER_LIB_SRC_CONNECTIONCONFIGURATIONCALLBACKSADAPTER_H_
